/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.sc.transformers;

import java.util.List;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.transform.sc.transformers.StaticCompilationTransformer;
import org.codehaus.groovy.transform.stc.StaticTypesMarker;

public class MethodCallExpressionTransformer {
    private final StaticCompilationTransformer staticCompilationTransformer;

    public MethodCallExpressionTransformer(StaticCompilationTransformer staticCompilationTransformer) {
        this.staticCompilationTransformer = staticCompilationTransformer;
    }

    Expression transformMethodCallExpression(MethodCallExpression expr) {
        Expression objectExpression = expr.getObjectExpression();
        if (expr.isSafe()) {
            MethodCallExpression notSafe = new MethodCallExpression(objectExpression, expr.getMethod(), expr.getArguments());
            notSafe.copyNodeMetaData(expr);
            notSafe.setSpreadSafe(expr.isSpreadSafe());
            notSafe.setSourcePosition(expr);
            notSafe.setMethodTarget(expr.getMethodTarget());
            TernaryExpression texpr = new TernaryExpression(new BooleanExpression(new BinaryExpression(objectExpression, Token.newSymbol("!=", objectExpression.getLineNumber(), objectExpression.getColumnNumber()), ConstantExpression.NULL)), notSafe, ConstantExpression.NULL);
            return this.staticCompilationTransformer.transform(texpr);
        }
        ClassNode type = this.staticCompilationTransformer.getTypeChooser().resolveType(objectExpression, this.staticCompilationTransformer.getClassNode());
        if (type != null && type.isArray()) {
            Expression indexExpr;
            List<Expression> argList;
            Expression arguments;
            String method = expr.getMethodAsString();
            ClassNode componentType = type.getComponentType();
            if ("getAt".equals(method) && (arguments = expr.getArguments()) instanceof TupleExpression && (argList = ((TupleExpression)arguments).getExpressions()).size() == 1) {
                indexExpr = argList.get(0);
                ClassNode argType = this.staticCompilationTransformer.getTypeChooser().resolveType(indexExpr, this.staticCompilationTransformer.getClassNode());
                ClassNode indexType = ClassHelper.getWrapper(argType);
                if (componentType.isEnum() && ClassHelper.Number_TYPE == indexType) {
                    indexType = ClassHelper.Integer_TYPE;
                }
                if (argType != null && ClassHelper.Integer_TYPE == indexType) {
                    BinaryExpression binaryExpression = new BinaryExpression(objectExpression, Token.newSymbol("[", indexExpr.getLineNumber(), indexExpr.getColumnNumber()), indexExpr);
                    binaryExpression.putNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, componentType);
                    return this.staticCompilationTransformer.transform(binaryExpression);
                }
            }
            if ("putAt".equals(method) && (arguments = expr.getArguments()) instanceof TupleExpression && (argList = ((TupleExpression)arguments).getExpressions()).size() == 2) {
                indexExpr = argList.get(0);
                Expression objExpr = argList.get(1);
                ClassNode argType = this.staticCompilationTransformer.getTypeChooser().resolveType(indexExpr, this.staticCompilationTransformer.getClassNode());
                if (argType != null && ClassHelper.Integer_TYPE == ClassHelper.getWrapper(argType)) {
                    BinaryExpression arrayGet = new BinaryExpression(objectExpression, Token.newSymbol("[", indexExpr.getLineNumber(), indexExpr.getColumnNumber()), indexExpr);
                    arrayGet.putNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, componentType);
                    BinaryExpression assignment = new BinaryExpression(arrayGet, Token.newSymbol("=", objExpr.getLineNumber(), objExpr.getColumnNumber()), objExpr);
                    return this.staticCompilationTransformer.transform(assignment);
                }
            }
        }
        return this.staticCompilationTransformer.superTransform(expr);
    }
}

