/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.widgets.util;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.widgets.IRotatableComponent;
import de.javasoft.widgets.IUIPropertySupport;
import de.javasoft.widgets.ui.UIValue;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import org.jdesktop.swingx.plaf.DefaultsList;

public class WidgetUtils {
    private static final String DOUBLE_BUFFER_VALUE = "Synthetica.OriginalDoubleBufferValue";
    private static Cursor dragCursor;
    private static Cursor stopCursor;

    public static Cursor getDragCursor() {
        if (dragCursor == null) {
            ImageIcon ii = new ImageIcon(WidgetUtils.class.getResource("/de/javasoft/widgets/resources/dragCursor.png"));
            dragCursor = Toolkit.getDefaultToolkit().createCustomCursor(ii.getImage(), new Point(0, 0), "DRAG_CURSOR");
        }
        return dragCursor;
    }

    public static Cursor getStopCursor() {
        if (stopCursor == null) {
            ImageIcon ii = new ImageIcon(WidgetUtils.class.getResource("/de/javasoft/widgets/resources/stopCursor.png"));
            stopCursor = Toolkit.getDefaultToolkit().createCustomCursor(ii.getImage(), new Point(0, 0), "STOP_CURSOR");
        }
        return stopCursor;
    }

    public static <T> void setUIProperty(JComponent c, String propertyName, UIValue<T> uiValue, T oldValue, T newValue, boolean isUIResource, boolean revalidate, boolean repaint) {
        if (uiValue == null) {
            return;
        }
        if (isUIResource) {
            oldValue = null;
        }
        if (oldValue == null || !oldValue.equals(newValue)) {
            uiValue.set(newValue);
            uiValue.setUIResource(isUIResource);
            ((IUIPropertySupport)((Object)c)).firePropertyChange(propertyName, oldValue, newValue);
            if (revalidate) {
                c.revalidate();
            }
            if (repaint) {
                c.repaint();
            }
        }
    }

    public static boolean shouldUpdateStyle(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("name".equals(name)) {
            return true;
        }
        return "Synthetica.style".equals(name);
    }

    public static Dimension rotateDimension(Dimension dim, IRotatableComponent.Rotation rotation) {
        if (rotation == IRotatableComponent.Rotation.LEFT || rotation == IRotatableComponent.Rotation.RIGHT) {
            int val = dim.width;
            dim.width = dim.height;
            dim.height = val;
        }
        return dim;
    }

    public static Rectangle rotateRectangle(Rectangle r, IRotatableComponent.Rotation rotation) {
        if (rotation == IRotatableComponent.Rotation.LEFT || rotation == IRotatableComponent.Rotation.RIGHT) {
            int val = r.width;
            r.width = r.height;
            r.height = val;
        }
        return r;
    }

    public static Border createRotatableEmptyBorder(Insets insets, boolean asUIResource) {
        if (asUIResource) {
            return new RotatableEmptyBorderUIResource(insets);
        }
        return new RotatableEmptyBorder(insets);
    }

    public static Insets rotateInsets(Insets insets, IRotatableComponent.Rotation rotation) {
        if (rotation == IRotatableComponent.Rotation.REVERSED) {
            int val = insets.top;
            insets.top = insets.bottom;
            insets.bottom = val;
        } else if (rotation == IRotatableComponent.Rotation.RIGHT) {
            int val = insets.top;
            insets.top = insets.left;
            int val_ = insets.right;
            insets.right = val;
            val = insets.bottom;
            insets.bottom = val_;
            insets.left = val;
        } else if (rotation == IRotatableComponent.Rotation.LEFT) {
            int val = insets.top;
            insets.top = insets.right;
            int val_ = insets.left;
            insets.left = val;
            val = insets.bottom;
            insets.bottom = val_;
            insets.right = val;
        }
        return insets;
    }

    public static Border createOrientationAwareEmptyBorder(Insets insets, boolean asUIResource) {
        if (asUIResource) {
            return new OrientationAwareEmptyBorderUIResource(insets);
        }
        return new OrientationAwareEmptyBorder(insets);
    }

    public static void addResourceBundleToDefaults(String name, DefaultsList defaults) {
        ResourceBundle resBundle = ResourceBundle.getBundle(name);
        Enumeration<String> enumeration = resBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String key = enumeration.nextElement();
            String value = resBundle.getString(key);
            defaults.add((Object)key, (Object)value);
        }
    }

    public static Font getDefaultFont() {
        Font f = SyntheticaLookAndFeel.getFont();
        return f == null ? new FontUIResource("Dialog", 0, 12) : new FontUIResource(f);
    }

    public static BufferedImage createPreviewImage(Component c, double scaleFactor, boolean centerThumbnail) {
        if (c == null) {
            return null;
        }
        int w = (int)((double)c.getWidth() * scaleFactor);
        int h = (int)((double)c.getHeight() * scaleFactor);
        return WidgetUtils.createPreviewImage(c, 0, 0, w, h, centerThumbnail);
    }

    public static BufferedImage createPreviewImage(Component c, int x, int y, int w, int h, boolean centerThumbnail) {
        if (c == null || w <= 0 || h <= 0) {
            return null;
        }
        BufferedImage image = new BufferedImage(w, h, 2);
        Graphics2D g2 = image.createGraphics();
        int orgWidth = c.getWidth();
        int orgHeight = c.getHeight();
        int cWidth = orgWidth;
        int cHeight = orgHeight;
        double sizeFactor = 1.0;
        int maxSize = SyntheticaLookAndFeel.getInt((String)"Synthetica.componentPreview.maxSize", (Component)c, (int)2500);
        if (maxSize > 0) {
            int maxFactor = SyntheticaLookAndFeel.getInt((String)"Synthetica.componentPreview.maxFactor", (Component)c, (int)125);
            while (cWidth > maxSize || cHeight > maxSize) {
                sizeFactor = (double)maxFactor / 100.0;
                cWidth = (int)((double)cWidth / sizeFactor);
                cHeight = (int)((double)cHeight / sizeFactor);
            }
        }
        if (sizeFactor > 1.0) {
            c.setSize(cWidth, cHeight);
        }
        if (cWidth > 0 && cHeight > 0) {
            double factor;
            if (c instanceof JComponent) {
                ((JComponent)c).putClientProperty("Synthetica.previewImageRatio", Float.valueOf(Float.valueOf(cWidth).floatValue() / Float.valueOf(orgWidth).floatValue()));
            }
            BufferedImage img = new BufferedImage(cWidth, cHeight, 2);
            c.paint(img.getGraphics());
            if (sizeFactor > 1.0) {
                c.setSize(orgWidth, orgHeight);
            }
            if (c instanceof JComponent) {
                ((JComponent)c).putClientProperty("Synthetica.previewImageRatio", null);
            }
            if ((factor = Math.min((double)w / (double)cWidth, (double)h / (double)cHeight)) < 1.0) {
                int w_ = (int)(factor * (double)cWidth);
                int h_ = (int)(factor * (double)cHeight);
                int x_ = x + (centerThumbnail ? (w - w_) / 2 : 0);
                int y_ = y + (centerThumbnail ? (h - h_) / 2 : 0);
                g2.drawImage((Image)WidgetUtils.createThumbnail(img, w_), x_, y_, null);
            } else {
                g2.drawImage((Image)img, x, y, null);
            }
        }
        g2.dispose();
        return image;
    }

    private static BufferedImage createThumbnail(BufferedImage image, int preferredWidth) {
        float ratio = (float)image.getWidth() / (float)image.getHeight();
        int width = image.getWidth();
        BufferedImage thumb = image;
        do {
            if ((width /= 2) < preferredWidth) {
                width = preferredWidth;
            }
            BufferedImage temp = new BufferedImage(width, (int)((float)width / ratio), 2);
            Graphics2D g2 = temp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.drawImage(thumb, 0, 0, temp.getWidth(), temp.getHeight(), null);
            g2.dispose();
            thumb = temp;
        } while (width != preferredWidth);
        return thumb;
    }

    public static void disableDoubleBuffer(Component c) {
        if (c instanceof JComponent) {
            JComponent jc = (JComponent)c;
            jc.putClientProperty(DOUBLE_BUFFER_VALUE, jc.isDoubleBuffered());
            jc.setDoubleBuffered(false);
        }
        if (c instanceof Container) {
            Container cont = (Container)c;
            int i = 0;
            while (i < cont.getComponentCount()) {
                WidgetUtils.disableDoubleBuffer(cont.getComponent(i));
                ++i;
            }
        }
    }

    public static void restoreDoubleBuffer(Component c) {
        if (c instanceof JComponent) {
            JComponent jc = (JComponent)c;
            Boolean val = (Boolean)jc.getClientProperty(DOUBLE_BUFFER_VALUE);
            if (val != null) {
                jc.setDoubleBuffered(val);
            } else {
                Container parent = c.getParent();
                if (parent instanceof JComponent) {
                    Boolean parentVal = (Boolean)((JComponent)parent).getClientProperty(DOUBLE_BUFFER_VALUE);
                    jc.setDoubleBuffered(parentVal == null ? false : parentVal);
                }
            }
        }
        if (c instanceof Container) {
            Container cont = (Container)c;
            int i = 0;
            while (i < cont.getComponentCount()) {
                WidgetUtils.restoreDoubleBuffer(cont.getComponent(i));
                ++i;
            }
        }
    }

    public static class OrientationAwareEmptyBorder
    extends EmptyBorder {
        private static final long serialVersionUID = 1197462533056882357L;

        public OrientationAwareEmptyBorder(int top, int left, int bottom, int right) {
            super(top, left, bottom, right);
        }

        public OrientationAwareEmptyBorder(Insets borderInsets) {
            super(borderInsets);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            boolean ltr = c.getComponentOrientation().isLeftToRight();
            insets.left = ltr ? this.left : this.right;
            insets.top = this.top;
            insets.right = ltr ? this.right : this.left;
            insets.bottom = this.bottom;
            return insets;
        }
    }

    public static class OrientationAwareEmptyBorderUIResource
    extends OrientationAwareEmptyBorder
    implements UIResource {
        private static final long serialVersionUID = -2425915691737611974L;

        public OrientationAwareEmptyBorderUIResource(Insets insets) {
            super(insets);
        }
    }

    private static class RotatableEmptyBorder
    extends EmptyBorder {
        private static final long serialVersionUID = -3288482079141574369L;

        public RotatableEmptyBorder(Insets insets) {
            super(insets);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            Insets insets = super.getBorderInsets(c);
            if (c instanceof AbstractButton) {
                Insets margin = ((AbstractButton)c).getMargin();
                insets = new Insets(insets.top + margin.top, insets.left + margin.left, insets.bottom + margin.bottom, insets.right + margin.right);
            }
            if (c instanceof IRotatableComponent) {
                insets = WidgetUtils.rotateInsets(insets, ((IRotatableComponent)((Object)c)).getRotation());
            }
            return insets;
        }
    }

    private static class RotatableEmptyBorderUIResource
    extends RotatableEmptyBorder
    implements UIResource {
        private static final long serialVersionUID = 1764839983093610630L;

        public RotatableEmptyBorderUIResource(Insets insets) {
            super(insets);
        }
    }
}

