/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.widgets;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.widgets.IUIPropertySupport;
import de.javasoft.widgets.ui.UIValue;
import de.javasoft.widgets.util.WidgetUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JViewport;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicMenuItemUI;

public class JYPopupMenu
extends JPopupMenu
implements IUIPropertySupport,
PropertyChangeListener {
    private static final long serialVersionUID = -7295789498551615230L;
    private JScrollPane scroller;
    private MenuElementPanel menuElementPanel = new MenuElementPanel();
    private UIValue<Integer> visibleElements;
    private int scrollBarGap;
    private KeyHandler keyHandler;

    public JYPopupMenu() {
        this.scroller = new JScrollPane(this.menuElementPanel){
            private static final long serialVersionUID = -3035272695393060772L;

            @Override
            public Dimension getPreferredSize() {
                int visibleElements = JYPopupMenu.this.getVisibleElements();
                int elements = JYPopupMenu.this.menuElementPanel.getComponentCount();
                int height = 0;
                int i = Math.min(elements, visibleElements);
                while (i > 0) {
                    height += ((JYPopupMenu)JYPopupMenu.this).menuElementPanel.getComponent((int)(i - 1)).getPreferredSize().height;
                    --i;
                }
                int scrollBarWidth = elements > visibleElements ? ((JYPopupMenu)JYPopupMenu.this).scroller.getVerticalScrollBar().getPreferredSize().width : 0;
                return new Dimension(((JYPopupMenu)JYPopupMenu.this).menuElementPanel.getPreferredSize().width + scrollBarWidth, height);
            }
        };
        this.scroller.setBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(0, 0, 0, 0, true));
        this.scroller.getViewport().setOpaque(false);
        this.scroller.setOpaque(false);
        this.scroller.setHorizontalScrollBarPolicy(31);
        this.scroller.setVerticalScrollBarPolicy(20);
        this.add(this.scroller);
        this.keyHandler = new KeyHandler();
        this.addPropertyChangeListener(this);
    }

    @Override
    public JMenuItem add(JMenuItem menuItem) {
        this.add((Component)menuItem);
        return menuItem;
    }

    @Override
    public Component add(Component comp) {
        if (comp instanceof MenuElement || comp instanceof JSeparator) {
            return this.menuElementPanel.add(comp);
        }
        return super.add(comp);
    }

    @Override
    public void menuSelectionChanged(boolean isIncluded) {
        super.menuSelectionChanged(isIncluded);
    }

    @Override
    public void show(Component invoker, int x, int y) {
        super.show(invoker, x, y);
    }

    @Override
    public void updateUI() {
        this.updateUIDefaults();
        super.updateUI();
    }

    private void updateUIDefaults() {
        if (this.visibleElementsIsUIResource()) {
            this.setVisibleElements(SyntheticaLookAndFeel.getInt((String)"JYPopupMenu.visibleElements", (Component)this, (int)20), true);
        }
        this.scrollBarGap = SyntheticaLookAndFeel.getInt((String)"JYPopupMenu.scrollBarGap", (Component)this, (int)2);
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            MenuSelectionManager.defaultManager().addChangeListener(this.keyHandler);
        } else {
            MenuSelectionManager.defaultManager().removeChangeListener(this.keyHandler);
            this.keyHandler.uninstall();
        }
        Component invoker = this.getInvoker();
        if (b && invoker != null) {
            MenuElement[] me = new MenuElement[]{this, this.menuElementPanel};
            MenuSelectionManager.defaultManager().setSelectedPath(me);
        }
    }

    public JPanel getMenuElementPanel() {
        return this.menuElementPanel;
    }

    @Override
    public void removeAll() {
        this.menuElementPanel.removeAll();
    }

    public void removeAllFromPopup() {
        super.removeAll();
    }

    public void setVisibleElements(Integer elements) {
        this.setVisibleElements(elements, false);
    }

    public void setVisibleElements(Integer elements, boolean isUIResource) {
        WidgetUtils.setUIProperty(this, "visibleElements", this.visibleElements, this.getVisibleElements(), elements, isUIResource, false, false);
    }

    public boolean visibleElementsIsUIResource() {
        return this.getVisibleElementsUIValue().isUIResource();
    }

    public Integer getVisibleElements() {
        return this.getVisibleElementsUIValue().get();
    }

    private UIValue<Integer> getVisibleElementsUIValue() {
        if (this.visibleElements == null) {
            this.visibleElements = new UIValue();
        }
        return this.visibleElements;
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (WidgetUtils.shouldUpdateStyle(evt)) {
            this.updateUIDefaults();
        }
    }

    private class KeyHandler
    extends KeyAdapter
    implements ChangeListener {
        private MenuElement[] lastPath = new MenuElement[0];
        private JRootPane rootPane;
        private boolean focusTraversalKeysEnabled;

        private KeyHandler() {
        }

        public void uninstall() {
            if (this.rootPane != null) {
                this.rootPane.removeKeyListener(this);
                this.rootPane.setFocusTraversalKeysEnabled(this.focusTraversalKeysEnabled);
                this.rootPane = null;
            }
            this.lastPath = new MenuElement[0];
        }

        private JPopupMenu getActivePopup(MenuElement[] path) {
            int i = path.length - 1;
            while (i >= 0) {
                MenuElement elem = path[i];
                if (elem instanceof JPopupMenu) {
                    return (JPopupMenu)elem;
                }
                --i;
            }
            return null;
        }

        @Override
        public void stateChanged(ChangeEvent evt) {
            MenuElement[] path = MenuSelectionManager.defaultManager().getSelectedPath();
            JPopupMenu popup = this.getActivePopup(path);
            if (popup == null || !popup.isFocusable()) {
                return;
            }
            if (this.lastPath.length == 0 && path.length > 0 && path[0] == JYPopupMenu.this) {
                this.rootPane = SwingUtilities.getRootPane(JYPopupMenu.this.getInvoker());
                if (this.rootPane != null) {
                    this.rootPane.requestFocus(true);
                    this.rootPane.addKeyListener(this);
                    this.focusTraversalKeysEnabled = this.rootPane.getFocusTraversalKeysEnabled();
                    this.rootPane.setFocusTraversalKeysEnabled(false);
                }
            }
            this.lastPath = path;
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            JPanel p = JYPopupMenu.this.getMenuElementPanel();
            int count = p.getComponentCount();
            if (count == 0) {
                return;
            }
            AbstractButton lastItem = null;
            int i = count - 1;
            while (i >= 0) {
                if (p.getComponent(i) instanceof JMenuItem) {
                    lastItem = (JMenuItem)p.getComponent(i);
                    break;
                }
                --i;
            }
            if (lastItem == null) {
                return;
            }
            if (MenuSelectionManager.defaultManager().getSelectedPath().length == 2) {
                MenuSelectionManager.defaultManager().setSelectedPath(((BasicMenuItemUI)lastItem.getUI()).getPath());
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (MenuSelectionManager.defaultManager().getSelectedPath().length == 3) {
                        JMenuItem c = (JMenuItem)MenuSelectionManager.defaultManager().getSelectedPath()[2].getComponent();
                        Rectangle r = c.getBounds();
                        JViewport viewport = JYPopupMenu.this.scroller.getViewport();
                        int viewY = viewport.getViewPosition().y;
                        int viewMaxY = viewY + viewport.getVisibleRect().height;
                        if (r.y < viewY) {
                            viewport.setViewPosition(new Point(0, r.y));
                        } else if (r.y >= viewMaxY) {
                            viewport.setViewPosition(new Point(0, viewY + r.y - viewMaxY + r.height));
                        }
                    }
                }
            });
        }
    }

    private class MenuElementPanel
    extends JPanel
    implements MenuElement,
    Scrollable {
        private static final long serialVersionUID = -555457288677345702L;

        public MenuElementPanel() {
            this.setName("JYPopupMenu.MenuElementPanel");
            this.setOpaque(false);
            this.setLayout(new BoxLayout(this, 3));
            this.setBorder(new AbstractBorder(){
                private static final long serialVersionUID = 7553579405198284896L;

                @Override
                public Insets getBorderInsets(Component c) {
                    Insets insets = new Insets(0, 0, 0, 0);
                    if (JYPopupMenu.this.scroller != null && ((Container)c).getComponentCount() > JYPopupMenu.this.getVisibleElements()) {
                        if (MenuElementPanel.this.getComponentOrientation().isLeftToRight()) {
                            insets.right = JYPopupMenu.this.scrollBarGap;
                        } else {
                            insets.left = JYPopupMenu.this.scrollBarGap;
                        }
                    }
                    return insets;
                }
            });
        }

        @Override
        public Component getComponent() {
            return this;
        }

        @Override
        public MenuElement[] getSubElements() {
            ArrayList<MenuElement> list = new ArrayList<MenuElement>();
            Component[] componentArray = this.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component c = componentArray[n2];
                if (c instanceof MenuElement) {
                    list.add((MenuElement)((Object)c));
                }
                ++n2;
            }
            return list.toArray(new MenuElement[0]);
        }

        @Override
        public void menuSelectionChanged(boolean isIncluded) {
        }

        @Override
        public void processKeyEvent(KeyEvent evt, MenuElement[] path, MenuSelectionManager manager) {
        }

        @Override
        public void processMouseEvent(MouseEvent evt, MenuElement[] path, MenuSelectionManager manager) {
            if ((evt.getModifiersEx() & 0x1F9) > 0) {
                JYPopupMenu.this.setVisible(false);
            }
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return null;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return this.getScrollableUnitIncrement(visibleRect, orientation, direction);
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            int index = -1;
            int i = 0;
            while (i < this.getComponentCount()) {
                Rectangle bounds = this.getComponent(i).getBounds();
                if (direction < 0 && bounds.y + bounds.height <= visibleRect.y || direction > 0 && bounds.y >= visibleRect.y + visibleRect.height) {
                    index = i;
                    break;
                }
                ++i;
            }
            return index < 0 ? SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(16)).intValue() : this.getComponent(index).getHeight();
        }
    }
}

