/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.widgets;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.SyntheticaBasicIconPainter;
import de.javasoft.plaf.synthetica.painter.UIKey;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.plaf.synth.SynthContext;

public abstract class JYButtonIcon
extends SyntheticaBasicIconPainter {
    private String key;
    private Icon cachedIcon;
    private int cachedState;
    private int nonSynthState;

    public JYButtonIcon(AbstractButton b, String uiKey, int width, int height, Icon icon) {
        super(null, width, height);
        this.key = uiKey;
        this.cachedState = -1;
        this.cachedIcon = icon == null ? SyntheticaLookAndFeel.loadIcon((String)uiKey, (Component)b, (boolean)true) : icon;
        this.nonSynthState = this.getNonSynthState(b);
    }

    public JYButtonIcon(AbstractButton b, String uiKey, int width, int height) {
        this(b, uiKey, width, height, null);
    }

    public JYButtonIcon(SyntheticaState state, String uiKey, int width, int height) {
        super(null, width, height);
        this.key = uiKey;
        this.cachedState = -1;
        this.cachedIcon = SyntheticaLookAndFeel.loadIcon((String)uiKey, null, (boolean)true);
        this.nonSynthState = state.getState();
    }

    public void setState(SyntheticaState state) {
        this.nonSynthState = state.getState();
    }

    public void paintIcon(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        int state;
        Action a;
        Icon icon;
        if (sc != null && sc.getComponent() instanceof AbstractButton && ((AbstractButton)sc.getComponent()).getAction() != null && (icon = (Icon)(a = ((AbstractButton)sc.getComponent()).getAction()).getValue("SmallIcon")) != null && !(icon instanceof JYButtonIcon)) {
            icon.paintIcon(sc.getComponent(), g, x, y);
            return;
        }
        int n = state = sc == null ? this.nonSynthState : sc.getComponentState();
        if (state != this.cachedState) {
            this.cachedState = state;
            UIKey uiKey = new UIKey(this.key, this.getState(), "");
            this.cachedIcon = SyntheticaLookAndFeel.loadIcon((String)uiKey.get(), (Component)(sc == null ? null : sc.getComponent()), (boolean)true);
        }
        if (this.cachedIcon != null) {
            this.cachedIcon.paintIcon(sc == null ? null : sc.getComponent(), g, x, y);
        } else {
            super.paintIcon(sc, g, x, y, w, h);
        }
    }

    private int getNonSynthState(AbstractButton b) {
        int state = 0;
        ButtonModel model = b.getModel();
        if (!b.isEnabled() || !model.isEnabled()) {
            state |= SyntheticaState.State.DISABLED.toInt();
        }
        if (model.isArmed() && model.isPressed()) {
            state |= SyntheticaState.State.PRESSED.toInt();
        }
        if (model.isRollover()) {
            state |= SyntheticaState.State.HOVER.toInt();
        }
        if (b.isSelected() || model.isSelected()) {
            state |= SyntheticaState.State.SELECTED.toInt();
        }
        return state;
    }

    protected SyntheticaState getState() {
        return new SyntheticaState(this.cachedState);
    }

    public int getIconWidth() {
        if (this.cachedIcon != null) {
            return this.cachedIcon.getIconWidth();
        }
        return super.getIconWidth();
    }

    public int getIconWidth(SynthContext sc) {
        return this.getIconWidth();
    }

    public int getIconHeight() {
        if (this.cachedIcon != null) {
            return this.cachedIcon.getIconHeight();
        }
        return super.getIconHeight();
    }

    public int getIconHeight(SynthContext sc) {
        return this.getIconHeight();
    }

    public void paint2D(SynthContext sc, Graphics2D g2, float x, float y, float w, float h) {
        this.paintFallback2DIcon(sc, this.getState(), g2, x, y, w, h);
    }

    public String getUIKey() {
        return this.key;
    }

    public abstract void paintFallback2DIcon(SynthContext var1, SyntheticaState var2, Graphics2D var3, float var4, float var5, float var6, float var7);
}

