/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.textfield;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.textfield.IFormattedField;
import de.javasoft.textfield.JYTextField;
import java.awt.Component;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;

public class JYPasswordField
extends JYTextField
implements IFormattedField {
    private static final long serialVersionUID = -5857342396303844897L;
    private char echoChar;
    private boolean echoCharSet = false;

    public JYPasswordField() {
    }

    public JYPasswordField(String text) {
        super(text);
    }

    public JYPasswordField(int columns) {
        super(columns);
    }

    public JYPasswordField(String text, int columns) {
        super(text, columns);
    }

    @Override
    public void updateUI() {
        if (!this.echoCharSet) {
            this.echoChar = (char)SyntheticaLookAndFeel.getInt((String)"JYPasswordField.echoChar", (Component)this, (int)42);
        }
        super.updateUI();
    }

    public char getEchoChar() {
        return this.echoChar;
    }

    public void setEchoChar(char c) {
        this.echoChar = c;
        this.echoCharSet = true;
        this.repaint();
        this.revalidate();
    }

    public boolean echoCharIsSet() {
        return this.echoChar != '\u0000';
    }

    @Override
    public void cut() {
        if (this.getClientProperty("JYPasswordField.cutCopyAllowed") != Boolean.TRUE) {
            UIManager.getLookAndFeel().provideErrorFeedback(this);
        } else {
            super.cut();
        }
    }

    @Override
    public void copy() {
        if (this.getClientProperty("JYPasswordField.cutCopyAllowed") != Boolean.TRUE) {
            UIManager.getLookAndFeel().provideErrorFeedback(this);
        } else {
            super.copy();
        }
    }

    public char[] getPassword() {
        Document doc = this.getDocument();
        Segment txt = new Segment();
        try {
            doc.getText(0, doc.getLength(), txt);
        }
        catch (BadLocationException e) {
            return null;
        }
        char[] retValue = new char[txt.count];
        System.arraycopy(txt.array, txt.offset, retValue, 0, txt.count);
        return retValue;
    }

    @Override
    protected String paramString() {
        return String.valueOf(super.paramString()) + ",echoChar=" + this.echoChar;
    }
}

