/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.textfield;

import de.javasoft.textfield.IFormattedField;
import de.javasoft.textfield.JYTextField;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Date;
import javax.swing.JFormattedTextField;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.InternationalFormatter;
import javax.swing.text.NumberFormatter;

public class JYFormattedTextField
extends JYTextField
implements IFormattedField {
    private static final long serialVersionUID = 511956605401079567L;

    public JYFormattedTextField() {
    }

    public JYFormattedTextField(Object value) {
        this();
        this.setValue(value);
    }

    public JYFormattedTextField(Format format) {
        this();
        this.setFormatterFactory(this.getDefaultFormatterFactory(format));
    }

    private JFormattedTextField.AbstractFormatterFactory getDefaultFormatterFactory(Object type) {
        if (type instanceof DateFormat) {
            return new DefaultFormatterFactory(new DateFormatter((DateFormat)type));
        }
        if (type instanceof NumberFormat) {
            return new DefaultFormatterFactory(new NumberFormatter((NumberFormat)type));
        }
        if (type instanceof Format) {
            return new DefaultFormatterFactory(new InternationalFormatter((Format)type));
        }
        if (type instanceof Date) {
            return new DefaultFormatterFactory(new DateFormatter());
        }
        if (type instanceof Number) {
            NumberFormatter displayFormatter = new NumberFormatter();
            displayFormatter.setValueClass(type.getClass());
            NumberFormatter editFormatter = new NumberFormatter(new DecimalFormat("#.#"));
            editFormatter.setValueClass(type.getClass());
            return new DefaultFormatterFactory(displayFormatter, displayFormatter, editFormatter);
        }
        return new DefaultFormatterFactory(new DefaultFormatter());
    }

    public JYFormattedTextField(JFormattedTextField.AbstractFormatter formatter) {
        this(new DefaultFormatterFactory(formatter));
    }

    public JYFormattedTextField(JFormattedTextField.AbstractFormatterFactory factory) {
        this();
        this.setFormatterFactory(factory);
    }
}

