/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.taskpane.ui;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.taskpane.JYTaskPane;
import de.javasoft.taskpane.ui.JYTaskPaneUI;
import de.javasoft.widgets.util.WidgetUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.jdesktop.swingx.JXCollapsiblePane;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.SwingXUtilities;

public class BasicJYTaskPaneUI
extends JYTaskPaneUI
implements PropertyChangeListener,
ContainerListener {
    private static final String CONTENT_PANE_DEFAULT_NAME = "JYTaskPane.contentPane";
    protected JYTaskPane taskPane;
    protected JComponent titlePane;
    protected JLabel titleLabel;
    protected JLabel iconLabel;
    protected JButton arrowButton;
    private ArrowIcon arrowIcon;
    private Icon arrowIconHover;

    public static ComponentUI createUI(JComponent c) {
        return new BasicJYTaskPaneUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.taskPane = (JYTaskPane)c;
        if (!(this.taskPane.getTaskPaneLayout() instanceof BorderLayout)) {
            this.taskPane.setTaskPaneLayout(new BorderLayout());
        }
        super.installUI(c);
        this.taskPane.getActionMap().put("toggleCollapsed", new ToggleCollapsedAction());
        if (this.titlePane instanceof TitlePanel) {
            this.titlePane.getInputMap(0).put(KeyStroke.getKeyStroke(32, 0), "toggleCollapsed");
            this.titlePane.getActionMap().put("toggleCollapsed", new ToggleCollapsedAction());
        }
    }

    @Override
    protected void installDefaults(JPanel c) {
        this.arrowIcon = new ArrowIcon(false);
        this.arrowIconHover = new ArrowIcon(true);
        if (this.taskPane.getTitlePane() == null) {
            this.taskPane.setTitlePane(this.createTitlePane());
        }
        this.taskPane.addPropertyChangeListener(this);
        this.taskPane.addContainerListener(this);
        this.taskPane.setOpaque(false);
        if (this.taskPane.titleForegroundIsUIResource()) {
            this.taskPane.setTitleForeground(SyntheticaLookAndFeel.getColor((String)"JYTaskPane.titlePane.title.foreground", (Component)this.taskPane, (Color)UIManager.getColor("TaskPane.titleForeground")), true);
        } else if (this.titleLabel != null && !this.taskPane.titleForegroundIsUIResource() && !this.taskPane.isSpecial()) {
            this.titleLabel.setForeground(this.taskPane.getTitleForeground());
        }
        if (this.taskPane.specialTitleForegroundIsUIResource()) {
            this.taskPane.setSpecialTitleForeground(SyntheticaLookAndFeel.getColor((String)"JYTaskPane.titlePane.title.specialForeground", (Component)this.taskPane, (Color)UIManager.getColor("TaskPane.specialTitleForeground")), true);
        } else if (this.titleLabel != null && !this.taskPane.specialTitleForegroundIsUIResource() && this.taskPane.isSpecial()) {
            this.titleLabel.setForeground(this.taskPane.getSpecialTitleForeground());
        }
        if (this.taskPane.titleFontIsUIResource()) {
            this.taskPane.setTitleFont((Font)SyntheticaLookAndFeel.get((String)"JYTaskPane.font", (Component)this.taskPane), true);
        } else if (this.titleLabel != null) {
            this.titleLabel.setFont(this.taskPane.getTitleFont());
        }
        if (this.taskPane.titlePaneMouseSensitiveIsUIResource()) {
            this.taskPane.setTitlePaneMouseSensitive(SyntheticaLookAndFeel.getBoolean((String)"JYTaskPane.titlePane.mouseSensitive", (Component)this.taskPane, (boolean)true), true);
        }
        if (this.taskPane.animationEnabledIsUIResource()) {
            this.taskPane.setAnimationEnabled(SyntheticaLookAndFeel.getBoolean((String)"JYTaskPane.animation.enabled", (Component)this.taskPane, (boolean)true), true);
        }
        if (this.taskPane.collapsedIconIsUIResource()) {
            this.taskPane.setCollapsedIcon(SyntheticaLookAndFeel.loadIcon((String)"JYTaskPane.titlePane.collapsedIcon", (Component)this.taskPane, (boolean)true), true);
        }
        if (this.taskPane.expandedIconIsUIResource()) {
            this.taskPane.setExpandedIcon(SyntheticaLookAndFeel.loadIcon((String)"JYTaskPane.titlePane.expandedIcon", (Component)this.taskPane, (boolean)true), true);
        }
    }

    @Override
    protected void uninstallDefaults(JPanel p) {
        JComponent tp = this.taskPane.getTitlePane();
        if (tp instanceof UIResource) {
            this.taskPane.setTitlePane(null);
        }
        this.taskPane.removePropertyChangeListener(this);
        this.taskPane.removeContainerListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        JComponent c = (JComponent)evt.getSource();
        String name = evt.getPropertyName();
        if (WidgetUtils.shouldUpdateStyle(evt)) {
            this.installDefaults((JPanel)c);
        }
        if (!(this.titlePane instanceof TitlePanel)) {
            return;
        }
        if ("title".equals(name)) {
            this.titleLabel.setText("" + evt.getNewValue());
        } else if ("titleForeground".equals(name) && !this.taskPane.isSpecial() || "specialTitleForeground".equals(name) && this.taskPane.isSpecial()) {
            this.setTitleForeground((Color)evt.getNewValue());
        } else if ("titleFont".equals(name)) {
            Font f = (Font)evt.getNewValue();
            this.titleLabel.setFont(f == null ? null : f.deriveFont(f.getStyle()));
        } else if ("mnemonic".equals(evt.getPropertyName())) {
            SwingXUtilities.updateMnemonicBinding((JComponent)this.taskPane, (String)"toggleCollapsed");
            this.titleLabel.setDisplayedMnemonic((Integer)evt.getNewValue());
        } else if ("icon".equals(name)) {
            this.iconLabel.setIcon((Icon)evt.getNewValue());
        } else if ("special".equals(name)) {
            this.setTitleForeground(this.taskPane.isSpecial() ? this.taskPane.getSpecialTitleForeground() : this.taskPane.getTitleForeground());
            this.titlePane.repaint();
        } else if ("titlePaneMouseSensitive".equals(name) && this.titlePane instanceof TitlePanel) {
            ((TitlePanel)this.titlePane).setMouseSensitive((Boolean)evt.getNewValue());
        } else if ("name".equals(name)) {
            this.taskPane.getContentPane().setName("JYTaskPane.contentPane." + evt.getNewValue());
        }
    }

    @Override
    public void componentAdded(ContainerEvent evt) {
        if (evt.getChild() instanceof JXCollapsiblePane) {
            this.taskPane.getContentPane().setName(CONTENT_PANE_DEFAULT_NAME);
        }
    }

    @Override
    public void componentRemoved(ContainerEvent evt) {
    }

    private void setTitleForeground(Color color) {
        this.titleLabel.setForeground(color == null ? null : new Color(color.getRGB()));
    }

    @Override
    public Component createAction(Action action) {
        JXHyperlink link = new JXHyperlink(action){
            private static final long serialVersionUID = 411631211475663711L;

            public void updateUI() {
                super.updateUI();
                BasicJYTaskPaneUI.this.configureHyperlink(this);
            }
        };
        this.configureHyperlink(link);
        return link;
    }

    protected void configureHyperlink(JXHyperlink link) {
        link.setOpaque(false);
        Insets insets = SyntheticaLookAndFeel.getInsets((String)"Synthetica.taskPane.link.insets", (Component)this.taskPane, (Insets)new Insets(2, 2, 2, 2), (boolean)true);
        link.setBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(insets, false));
        link.setBorderPainted(false);
        link.setFocusPainted(true);
        Color foreground = SyntheticaLookAndFeel.getColor((String)"Synthetica.taskPane.link.foreground", (Component)this.taskPane, (Color)UIManager.getColor("TaskPane.titleForeground"));
        link.setForeground(foreground);
    }

    protected JComponent createTitlePane() {
        this.titlePane = new TitlePanel();
        this.titleLabel = new JLabel(this.taskPane.getTitle());
        this.titleLabel.setFocusable(false);
        this.titleLabel.setIconTextGap(0);
        this.titleLabel.setBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(0, 0, 0, 0, true));
        this.titleLabel.setDisplayedMnemonic(this.taskPane.getMnemonic());
        this.titleLabel.setName("JYTaskPane.titleLabel");
        this.iconLabel = new JLabel(this.taskPane.getIcon());
        this.iconLabel.setFocusable(false);
        this.iconLabel.setIconTextGap(0);
        this.iconLabel.setBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(0, 0, 0, 0, true));
        this.iconLabel.setName("JYTaskPane.iconLabel");
        this.arrowButton = new ArrowButton();
        int xGap = SyntheticaLookAndFeel.getInt((String)"JYTaskPane.titlePane.gap", (Component)this.taskPane, (int)8, (boolean)true);
        this.titlePane.add((Component)this.iconLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, this.getIconLabelInsets(), 0, 0));
        this.titlePane.add((Component)this.titleLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 2, this.getTitleLabelInsets(xGap), 0, 0));
        this.titlePane.add((Component)this.arrowButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, this.getArrowButtonInsets(), 0, 0));
        return this.titlePane;
    }

    private Insets getIconLabelInsets() {
        return SyntheticaLookAndFeel.getInsets((String)"JYTaskPane.titlePane.icon.insets", (Component)this.taskPane, (boolean)false, (boolean)true);
    }

    private Insets getTitleLabelInsets(int xGap) {
        Insets titleInsets = SyntheticaLookAndFeel.getInsets((String)"JYTaskPane.titlePane.title.insets", (Component)this.taskPane, (boolean)false, (boolean)true);
        return new Insets(titleInsets.top, titleInsets.left + xGap, titleInsets.bottom, titleInsets.right + xGap);
    }

    private Insets getArrowButtonInsets() {
        return SyntheticaLookAndFeel.getInsets((String)"JYTaskPane.titlePane.arrowButton.insets", (Component)this.taskPane, (Insets)new Insets(2, 0, 2, 6), (boolean)true);
    }

    protected void paintTitlePaneBackground(Graphics g, SyntheticaState state, boolean special, boolean expanded, int x, int y, int w, int h) {
        Graphics2D g2 = (Graphics2D)g;
        Shape shape = this.createTitleShape(x, y, w, h, 4.0f, expanded);
        g2.setPaint(new Color(0xDDDDDD));
        g2.fill(shape);
    }

    protected void paintTitlePaneFocus(Graphics g, SyntheticaState state, boolean special, boolean expanded, int x, int y, int w, int h) {
    }

    protected void paintArrowIcon(Graphics g, SyntheticaState state, boolean special, boolean expanded, int x, int y, int w, int h) {
        Graphics2D g2 = (Graphics2D)g;
        Shape shape = expanded ? this.createUpShape(w / 2, h / 2 - 2) : this.createDownShape(w / 2, h / 2 - 2);
        g2.setPaint(Color.BLACK);
        g2.draw(shape);
    }

    private Shape createTitleShape(float x, float y, float w, float h, float arc, boolean expanded) {
        GeneralPath path = new GeneralPath();
        path.moveTo(x, y + h);
        path.lineTo(x, arc /= 2.0f);
        path.quadTo(x, y, x + arc, y);
        path.lineTo(x + w - arc, y);
        path.quadTo(x + w, y, x + w, y + arc);
        path.lineTo(x + w, y + h);
        if (!expanded) {
            path.closePath();
        }
        return path;
    }

    private Shape createUpShape(float x, float y) {
        GeneralPath path = new GeneralPath();
        path.moveTo(x, y + 3.0f);
        path.lineTo(x + 3.0f, y);
        path.lineTo(x + 6.0f, y + 3.0f);
        path.moveTo(x, y + 6.0f);
        path.lineTo(x + 3.0f, y + 3.0f);
        path.lineTo(x + 6.0f, y + 6.0f);
        return path;
    }

    private Shape createDownShape(float x, float y) {
        GeneralPath path = new GeneralPath();
        path.moveTo(x, y);
        path.lineTo(x + 3.0f, y + 3.0f);
        path.lineTo(x + 6.0f, y);
        path.moveTo(x, y + 3.0f);
        path.lineTo(x + 3.0f, y + 6.0f);
        path.lineTo(x + 6.0f, y + 3.0f);
        return path;
    }

    private class ArrowButton
    extends JButton {
        private static final long serialVersionUID = 3382579741465887725L;

        public ArrowButton() {
            this.setFocusPainted(false);
            this.setFocusable(false);
            this.setOpaque(false);
            this.setBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(0, 0, 0, 0, true));
            this.setBorderPainted(false);
            this.setContentAreaFilled(false);
            this.setName("JYTaskPane.arrowButton");
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent evt) {
                    evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                    this.dispatchMouseEvent(evt);
                }

                @Override
                public void mouseExited(MouseEvent evt) {
                    evt.getComponent().setCursor(null);
                    this.dispatchMouseEvent(evt);
                }

                @Override
                public void mouseClicked(MouseEvent evt) {
                    if (((ArrowButton)ArrowButton.this).BasicJYTaskPaneUI.this.taskPane.isEnabled() && !this.collapseOnMousePressed()) {
                        ((ArrowButton)ArrowButton.this).BasicJYTaskPaneUI.this.taskPane.setCollapsed(!((ArrowButton)ArrowButton.this).BasicJYTaskPaneUI.this.taskPane.isCollapsed());
                    }
                }

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (((ArrowButton)ArrowButton.this).BasicJYTaskPaneUI.this.taskPane.isEnabled() && this.collapseOnMousePressed()) {
                        ((ArrowButton)ArrowButton.this).BasicJYTaskPaneUI.this.taskPane.setCollapsed(!((ArrowButton)ArrowButton.this).BasicJYTaskPaneUI.this.taskPane.isCollapsed());
                    }
                }

                @Override
                public void mouseMoved(MouseEvent evt) {
                    this.dispatchMouseEvent(evt);
                }

                private void dispatchMouseEvent(MouseEvent evt) {
                    if ((evt.getModifiersEx() & Integer.MIN_VALUE) != 0) {
                        return;
                    }
                    Point p = SwingUtilities.convertPoint(evt.getComponent(), evt.getPoint(), ((ArrowButton)ArrowButton.this).BasicJYTaskPaneUI.this.titlePane);
                    MouseEvent e = new MouseEvent(((ArrowButton)ArrowButton.this).BasicJYTaskPaneUI.this.titlePane, evt.getID(), evt.getWhen(), evt.getModifiersEx(), p.x, p.y, evt.getClickCount(), evt.isPopupTrigger(), evt.getButton());
                    ((ArrowButton)ArrowButton.this).BasicJYTaskPaneUI.this.titlePane.dispatchEvent(e);
                }

                private boolean collapseOnMousePressed() {
                    return SyntheticaLookAndFeel.getBoolean((String)"JYTaskPane.collapseOnMousePressed", (Component)((ArrowButton)ArrowButton.this).BasicJYTaskPaneUI.this.taskPane, (boolean)false);
                }
            });
        }

        @Override
        public Icon getIcon() {
            return super.getIcon() == null ? BasicJYTaskPaneUI.this.arrowIcon : super.getIcon();
        }

        @Override
        public Icon getRolloverIcon() {
            return super.getRolloverIcon() == null ? BasicJYTaskPaneUI.this.arrowIconHover : super.getRolloverIcon();
        }
    }

    private class ArrowIcon
    implements Icon {
        private boolean hover;

        public ArrowIcon(boolean hover) {
            this.hover = hover;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Icon icon = this.getArrowIcon();
            if (icon == null) {
                SyntheticaState state = new SyntheticaState(this.hover && BasicJYTaskPaneUI.this.taskPane.isEnabled() ? SyntheticaState.State.HOVER.toInt() : 0);
                BasicJYTaskPaneUI.this.paintArrowIcon(g, state, BasicJYTaskPaneUI.this.taskPane.isSpecial(), !BasicJYTaskPaneUI.this.taskPane.isCollapsed(), x, y, this.getIconWidth(), this.getIconHeight());
            } else {
                icon.paintIcon(c, g, x, y);
            }
        }

        @Override
        public int getIconWidth() {
            Icon icon = this.getArrowIcon();
            return icon == null ? SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(16)).intValue() : icon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            Icon icon = this.getArrowIcon();
            return icon == null ? SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(16)).intValue() : icon.getIconHeight();
        }

        private Icon getArrowIcon() {
            return BasicJYTaskPaneUI.this.taskPane.isCollapsed() ? BasicJYTaskPaneUI.this.taskPane.getCollapsedIcon() : BasicJYTaskPaneUI.this.taskPane.getExpandedIcon();
        }
    }

    private class TitlePanel
    extends JPanel
    implements UIResource {
        private static final long serialVersionUID = -3491688257438764832L;
        private MouseAdapter mouseListener;

        public TitlePanel() {
            this.setLayout(new GridBagLayout());
            this.setOpaque(false);
            this.setBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(SyntheticaLookAndFeel.getInsets((String)"JYTaskPane.titlePane.insets", (Component)BasicJYTaskPaneUI.this.taskPane, (Insets)new Insets(2, 4, 2, 4), (boolean)true), false));
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent evt) {
                    TitlePanel.this.repaint();
                }

                @Override
                public void focusGained(FocusEvent evt) {
                    TitlePanel.this.repaint();
                }
            });
            this.mouseListener = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    this.dispatchMouseEvent(evt);
                }

                @Override
                public void mousePressed(MouseEvent evt) {
                    this.dispatchMouseEvent(evt);
                }

                @Override
                public void mouseReleased(MouseEvent evt) {
                    this.dispatchMouseEvent(evt);
                }

                @Override
                public void mouseEntered(MouseEvent evt) {
                    evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                    BasicJYTaskPaneUI.this.setTitleForeground(this.getTitleColor(true));
                    this.dispatchMouseEvent(evt);
                }

                @Override
                public void mouseExited(MouseEvent evt) {
                    evt.getComponent().setCursor(null);
                    BasicJYTaskPaneUI.this.setTitleForeground(this.getTitleColor(false));
                    this.dispatchMouseEvent(evt);
                }

                private void dispatchMouseEvent(MouseEvent evt) {
                    Point p = SwingUtilities.convertPoint(evt.getComponent(), evt.getPoint(), ((TitlePanel)TitlePanel.this).BasicJYTaskPaneUI.this.arrowButton);
                    MouseEvent e = new MouseEvent(((TitlePanel)TitlePanel.this).BasicJYTaskPaneUI.this.arrowButton, evt.getID(), evt.getWhen(), evt.getModifiersEx() | Integer.MIN_VALUE, p.x, p.y, evt.getClickCount(), evt.isPopupTrigger(), evt.getButton());
                    ((TitlePanel)TitlePanel.this).BasicJYTaskPaneUI.this.arrowButton.dispatchEvent(e);
                }

                private Color getTitleColor(boolean hover) {
                    Color specialForegroundHover;
                    if (!((TitlePanel)TitlePanel.this).BasicJYTaskPaneUI.this.taskPane.isEnabled()) {
                        hover = false;
                    }
                    Color foregroundHover = ((TitlePanel)TitlePanel.this).BasicJYTaskPaneUI.this.taskPane.titleForegroundIsUIResource() ? SyntheticaLookAndFeel.getColor((String)"TaskPane.titleOver", (Component)((TitlePanel)TitlePanel.this).BasicJYTaskPaneUI.this.taskPane, (Color)this.getHoverColor(((TitlePanel)TitlePanel.this).BasicJYTaskPaneUI.this.taskPane.getTitleForeground())) : this.getHoverColor(((TitlePanel)TitlePanel.this).BasicJYTaskPaneUI.this.taskPane.getTitleForeground());
                    Color color = specialForegroundHover = ((TitlePanel)TitlePanel.this).BasicJYTaskPaneUI.this.taskPane.specialTitleForegroundIsUIResource() ? SyntheticaLookAndFeel.getColor((String)"TaskPane.specialTitleOver", (Component)((TitlePanel)TitlePanel.this).BasicJYTaskPaneUI.this.taskPane, (Color)this.getHoverColor(((TitlePanel)TitlePanel.this).BasicJYTaskPaneUI.this.taskPane.getSpecialTitleForeground())) : this.getHoverColor(((TitlePanel)TitlePanel.this).BasicJYTaskPaneUI.this.taskPane.getSpecialTitleForeground());
                    Color foreground = ((TitlePanel)TitlePanel.this).BasicJYTaskPaneUI.this.taskPane.isSpecial() ? (hover ? specialForegroundHover : ((TitlePanel)TitlePanel.this).BasicJYTaskPaneUI.this.taskPane.getSpecialTitleForeground()) : (hover ? foregroundHover : ((TitlePanel)TitlePanel.this).BasicJYTaskPaneUI.this.taskPane.getTitleForeground());
                    return foreground;
                }

                private Color getHoverColor(Color color) {
                    return color == null ? Color.BLACK.brighter() : color.brighter();
                }
            };
        }

        public void setMouseSensitive(boolean enabled) {
            if (enabled) {
                this.addMouseListener(this.mouseListener);
            } else {
                this.removeMouseListener(this.mouseListener);
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            int x = 0;
            int y = 0;
            int w = this.getWidth();
            int h = this.getHeight();
            SyntheticaState state = new SyntheticaState();
            BasicJYTaskPaneUI.this.paintTitlePaneBackground(g, state, BasicJYTaskPaneUI.this.taskPane.isSpecial(), !BasicJYTaskPaneUI.this.taskPane.isCollapsed(), x, y, w, h);
            if (this.hasFocus()) {
                state.setState(SyntheticaState.State.FOCUSED);
                BasicJYTaskPaneUI.this.paintTitlePaneFocus(g, state, BasicJYTaskPaneUI.this.taskPane.isSpecial(), !BasicJYTaskPaneUI.this.taskPane.isCollapsed(), x, y, w, h);
            }
        }
    }

    private class ToggleCollapsedAction
    extends AbstractAction {
        private static final long serialVersionUID = 6975483484274221317L;

        public ToggleCollapsedAction() {
            super("toggleCollapsed");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BasicJYTaskPaneUI.this.taskPane.setCollapsed(!BasicJYTaskPaneUI.this.taskPane.isCollapsed());
        }

        @Override
        public boolean isEnabled() {
            return BasicJYTaskPaneUI.this.taskPane.isEnabled();
        }
    }
}

