/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.tabpane.ui.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaComponentPainter;
import de.javasoft.plaf.synthetica.painter.TabbedPanePainter;
import de.javasoft.plaf.synthetica.painter.UIKey;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.SynthContext;

public class JYTabbedPanePainter
extends SyntheticaComponentPainter {
    public static final String JYTABBEDPANE_PAINTER = "Synthetica.JYTabbedPanePainter";
    private int[] xCrop;
    private int[] yCrop;
    private int cropSegmentSize;

    public JYTabbedPanePainter() {
        int[] nArray = new int[8];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 2;
        nArray[7] = 2;
        this.xCrop = nArray;
        int[] nArray2 = new int[8];
        nArray2[1] = 3;
        nArray2[2] = 3;
        nArray2[3] = 6;
        nArray2[4] = 6;
        nArray2[5] = 9;
        nArray2[6] = 9;
        nArray2[7] = 12;
        this.yCrop = nArray2;
        this.cropSegmentSize = 12;
    }

    public static JYTabbedPanePainter getInstance() {
        return JYTabbedPanePainter.getInstance(null);
    }

    public static JYTabbedPanePainter getInstance(SynthContext sc) {
        SyntheticaComponentPainter instance = (SyntheticaComponentPainter)instances.get(JYTabbedPanePainter.getPainterClassName((SynthContext)sc, JYTabbedPanePainter.class, (String)JYTABBEDPANE_PAINTER));
        if (instance == null) {
            instance = JYTabbedPanePainter.getInstance((SynthContext)sc, JYTabbedPanePainter.class, (String)JYTABBEDPANE_PAINTER);
        }
        return (JYTabbedPanePainter)instance;
    }

    public void paintTabbedPaneTabAreaBackground(JComponent c, SyntheticaState state, int placement, int angle, Graphics g, int x, int y, int w, int h) {
        TabbedPanePainter.getInstance().paintTabbedPaneTabAreaBackground(c, state, placement, angle, g, x, y, w, h);
    }

    public void paintTabbedPaneContentBorder(JComponent c, SyntheticaState state, int placement, boolean gap4SelectedTab, int angle, Graphics g, int x, int y, int w, int h) {
        TabbedPanePainter.getInstance().paintTabbedPaneContentBorder(c, state, placement, gap4SelectedTab, angle, g, x, y, w, h);
    }

    public void paintTabbedPaneTab(JComponent c, SyntheticaState state, int tabIndex, int placement, int position, int angle, Graphics g, int x, int y, int w, int h) {
        TabbedPanePainter.getInstance().paintTabbedPaneTab(c, state, tabIndex, placement, position, angle, g, x, y, w, h);
    }

    public void paintCroppedEdge(JComponent c, SyntheticaState state, int placement, boolean leading, Graphics g, int x, int y, int w, int h, Color background, Color foreground) {
        boolean isVertical = placement == 2 || placement == 4;
        boolean ltr = c.getComponentOrientation().isLeftToRight();
        String imagePath = "JYTabbedPane.tabsPanel.croppedEdge.image";
        imagePath = isVertical ? String.valueOf(imagePath) + (placement == 2 ? (leading ? ".trailing" : ".leading") : (leading ? ".leading" : ".trailing")) : String.valueOf(imagePath) + (ltr ? (leading ? ".leading" : ".trailing") : (leading ? ".trailing" : ".leading"));
        Insets sInsets = SyntheticaLookAndFeel.getInsets((String)(String.valueOf(imagePath) + ".insets"), (Component)c);
        if (sInsets == null) {
            sInsets = new Insets(0, 0, 0, 0);
        }
        Insets dInsets = sInsets;
        if ((imagePath = this.resolveImagePath(imagePath, c)) != null) {
            Boolean flipVertical = (Boolean)c.getClientProperty("Synthetica.flipVertical");
            c.putClientProperty("Synthetica.flipVertical", placement == 3 || placement == 2 && !ltr || placement == 4 && !ltr);
            ImagePainter imagePainter = new ImagePainter(c, g, x, y, isVertical ? h : w, isVertical ? w : h, imagePath, sInsets, dInsets, 0, 0);
            if (placement == 2) {
                imagePainter.setAngle(-90);
            } else if (placement == 4) {
                imagePainter.setAngle(90);
            }
            imagePainter.draw();
            c.putClientProperty("Synthetica.flipVertical", flipVertical);
        } else {
            Shape s = this.createCroppedEdgeShape(placement, leading, ltr, x, y, w, h);
            Graphics2D g2 = this.prepareGraphics2D(null, g, x, y, true);
            g2.setPaint(background);
            g2.fill(s);
            g2.draw(s);
            s = this.createCroppedLineShape(placement, leading, ltr, x, y, w, h);
            g2.setPaint(foreground);
            g2.draw(s);
            this.restoreGraphics2D(g2);
        }
    }

    protected Shape createCroppedLineShape(int placement, boolean leading, boolean ltr, int x, int y, int w, int h) {
        GeneralPath path = new GeneralPath();
        if (placement == 2 || placement == 4) {
            int n = leading ? h - 1 : 2;
            int x_ = x;
            path.moveTo(x_ + this.yCrop[0], (y += n) - this.xCrop[0]);
            while (x_ <= x + w) {
                int i = 0;
                while (i < this.xCrop.length) {
                    path.lineTo(x_ + this.yCrop[i + 1] - 3, y - this.xCrop[i + 1]);
                    i += 2;
                }
                x_ += this.cropSegmentSize;
            }
        } else {
            int n = (leading ^= !ltr) ? w - 1 : 2;
            int y_ = y;
            path.moveTo((x += n) - this.xCrop[0], y_ + this.yCrop[0]);
            while (y_ <= y + h) {
                int i = 0;
                while (i < this.xCrop.length) {
                    path.lineTo(x - this.xCrop[i + 1], y_ + this.yCrop[i + 1] - 3);
                    i += 2;
                }
                y_ += this.cropSegmentSize;
            }
        }
        return path;
    }

    protected Shape createCroppedEdgeShape(int placement, boolean leading, boolean ltr, int x, int y, int w, int h) {
        GeneralPath path = (GeneralPath)this.createCroppedLineShape(placement, leading, ltr, x, y, w, h);
        if (placement == 2 || placement == 4) {
            int y_ = y + (leading ? 0 : h - 1);
            int x2 = x + w - 1;
            path.lineTo(x2, y_);
            path.lineTo(x, y_);
        } else {
            int x_ = x + ((leading ^= !ltr) ? 0 : w - 1);
            int y2 = y + h - 1;
            path.lineTo(x_, y2);
            path.lineTo(x_, y);
        }
        path.closePath();
        return path;
    }

    public void paintTabOverviewPreviewPanel(JComponent c, JPanel previewPane, SyntheticaState state, int tabIndex, Graphics g, int x, int y, int w, int h) {
        UIKey key = new UIKey("tabOverviewPreviewPanel", state, "JYTabbedPane.");
        String imagePath = UIKey.resolveImagePath((JComponent)c, (String)key.get(), (String)"background.image", (int)2);
        if (imagePath != null) {
            if (SyntheticaLookAndFeel.getBoolean((String)"JYTabbedPane.tabOverviewPreviewPanel.colorizeSupport.enabled", (Component)c)) {
                String bgKey = "Synthetica.tabbedPane.tab." + tabIndex + ".background";
                Color bg = (Color)c.getClientProperty(bgKey);
                Color tabBg = this.getTabBackgroundAt(c, tabIndex);
                if (bg == null && tabBg != null && !(tabBg instanceof UIResource)) {
                    bg = tabBg;
                }
                if (bg != null) {
                    int uiAlpha;
                    previewPane.putClientProperty("Synthetica.background", bg);
                    Float alpha = null;
                    if (c.getClientProperty(String.valueOf(bgKey) + ".alpha") != null) {
                        alpha = (Float)c.getClientProperty(String.valueOf(bgKey) + ".alpha");
                    }
                    if ((uiAlpha = SyntheticaLookAndFeel.getInt((String)(state.isSet(SyntheticaState.State.HOVER) ? "JYTabbedPane.tabOverviewPreviewPanel.hover.background.alpha" : "JYTabbedPane.tabOverviewPreviewPanel.background.alpha"), (Component)c, (int)-1)) >= 0) {
                        alpha = Float.valueOf(Float.valueOf(uiAlpha).floatValue() / 100.0f);
                    }
                    previewPane.putClientProperty("Synthetica.background.alpha", alpha);
                }
            }
            int cycles = SyntheticaLookAndFeel.getInt((String)key.get("animation.cycles"), (Component)c, (int)1);
            int delay = SyntheticaLookAndFeel.getInt((String)key.get("animation.delay"), (Component)c, (int)50);
            int type = SyntheticaLookAndFeel.getInt((String)key.get("animation.type"), (Component)c, (int)(state.isSet(SyntheticaState.State.HOVER) ? 1 : 2));
            Insets sInsets = this.getImageInsets("JYTabbedPane.tabOverviewPreviewPanel.background.image.insets", c);
            Insets dInsets = (Insets)sInsets.clone();
            ImagePainter imagePainter = new ImagePainter((JComponent)previewPane, cycles, delay, type, state.getState(), g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
            imagePainter.draw();
        } else {
            Graphics2D g2 = this.prepareGraphics2D(null, g, x, y, true);
            float arc = this.scaleArc(2.0f);
            Shape shape = this.createTabOverviewPreviewShape(0.0f, 0.0f, JYTabbedPanePainter.calcRelativeLength((Graphics2D)g2, (float)w, (float)0.0f), JYTabbedPanePainter.calcRelativeLength((Graphics2D)g2, (float)h, (float)0.0f), arc);
            g2.setPaint(this.getTabOverviewPreviewBackgroundColor(state));
            g2.fill(shape);
            if (SyntheticaLookAndFeel.getBoolean((String)"JYTabbedPane.tabOverviewPreviewPanel.colorizeSupport.enabled", (Component)c)) {
                String bgKey = "Synthetica.tabbedPane.tab." + tabIndex + ".background";
                Color bg = (Color)c.getClientProperty(bgKey);
                Color tabBg = this.getTabBackgroundAt(c, tabIndex);
                if (bg == null && tabBg != null && !(tabBg instanceof UIResource)) {
                    bg = tabBg;
                }
                if (bg != null) {
                    Float alpha = (Float)c.getClientProperty(String.valueOf(bgKey) + ".alpha");
                    int uiAlpha = SyntheticaLookAndFeel.getInt((String)(state.isSet(SyntheticaState.State.HOVER) ? "JYTabbedPane.tabOverviewPreviewPanel.hover.background.alpha" : "JYTabbedPane.tabOverviewPreviewPanel.background.alpha"), (Component)c, (int)-1);
                    if (uiAlpha >= 0) {
                        alpha = Float.valueOf(Float.valueOf(uiAlpha).floatValue() / 100.0f);
                    }
                    g2.setPaint(this.createAlphaColor(bg, alpha));
                    g2.fill(JYTabbedPanePainter.subtractStroke((Graphics2D)g2, (Shape)shape));
                }
            }
            g2.setPaint(this.getTabOverviewPreviewBorderColor(state));
            g2.draw(shape);
            this.restoreGraphics2D(g2);
        }
    }

    private Color getTabBackgroundAt(JComponent c, int index) {
        JTabbedPane tabPane;
        Color color = null;
        if (c instanceof JTabbedPane && index < (tabPane = (JTabbedPane)c).getTabCount()) {
            color = tabPane.getBackgroundAt(index);
        }
        return color;
    }

    protected Color getTabOverviewPreviewBorderColor(SyntheticaState state) {
        return state.isSet(SyntheticaState.State.HOVER) ? new Color(-2147442448, true) : new Color(0x2F000000, true);
    }

    protected Color getTabOverviewPreviewBackgroundColor(SyntheticaState state) {
        return state.isSet(SyntheticaState.State.HOVER) ? new Color(1073783024, true) : new Color(0x1A000000, true);
    }

    protected Shape createTabOverviewPreviewShape(float x, float y, float w, float h, float arc) {
        return new RoundRectangle2D.Float(x, y, w, h, arc, arc);
    }
}

