/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.tabpane.ui;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.tabpane.JYTabbedPane;
import de.javasoft.tabpane.ui.BasicJYTabbedPaneUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;

public class SyntheticaJYTabbedPaneUI
extends BasicJYTabbedPaneUI {
    public static ComponentUI createUI(JComponent c) {
        WeakReference reference;
        ComponentUI ui;
        if (c.getName() == null) {
            c.setName("JYTabbedPane");
        }
        ComponentUI componentUI = ui = (reference = (WeakReference)uis.get(c)) == null ? null : (ComponentUI)reference.get();
        if (ui == null) {
            ui = new SyntheticaJYTabbedPaneUI();
            uis.put(c, new WeakReference<ComponentUI>(ui));
        }
        return ui;
    }

    @Override
    protected void installDefaults(JComponent c) {
        super.installDefaults(c);
        JYTabbedPane tabbedPane = (JYTabbedPane)c;
        Border border = tabbedPane.getBorder();
        if (border == null || border instanceof UIResource) {
            SynthStyle ss = SynthLookAndFeel.getStyle(this.tabPane, Region.TABBED_PANE);
            SynthContext sc = new SynthContext(this.tabPane, Region.TABBED_PANE, ss, 0);
            tabbedPane.setBorder(new BorderUIResource.EmptyBorderUIResource(ss.getInsets(sc, null)));
        }
        if (tabbedPane.paintSelectedTabBoldIsUIResource()) {
            tabbedPane.setPaintSelectedTabBold(SyntheticaLookAndFeel.getBoolean((String)"JYTabbedPane.tab.selectedBold", (Component)c), true);
        }
    }

    @Override
    protected void updateTabbedPaneBorder() {
        SynthStyle ss = SynthLookAndFeel.getStyle(this.tabPane, Region.TABBED_PANE);
        SynthContext sc = new SynthContext(this.tabPane, Region.TABBED_PANE, ss, 0);
        Border border = this.tabPane.getBorder();
        if (border == null || border instanceof UIResource) {
            this.tabPane.setBorder(new BorderUIResource.EmptyBorderUIResource(ss.getInsets(sc, null)));
        }
    }

    @Override
    protected Color getDefaultTabForeground(int tabIndex) {
        boolean selected;
        boolean bl = selected = this.tabPane.getSelectedIndex() == tabIndex;
        boolean disabled = tabIndex < 0 || tabIndex >= this.tabPane.getTabCount() ? false : !this.tabPane.isEnabledAt(tabIndex);
        boolean hover = (Integer)SyntheticaLookAndFeel.getClientProperty((String)"Synthetica.MOUSE_OVER", (JComponent)this.tabPane, (Object)Integer.MIN_VALUE) == tabIndex;
        SynthStyle ss = SynthLookAndFeel.getStyle(this.tabPane, Region.TABBED_PANE_TAB);
        SynthContext sc = new SynthContext(this.tabPane, Region.TABBED_PANE_TAB, ss, selected ? 512 : (disabled ? 8 : (hover ? 2 : 0)));
        Color color = ss.getColor(sc, ColorType.TEXT_FOREGROUND);
        return color;
    }

    @Override
    protected Insets getTabInsets(boolean selected) {
        SynthStyle ss = SynthLookAndFeel.getStyle(this.tabPane, Region.TABBED_PANE_TAB);
        SynthContext sc = new SynthContext(this.tabPane, Region.TABBED_PANE_TAB, ss, 0);
        Insets tabInsets = ss.getInsets(sc, null);
        tabInsets.top += 2;
        ++tabInsets.left;
        tabInsets.bottom += 0;
        ++tabInsets.right;
        if (selected) {
            tabInsets.top -= 2;
            tabInsets.bottom += 2;
            if (SyntheticaLookAndFeel.get((String)"Synthetica.tabbedPane.tab.selected.text.insets", (Component)this.tabPane) != null) {
                Insets insets = SyntheticaLookAndFeel.getInsets((String)"Synthetica.tabbedPane.tab.selected.text.insets", (Component)this.tabPane, (boolean)false, (boolean)true);
                tabInsets.top += insets.top;
                tabInsets.bottom -= insets.top;
            }
        } else if (SyntheticaLookAndFeel.get((String)"Synthetica.tabbedPane.tab.text.insets", (Component)this.tabPane) != null) {
            Insets insets = SyntheticaLookAndFeel.getInsets((String)"Synthetica.tabbedPane.tab.text.insets", (Component)this.tabPane, (boolean)false, (boolean)true);
            tabInsets.top += insets.top;
            tabInsets.bottom -= insets.top;
        }
        return tabInsets;
    }

    @Override
    protected Insets getTabAreaPanelInsets() {
        Insets insets = this.tabAreaInsets;
        SynthStyle ss = SynthLookAndFeel.getStyle(this.tabPane, Region.TABBED_PANE_TAB_AREA);
        SynthContext sc = new SynthContext(this.tabPane, Region.TABBED_PANE_TAB_AREA, ss, 0);
        insets = ss.getInsets(sc, null);
        return insets;
    }
}

