/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.tabpane.ui;

import de.javasoft.label.JYLabel;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.SyntheticaBasicIconPainter;
import de.javasoft.syntheticaaddons.SimpleDropDownButton;
import de.javasoft.syntheticaaddons.SyntheticaAddonsUtilities;
import de.javasoft.tabpane.JYTabbedPane;
import de.javasoft.tabpane.ui.JYTabbedPaneUI;
import de.javasoft.tabpane.ui.controls.ButtonFactory;
import de.javasoft.tabpane.ui.controls.IButtonFactory;
import de.javasoft.tabpane.ui.controls.ICloseButtonStrategy;
import de.javasoft.tabpane.ui.controls.JYTabbedPaneLayout;
import de.javasoft.tabpane.ui.controls.Tab;
import de.javasoft.tabpane.ui.controls.TabOverviewDialog;
import de.javasoft.tabpane.ui.painter.JYTabbedPanePainter;
import de.javasoft.widgets.IRotatableComponent;
import de.javasoft.widgets.OverlapBoxLayout;
import de.javasoft.widgets.util.WidgetUtils;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.ViewportLayout;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.text.View;
import org.jdesktop.swingx.icon.EmptyIcon;

public class BasicJYTabbedPaneUI
extends JYTabbedPaneUI {
    private TabAreaPanel tabAreaPanel;
    private JPanel leadingTabsPanel;
    private JPanel trailingTabsPanel;
    private JPanel leadingTabControlsPanel;
    private JPanel trailingTabControlsPanel;
    private TabsPanelViewport tabsPanelViewport;
    private TabsPanel tabsPanel;
    private IButtonFactory buttonFactory;
    private int closeButtonGap;
    private boolean reversedCloseButtonPlacement;
    private int croppedEdgeSize;
    private Color croppedEdgeBackground;
    private Color croppedEdgeForeground;
    private boolean avoidTrailingCroppedTabs;
    private boolean avoidLeadingCroppedTabs;
    private int tabAutoScrollDelay;
    private boolean forcePopupMenuIconSpace;
    private TabPreviewHandler tabPreviewHandler;
    protected static WeakHashMap<JComponent, WeakReference<ComponentUI>> uis = new WeakHashMap();
    private WeakReference<TabOverviewDialog> tabOverviewDialog = new WeakReference<Object>(null);

    static {
        $SWITCH_TABLE$de$javasoft$tabpane$JYTabbedPane$TabControlsPosition = BasicJYTabbedPaneUI.$SWITCH_TABLE$de$javasoft$tabpane$JYTabbedPane$TabControlsPosition();
    }

    @Override
    public void update(Graphics g, JComponent c) {
        super.update(g, c);
    }

    public static ComponentUI createUI(JComponent c) {
        WeakReference<ComponentUI> reference;
        ComponentUI ui;
        if (c.getName() == null) {
            c.setName("JYTabbedPane");
        }
        ComponentUI componentUI = ui = (reference = uis.get(c)) == null ? null : (ComponentUI)reference.get();
        if (ui == null) {
            ui = new BasicJYTabbedPaneUI();
            uis.put(c, new WeakReference<ComponentUI>(ui));
        }
        return ui;
    }

    @Override
    public void installUI(JComponent c) {
        this.tabPane = (JTabbedPane)c;
        if (c.getLayout() == null) {
            c.setLayout(this.createLayoutManager());
            this.installComponents();
        }
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
        this.installDefaults(c);
        this.installListeners(c);
        this.installActions(c);
        this.updateTabbedPaneBorder();
        this.updateAllTabBorders();
        ComponentOrientation o = c.getComponentOrientation();
        c.applyComponentOrientation(o);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallComponents();
        this.tabPane = null;
        this.uninstallDefaults(c);
        this.uninstallListeners(c);
    }

    protected void installDefaults(JComponent c) {
        Boolean enabled;
        Boolean show;
        String key;
        String strategy;
        JYTabbedPane tabbedPane = (JYTabbedPane)c;
        this.tabAreaInsets = new Insets(0, 0, 0, 0);
        JPanel contentPane = tabbedPane.getContentPanel();
        contentPane.updateUI();
        if (tabbedPane.paintSelectedTabBoldIsUIResource()) {
            tabbedPane.setPaintSelectedTabBold(SyntheticaLookAndFeel.getBoolean((String)"JYTabbedPane.tab.selectedBold", (Component)c, (boolean)true), true);
        }
        if (tabbedPane.tabGapIsUIResource()) {
            tabbedPane.setTabGap(SyntheticaLookAndFeel.getInt((String)"JYTabbedPane.tabGap", (Component)c, (boolean)true), true);
        }
        if (tabbedPane.horizontalTabAlignmentIsUIResource()) {
            tabbedPane.setHorizontalTabAlignment(SyntheticaLookAndFeel.getInt((String)"JYTabbedPane.horizontalTabAlignment", (Component)c, (int)2), true);
        }
        if (tabbedPane.verticalTabAlignmentIsUIResource()) {
            tabbedPane.setVerticalTabAlignment(SyntheticaLookAndFeel.getInt((String)"JYTabbedPane.verticalTabAlignment", (Component)c, (int)1), true);
        }
        if (tabbedPane.closeButtonStrategyIsUIResource()) {
            strategy = SyntheticaLookAndFeel.getString((String)"JYTabbedPane.closeButtonStrategy", (Component)c);
            if (strategy == null) {
                strategy = JYTabbedPane.CloseButtonStrategy.NONE.name();
            }
            tabbedPane.setCloseButtonStrategy(JYTabbedPane.CloseButtonStrategy.valueOf(strategy), true);
        }
        if (tabbedPane.tabStyleIsUIResource()) {
            String style = SyntheticaLookAndFeel.getString((String)"JYTabbedPane.tabStyle", (Component)c);
            if (style == null) {
                style = JYTabbedPane.TabStyle.COMMON.name();
            }
            tabbedPane.setTabStyle(JYTabbedPane.TabStyle.valueOf(style), true);
        }
        if (tabbedPane.showScrollButtonsIsUIResource()) {
            key = "JYTabbedPane.showScrollButtons";
            show = SyntheticaLookAndFeel.getBoolean((String)key, (Component)c, (boolean)true);
            tabbedPane.setShowScrollButtons(show, true);
        }
        if (tabbedPane.showPopupButtonIsUIResource()) {
            key = "JYTabbedPane.showPopupButton";
            show = SyntheticaLookAndFeel.getBoolean((String)key, (Component)c, (boolean)true);
            tabbedPane.setShowPopupButton(show, true);
        }
        if (tabbedPane.overlapTabsInversIsUIResource()) {
            key = "JYTabbedPane.overlapTabsInvers";
            tabbedPane.setOverlapTabsInvers(SyntheticaLookAndFeel.getBoolean((String)key, (Component)c, (boolean)false), true);
        }
        if (tabbedPane.tabControlsPositionIsUIResource()) {
            String position = SyntheticaLookAndFeel.getString((String)"JYTabbedPane.tabControlsPosition", (Component)c);
            if (position == null) {
                position = JYTabbedPane.TabControlsPosition.TRAILING.name();
            }
            tabbedPane.setTabControlsPosition(JYTabbedPane.TabControlsPosition.valueOf(position), true);
        }
        if (tabbedPane.tabControlsShowStrategyIsUIResource()) {
            strategy = SyntheticaLookAndFeel.getString((String)"JYTabbedPane.tabControlsShowStrategy", (Component)c);
            if (strategy == null) {
                strategy = JYTabbedPane.TabControlsShowStrategy.AS_NEEDED.name();
            }
            tabbedPane.setTabControlsShowStrategy(JYTabbedPane.TabControlsShowStrategy.valueOf(strategy), true);
        }
        if (tabbedPane.tabScrollAnimationEnabledIsUIResource()) {
            key = "JYTabbedPane.tabScrollAnimationEnabled";
            enabled = SyntheticaLookAndFeel.get((String)key, (Component)c) == null ? Boolean.TRUE : SyntheticaLookAndFeel.getBoolean((String)key, (Component)c);
            tabbedPane.setTabScrollAnimationEnabled(enabled, true);
        }
        if (tabbedPane.tabReorderByDraggingEnabledIsUIResource()) {
            key = "JYTabbedPane.tabReorderByDraggingEnabled";
            enabled = SyntheticaLookAndFeel.get((String)key, (Component)c) == null ? Boolean.TRUE : SyntheticaLookAndFeel.getBoolean((String)key, (Component)c);
            tabbedPane.setTabReorderByDraggingEnabled(enabled, true);
        }
        if (tabbedPane.minimumTabSizeIsUIResource()) {
            tabbedPane.setMinimumTabSize(SyntheticaLookAndFeel.getInt((String)"JYTabbedPane.tab.minimumSize", (Component)c, (int)-1, (boolean)true, (boolean)false), true);
        }
        if (tabbedPane.maximumTabSizeIsUIResource()) {
            tabbedPane.setMaximumTabSize(SyntheticaLookAndFeel.getInt((String)"JYTabbedPane.tab.maximumSize", (Component)c, (int)-1, (boolean)true, (boolean)false), true);
        }
        if (tabbedPane.tabsStretchedEnabledIsUIResource()) {
            tabbedPane.setTabsStretchedEnabled(SyntheticaLookAndFeel.getBoolean((String)"JYTabbedPane.tabsStretchedEnabled", (Component)c), true);
        }
        if (tabbedPane.tabRotationEnabledIsUIResource()) {
            tabbedPane.setTabRotationEnabled(SyntheticaLookAndFeel.getBoolean((String)"JYTabbedPane.tabRotationEnabled", (Component)c, (boolean)true), true);
        }
        if (tabbedPane.showPlusButtonIsUIResource()) {
            tabbedPane.setShowPlusButton(SyntheticaLookAndFeel.getBoolean((String)"JYTabbedPane.showPlusButton", (Component)c, (boolean)false), true);
        }
        if (tabbedPane.tabOverviewEnabledIsUIResource()) {
            tabbedPane.setTabOverviewEnabled(SyntheticaLookAndFeel.getBoolean((String)"JYTabbedPane.tabOverviewEnabled", (Component)c, (boolean)false), true);
        }
        if (tabbedPane.tabPreviewOnHoverEnabledIsUIResource()) {
            tabbedPane.setTabPreviewOnHoverEnabled(SyntheticaLookAndFeel.getBoolean((String)"JYTabbedPane.tabPreviewOnHoverEnabled", (Component)c, (boolean)false), true);
        }
        this.closeButtonGap = SyntheticaLookAndFeel.getInt((String)"JYTabbedPane.tab.closeButtonGap", (Component)this.tabPane, (int)6, (boolean)true);
        this.reversedCloseButtonPlacement = SyntheticaLookAndFeel.getBoolean((String)"JYTabbedPane.tab.reversedCloseButtonPlacement", (Component)this.tabPane, (boolean)false);
        this.tabAutoScrollDelay = SyntheticaLookAndFeel.getInt((String)"JYTabbedPane.tab.autoScrollDelay", (Component)this.tabPane, (int)250);
        this.croppedEdgeSize = SyntheticaLookAndFeel.getInt((String)"JYTabbedPane.tabsPanel.croppedEdge.size", (Component)c, (int)3, (boolean)true);
        this.croppedEdgeBackground = SyntheticaLookAndFeel.getColor((String)"JYTabbedPane.tabsPanel.croppedEdge.background", (Component)c);
        this.forcePopupMenuIconSpace = SyntheticaLookAndFeel.getBoolean((String)"JYTabbedPane.popupMenu.forceIconSpace", (Component)c);
        if (this.croppedEdgeBackground == null) {
            this.croppedEdgeBackground = SyntheticaLookAndFeel.getColor((String)"Panel.background", (Component)c);
        }
        this.croppedEdgeForeground = SyntheticaLookAndFeel.getColor((String)"JYTabbedPane.tabsPanel.croppedEdge.foreground", (Component)c);
        if (this.croppedEdgeForeground == null) {
            this.croppedEdgeForeground = new Color(0x40000000, true);
        }
        this.avoidLeadingCroppedTabs = this.avoidTrailingCroppedTabs = SyntheticaLookAndFeel.getBoolean((String)"JYTabbedPane.tabsPanel.avoidCroppedTabs", (Component)c);
        ((OverlapBoxLayout)this.tabsPanel.getLayout()).setSpaceForInvisibleComponentsRetained(this.avoidTrailingCroppedTabs);
    }

    private void installActions(JComponent c) {
        ActionMap map = c.getActionMap();
        map.put("closeTab", new Tab.CloseTabAction());
        map.put("addTab", this.tabsPanel.createAddTabAction());
        map.put("setSelectedTabIndex", this.tabsPanel.createMnemonicAction());
        map.put("scrollTabIndexToVisible", this.tabsPanel.createScrollTabIndexToVisibleAction());
    }

    protected void uninstallDefaults(JComponent c) {
    }

    protected void installListeners(JComponent c) {
        this.tabPane.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                int index = ((DefaultSingleSelectionModel)evt.getSource()).getSelectedIndex();
                if (SyntheticaLookAndFeel.getBoolean((String)"JYTabbedPane.focusFollowsSelection", (Component)BasicJYTabbedPaneUI.this.tabPane, (boolean)true) && ((JYTabbedPane)BasicJYTabbedPaneUI.this.tabPane).getTabsFocusable() && BasicJYTabbedPaneUI.this.tabsPanel != null && BasicJYTabbedPaneUI.this.tabsPanel.getTab(index) != null && !BasicJYTabbedPaneUI.this.tabOverviewVisible()) {
                    BasicJYTabbedPaneUI.this.tabsPanel.getTab(index).requestFocus();
                }
            }
        });
    }

    private boolean tabOverviewVisible() {
        return this.tabOverviewDialog.get() != null && ((TabOverviewDialog)this.tabOverviewDialog.get()).isVisible();
    }

    protected void uninstallListeners(JComponent c) {
    }

    private void installButtonFactory() {
        String className = SyntheticaLookAndFeel.getString((String)"JYTabbedPane.buttonFactory.className", (Component)this.tabPane);
        if (className == null) {
            this.buttonFactory = new ButtonFactory();
        } else {
            try {
                this.buttonFactory = (IButtonFactory)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    protected void installComponents() {
        this.installButtonFactory();
        int placement = this.tabPane.getTabPlacement();
        this.trailingTabControlsPanel = new JPanel();
        this.trailingTabControlsPanel.setLayout(new BoxLayout(this.trailingTabControlsPanel, placement == 1 || placement == 3 ? 2 : 3));
        this.trailingTabControlsPanel.setOpaque(SyntheticaLookAndFeel.getBoolean((String)"JYTabbedPane.tabControlsPanel.opaque", (Component)this.tabPane, (boolean)true));
        this.trailingTabControlsPanel.add(this.createScrollBackwardButton());
        this.trailingTabControlsPanel.add(this.createScrollForwardButton());
        this.trailingTabControlsPanel.add(this.createPopupButton());
        this.trailingTabsPanel = new JPanel(new BorderLayout());
        this.trailingTabsPanel.setName("JYTabbedPane.TrailingTabsPanel");
        this.trailingTabsPanel.setOpaque(false);
        this.trailingTabsPanel.add((Component)this.trailingTabControlsPanel, this.getBLConstraints(1, placement, "Before"));
        JComponent tc = ((JYTabbedPane)this.tabPane).getTrailingTabAreaComponent();
        if (tc != null) {
            this.trailingTabsPanel.add(tc);
        }
        this.leadingTabControlsPanel = new JPanel();
        this.leadingTabControlsPanel.setLayout(new BoxLayout(this.leadingTabControlsPanel, placement == 1 || placement == 3 ? 2 : 3));
        this.leadingTabControlsPanel.setOpaque(SyntheticaLookAndFeel.getBoolean((String)"JYTabbedPane.tabControlsPanel.opaque", (Component)this.tabPane, (boolean)true));
        this.leadingTabControlsPanel.add(this.createTabOverviewButton());
        this.leadingTabControlsPanel.add(this.createScrollBackwardButton());
        this.leadingTabControlsPanel.add(this.createScrollForwardButton());
        this.leadingTabControlsPanel.add(this.createPopupButton());
        this.leadingTabsPanel = new JPanel(new BorderLayout());
        this.leadingTabsPanel.setName("JYTabbedPane.LeadingTabsPanel");
        this.leadingTabsPanel.setOpaque(false);
        this.leadingTabsPanel.add((Component)this.leadingTabControlsPanel, this.getBLConstraints(1, placement, "After"));
        JComponent lc = ((JYTabbedPane)this.tabPane).getLeadingTabAreaComponent();
        if (lc != null) {
            this.leadingTabsPanel.add(lc);
        }
        this.tabsPanel = new TabsPanel();
        this.tabsPanelViewport = new TabsPanelViewport();
        this.tabsPanelViewport.setView(this.tabsPanel);
        this.tabAreaPanel = new TabAreaPanel();
        this.tabAreaPanel.add((Component)this.leadingTabsPanel, this.getBLConstraints(1, placement, "Before"));
        this.tabAreaPanel.add(this.tabsPanelViewport);
        this.tabAreaPanel.add((Component)this.trailingTabsPanel, this.getBLConstraints(1, placement, "After"));
        this.tabPane.add((Component)this.tabAreaPanel, this.getBLConstraints(1, placement, "First"));
        this.tabPane.add((Component)((JYTabbedPane)this.tabPane).getContentPanel(), "Center");
        this.installTabs(this.tabPane);
    }

    protected void updateTabbedPaneBorder() {
    }

    @Override
    protected void uninstallComponents() {
    }

    @Override
    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
    }

    @Override
    protected void paintTabArea(Graphics g, int tabPlacement, int selectedIndex) {
    }

    @Override
    protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
    }

    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
    }

    @Override
    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics fm, int tabIndex, String text, Rectangle textRect, boolean isSelected) {
    }

    @Override
    protected void paintIcon(Graphics g, int tabPlacement, int tabIndex, Icon icon, Rectangle iconRect, boolean isSelected) {
        if (tabPlacement == 2 || tabPlacement == 4) {
            Graphics2D g2 = (Graphics2D)g;
            int angle = tabPlacement == 2 ? -90 : 90;
            double origin = tabPlacement == 2 ? -(iconRect.width - iconRect.height) / 2 : (iconRect.width - iconRect.height) / 2;
            g2.translate(origin, origin);
            g2.rotate(Math.toRadians(angle), iconRect.x + iconRect.width / 2, iconRect.y + iconRect.height / 2);
            super.paintIcon(g, tabPlacement, tabIndex, icon, iconRect, isSelected);
            g2.rotate(-Math.toRadians(angle), iconRect.x + iconRect.width / 2, iconRect.y + iconRect.height / 2);
            g2.translate(-origin, -origin);
        } else {
            super.paintIcon(g, tabPlacement, tabIndex, icon, iconRect, isSelected);
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        int selectedIndex;
        int placement = this.tabPane.getTabPlacement();
        if (this.isVerticalTabPlacement() && !this.tabPane.getComponentOrientation().isLeftToRight()) {
            placement = placement == 2 ? 4 : 2;
        }
        Rectangle viewRect = SwingUtilities.convertRectangle(this.tabsPanelViewport.getParent(), this.tabsPanelViewport.getBounds(), this.tabPane);
        if (this.tabsPanel.getShowPlusButton()) {
            this.tabsPanelViewport.calculatePlusButtonAwareViewRect(viewRect);
        }
        this.tabPane.putClientProperty("JTabbedPane.visibleSelectedTabRect", (selectedIndex = this.tabPane.getSelectedIndex()) < 0 || selectedIndex >= this.rects.length ? null : viewRect.intersection(this.rects[selectedIndex]));
    }

    @Override
    protected void layoutLabel(int tabPlacement, FontMetrics metrics, int tabIndex, String title, Icon icon, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new JYTabbedPaneLayout((JYTabbedPane)this.tabPane, this);
    }

    protected JButton createScrollForwardButton() {
        AbstractAction a = new AbstractAction(){
            private static final long serialVersionUID = -4600543021015290032L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicJYTabbedPaneUI.this.tabsPanelViewport.scrollForward();
            }
        };
        a.putValue("ShortDescription", UIManager.get("JYTabbedPane.scrollButton.forward.toolTip"));
        JButton b = this.buttonFactory.createScrollForwardButton((JYTabbedPane)this.tabPane, a);
        if (SyntheticaLookAndFeel.getBoolean((String)"JYTabbedPane.scrollButton.doubleClickSupport", (Component)this.tabPane, (boolean)true)) {
            b.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    if (evt.getClickCount() == 2) {
                        BasicJYTabbedPaneUI.this.tabsPanelViewport.setLeadingTabIndex(BasicJYTabbedPaneUI.this.tabPane.getTabCount() - 1);
                    }
                }
            });
        }
        return b;
    }

    protected JButton createScrollBackwardButton() {
        AbstractAction a = new AbstractAction(){
            private static final long serialVersionUID = 5713855202221320228L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicJYTabbedPaneUI.this.tabsPanelViewport.scrollBackward();
            }
        };
        a.putValue("ShortDescription", UIManager.get("JYTabbedPane.scrollButton.backward.toolTip"));
        JButton b = this.buttonFactory.createScrollBackwardButton((JYTabbedPane)this.tabPane, a);
        if (SyntheticaLookAndFeel.getBoolean((String)"JYTabbedPane.scrollButton.doubleClickSupport", (Component)this.tabPane, (boolean)true)) {
            b.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    if (evt.getClickCount() == 2) {
                        BasicJYTabbedPaneUI.this.tabsPanelViewport.setLeadingTabIndex(0);
                    }
                }
            });
        }
        return b;
    }

    protected JButton createPlusButton() {
        Action a = this.getTabbedPane().getActionMap().get("addTab");
        return this.buttonFactory.createPlusButton((JYTabbedPane)this.tabPane, a);
    }

    protected JButton createTabOverviewButton() {
        AbstractAction a = new AbstractAction(){
            private static final long serialVersionUID = -1692512757990693052L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicJYTabbedPaneUI.this.tabOverviewDialog = new WeakReference<TabOverviewDialog>(new TabOverviewDialog(BasicJYTabbedPaneUI.this.getTabbedPane(), BasicJYTabbedPaneUI.this.buttonFactory));
                ((TabOverviewDialog)BasicJYTabbedPaneUI.this.tabOverviewDialog.get()).setVisible(true);
            }
        };
        a.putValue("ShortDescription", UIManager.get("JYTabbedPane.tabOverviewButton.toolTip"));
        return this.buttonFactory.createTabOverviewButton((JYTabbedPane)this.tabPane, a);
    }

    protected JButton createPopupButton() {
        return this.buttonFactory.createPopupButton((JYTabbedPane)this.tabPane);
    }

    private JButton getScrollButton(boolean forward) {
        return this.findButton(forward ? "JYTabbedPane.ScrollForwardButton" : "JYTabbedPane.ScrollBackwardButton");
    }

    private JButton getPopupButton() {
        return this.findButton("JYTabbedPane.PopupButton");
    }

    private JButton findButton(String key) {
        JButton b = (JButton)SyntheticaLookAndFeel.findComponent((String)key, (Container)this.leadingTabControlsPanel);
        if (!b.isVisible()) {
            b = (JButton)SyntheticaLookAndFeel.findComponent((String)key, (Container)this.trailingTabControlsPanel);
        }
        return b;
    }

    @Override
    protected int calculateTabAreaWidth(int tabPlacement, int vertRunCount, int maxTabWidth) {
        int w = 0;
        if (tabPlacement == 2 || tabPlacement == 4) {
            w = super.calculateTabAreaHeight(tabPlacement, this.runCount, maxTabWidth);
        }
        w = super.calculateTabAreaWidth(tabPlacement, vertRunCount, maxTabWidth);
        return w;
    }

    @Override
    protected int calculateTabAreaHeight(int tabPlacement, int horizRunCount, int maxTabHeight) {
        if (tabPlacement == 2 || tabPlacement == 4) {
            return super.calculateTabAreaWidth(tabPlacement, this.runCount, maxTabHeight);
        }
        return super.calculateTabAreaHeight(tabPlacement, horizRunCount, maxTabHeight);
    }

    @Override
    public int calculateMaxTabWidth(int tabPlacement) {
        if (tabPlacement == 2 || tabPlacement == 4) {
            return super.calculateMaxTabHeight(tabPlacement);
        }
        return super.calculateMaxTabWidth(tabPlacement);
    }

    @Override
    public int calculateMaxTabHeight(int tabPlacement) {
        if (tabPlacement == 2 || tabPlacement == 4) {
            return super.calculateMaxTabWidth(tabPlacement);
        }
        return super.calculateMaxTabHeight(tabPlacement);
    }

    @Override
    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        if (tabPlacement == 2 || tabPlacement == 4) {
            return this.tabsPanel.getTab((int)tabIndex).getPreferredSize().height;
        }
        return this.tabsPanel.getTab((int)tabIndex).getPreferredSize().width;
    }

    @Override
    protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        if (tabPlacement == 2 || tabPlacement == 4) {
            return this.tabsPanel.getTab((int)tabIndex).getPreferredSize().width;
        }
        return this.tabsPanel.getTab((int)tabIndex).getPreferredSize().height;
    }

    @Override
    protected View getTextViewForTab(int tabIndex) {
        return null;
    }

    @Override
    protected FontMetrics getFontMetrics() {
        Font font = this.tabPane.getFont();
        if (font == null) {
            font = UIManager.getFont("Label.font");
        }
        return this.tabPane.getFontMetrics(font);
    }

    @Override
    protected void selectNextTab(int current) {
        int maxIndex = this.tabsPanel.getTabCount() - 1;
        int index = current >= maxIndex ? 0 : current + 1;
        Rectangle vr = SwingUtilities.convertRectangle(this.tabsPanelViewport.getParent(), this.tabsPanelViewport.getBounds(), this.tabPane);
        if (!vr.contains(this.rects[index])) {
            if (index < current) {
                this.tabsPanelViewport.setLeadingTabIndex(index);
            } else {
                this.tabsPanelViewport.scrollForward();
            }
        }
        super.selectNextTab(current);
    }

    @Override
    protected void selectPreviousTab(int current) {
        int maxIndex = this.tabsPanel.getTabCount() - 1;
        int index = current <= 0 ? maxIndex : current - 1;
        Rectangle vr = SwingUtilities.convertRectangle(this.tabsPanelViewport.getParent(), this.tabsPanelViewport.getBounds(), this.tabPane);
        if (!vr.contains(this.rects[index])) {
            if (index > current) {
                this.tabsPanelViewport.setLeadingTabIndex(index);
            } else {
                this.tabsPanelViewport.scrollBackward();
            }
        }
        super.selectPreviousTab(current);
    }

    @Override
    public Rectangle getTabBounds(JTabbedPane pane, int i) {
        if (!this.tabsPanel.isValid()) {
            this.tabsPanel.validate();
            this.tabsPanel.updateTabRects();
        }
        return i < this.rects.length ? this.getTabBounds(i, new Rectangle()) : new Rectangle();
    }

    @Override
    protected ChangeListener createChangeListener() {
        return new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                BasicJYTabbedPaneUI.this.cancelTabEdit();
                BasicJYTabbedPaneUI.this.updateAllTabBorders();
                BasicJYTabbedPaneUI.this.updateTabCloseButtons();
                JYTabbedPane tabbedPane = (JYTabbedPane)evt.getSource();
                int selectedIndex = tabbedPane.getSelectedIndex();
                if (selectedIndex >= 0 && tabbedPane.isEnabledAt(selectedIndex) && BasicJYTabbedPaneUI.this.tabsPanel.getTab(selectedIndex) != null) {
                    BasicJYTabbedPaneUI.this.updateTabFontStyle();
                    if (tabbedPane.hasFocus()) {
                        BasicJYTabbedPaneUI.this.tabsPanel.getTab(selectedIndex).requestFocus();
                    }
                }
            }
        };
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JYTabbedPane tabbedPane = (JYTabbedPane)evt.getSource();
                String name = evt.getPropertyName();
                if (WidgetUtils.shouldUpdateStyle(evt)) {
                    BasicJYTabbedPaneUI.this.installDefaults(tabbedPane);
                }
                if ("insertTab".equals(name)) {
                    BasicJYTabbedPaneUI.this.cancelTabEdit();
                    int tabCount = BasicJYTabbedPaneUI.this.tabPane.getTabCount();
                    BasicJYTabbedPaneUI.this.assureRectsCreated(tabCount);
                    int index = (Integer)evt.getNewValue();
                    BasicJYTabbedPaneUI.this.addTab(tabbedPane, index);
                } else if ("removeTab".equals(name)) {
                    BasicJYTabbedPaneUI.this.cancelTabEdit();
                    int index = (Integer)evt.getNewValue();
                    BasicJYTabbedPaneUI.this.tabsPanel.removeTab(index);
                    BasicJYTabbedPaneUI.this.updateAllTabBorders();
                } else if ("title".equals(name)) {
                    int index = (Integer)evt.getNewValue();
                    Tab tab = BasicJYTabbedPaneUI.this.tabsPanel.getTab(index);
                    JComponent tabComponent = tab.getComponent();
                    if (tabComponent instanceof JLabel) {
                        ((JLabel)tabComponent).setText(tabbedPane.getTitleAt(index));
                    }
                } else if ("icon".equals(name)) {
                    int index = (Integer)evt.getNewValue();
                    Tab tab = BasicJYTabbedPaneUI.this.tabsPanel.getTab(index);
                    JComponent tabComponent = tab.getComponent();
                    if (tabComponent instanceof JLabel) {
                        ((JLabel)tabComponent).setIcon(BasicJYTabbedPaneUI.this.getIconForTab(index));
                    }
                } else if ("toolTipText".equals(name)) {
                    BasicJYTabbedPaneUI.this.tabsPanelViewport.setToolTipText("");
                } else if ("tabPlacement".equals(name)) {
                    int oldPlacement = (Integer)evt.getOldValue();
                    int newPlacement = (Integer)evt.getNewValue();
                    BasicJYTabbedPaneUI.this.updateAllTabBorders();
                    BasicJYTabbedPaneUI.this.updateLayout(tabbedPane, oldPlacement, newPlacement);
                    if (!tabbedPane.getTabRotationEnabled().booleanValue()) {
                        for (Tab tab : BasicJYTabbedPaneUI.this.tabsPanel.getTabs()) {
                            BasicJYTabbedPaneUI.this.updateLayout(tab, newPlacement, oldPlacement);
                        }
                        BasicJYTabbedPaneUI.this.updateAllTabBorders();
                    }
                    BasicJYTabbedPaneUI.this.trailingTabControlsPanel.revalidate();
                    BasicJYTabbedPaneUI.this.leadingTabControlsPanel.revalidate();
                    if (BasicJYTabbedPaneUI.this.tabsPanel.getShowPlusButton()) {
                        BasicJYTabbedPaneUI.this.tabsPanel.plusComponentPanel.updatePlusButtonMargin();
                        BasicJYTabbedPaneUI.this.tabsPanel.plusComponentPanel.revalidate();
                    }
                } else if ("indexForTabComponent".equals(name)) {
                    int index = (Integer)evt.getNewValue();
                    if (tabbedPane.getTabComponentAt(index) != null) {
                        BasicJYTabbedPaneUI.this.addTab(tabbedPane, index);
                    }
                } else if ("leadingTabAreaComponent".equals(name)) {
                    Component c = (Component)evt.getOldValue();
                    if (c != null) {
                        BasicJYTabbedPaneUI.this.leadingTabsPanel.remove(c);
                    }
                    if ((c = (JComponent)evt.getNewValue()) != null) {
                        BasicJYTabbedPaneUI.this.leadingTabsPanel.add(c);
                        int placement = BasicJYTabbedPaneUI.this.tabPane.getTabPlacement();
                        BasicJYTabbedPaneUI.this.updateLayout((Container)c, 1, placement);
                    }
                    BasicJYTabbedPaneUI.this.tabsPanel.revalidate();
                    BasicJYTabbedPaneUI.this.tabsPanel.repaint();
                } else if ("trailingTabAreaComponent".equals(name)) {
                    Component c = (Component)evt.getOldValue();
                    if (c != null) {
                        BasicJYTabbedPaneUI.this.trailingTabsPanel.remove(c);
                    }
                    if ((c = (JComponent)evt.getNewValue()) != null) {
                        BasicJYTabbedPaneUI.this.trailingTabsPanel.add(c);
                        int placement = BasicJYTabbedPaneUI.this.tabPane.getTabPlacement();
                        BasicJYTabbedPaneUI.this.updateLayout((Container)c, 1, placement);
                    }
                    BasicJYTabbedPaneUI.this.tabsPanel.revalidate();
                    BasicJYTabbedPaneUI.this.tabsPanel.repaint();
                } else if ("componentOrientation".equals(name)) {
                    BasicJYTabbedPaneUI.this.updateAllTabBorders();
                    if (BasicJYTabbedPaneUI.this.tabsPanel.getShowPlusButton()) {
                        BasicJYTabbedPaneUI.this.tabsPanel.plusComponentPanel.updatePlusButtonMargin();
                    }
                } else if (!"paintSelectedTabBold".equals(name)) {
                    if ("tabGap".equals(name)) {
                        ((OverlapBoxLayout)BasicJYTabbedPaneUI.this.tabsPanel.getLayout()).setOverlapSize((Integer)evt.getNewValue());
                        BasicJYTabbedPaneUI.this.tabsPanel.revalidate();
                        BasicJYTabbedPaneUI.this.tabsPanel.repaint();
                    } else if ("horizontalTabAlignment".equals(name)) {
                        ((OverlapBoxLayout)BasicJYTabbedPaneUI.this.tabsPanel.getLayout()).setHorizontalAlignment((Integer)evt.getNewValue());
                        BasicJYTabbedPaneUI.this.tabsPanel.revalidate();
                        BasicJYTabbedPaneUI.this.tabsPanel.repaint();
                    } else if ("verticalTabAlignment".equals(name)) {
                        ((OverlapBoxLayout)BasicJYTabbedPaneUI.this.tabsPanel.getLayout()).setVerticalAlignment((Integer)evt.getNewValue());
                        BasicJYTabbedPaneUI.this.tabsPanel.revalidate();
                        BasicJYTabbedPaneUI.this.tabsPanel.repaint();
                    } else if ("tabControlsPosition".equals(name) || "showScrollButtons".equals(name) || "showPopupButton".equals(name) || "tabOverviewEnabled".equals(name)) {
                        BasicJYTabbedPaneUI.this.updateTabControls(tabbedPane.getTabControlsPosition(), tabbedPane.getShowScrollButtons(), tabbedPane.getShowPopupButton(), tabbedPane.getTabOverviewEnabled());
                        BasicJYTabbedPaneUI.this.tabsPanel.revalidate();
                        BasicJYTabbedPaneUI.this.tabsPanel.repaint();
                    } else if ("tabPreviewOnHoverEnabled".equals(name)) {
                        if (tabbedPane.getTabPreviewOnHoverEnabled().booleanValue() && BasicJYTabbedPaneUI.this.tabPreviewHandler == null) {
                            BasicJYTabbedPaneUI.this.tabPreviewHandler = new TabPreviewHandler();
                            BasicJYTabbedPaneUI.this.tabPreviewHandler.install();
                        } else if (BasicJYTabbedPaneUI.this.tabPreviewHandler != null) {
                            BasicJYTabbedPaneUI.this.tabPreviewHandler.uninstall();
                            BasicJYTabbedPaneUI.this.tabPreviewHandler = null;
                        }
                    } else if ("minimumTabSize".equals(name) || "maximumTabSize".equals(name)) {
                        BasicJYTabbedPaneUI.this.tabsPanel.revalidate();
                        BasicJYTabbedPaneUI.this.tabsPanel.repaint();
                    } else if ("tabsStretchedEnabled".equals(name)) {
                        BasicJYTabbedPaneUI.this.tabsPanel.revalidate();
                        BasicJYTabbedPaneUI.this.tabsPanel.repaint();
                    } else if ("tabRotationEnabled".equals(name)) {
                        BasicJYTabbedPaneUI.this.updateAllTabBorders();
                        boolean oldRotate = evt.getOldValue() == null ? true : (Boolean)evt.getOldValue();
                        boolean newRotate = (Boolean)evt.getNewValue();
                        int oldPlacement = oldRotate ? tabbedPane.getTabPlacement() : 1;
                        int newPlacement = newRotate ? tabbedPane.getTabPlacement() : 1;
                        Component[] componentArray = BasicJYTabbedPaneUI.this.tabsPanel.getComponents();
                        int n = componentArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Component c = componentArray[n2];
                            if (c instanceof PlusComponentPanel) {
                                BasicJYTabbedPaneUI.this.updateLayout(((PlusComponentPanel)c).buttonPane, oldPlacement, newPlacement);
                            } else {
                                BasicJYTabbedPaneUI.this.updateLayout((Container)c, oldPlacement, newPlacement);
                            }
                            ++n2;
                        }
                        BasicJYTabbedPaneUI.this.tabsPanel.revalidate();
                        BasicJYTabbedPaneUI.this.tabsPanel.repaint();
                    } else if ("tabsEditable".equals(name)) {
                        boolean editable = (Boolean)evt.getNewValue();
                        for (Tab tab : BasicJYTabbedPaneUI.this.tabsPanel.getTabs()) {
                            JComponent c = tab.getComponent();
                            if (!(c instanceof JYLabel)) continue;
                            ((JYLabel)c).setEditable(editable);
                        }
                    } else if ("tabsFocusable".equals(name)) {
                        boolean focusable = (Boolean)evt.getNewValue();
                        for (Tab tab : BasicJYTabbedPaneUI.this.tabsPanel.getTabs()) {
                            tab.setFocusable(focusable);
                        }
                    } else if ("showPlusButton".equals(name)) {
                        BasicJYTabbedPaneUI.this.tabsPanel.setShowPlusButton((Boolean)evt.getNewValue());
                        BasicJYTabbedPaneUI.this.tabsPanel.revalidate();
                        BasicJYTabbedPaneUI.this.tabsPanel.repaint();
                    } else if (!"tabControlsShowStrategy".equals(name) && !"closeButtonStrategy".equals(name) && name != "mnemonicAt") {
                        if (name == "displayedMnemonicIndexAt") {
                            tabbedPane.repaint();
                        } else if (name == "indexForTitle" || name == "tabLayoutPolicy" || name == "opaque" || name != "background") {
                            // empty if block
                        }
                    }
                }
            }
        };
    }

    public void updateTabControls(JYTabbedPane.TabControlsPosition position, Boolean showScrollButtons, Boolean showPopupButton, Boolean tabOverviewEnabled) {
        if (position == null || showScrollButtons == null || showPopupButton == null || tabOverviewEnabled == null) {
            return;
        }
        switch (position) {
            case LEADING: {
                Component[] componentArray = this.trailingTabControlsPanel.getComponents();
                int n = componentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Component c = componentArray[n2];
                    c.setVisible(false);
                    ++n2;
                }
                this.leadingTabControlsPanel.getComponent(1).setVisible(showScrollButtons);
                this.leadingTabControlsPanel.getComponent(2).setVisible(showScrollButtons);
                this.leadingTabControlsPanel.getComponent(3).setVisible(showPopupButton);
                break;
            }
            case TRAILING: {
                Component[] componentArray = this.leadingTabControlsPanel.getComponents();
                int n = componentArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Component c = componentArray[n3];
                    c.setVisible(false);
                    ++n3;
                }
                this.trailingTabControlsPanel.getComponent(0).setVisible(showScrollButtons);
                this.trailingTabControlsPanel.getComponent(1).setVisible(showScrollButtons);
                this.trailingTabControlsPanel.getComponent(2).setVisible(showPopupButton);
                break;
            }
            case LEADING_TRAILING: {
                this.leadingTabControlsPanel.getComponent(2).setVisible(false);
                this.leadingTabControlsPanel.getComponent(3).setVisible(false);
                this.trailingTabControlsPanel.getComponent(0).setVisible(false);
                this.leadingTabControlsPanel.getComponent(1).setVisible(showScrollButtons);
                this.trailingTabControlsPanel.getComponent(1).setVisible(showScrollButtons);
                this.trailingTabControlsPanel.getComponent(2).setVisible(showPopupButton);
            }
        }
        this.leadingTabControlsPanel.getComponent(0).setVisible(tabOverviewEnabled);
    }

    private void installTabs(JTabbedPane pane) {
        int i = 0;
        while (i < pane.getTabCount()) {
            this.addTab(pane, i);
            ++i;
        }
    }

    private void addTab(JTabbedPane pane, int tabIndex) {
        JComponent c = (JComponent)pane.getTabComponentAt(tabIndex);
        if (c != null && tabIndex < this.tabsPanel.getTabCount()) {
            this.tabsPanel.removeTab(tabIndex);
        } else if (c == null) {
            JLabel l = this.createTabLabel();
            if (l instanceof JYLabel) {
                ((JYLabel)l).setEditable(this.getTabbedPane().getTabsEditable());
            }
            l.setBorder(new Border(){

                @Override
                public Insets getBorderInsets(Component c) {
                    Tab tab;
                    Insets insets = new Insets(0, 0, 0, 0);
                    Container parent = c.getParent();
                    Tab tab2 = tab = parent == null ? null : (Tab)parent.getParent();
                    if (tab != null && !tab.getCloseButton().isVisible()) {
                        return insets;
                    }
                    int placement = BasicJYTabbedPaneUI.this.tabPane.getTabPlacement();
                    if (!((JYTabbedPane)BasicJYTabbedPaneUI.this.tabPane).getTabRotationEnabled().booleanValue() && placement != 3) {
                        placement = 1;
                    }
                    if (BasicJYTabbedPaneUI.this.reversedCloseButtonPlacement) {
                        if (placement == 2) {
                            insets.bottom = BasicJYTabbedPaneUI.this.closeButtonGap;
                        } else if (placement == 4) {
                            insets.top = BasicJYTabbedPaneUI.this.closeButtonGap;
                        } else if (c.getComponentOrientation().isLeftToRight()) {
                            insets.left = BasicJYTabbedPaneUI.this.closeButtonGap;
                        } else {
                            insets.right = BasicJYTabbedPaneUI.this.closeButtonGap;
                        }
                    } else if (placement == 2) {
                        insets.top = BasicJYTabbedPaneUI.this.closeButtonGap;
                    } else if (placement == 4) {
                        insets.bottom = BasicJYTabbedPaneUI.this.closeButtonGap;
                    } else if (c.getComponentOrientation().isLeftToRight()) {
                        insets.right = BasicJYTabbedPaneUI.this.closeButtonGap;
                    } else {
                        insets.left = BasicJYTabbedPaneUI.this.closeButtonGap;
                    }
                    return insets;
                }

                @Override
                public boolean isBorderOpaque() {
                    return false;
                }

                @Override
                public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                }
            });
            l.setText(pane.getTitleAt(tabIndex));
            l.setIcon(this.getIconForTab(tabIndex));
            l.setDisplayedMnemonic(this.tabPane.getMnemonicAt(tabIndex));
            c = l;
        }
        Tab tab = new Tab((JYTabbedPane)this.tabPane, c);
        this.tabsPanel.add(tab, tabIndex);
        this.setTabBorder(tabIndex);
        if (c instanceof IRotatableComponent) {
            ((IRotatableComponent)((Object)c)).setRotation(this.placementToRotation(c, pane.getTabPlacement()));
        }
        this.updateTabFontStyle();
    }

    protected JLabel createTabLabel() {
        return new TabLabel();
    }

    protected Color getDefaultTabForeground(int tabIndex) {
        Color color = Color.BLACK;
        return color;
    }

    private void setTabBorder(int tabIndex) {
        boolean selected = tabIndex == this.tabPane.getSelectedIndex();
        int placement = this.tabPane.getTabPlacement();
        if (!((JYTabbedPane)this.tabPane).getTabRotationEnabled().booleanValue() && placement != 3) {
            placement = 1;
        }
        EmptyBorder border = new EmptyBorder(this.rotateInsets(this.getTabInsets(selected), placement, true));
        this.tabsPanel.getTab(tabIndex).setBorder(border);
    }

    protected Insets getTabInsets(boolean selected) {
        Insets tabInsets = new Insets(0, 0, 0, 0);
        tabInsets.top += 3;
        tabInsets.left += 10;
        tabInsets.bottom += 2;
        tabInsets.right += 10;
        return tabInsets;
    }

    private Insets rotateInsets(Insets insets, int placement, boolean respectComponentOrientation) {
        boolean ltr;
        boolean bl = ltr = respectComponentOrientation ? this.tabPane.getComponentOrientation().isLeftToRight() : true;
        if (placement == 1 && !ltr) {
            return new Insets(insets.top, insets.right, insets.bottom, insets.left);
        }
        if (placement == 3) {
            return ltr ? new Insets(insets.bottom, insets.left, insets.top, insets.right) : new Insets(insets.bottom, insets.right, insets.top, insets.left);
        }
        if (placement == 4) {
            return ltr ? new Insets(insets.left, insets.bottom, insets.right, insets.top) : new Insets(insets.left, insets.top, insets.right, insets.bottom);
        }
        if (placement == 2) {
            return ltr ? new Insets(insets.right, insets.top, insets.left, insets.bottom) : new Insets(insets.right, insets.bottom, insets.left, insets.top);
        }
        return insets;
    }

    private void updateLayout(Container container, int oldPlacement, int newPlacement) {
        if (container == ((JYTabbedPane)this.tabPane).getContentPanel()) {
            return;
        }
        Component[] componentArray = container.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c instanceof Container) {
                this.updateLayout((Container)c, oldPlacement, newPlacement);
            }
            ++n2;
        }
        this.updateLayoutFlat(container, oldPlacement, newPlacement);
        if (container instanceof IRotatableComponent) {
            ((IRotatableComponent)((Object)container)).setRotation(this.placementToRotation(container, newPlacement));
        } else if (container instanceof JToolBar) {
            IRotatableComponent.Rotation r = this.placementToRotation(container, newPlacement);
            ((JToolBar)container).setOrientation(r == IRotatableComponent.Rotation.NONE ? 0 : 1);
        }
    }

    private void updateLayoutFlat(Container container, int oldPlacement, int newPlacement) {
        LayoutManager lm = container.getLayout();
        if (lm instanceof BorderLayout) {
            boolean rotateAndFlipPanel;
            BorderLayout bl = (BorderLayout)lm;
            int rotate = newPlacement - oldPlacement;
            boolean bl2 = rotateAndFlipPanel = container == this.tabAreaPanel || container == this.leadingTabsPanel || container == this.trailingTabsPanel;
            if (oldPlacement == 3 || oldPlacement == 2 && rotateAndFlipPanel) {
                this.flipBorderLayout(bl, oldPlacement == 3);
            }
            if (rotate != 0) {
                if (Math.abs(rotate) == 2) {
                    this.rotateBorderLayout(bl, false);
                    this.rotateBorderLayout(bl, false);
                } else {
                    boolean clockwise = rotate == -1 || rotate == 3;
                    this.rotateBorderLayout(bl, clockwise);
                }
            }
            if (newPlacement == 3 || newPlacement == 2 && rotateAndFlipPanel) {
                this.flipBorderLayout(bl, newPlacement == 3);
            }
        } else if (lm instanceof BoxLayout) {
            boolean rotate;
            boolean bl = rotate = !((oldPlacement != 1 && oldPlacement != 3 || newPlacement != 2 && newPlacement != 4) && (oldPlacement != 2 && oldPlacement != 4 || newPlacement != 1 && newPlacement != 3));
            if (rotate) {
                int axis = ((BoxLayout)lm).getAxis();
                int newAxis = axis == 2 ? 3 : (axis == 3 ? 2 : (axis == 0 ? 1 : 0));
                container.setLayout(new BoxLayout(container, newAxis));
            }
        } else if (lm instanceof OverlapBoxLayout) {
            OverlapBoxLayout.Axis axis = newPlacement == 1 || newPlacement == 3 ? OverlapBoxLayout.Axis.LINE : OverlapBoxLayout.Axis.PAGE;
            OverlapBoxLayout obl = (OverlapBoxLayout)lm;
            obl.setAxis(axis);
        }
    }

    private void rotateBorderLayout(BorderLayout bl, boolean clockwise) {
        String[] constraints = new String[]{"First", clockwise ? "After" : "Before", "Last", clockwise ? "Before" : "After"};
        int i = constraints.length - 2;
        while (i >= 0) {
            Component child_;
            Component child = bl.getLayoutComponent(constraints[i]);
            if (child != null) {
                bl.removeLayoutComponent(child);
            }
            if ((child_ = bl.getLayoutComponent(constraints[i + 1])) != null) {
                bl.removeLayoutComponent(child_);
            }
            if (child != null) {
                bl.addLayoutComponent(child, constraints[i + 1]);
            }
            if (child_ != null) {
                bl.addLayoutComponent(child_, constraints[i]);
            }
            --i;
        }
    }

    private void flipBorderLayout(BorderLayout bl, boolean horizontal) {
        Component child_;
        String[] constraints = new String[]{horizontal ? "Before" : "First", horizontal ? "After" : "Last"};
        Component child = bl.getLayoutComponent(constraints[0]);
        if (child != null) {
            bl.removeLayoutComponent(child);
        }
        if ((child_ = bl.getLayoutComponent(constraints[1])) != null) {
            bl.removeLayoutComponent(child_);
        }
        if (child != null) {
            bl.addLayoutComponent(child, constraints[1]);
        }
        if (child_ != null) {
            bl.addLayoutComponent(child_, constraints[0]);
        }
    }

    private String getBLConstraints(int oldPlacement, int newPlacement, String oldConstraint) {
        boolean PS = true;
        int PE = 2;
        int LS = 3;
        int LE = 4;
        int[][] m = new int[][]{{1, 2, 1, 3}, {1, 2, 2, 4}, {1, 2, 3, 1}, {1, 2, 4, 2}, {1, 4, 1, 4}, {1, 4, 2, 3}, {1, 4, 3, 1}, {1, 4, 4, 2}, {2, 4, 3, 4}, {1, 3, 1, 2}};
        if (oldPlacement == 3 && newPlacement != 1) {
            oldPlacement = 1;
        }
        int oldConstr = oldConstraint.equals("First") ? 1 : (oldConstraint.equals("Last") ? 2 : (oldConstraint.equals("Before") ? 3 : 4));
        int newConstr = -1;
        int i = 0;
        while (i < m.length) {
            if (oldPlacement == m[i][0] && newPlacement == m[i][1] && oldConstr == m[i][2]) {
                newConstr = m[i][3];
                break;
            }
            if (newPlacement == m[i][0] && oldPlacement == m[i][1] && oldConstr == m[i][3]) {
                newConstr = m[i][2];
                break;
            }
            ++i;
        }
        String newConstraint = oldConstraint;
        switch (newConstr) {
            case 1: {
                newConstraint = "First";
                break;
            }
            case 2: {
                newConstraint = "Last";
                break;
            }
            case 3: {
                newConstraint = "Before";
                break;
            }
            case 4: {
                newConstraint = "After";
            }
        }
        return newConstraint;
    }

    public IRotatableComponent.Rotation placementToRotation(int placement) {
        return this.placementToRotation(null, placement);
    }

    public IRotatableComponent.Rotation placementToRotation(Container container, int placement) {
        boolean plusButtonComp;
        boolean rotate = ((JYTabbedPane)this.tabPane).getTabRotationEnabled();
        boolean tabComp = container instanceof Tab || SwingUtilities.getAncestorOfClass(Tab.class, container) != null;
        boolean bl = plusButtonComp = SwingUtilities.getAncestorOfClass(PlusComponentPanel.class, container) != null;
        if (!rotate && (container == null || tabComp || plusButtonComp)) {
            return IRotatableComponent.Rotation.NONE;
        }
        return placement == 1 || placement == 3 ? IRotatableComponent.Rotation.NONE : (placement == 2 ? IRotatableComponent.Rotation.LEFT : IRotatableComponent.Rotation.RIGHT);
    }

    private void repaintContentBorderGap() {
        int index = this.tabPane.getSelectedIndex();
        if (index >= 0 && index < this.rects.length) {
            Rectangle r = ((JYTabbedPane)this.tabPane).getContentPanel().getBounds();
            int placement = this.tabPane.getTabPlacement();
            if (this.isVerticalTabPlacement() && !this.tabPane.getComponentOrientation().isLeftToRight()) {
                int n = placement = placement == 2 ? 4 : 2;
            }
            if (placement == 1) {
                r.y = this.rects[index].y + this.rects[index].height;
                r.height = 1;
            } else if (placement == 3) {
                r.y = this.rects[index].y - 1;
                r.height = 1;
            } else if (placement == 2) {
                r.x = this.rects[index].x + this.rects[index].width;
                r.width = 1;
            } else if (placement == 4) {
                r.x = this.rects[index].x - 1;
                r.width = 1;
            }
            this.tabPane.repaint(r);
        }
    }

    public boolean isVerticalTabPlacement() {
        int placement = this.tabPane.getTabPlacement();
        return placement == 2 || placement == 4;
    }

    public float getTabControlsAlignment(boolean xAlignment) {
        int placement = this.tabPane.getTabPlacement();
        float alignment = 0.5f;
        if (xAlignment) {
            if (placement == 2) {
                alignment = 1.0f;
            } else if (placement == 4) {
                alignment = 0.0f;
            }
            String align = SyntheticaLookAndFeel.getString((String)"JYTabbedPane.tabControls.xAlignment", (Component)this.tabPane);
            if (align != null) {
                alignment = Alignment.valueOf(align).asFloat();
            }
        } else {
            if (placement == 1) {
                alignment = 1.0f;
            } else if (placement == 3) {
                alignment = 0.0f;
            }
            String align = SyntheticaLookAndFeel.getString((String)"JYTabbedPane.tabControls.yAlignment", (Component)this.tabPane);
            if (align != null) {
                alignment = Alignment.valueOf(align).asFloat();
            }
        }
        return alignment;
    }

    public void updateTabFontStyle() {
        block12: {
            Boolean paintSelectedBold;
            Font font;
            block14: {
                int selectedStyle;
                int selectedIndex;
                block13: {
                    block11: {
                        boolean customFont;
                        selectedIndex = this.tabPane.getSelectedIndex();
                        if (selectedIndex < 0 || selectedIndex >= this.tabsPanel.getTabCount()) {
                            return;
                        }
                        font = this.tabPane.getFont();
                        if (UIManager.getLookAndFeel() instanceof SynthLookAndFeel) {
                            SynthStyle ss = SynthLookAndFeel.getStyle(this.tabPane, Region.TABBED_PANE_TAB);
                            SynthContext sc = new SynthContext(this.tabPane, Region.TABBED_PANE_TAB, ss, 0);
                            font = ss.getFont(sc);
                            if (SyntheticaLookAndFeel.getBoolean((String)"JYTabbedPane.tab.useSynthFont", (Component)this.tabPane)) {
                                int i = 0;
                                while (i < this.tabsPanel.getTabCount()) {
                                    JComponent c = this.tabsPanel.getTab(i).getComponent();
                                    c.setFont(font);
                                    ++i;
                                }
                                return;
                            }
                        }
                        selectedStyle = this.tabsPanel.getTab(selectedIndex).getComponent().getFont().getStyle();
                        paintSelectedBold = ((JYTabbedPane)this.tabPane).getPaintSelectedTabBold();
                        boolean bl = this.tabPane.getFont() == null ? false : (customFont = !this.tabPane.getFont().getFamily().equals(font.getFamily()) || this.tabPane.getFont().getSize() != font.getSize());
                        if (!customFont || paintSelectedBold.booleanValue()) break block11;
                        int i = 0;
                        while (i < this.tabsPanel.getTabCount()) {
                            JComponent c = this.tabsPanel.getTab(i).getComponent();
                            if (c.getClientProperty("html") != null) {
                                c.setFont(font.deriveFont(2));
                            }
                            c.setFont(font);
                            ++i;
                        }
                        break block12;
                    }
                    if (!paintSelectedBold.booleanValue() || (selectedStyle & 1) == 1) break block13;
                    int i = 0;
                    while (i < this.tabsPanel.getTabCount()) {
                        JComponent c = this.tabsPanel.getTab(i).getComponent();
                        if (i == selectedIndex) {
                            c.setFont(font.deriveFont(1));
                        } else {
                            c.setFont(font.deriveFont(0));
                        }
                        ++i;
                    }
                    break block12;
                }
                if (paintSelectedBold.booleanValue() || (selectedStyle & 1) != 1) break block14;
                Tab tab = this.tabsPanel.getTab(selectedIndex);
                JComponent c = tab.getComponent();
                c.setFont(font.deriveFont(0));
                break block12;
            }
            if (paintSelectedBold.booleanValue()) break block12;
            int i = 0;
            while (i < this.tabsPanel.getTabCount()) {
                JComponent c = this.tabsPanel.getTab(i).getComponent();
                if (c.getClientProperty("html") != null) {
                    c.setFont(font.deriveFont(2));
                    c.setFont(font.deriveFont(0));
                }
                ++i;
            }
        }
    }

    public void updateTabCloseButtons() {
        ICloseButtonStrategy strategy = ((JYTabbedPane)this.tabPane).getCloseButtonStrategy();
        for (Tab tab : this.tabsPanel.getTabs()) {
            tab.getCloseButton().setVisible(strategy.isButtonVisible((JYTabbedPane)this.tabPane, tab, false));
        }
    }

    void updateAllTabBorders() {
        Insets tabInsets = this.getTabInsets(false);
        Insets selectedTabInsets = this.getTabInsets(true);
        int placement = this.tabPane.getTabPlacement();
        if (!((JYTabbedPane)this.tabPane).getTabRotationEnabled().booleanValue() && placement != 3) {
            placement = 1;
        }
        EmptyBorder border = new EmptyBorder(this.rotateInsets(tabInsets, placement, true));
        EmptyBorder selectedBorder = new EmptyBorder(this.rotateInsets(selectedTabInsets, placement, true));
        int selectedTabIndex = this.tabPane.getSelectedIndex();
        int i = 0;
        while (i < this.tabsPanel.getTabCount()) {
            Tab tab = this.tabsPanel.getTab(i);
            tab.setBorder(i == selectedTabIndex ? selectedBorder : border);
            ++i;
        }
    }

    public IButtonFactory getButtonFactory() {
        return this.buttonFactory;
    }

    public JYTabbedPane getTabbedPane() {
        return (JYTabbedPane)this.tabPane;
    }

    public TabsPanel getTabsPanel() {
        return this.tabsPanel;
    }

    public JPanel getLeadingTabControlsPanel() {
        return this.leadingTabControlsPanel;
    }

    public JPanel getTrailingTabControlsPanel() {
        return this.trailingTabControlsPanel;
    }

    public TabsPanelViewport getTabsPanelViewport() {
        return this.tabsPanelViewport;
    }

    public boolean isPaintContentBorderGap4SelectedTabEnabled() {
        if (this.avoidTrailingCroppedTabs) {
            return this.tabsPanelViewport.getTrailingViewTabIndex() != this.tabPane.getSelectedIndex();
        }
        return true;
    }

    @Override
    public void assureRectsCreated(int tabCount) {
        super.assureRectsCreated(tabCount);
    }

    @Override
    public Insets getContentBorderInsets(int tabPlacement) {
        return super.getContentBorderInsets(tabPlacement);
    }

    @Override
    public Insets getTabAreaInsets(int tabPlacement) {
        return this.getTabAreaPanelInsets();
    }

    protected Insets getTabAreaPanelInsets() {
        Insets insets = new Insets(0, 0, 0, 0);
        return insets;
    }

    public void cancelTabEdit() {
        for (Tab tab : this.getTabsPanel().getTabs()) {
            JComponent tabComponent = tab.getComponent();
            if (!(tabComponent instanceof JYLabel)) continue;
            ((JYLabel)tabComponent).stopEdit();
        }
    }

    private static enum Alignment {
        TOP_LEFT(0.0f),
        CENTER(0.5f),
        BOTTOM_RIGHT(1.0f);

        private float alignment;

        private Alignment(float alignment) {
            this.alignment = alignment;
        }

        public float asFloat() {
            return this.alignment;
        }
    }

    private class CroppedEdge
    extends JPanel {
        private static final long serialVersionUID = 5416935823810362916L;
        private boolean leading;

        public CroppedEdge(boolean leading) {
            this.leading = leading;
            this.setVisible(false);
            this.setOpaque(false);
            this.setLayout(null);
            this.setFocusable(false);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(0, 0);
        }

        public int getCroppedEdgeSize() {
            return BasicJYTabbedPaneUI.this.croppedEdgeSize;
        }

        @Override
        public Dimension getMaximumSize() {
            int size = this.getCroppedEdgeSize();
            int placement = BasicJYTabbedPaneUI.this.tabPane.getTabPlacement();
            if (placement == 1 || placement == 3) {
                return new Dimension(size, BasicJYTabbedPaneUI.this.tabsPanel.getTabCount() == 0 ? 0 : ((BasicJYTabbedPaneUI)BasicJYTabbedPaneUI.this).tabsPanel.getFirstTab().getMaximumSize().height);
            }
            return new Dimension(BasicJYTabbedPaneUI.this.tabsPanel.getTabCount() == 0 ? 0 : ((BasicJYTabbedPaneUI)BasicJYTabbedPaneUI.this).tabsPanel.getFirstTab().getMaximumSize().width, size);
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getMaximumSize();
        }

        @Override
        public void setBounds(int x, int y, int width, int height) {
            width = this.getMaximumSize().width;
            height = this.getMaximumSize().height;
            Rectangle r = BasicJYTabbedPaneUI.this.tabsPanelViewport.getViewRect();
            int placement = BasicJYTabbedPaneUI.this.tabPane.getTabPlacement();
            boolean ltr = this.getComponentOrientation().isLeftToRight();
            if (BasicJYTabbedPaneUI.this.isVerticalTabPlacement()) {
                if (placement == 2 && ltr || placement == 4 && !ltr) {
                    x = BasicJYTabbedPaneUI.this.tabsPanel.getWidth() - width;
                }
                y = this.leading ? r.y : r.y + r.height - height;
            } else {
                int n = x = this.leading && ltr || !this.leading && !ltr ? r.x : r.x + r.width - width;
                if (placement == 1) {
                    y = BasicJYTabbedPaneUI.this.tabsPanel.getHeight() - height;
                }
            }
            this.setBounds_(x, y, width, height);
        }

        protected void setBounds_(int x, int y, int width, int height) {
            super.setBounds(x, y, width, height);
        }

        @Override
        public float getAlignmentX() {
            return BasicJYTabbedPaneUI.this.getTabbedPane().getTabPlacement() == 2 ? 1.0f : 0.0f;
        }

        @Override
        public float getAlignmentY() {
            return BasicJYTabbedPaneUI.this.getTabbedPane().getTabPlacement() == 1 ? 1.0f : 0.0f;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            SynthContext sc = null;
            if (UIManager.getLookAndFeel() instanceof SynthLookAndFeel) {
                sc = new SynthContext(BasicJYTabbedPaneUI.this.tabPane, Region.TABBED_PANE, SynthLookAndFeel.getStyle(BasicJYTabbedPaneUI.this.tabPane, Region.TABBED_PANE), 0);
            }
            JYTabbedPanePainter.getInstance(sc).paintCroppedEdge(BasicJYTabbedPaneUI.this.tabPane, new SyntheticaState(), BasicJYTabbedPaneUI.this.tabPane.getTabPlacement(), this.leading, g, 0, 0, this.getWidth(), this.getHeight(), BasicJYTabbedPaneUI.this.croppedEdgeBackground, BasicJYTabbedPaneUI.this.croppedEdgeForeground);
        }
    }

    private class PlusComponentPanel
    extends JPanel {
        private static final long serialVersionUID = -9038268180426245492L;
        private int plusButtonGap;
        private JPanel croppedEdgePane;
        private JPanel gapPane;
        private JPanel buttonPane;

        public PlusComponentPanel() {
            this.setLayout(new BoxLayout(this, 2));
            this.setOpaque(false);
            this.croppedEdgePane = new CroppedEdge(BasicJYTabbedPaneUI.this, false){
                private static final long serialVersionUID = -5943710616103001376L;

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(BasicJYTabbedPaneUI.this.croppedEdgeSize, BasicJYTabbedPaneUI.this.croppedEdgeSize);
                }

                @Override
                public void setBounds(int x, int y, int width, int height) {
                    if (!BasicJYTabbedPaneUI.this.tabsPanelViewport.isViewCompletelyVisible()) {
                        width = this.getMaximumSize().width;
                        height = this.getMaximumSize().height;
                        int placement = BasicJYTabbedPaneUI.this.tabPane.getTabPlacement();
                        boolean ltr = this.getComponentOrientation().isLeftToRight();
                        if (BasicJYTabbedPaneUI.this.isVerticalTabPlacement()) {
                            x = placement == 2 && ltr || placement == 4 && !ltr ? this.getParent().getWidth() - width : 0;
                        } else {
                            y = placement == 1 ? this.getParent().getHeight() - height : 0;
                        }
                    }
                    this.setBounds_(x, y, width, height);
                }
            };
            this.add(this.croppedEdgePane);
            Color background = SyntheticaLookAndFeel.getColor((String)"JYTabbedPane.tabsPanel.croppedEdge.background", (Component)BasicJYTabbedPaneUI.this.tabPane);
            if (background == null) {
                background = SyntheticaLookAndFeel.getColor((String)"Panel.background", (Component)BasicJYTabbedPaneUI.this.tabPane);
            }
            this.gapPane = new JPanel(null){
                private static final long serialVersionUID = 478728021825728313L;

                @Override
                public Dimension getPreferredSize() {
                    return BasicJYTabbedPaneUI.this.isVerticalTabPlacement() ? new Dimension(0, PlusComponentPanel.this.plusButtonGap) : new Dimension(PlusComponentPanel.this.plusButtonGap, 0);
                }

                @Override
                public Dimension getMinimumSize() {
                    return this.getPreferredSize();
                }
            };
            this.gapPane.putClientProperty("Synthetica.panel.paintViewportAware", false);
            this.gapPane.setBackground(background);
            this.add(this.gapPane);
            this.buttonPane = new JPanel(new BorderLayout());
            this.buttonPane.setBackground(background);
            this.buttonPane.putClientProperty("Synthetica.panel.paintViewportAware", false);
            this.buttonPane.add(BasicJYTabbedPaneUI.this.createPlusButton());
            this.updatePlusButtonMargin();
            this.add(this.buttonPane);
            this.applyComponentOrientation(BasicJYTabbedPaneUI.this.tabPane.getComponentOrientation());
            BasicJYTabbedPaneUI.this.updateLayout(this, 1, BasicJYTabbedPaneUI.this.tabPane.getTabPlacement());
            this.updateAppearance(BasicJYTabbedPaneUI.this.tabsPanelViewport.isViewCompletelyVisible(), BasicJYTabbedPaneUI.this.tabsPanelViewport.isScrollEndReached());
        }

        void updatePlusButtonMargin() {
            Insets insets = SyntheticaLookAndFeel.getInsets((String)"JYTabbedPane.plusButton.margin", (Component)BasicJYTabbedPaneUI.this.tabPane, (boolean)false, (boolean)true);
            int placement = BasicJYTabbedPaneUI.this.tabPane.getTabPlacement();
            if (placement == 2) {
                insets = new Insets(insets.top, insets.right, insets.bottom, insets.left);
            }
            EmptyBorder border = new EmptyBorder(BasicJYTabbedPaneUI.this.rotateInsets(insets, placement, true));
            this.buttonPane.setBorder(border);
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.plusButtonGap = SyntheticaLookAndFeel.getInt((String)"JYTabbedPane.plusButtonGap", (Component)BasicJYTabbedPaneUI.this.tabPane, (int)4, (boolean)true);
            if (this.buttonPane != null) {
                this.updatePlusButtonMargin();
            }
        }

        public void updateAppearance(boolean viewCompletelyVisible, boolean scrollEndReached) {
            this.croppedEdgePane.setVisible(BasicJYTabbedPaneUI.this.avoidTrailingCroppedTabs ? false : !viewCompletelyVisible && !scrollEndReached);
            this.gapPane.setOpaque(this.croppedEdgePane.isVisible());
            this.buttonPane.setOpaque(this.croppedEdgePane.isVisible());
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dim = super.getPreferredSize();
            if (BasicJYTabbedPaneUI.this.tabsPanel == null) {
                return dim;
            }
            if (BasicJYTabbedPaneUI.this.isVerticalTabPlacement()) {
                for (Component component : BasicJYTabbedPaneUI.this.tabsPanel.getTabs()) {
                    dim.width = Math.max(dim.width, component.getPreferredSize().width);
                }
            } else {
                for (Component component : BasicJYTabbedPaneUI.this.tabsPanel.getTabs()) {
                    dim.height = Math.max(dim.height, component.getPreferredSize().height);
                }
            }
            return dim;
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public float getAlignmentX() {
            int placement = BasicJYTabbedPaneUI.this.tabPane.getTabPlacement();
            boolean ltr = BasicJYTabbedPaneUI.this.tabPane.getComponentOrientation().isLeftToRight();
            return placement == 2 && ltr || placement == 4 && !ltr ? 1.0f : 0.0f;
        }

        @Override
        public float getAlignmentY() {
            return BasicJYTabbedPaneUI.this.tabPane.getTabPlacement() == 1 ? 1.0f : 0.0f;
        }

        @Override
        public void setBounds(int x, int y, int width, int height) {
            if (!BasicJYTabbedPaneUI.this.tabsPanelViewport.isViewCompletelyVisible()) {
                int tabGap = ((JYTabbedPane)BasicJYTabbedPaneUI.this.tabPane).getTabGap();
                Rectangle tr = new Rectangle();
                int i = BasicJYTabbedPaneUI.this.tabsPanel.getTabCount() - 1;
                while (i >= 0) {
                    Tab t = BasicJYTabbedPaneUI.this.tabsPanel.getTab(i);
                    if (t.isVisible()) {
                        tr = t.getBounds();
                        break;
                    }
                    --i;
                }
                width = this.getPreferredSize().width;
                height = this.getPreferredSize().height;
                Rectangle r = BasicJYTabbedPaneUI.this.tabsPanelViewport.getViewRect();
                if (BasicJYTabbedPaneUI.this.isVerticalTabPlacement()) {
                    y = Math.min(r.y + r.height - height, tr.y + tr.height + tabGap);
                } else {
                    boolean ltr = this.getComponentOrientation().isLeftToRight();
                    x = ltr ? Math.min(r.x + r.width - width, tr.x + tr.width + tabGap) : Math.max(r.x, tr.x - (width + tabGap));
                }
            }
            super.setBounds(x, y, width, height);
        }
    }

    class TabAreaPanel
    extends JPanel
    implements UIResource {
        private static final long serialVersionUID = 7275702352762336232L;

        public TabAreaPanel() {
            super(new BorderLayout());
            this.setName("JYTabbedPane.TabAreaPanel");
            this.setOpaque(false);
            this.setBorder(new Border(){

                @Override
                public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                }

                @Override
                public Insets getBorderInsets(Component c) {
                    return BasicJYTabbedPaneUI.this.rotateInsets(BasicJYTabbedPaneUI.this.getTabAreaPanelInsets(), BasicJYTabbedPaneUI.this.tabPane.getTabPlacement(), true);
                }

                @Override
                public boolean isBorderOpaque() {
                    return false;
                }
            });
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            int placement = BasicJYTabbedPaneUI.this.tabPane.getTabPlacement();
            SynthContext sc = null;
            if (UIManager.getLookAndFeel() instanceof SynthLookAndFeel) {
                sc = new SynthContext(BasicJYTabbedPaneUI.this.tabPane, Region.TABBED_PANE, SynthLookAndFeel.getStyle(BasicJYTabbedPaneUI.this.tabPane, Region.TABBED_PANE), 0);
            }
            JYTabbedPanePainter.getInstance(sc).paintTabbedPaneTabAreaBackground(BasicJYTabbedPaneUI.this.tabPane, new SyntheticaState(0), placement, 0, g, 0, 0, this.getWidth(), this.getHeight());
        }
    }

    private class TabLabel
    extends JYLabel {
        private static final long serialVersionUID = 695466598960280638L;

        public TabLabel() {
            TabLabelMouseHandler mouseHandler = new TabLabelMouseHandler();
            this.addMouseListener(mouseHandler);
            this.addMouseMotionListener(mouseHandler);
            this.addMouseWheelListener(mouseHandler);
        }

        @Override
        public boolean isEditable() {
            return this.isEnabled() && super.isEditable();
        }

        @Override
        public void commitEdit() {
            BasicJYTabbedPaneUI.this.tabPane.setTitleAt(this.getTabIndex(), this.editor.getText());
            this.stopEdit();
        }

        @Override
        public boolean isEnabled() {
            int index = this.getTabIndex();
            return index >= 0 && index < BasicJYTabbedPaneUI.this.tabPane.getTabCount() ? BasicJYTabbedPaneUI.this.tabPane.isEnabledAt(index) : super.isEnabled();
        }

        @Override
        public Color getForeground() {
            int tabIndex = this.getTabIndex();
            Color color = BasicJYTabbedPaneUI.this.getDefaultTabForeground(tabIndex);
            Color foreground = tabIndex < 0 || tabIndex >= BasicJYTabbedPaneUI.this.tabPane.getTabCount() ? null : BasicJYTabbedPaneUI.this.tabPane.getForegroundAt(tabIndex);
            return foreground == null || foreground instanceof ColorUIResource ? color : foreground;
        }

        private int getTabIndex() {
            int index = -1;
            Container parent = this.getParent();
            if (parent != null && parent.getParent() != null) {
                index = ((Tab)this.getParent().getParent()).getTabIndex();
            }
            return index;
        }
    }

    private class TabLabelMouseHandler
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        private Component target;

        private TabLabelMouseHandler() {
            this.target = BasicJYTabbedPaneUI.this.tabsPanelViewport;
        }

        private void dispatchMouseEvent(MouseEvent evt) {
            this.target.dispatchEvent(SwingUtilities.convertMouseEvent(evt.getComponent(), evt, this.target));
        }

        private void dispatchMouseWheelEvent(MouseWheelEvent evt) {
            this.target.dispatchEvent(SwingUtilities.convertMouseEvent(evt.getComponent(), evt, this.target));
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
            this.dispatchMouseEvent(evt);
        }

        @Override
        public void mouseExited(MouseEvent evt) {
            this.dispatchMouseEvent(evt);
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            this.dispatchMouseEvent(evt);
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            this.dispatchMouseEvent(evt);
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            this.dispatchMouseEvent(evt);
        }

        @Override
        public void mouseMoved(MouseEvent evt) {
            this.dispatchMouseEvent(evt);
        }

        @Override
        public void mouseDragged(MouseEvent evt) {
            this.dispatchMouseEvent(evt);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent evt) {
            this.dispatchMouseWheelEvent(evt);
        }
    }

    private class TabPreviewHandler
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener,
    PropertyChangeListener,
    ActionListener {
        private int oldIndex;
        private Timer timer;
        private TabPreviewPopup tabPreviewPopup;

        private TabPreviewHandler() {
        }

        public void install() {
            BasicJYTabbedPaneUI.this.tabPane.addMouseListener(this);
            BasicJYTabbedPaneUI.this.tabPane.addMouseMotionListener(this);
            BasicJYTabbedPaneUI.this.tabPane.addMouseWheelListener(this);
            BasicJYTabbedPaneUI.this.tabPane.addPropertyChangeListener(this);
        }

        public void uninstall() {
            BasicJYTabbedPaneUI.this.tabPane.removeMouseListener(this);
            BasicJYTabbedPaneUI.this.tabPane.removeMouseMotionListener(this);
            BasicJYTabbedPaneUI.this.tabPane.removeMouseWheelListener(this);
            BasicJYTabbedPaneUI.this.tabPane.removePropertyChangeListener(this);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.cancelPreview();
        }

        @Override
        public void mouseMoved(MouseEvent evt) {
            this.update(BasicJYTabbedPaneUI.this.getRolloverTab());
        }

        @Override
        public void mouseDragged(MouseEvent evt) {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent evt) {
            if (this.oldIndex >= 0) {
                this.cancelPreview();
            }
            this.update(BasicJYTabbedPaneUI.this.getRolloverTab());
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("Synthetica.MOUSE_OVER".equals(evt.getPropertyName())) {
                this.update((Integer)evt.getNewValue());
            }
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            int xOffset;
            if (this.tabPreviewPopup == null) {
                return;
            }
            this.tabPreviewPopup.preparePreview();
            Tab tab = BasicJYTabbedPaneUI.this.tabsPanel.getTab(this.tabPreviewPopup.getTabIndex());
            boolean rotated = BasicJYTabbedPaneUI.this.getTabbedPane().getTabRotationEnabled();
            boolean ltr = BasicJYTabbedPaneUI.this.tabPane.getComponentOrientation().isLeftToRight();
            int placement = BasicJYTabbedPaneUI.this.tabPane.getTabPlacement();
            int n = placement == (ltr ? 2 : 4) && rotated ? tab.getWidth() : (xOffset = placement == (ltr ? 4 : 2) && rotated ? -this.tabPreviewPopup.getPreferredSize().width : 0);
            int yOffset = BasicJYTabbedPaneUI.this.isVerticalTabPlacement() && rotated ? 0 : (placement == 3 ? -this.tabPreviewPopup.getPreferredSize().height : tab.getHeight());
            this.tabPreviewPopup.show(tab, xOffset, yOffset);
        }

        private void update(int index) {
            if (index < 0 || index >= BasicJYTabbedPaneUI.this.tabPane.getTabCount() || !BasicJYTabbedPaneUI.this.tabPane.isEnabledAt(index)) {
                return;
            }
            if (index == BasicJYTabbedPaneUI.this.tabPane.getSelectedIndex()) {
                this.cancelPreview();
            } else if (index != this.oldIndex) {
                if (this.oldIndex >= 0) {
                    this.cancelPreview();
                }
                this.startPreview(index);
                this.oldIndex = index;
            }
        }

        private void startPreview(int index) {
            if (this.timer != null) {
                this.cancelPreview();
            }
            this.tabPreviewPopup = new TabPreviewPopup(BasicJYTabbedPaneUI.this.getTabbedPane(), index);
            this.tabPreviewPopup.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent evt) {
                    TabPreviewHandler.this.cancelPreview();
                }
            });
            this.timer = new Timer(SyntheticaLookAndFeel.getInt((String)"JYTabbedPane.tabPreviewOnHover.delay", (Component)BasicJYTabbedPaneUI.this.tabPane, (int)1500), this);
            this.timer.setRepeats(false);
            this.timer.start();
        }

        private void cancelPreview() {
            if (this.timer != null && this.timer.isRunning()) {
                this.timer.stop();
                this.timer = null;
            }
            if (this.tabPreviewPopup != null) {
                this.tabPreviewPopup.setVisible(false);
            }
            this.tabPreviewPopup = null;
            this.oldIndex = -1;
        }
    }

    private static class TabPreviewPopup
    extends JPopupMenu {
        private JYTabbedPane tabPane;
        private int tabIndex;
        private BufferedImage previewImage;

        public TabPreviewPopup(JYTabbedPane tabPane, int tabIndex) {
            this.setName("JYTabbedPane.TabPreviewPopup");
            this.tabPane = tabPane;
            this.tabIndex = tabIndex;
            this.setLayout(new BorderLayout());
            this.add(new PopupContent());
        }

        public int getTabIndex() {
            return this.tabIndex;
        }

        private Dimension getPreviewSize(Component tabComponent) {
            Dimension dim = SyntheticaLookAndFeel.getInstance().scaleDimension(300, 200);
            int w = dim.width;
            int h = dim.height;
            if (tabComponent != null) {
                double pRatio = (double)w / (double)h;
                double cRatio = (double)tabComponent.getWidth() / (double)tabComponent.getHeight();
                if (pRatio > cRatio) {
                    w = (int)((double)h * cRatio);
                } else {
                    h = (int)((double)w / cRatio);
                }
            }
            return new Dimension(w, h);
        }

        public void preparePreview() {
            Component c = this.tabPane.getComponentAt(this.tabIndex);
            double cWidth = c == null ? 1 : c.getWidth();
            double cHeight = c == null ? 1 : c.getHeight();
            Dimension previewDim = this.getPreviewSize(c);
            double scaleX = previewDim.getWidth() / cWidth;
            double scaleY = previewDim.getHeight() / cHeight;
            double scaleFactor = Math.min(scaleX, scaleY);
            this.previewImage = WidgetUtils.createPreviewImage(c, scaleFactor, true);
        }

        private class PopupContent
        extends JComponent {
            private PopupContent() {
            }

            @Override
            public Dimension getPreferredSize() {
                Insets insets = this.getInsets();
                int w = TabPreviewPopup.this.previewImage == null ? 0 : TabPreviewPopup.this.previewImage.getWidth(null);
                int h = TabPreviewPopup.this.previewImage == null ? 0 : TabPreviewPopup.this.previewImage.getHeight(null);
                return new Dimension(w + insets.left + insets.right, h + insets.top + insets.bottom);
            }

            @Override
            protected void paintComponent(Graphics g) {
                if (TabPreviewPopup.this.previewImage == null) {
                    return;
                }
                Insets insets = this.getInsets();
                g.drawImage(TabPreviewPopup.this.previewImage, insets.left, insets.top, null);
            }
        }
    }

    public class TabsPanel
    extends JPanel {
        private static final long serialVersionUID = -5953802488838816461L;
        private ArrayList<Tab> tabs;
        private CroppedEdge leadingCroppedEdge;
        private CroppedEdge trailingCroppedEdge;
        private PlusComponentPanel plusComponentPanel;

        public TabsPanel() {
            this.setName("JYTabbedPane.TabsPanel");
            int placement = BasicJYTabbedPaneUI.this.tabPane.getTabPlacement();
            OverlapBoxLayout.ComponentFilter filter = new OverlapBoxLayout.ComponentFilter(){

                @Override
                public boolean accept(Component c, Class<?> childClass, Object constraints) {
                    return !(c instanceof CroppedEdge);
                }
            };
            OverlapBoxLayout<JComponent> lm = new OverlapBoxLayout<JComponent>((Container)this, placement == 1 || placement == 3 ? OverlapBoxLayout.Axis.LINE : OverlapBoxLayout.Axis.PAGE, JComponent.class, filter){

                @Override
                public void layoutContainer(Container container) {
                    super.layoutContainer(container);
                    BasicJYTabbedPaneUI.this.repaintContentBorderGap();
                }
            };
            Integer tabGap = ((JYTabbedPane)BasicJYTabbedPaneUI.this.tabPane).getTabGap();
            lm.setOverlapSize(tabGap == null ? 0 : tabGap);
            this.setLayout(lm);
            this.tabs = new ArrayList();
            this.leadingCroppedEdge = new CroppedEdge(true);
            this.leadingCroppedEdge.setName("JYTabbedPane.LeadingCroppedEdge");
            super.add(this.leadingCroppedEdge);
            this.setComponentZOrder(this.leadingCroppedEdge, 0);
            this.trailingCroppedEdge = new CroppedEdge(false);
            this.trailingCroppedEdge.setName("JYTabbedPane.TrailingCroppedEdge");
            super.add(this.trailingCroppedEdge);
            this.setComponentZOrder(this.trailingCroppedEdge, 1);
            this.setOpaque(false);
        }

        void setShowPlusButton(boolean show) {
            if (show) {
                this.plusComponentPanel = new PlusComponentPanel();
                super.add(this.plusComponentPanel);
            } else {
                if (this.plusComponentPanel != null) {
                    super.remove(this.plusComponentPanel);
                }
                this.plusComponentPanel = null;
            }
        }

        public boolean getShowPlusButton() {
            return this.plusComponentPanel != null;
        }

        @Override
        public Component add(Component comp) {
            throw new UnsupportedOperationException("Use method #add(Tab tab)");
        }

        public Tab add(Tab tab) {
            return this.add(tab, -1);
        }

        @Override
        public Component add(Component comp, int index) {
            throw new UnsupportedOperationException("Use method #add(Tab tab, int index)");
        }

        public Tab add(Tab tab, int index) {
            this.tabs.add(index, tab);
            super.add(tab, index, index);
            return tab;
        }

        public void remove(Tab tab) {
            this.tabs.remove(tab);
            super.remove(tab);
        }

        public void removeTab(int index) {
            Tab tab = this.tabs.get(index);
            this.tabs.remove(index);
            super.remove(tab);
        }

        public void removeAllTabs() {
            for (Tab tab : this.tabs) {
                super.remove(tab);
            }
            this.tabs.clear();
        }

        public List<Tab> getTabs() {
            return this.tabs;
        }

        public Tab getTab(int index) {
            if (index >= 0 && index < this.tabs.size()) {
                return this.tabs.get(index);
            }
            return null;
        }

        public int getTabIndex(Tab tab) {
            return this.tabs.indexOf(tab);
        }

        public int getTabCount() {
            return this.tabs.size();
        }

        public void updateTabRects() {
            BasicJYTabbedPaneUI.this.assureRectsCreated(this.getTabCount());
            int i = 0;
            while (i < this.getTabCount()) {
                Tab tab = this.getTab(i);
                Point p = SwingUtilities.convertPoint(tab, 0, 0, BasicJYTabbedPaneUI.this.tabPane);
                this.setTabRect(i, p.x, p.y, tab.getWidth(), tab.getHeight());
                ++i;
            }
        }

        public void setTabRect(int index, int x, int y, int w, int h) {
            Rectangle r = BasicJYTabbedPaneUI.this.rects[index];
            r.x = x;
            r.y = y;
            r.width = w;
            r.height = h;
        }

        public Tab getFirstTab() {
            return this.getTab(0);
        }

        public Tab getLastTab() {
            return this.getTab(this.getTabCount() - 1);
        }

        @Override
        public boolean isOptimizedDrawingEnabled() {
            return false;
        }

        @Override
        protected void paintChildren(Graphics g) {
            boolean isScrollEnd = BasicJYTabbedPaneUI.this.tabsPanelViewport.isScrollEndReached();
            int selectedIndex = BasicJYTabbedPaneUI.this.tabPane.getSelectedIndex();
            if (selectedIndex >= 0) {
                if (!this.getShowPlusButton()) {
                    BasicJYTabbedPaneUI.this.tabsPanel.updateZOrder(2, selectedIndex);
                } else {
                    BasicJYTabbedPaneUI.this.tabsPanel.updateZOrder(isScrollEnd ? 2 : 3, selectedIndex);
                    BasicJYTabbedPaneUI.this.tabsPanel.setComponentZOrder(this.plusComponentPanel, isScrollEnd ? BasicJYTabbedPaneUI.this.tabsPanel.getComponentCount() - 1 : 2);
                }
            }
            super.paintChildren(g);
        }

        public void updateZOrder(int minIndex, int lastPaintIndex) {
            boolean left = BasicJYTabbedPaneUI.this.tabPane.getTabPlacement() == 2;
            boolean right = BasicJYTabbedPaneUI.this.tabPane.getTabPlacement() == 4;
            boolean rtl = !BasicJYTabbedPaneUI.this.tabPane.getComponentOrientation().isLeftToRight();
            boolean overlapInvers = ((JYTabbedPane)BasicJYTabbedPaneUI.this.tabPane).getOverlapTabsInvers();
            int i = 0;
            while (i < this.tabs.size()) {
                boolean overlapLeft;
                Component tab = this.tabs.get(i);
                int index = minIndex;
                if (i < lastPaintIndex) {
                    index += i + 1;
                } else if (i > lastPaintIndex) {
                    index += i;
                }
                boolean bl = overlapLeft = left || rtl && !right;
                if (overlapInvers) {
                    overlapLeft = !overlapLeft;
                }
                index = i == lastPaintIndex || overlapLeft ? index : this.tabs.size() + minIndex * 2 - index;
                this.setComponentZOrder(tab, index);
                ++i;
            }
        }

        private Action createMnemonicAction() {
            return new SetSelectedTabAction();
        }

        private Action createScrollTabIndexToVisibleAction() {
            return new ScrollTabIndexToVisibleAction();
        }

        private Action createAddTabAction() {
            return new AddTabAction();
        }

        private class AddTabAction
        extends AbstractAction {
            private static final long serialVersionUID = 4096240284894333199L;

            private AddTabAction() {
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                JYTabbedPane tabPane = BasicJYTabbedPaneUI.this.getTabbedPane();
                tabPane.addTab("New Tab", null);
                if (tabPane.getTabCount() > 1) {
                    int index = tabPane.getSelectedIndex() + 1;
                    tabPane.moveTab(tabPane.getTabCount() - 1, index);
                    tabPane.setSelectedIndex(index);
                }
            }
        }

        private class ScrollTabIndexToVisibleAction
        extends AbstractAction {
            private static final long serialVersionUID = -4206367017205908279L;

            private ScrollTabIndexToVisibleAction() {
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                String command = evt.getActionCommand();
                if (command != null && command.length() > 0) {
                    int index = Integer.parseInt(command);
                    Rectangle vr = SwingUtilities.convertRectangle(BasicJYTabbedPaneUI.this.tabsPanelViewport.getParent(), BasicJYTabbedPaneUI.this.tabsPanelViewport.getBounds(), BasicJYTabbedPaneUI.this.tabPane);
                    if (index < BasicJYTabbedPaneUI.this.rects.length && !vr.contains(BasicJYTabbedPaneUI.this.rects[index])) {
                        BasicJYTabbedPaneUI.this.tabsPanelViewport.setLeadingTabIndex(index);
                    }
                }
            }
        }

        private class SetSelectedTabAction
        extends AbstractAction {
            private static final long serialVersionUID = -40705378264240905L;

            private SetSelectedTabAction() {
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                String command = evt.getActionCommand();
                if (command != null && command.length() > 0) {
                    char mnemonic = command.toUpperCase().charAt(0);
                    int i = 0;
                    while (i < TabsPanel.this.getTabCount()) {
                        char mne;
                        JComponent c = TabsPanel.this.getTab(i).getComponent();
                        if (c instanceof JLabel && (mne = new String(new char[]{(char)((JLabel)c).getDisplayedMnemonic()}).toUpperCase().charAt(0)) == mnemonic && BasicJYTabbedPaneUI.this.tabPane.isEnabledAt(i)) {
                            BasicJYTabbedPaneUI.this.tabPane.setSelectedIndex(i);
                            BasicJYTabbedPaneUI.this.updateTabFontStyle();
                            Rectangle vr = SwingUtilities.convertRectangle(BasicJYTabbedPaneUI.this.tabsPanelViewport.getParent(), BasicJYTabbedPaneUI.this.tabsPanelViewport.getBounds(), BasicJYTabbedPaneUI.this.tabPane);
                            if (vr.contains(BasicJYTabbedPaneUI.this.rects[i])) break;
                            BasicJYTabbedPaneUI.this.tabsPanelViewport.setLeadingTabIndex(i);
                            break;
                        }
                        ++i;
                    }
                }
            }
        }
    }

    public class TabsPanelViewport
    extends JViewport {
        private static final long serialVersionUID = 3083737645685481572L;
        private boolean dragging;
        private Point dragStart;
        private int dragStartIndex;
        private int dragIndex;
        private int leadingTabIndex;
        private long lastAutoScroll;
        private int autoScrollArea = 16;
        private MouseEventGenerator mouseEventGenerator = new MouseEventGenerator();
        private ScrollAnimator scrollAnimator = new ScrollAnimator();
        private Point mouseWheelPosition;
        private Component oldGlassPane;

        public TabsPanelViewport() {
            this.setName("JYTabbedPane.TabsPanelViewport");
            this.setOpaque(false);
            this.addMouseWheelListener(new MouseWheelListener(){

                @Override
                public void mouseWheelMoved(MouseWheelEvent evt) {
                    TabsPanelViewport.this.mouseWheelPosition = evt.getPoint();
                    if (evt.getWheelRotation() > 0) {
                        TabsPanelViewport.this.scrollForward();
                    } else {
                        TabsPanelViewport.this.scrollBackward();
                    }
                }
            });
            this.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    TabsPanelViewport.this.dispatchMouseEvent(evt);
                }

                @Override
                public void mouseEntered(MouseEvent evt) {
                    TabsPanelViewport.this.mouseWheelPosition = null;
                    TabsPanelViewport.this.dispatchMouseEvent(evt);
                }

                @Override
                public void mouseExited(MouseEvent evt) {
                    TabsPanelViewport.this.dispatchMouseEvent(evt);
                }

                @Override
                public void mousePressed(MouseEvent evt) {
                    TabsPanelViewport.this.dispatchMouseEvent(evt);
                }

                @Override
                public void mouseReleased(MouseEvent evt) {
                    if (((JYTabbedPane)BasicJYTabbedPaneUI.this.tabPane).getTabReorderByDraggingEnabled().booleanValue()) {
                        TabsPanelViewport.this.enableDragging(false);
                        TabsPanelViewport.this.doDrag(evt);
                    }
                    TabsPanelViewport.this.dispatchMouseEvent(evt);
                }
            });
            this.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseDragged(MouseEvent evt) {
                    if (((JYTabbedPane)BasicJYTabbedPaneUI.this.tabPane).getTabReorderByDraggingEnabled().booleanValue()) {
                        TabsPanelViewport.this.dragIndex = TabsPanelViewport.this.mousePos2TabIndex(evt.getX(), evt.getY());
                        if (!TabsPanelViewport.this.dragging && TabsPanelViewport.this.dragIndex >= 0) {
                            TabsPanelViewport.this.dragStartIndex = Math.max(0, TabsPanelViewport.this.dragIndex);
                            TabsPanelViewport.this.dragStart = evt.getPoint().getLocation();
                            TabsPanelViewport.this.enableDragging(true);
                        }
                        TabsPanelViewport.this.doDrag(evt);
                    }
                    TabsPanelViewport.this.dispatchMouseEvent(evt);
                }

                @Override
                public void mouseMoved(MouseEvent evt) {
                    TabsPanelViewport.this.mouseWheelPosition = null;
                    TabsPanelViewport.this.dispatchMouseEvent(evt);
                }
            });
            this.addMouseWheelListener(new MouseWheelListener(){

                @Override
                public void mouseWheelMoved(MouseWheelEvent evt) {
                    TabsPanelViewport.this.dispatchMouseEvent(evt);
                }
            });
        }

        private void dispatchMouseEvent(MouseEvent evt) {
            Point p = SwingUtilities.convertPoint(evt.getComponent(), evt.getPoint(), BasicJYTabbedPaneUI.this.tabPane);
            if (BasicJYTabbedPaneUI.this.avoidTrailingCroppedTabs && this.mousePos2TabIndex(p.x, p.y) == this.getTrailingViewTabIndex()) {
                return;
            }
            MouseEvent e = evt instanceof MouseWheelEvent ? new MouseWheelEvent((Component)BasicJYTabbedPaneUI.this.tabPane, evt.getID(), evt.getWhen(), evt.getModifiersEx(), p.x, p.y, evt.getClickCount(), evt.isPopupTrigger(), ((MouseWheelEvent)evt).getScrollType(), ((MouseWheelEvent)evt).getScrollAmount(), ((MouseWheelEvent)evt).getWheelRotation()) : new MouseEvent(BasicJYTabbedPaneUI.this.tabPane, evt.getID(), evt.getWhen(), evt.getModifiersEx(), p.x, p.y, evt.getClickCount(), evt.isPopupTrigger(), evt.getButton());
            BasicJYTabbedPaneUI.this.tabPane.dispatchEvent(e);
        }

        private int mousePos2TabIndex(int x, int y) {
            Point p = SwingUtilities.convertPoint(BasicJYTabbedPaneUI.this.tabsPanelViewport, x, y, this.getView());
            int i = 0;
            while (i < BasicJYTabbedPaneUI.this.rects.length) {
                Rectangle r = SwingUtilities.convertRectangle(BasicJYTabbedPaneUI.this.tabPane, BasicJYTabbedPaneUI.this.rects[i], this.getView());
                if (r.contains(p)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        private int mousePos2DragStopIndex(int x, int y) {
            Point p = SwingUtilities.convertPoint(BasicJYTabbedPaneUI.this.tabsPanelViewport, x, y, this.getView());
            boolean ltr = BasicJYTabbedPaneUI.this.tabPane.getComponentOrientation().isLeftToRight();
            boolean vertical = BasicJYTabbedPaneUI.this.isVerticalTabPlacement();
            int direction = this.dragIndex - this.dragStartIndex;
            int i = 0;
            while (i < BasicJYTabbedPaneUI.this.rects.length) {
                Rectangle r = SwingUtilities.convertRectangle(BasicJYTabbedPaneUI.this.tabPane, BasicJYTabbedPaneUI.this.rects[i], this.getView());
                if (r.contains(p)) {
                    boolean firstHalf;
                    if (vertical) {
                        r.height /= 2;
                    } else {
                        r.width /= 2;
                    }
                    boolean bl = ltr || vertical ? r.contains(p) : (firstHalf = !r.contains(p));
                    if (direction < 0 && !firstHalf) {
                        ++i;
                    } else if (direction > 0 && firstHalf) {
                        --i;
                    }
                    return i;
                }
                ++i;
            }
            return -1;
        }

        private void doDrag(MouseEvent evt) {
            if (!this.dragging && this.mouseEventGenerator.isAlive()) {
                this.mouseEventGenerator.stop();
            }
            JRootPane root = this.getRootPane();
            Component glassPane = root.getGlassPane();
            if (this.dragging) {
                if (glassPane instanceof DragGlassPane) {
                    if (this.mousePos2DragStopIndex(evt.getX(), evt.getY()) >= 0) {
                        root.setCursor(WidgetUtils.getDragCursor());
                    } else {
                        root.setCursor(WidgetUtils.getStopCursor());
                    }
                    ((DragGlassPane)glassPane).update(evt.getPoint());
                }
                if (BasicJYTabbedPaneUI.this.tabPane.getClientProperty("Synthetica.MOUSE_OVER") != null && this.dragIndex != (Integer)BasicJYTabbedPaneUI.this.tabPane.getClientProperty("Synthetica.MOUSE_OVER")) {
                    BasicJYTabbedPaneUI.this.tabPane.putClientProperty("Synthetica.MOUSE_OVER", this.dragIndex);
                    evt.getComponent().repaint();
                }
                Rectangle forwardRect = SwingUtilities.convertRectangle(this.getParent(), this.getBounds(), BasicJYTabbedPaneUI.this.tabPane);
                Rectangle backwardRect = new Rectangle(forwardRect);
                if (BasicJYTabbedPaneUI.this.isVerticalTabPlacement()) {
                    forwardRect.y += forwardRect.height - this.autoScrollArea;
                    forwardRect.height = this.autoScrollArea * 2;
                    backwardRect.y += -this.autoScrollArea;
                    backwardRect.height = this.autoScrollArea * 2;
                } else {
                    forwardRect.x += forwardRect.width - this.autoScrollArea;
                    forwardRect.width = this.autoScrollArea * 2;
                    backwardRect.x += -this.autoScrollArea;
                    backwardRect.width = this.autoScrollArea * 2;
                    if (!BasicJYTabbedPaneUI.this.tabPane.getComponentOrientation().isLeftToRight()) {
                        Rectangle r_ = forwardRect;
                        forwardRect = backwardRect;
                        backwardRect = r_;
                    }
                }
                this.mouseEventGenerator.updateMousePosition(evt.getX(), evt.getY());
                long when = evt.getWhen();
                if (when - this.lastAutoScroll > (long)BasicJYTabbedPaneUI.this.tabAutoScrollDelay) {
                    Point p = SwingUtilities.convertPoint(this, evt.getPoint(), BasicJYTabbedPaneUI.this.tabPane);
                    if (forwardRect.contains(p) && !this.isScrollEndReached()) {
                        this.scrollForward();
                        if (!this.mouseEventGenerator.isAlive()) {
                            this.mouseEventGenerator.start(evt);
                        }
                    } else if (backwardRect.contains(p) && !this.isScrollStartReached()) {
                        this.scrollBackward();
                        if (!this.mouseEventGenerator.isAlive()) {
                            this.mouseEventGenerator.start(evt);
                        }
                    } else {
                        this.mouseEventGenerator.stop();
                    }
                    this.lastAutoScroll = when;
                }
            } else if (!this.dragging && this.dragIndex != this.dragStartIndex && this.dragIndex >= 0) {
                int dragStopIndex = this.mousePos2DragStopIndex(evt.getX(), evt.getY());
                ((JYTabbedPane)BasicJYTabbedPaneUI.this.tabPane).moveTab(this.dragStartIndex, dragStopIndex);
                this.dragIndex = -1;
            }
        }

        private void enableDragging(boolean enable) {
            JRootPane root = this.getRootPane();
            if (enable) {
                this.dragging = true;
                this.oldGlassPane = root.getGlassPane();
                root.setGlassPane(new DragGlassPane());
            } else if (this.dragging) {
                this.dragging = false;
                if (root.getGlassPane() instanceof DragGlassPane) {
                    root.getGlassPane().setVisible(false);
                    root.setGlassPane(this.oldGlassPane);
                }
                root.setCursor(null);
                this.oldGlassPane = null;
            }
        }

        @Override
        public String getToolTipText(MouseEvent evt) {
            String text = null;
            Point p = SwingUtilities.convertPoint(BasicJYTabbedPaneUI.this.tabsPanelViewport, evt.getPoint(), BasicJYTabbedPaneUI.this.tabPane);
            int index = BasicJYTabbedPaneUI.this.tabForCoordinate(BasicJYTabbedPaneUI.this.tabPane, p.x, p.y);
            if (index >= 0 && index < BasicJYTabbedPaneUI.this.tabPane.getTabCount()) {
                text = BasicJYTabbedPaneUI.this.tabPane.getToolTipTextAt(index);
            }
            return text;
        }

        public void scrollForward() {
            this.setLeadingTabIndex(this.leadingTabIndex + 1);
        }

        public void scrollBackward() {
            this.setLeadingTabIndex(this.leadingTabIndex - 1);
        }

        private void setLeadingTabIndex(int index) {
            boolean forward;
            boolean bl = forward = index > this.leadingTabIndex;
            if (this.isViewCompletelyVisible() || forward && this.isScrollEndReached() || !forward && this.isScrollStartReached()) {
                return;
            }
            BasicJYTabbedPaneUI.this.cancelTabEdit();
            this.leadingTabIndex = Math.min(Math.max(0, index), BasicJYTabbedPaneUI.this.tabPane.getTabCount() - 1);
            Point viewPosition = this.getViewPositionForLeadingTabIndex();
            if (((JYTabbedPane)BasicJYTabbedPaneUI.this.tabPane).getTabScrollAnimationEnabled().booleanValue()) {
                this.scrollAnimator.updateEndPosition(viewPosition.x, viewPosition.y);
                if (!this.scrollAnimator.isAlive()) {
                    this.scrollAnimator.start();
                }
            } else {
                this.setViewPosition(viewPosition);
            }
            if (!this.scrollAnimator.isAlive()) {
                this.revalidate();
            }
        }

        private Point getViewPositionForLeadingTabIndex() {
            int viewportWidth = this.getWidth();
            int viewportHeight = this.getHeight();
            Rectangle r = SwingUtilities.convertRectangle(BasicJYTabbedPaneUI.this.tabPane, BasicJYTabbedPaneUI.this.rects[this.leadingTabIndex], this.getView());
            int xMax = this.getView().getPreferredSize().width - viewportWidth;
            int yMax = this.getView().getPreferredSize().height - this.getHeight();
            boolean rtl = !BasicJYTabbedPaneUI.this.isVerticalTabPlacement() & !BasicJYTabbedPaneUI.this.tabPane.getComponentOrientation().isLeftToRight();
            int tabGap = ((JYTabbedPane)BasicJYTabbedPaneUI.this.tabPane).getTabGap();
            if (BasicJYTabbedPaneUI.this.avoidLeadingCroppedTabs) {
                if (!BasicJYTabbedPaneUI.this.isVerticalTabPlacement()) {
                    int width = BasicJYTabbedPaneUI.this.tabsPanel.getShowPlusButton() ? BasicJYTabbedPaneUI.this.tabsPanel.plusComponentPanel.getWidth() + tabGap : 0;
                    int i = BasicJYTabbedPaneUI.this.rects.length - 1;
                    while (i >= 0) {
                        if ((width += ((BasicJYTabbedPaneUI)BasicJYTabbedPaneUI.this).rects[i].width + (width > 0 ? tabGap : 0)) > viewportWidth && i + 1 < BasicJYTabbedPaneUI.this.rects.length) {
                            Rectangle rect = BasicJYTabbedPaneUI.this.rects[i + 1];
                            rect = SwingUtilities.convertRectangle(BasicJYTabbedPaneUI.this.tabPane, rect, this.getView());
                            xMax = rtl ? -viewportWidth + rect.x + rect.width : rect.x;
                            break;
                        }
                        --i;
                    }
                } else {
                    int height = BasicJYTabbedPaneUI.this.tabsPanel.getShowPlusButton() ? BasicJYTabbedPaneUI.this.tabsPanel.plusComponentPanel.getHeight() + tabGap : 0;
                    int i = BasicJYTabbedPaneUI.this.rects.length - 1;
                    while (i >= 0) {
                        if ((height += ((BasicJYTabbedPaneUI)BasicJYTabbedPaneUI.this).rects[i].height + (height > 0 ? tabGap : 0)) > viewportHeight && i + 1 < BasicJYTabbedPaneUI.this.rects.length) {
                            Rectangle rect = BasicJYTabbedPaneUI.this.rects[i + 1];
                            rect = SwingUtilities.convertRectangle(BasicJYTabbedPaneUI.this.tabPane, rect, this.getView());
                            yMax = rect.y;
                            break;
                        }
                        --i;
                    }
                }
            }
            r.x = BasicJYTabbedPaneUI.this.avoidLeadingCroppedTabs && rtl ? Math.max(xMax, -viewportWidth + r.x + r.width) : Math.max(0, Math.min(xMax, this.getComponentOrientation().isLeftToRight() ? r.x : r.x - viewportWidth + r.width));
            r.y = Math.max(0, Math.min(yMax, r.y));
            Point viewPosition = this.getViewPosition().getLocation();
            if (!BasicJYTabbedPaneUI.this.isVerticalTabPlacement()) {
                viewPosition.x = r.x;
            } else {
                viewPosition.y = r.y;
            }
            return viewPosition;
        }

        private void updateLeadingTabIndex() {
            boolean ltr = this.getComponentOrientation().isLeftToRight();
            Point viewPosition = this.getViewPosition();
            int i = 0;
            while (i < BasicJYTabbedPaneUI.this.rects.length) {
                Rectangle r = SwingUtilities.convertRectangle(BasicJYTabbedPaneUI.this.tabPane, BasicJYTabbedPaneUI.this.rects[i], this.getView());
                if (BasicJYTabbedPaneUI.this.isVerticalTabPlacement()) {
                    if (r.contains(r.x, viewPosition.y)) {
                        this.leadingTabIndex = r.y == viewPosition.y ? i : Math.min(BasicJYTabbedPaneUI.this.rects.length, i + 1);
                        break;
                    }
                } else if (ltr) {
                    if (r.contains(viewPosition.x, r.y)) {
                        this.leadingTabIndex = r.x == viewPosition.x ? i : Math.min(BasicJYTabbedPaneUI.this.rects.length, i + 1);
                        break;
                    }
                } else {
                    int x = viewPosition.x + this.getSize().width - 1;
                    if (r.contains(x, r.y)) {
                        this.leadingTabIndex = r.x + r.width - 1 == x ? i : Math.min(BasicJYTabbedPaneUI.this.rects.length, i + 1);
                        break;
                    }
                }
                ++i;
            }
        }

        @Override
        protected LayoutManager createLayoutManager() {
            return new ViewportLayout(){
                private static final long serialVersionUID = 6666117029720189745L;

                @Override
                public void layoutContainer(Container parent) {
                    int i;
                    JViewport vp = (JViewport)parent;
                    Component view = vp.getView();
                    if (view == null) {
                        return;
                    }
                    boolean ltr = TabsPanelViewport.this.getComponentOrientation().isLeftToRight();
                    boolean vertical = BasicJYTabbedPaneUI.this.isVerticalTabPlacement();
                    Dimension vpSize = vp.getSize();
                    Dimension viewSize = new Dimension(view.getPreferredSize());
                    if (vertical) {
                        viewSize.width = vpSize.width;
                    } else {
                        viewSize.height = vpSize.height;
                    }
                    TabsPanelViewport.this.leadingTabIndex = Math.min(Math.max(0, TabsPanelViewport.this.leadingTabIndex), BasicJYTabbedPaneUI.this.tabPane.getTabCount() - 1);
                    if (vpSize.width > viewSize.width || vpSize.height > viewSize.height) {
                        TabsPanelViewport.this.leadingTabIndex = 0;
                    }
                    Point viewPosition = vp.getViewPosition().getLocation();
                    if (vertical) {
                        viewPosition.x = 0;
                        viewPosition.y = vpSize.height >= viewSize.height ? 0 : (!BasicJYTabbedPaneUI.this.avoidLeadingCroppedTabs ? Math.min(viewSize.height - vpSize.height, viewPosition.y) : Math.min(((TabsPanelViewport)TabsPanelViewport.this).getViewPositionForLeadingTabIndex().y, viewPosition.y));
                    } else {
                        viewPosition.y = 0;
                        if (ltr) {
                            viewPosition.x = vpSize.width >= viewSize.width ? 0 : (!BasicJYTabbedPaneUI.this.avoidLeadingCroppedTabs ? Math.min(viewSize.width - vpSize.width, viewPosition.x) : Math.min(((TabsPanelViewport)TabsPanelViewport.this).getViewPositionForLeadingTabIndex().x, viewPosition.x));
                        } else {
                            int scrolledWidth = 0;
                            int tabGap = ((JYTabbedPane)BasicJYTabbedPaneUI.this.tabPane).getTabGap();
                            i = 0;
                            while (i < TabsPanelViewport.this.leadingTabIndex) {
                                scrolledWidth += ((BasicJYTabbedPaneUI)((TabsPanelViewport)TabsPanelViewport.this).BasicJYTabbedPaneUI.this).rects[i].width + tabGap;
                                ++i;
                            }
                            viewPosition.x = vpSize.width >= viewSize.width ? viewSize.width - vpSize.width : (!BasicJYTabbedPaneUI.this.avoidLeadingCroppedTabs ? Math.max(0, viewSize.width - vpSize.width - scrolledWidth) : Math.max(((TabsPanelViewport)TabsPanelViewport.this).getViewPositionForLeadingTabIndex().x, viewSize.width - vpSize.width - scrolledWidth));
                        }
                    }
                    if (vpSize.width > viewSize.width) {
                        viewPosition.x = 0;
                        viewSize.width = vpSize.width;
                    }
                    if (vpSize.height > viewSize.height) {
                        viewPosition.y = 0;
                        viewSize.height = vpSize.height;
                    }
                    if (!TabsPanelViewport.this.scrollAnimator.isAlive()) {
                        vp.setViewPosition(viewPosition);
                    }
                    vp.setViewSize(viewSize);
                    BasicJYTabbedPaneUI.this.tabsPanel.updateTabRects();
                    if (!TabsPanelViewport.this.isViewCompletelyVisible()) {
                        BasicJYTabbedPaneUI.this.tabsPanel.leadingCroppedEdge.revalidate();
                        BasicJYTabbedPaneUI.this.tabsPanel.trailingCroppedEdge.revalidate();
                    }
                    if (BasicJYTabbedPaneUI.this.avoidTrailingCroppedTabs) {
                        int li = TabsPanelViewport.this.getLeadingViewTabIndex();
                        int ti = TabsPanelViewport.this.getTrailingViewTabIndex();
                        i = 0;
                        while (i < BasicJYTabbedPaneUI.this.tabsPanel.getTabs().size()) {
                            boolean visible = i >= li && i < ti | ti < 0;
                            BasicJYTabbedPaneUI.this.tabsPanel.getTab(i).setVisible(visible);
                            ++i;
                        }
                    }
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TabsPanelViewport.this.updateLeadingTabIndex();
                            TabsPanelViewport.this.updatePopupItems();
                            boolean viewCompletelyVisible = TabsPanelViewport.this.isViewCompletelyVisible();
                            JButton forwardButton = BasicJYTabbedPaneUI.this.getScrollButton(true);
                            if (!BasicJYTabbedPaneUI.this.avoidTrailingCroppedTabs) {
                                forwardButton.setEnabled(!(TabsPanelViewport.this.isScrollEndReached() | viewCompletelyVisible | TabsPanelViewport.this.leadingTabIndex == BasicJYTabbedPaneUI.this.tabPane.getTabCount() - 1));
                            } else {
                                forwardButton.setEnabled(TabsPanelViewport.this.getTrailingViewTabIndex() != -1);
                            }
                            if (!forwardButton.isEnabled() && forwardButton.hasFocus()) {
                                FocusManager.getCurrentManager().focusNextComponent();
                            }
                            JButton backwardButton = BasicJYTabbedPaneUI.this.getScrollButton(false);
                            if (!BasicJYTabbedPaneUI.this.avoidLeadingCroppedTabs) {
                                backwardButton.setEnabled(TabsPanelViewport.this.leadingTabIndex != 0);
                            } else {
                                backwardButton.setEnabled(TabsPanelViewport.this.getLeadingViewTabIndex() > 0);
                            }
                            if (!backwardButton.isEnabled() && backwardButton.hasFocus()) {
                                FocusManager.getCurrentManager().focusNextComponent();
                            }
                            JButton popupButton = BasicJYTabbedPaneUI.this.getPopupButton();
                            popupButton.setEnabled(!viewCompletelyVisible);
                            if (BasicJYTabbedPaneUI.this.croppedEdgeSize > 0) {
                                BasicJYTabbedPaneUI.this.tabsPanel.leadingCroppedEdge.setVisible(!viewCompletelyVisible && !TabsPanelViewport.this.isScrollStartReached() && !BasicJYTabbedPaneUI.this.avoidLeadingCroppedTabs);
                                BasicJYTabbedPaneUI.this.tabsPanel.trailingCroppedEdge.setVisible(!viewCompletelyVisible && !TabsPanelViewport.this.isScrollEndReached() && !BasicJYTabbedPaneUI.this.avoidTrailingCroppedTabs && !BasicJYTabbedPaneUI.this.tabsPanel.getShowPlusButton());
                            }
                            if (BasicJYTabbedPaneUI.this.tabsPanel.getShowPlusButton()) {
                                BasicJYTabbedPaneUI.this.tabsPanel.plusComponentPanel.updateAppearance(viewCompletelyVisible, TabsPanelViewport.this.isScrollEndReached());
                            }
                        }
                    });
                }
            };
        }

        private boolean isScrollEndReached() {
            Dimension viewSize = this.getViewSize();
            Rectangle r = this.getViewRect();
            boolean endReached = BasicJYTabbedPaneUI.this.isVerticalTabPlacement() ? r.y == viewSize.height - r.height : (this.getComponentOrientation().isLeftToRight() ? r.x == viewSize.width - r.width : r.x == 0);
            return endReached;
        }

        private boolean isScrollStartReached() {
            Dimension viewSize = this.getViewSize();
            Rectangle r = this.getViewRect();
            boolean startReached = BasicJYTabbedPaneUI.this.isVerticalTabPlacement() ? r.y == 0 : (this.getComponentOrientation().isLeftToRight() ? r.x == 0 : r.x == viewSize.width - r.width);
            return startReached;
        }

        private boolean isViewCompletelyVisible() {
            Dimension viewSize = this.getViewSize();
            Rectangle r = this.getViewRect();
            return BasicJYTabbedPaneUI.this.isVerticalTabPlacement() ? r.height >= viewSize.height : r.width >= viewSize.width;
        }

        private int getTrailingViewTabIndex() {
            Rectangle viewRect = this.getViewRect();
            boolean ltr = BasicJYTabbedPaneUI.this.tabPane.getComponentOrientation().isLeftToRight();
            boolean vertical = BasicJYTabbedPaneUI.this.isVerticalTabPlacement();
            int tabGap = ((JYTabbedPane)BasicJYTabbedPaneUI.this.tabPane).getTabGap();
            if (BasicJYTabbedPaneUI.this.tabsPanel.getShowPlusButton()) {
                this.calculatePlusButtonAwareViewRect(viewRect, ltr, vertical, tabGap);
            }
            int i = 0;
            while (i < BasicJYTabbedPaneUI.this.rects.length) {
                Rectangle r = BasicJYTabbedPaneUI.this.rects[i];
                Rectangle rect = SwingUtilities.convertRectangle(BasicJYTabbedPaneUI.this.tabPane, r, this);
                if (vertical) {
                    rect.height += tabGap;
                    if (rect.contains(rect.x, viewRect.height + tabGap - 1)) {
                        return i;
                    }
                } else {
                    rect.width += tabGap;
                    if (rect.contains(ltr ? viewRect.width + tabGap - 1 : (BasicJYTabbedPaneUI.this.tabsPanel.getShowPlusButton() ? BasicJYTabbedPaneUI.this.tabsPanel.plusComponentPanel.getWidth() : 0), rect.y)) {
                        return i;
                    }
                }
                ++i;
            }
            return -1;
        }

        private int getLeadingViewTabIndex() {
            Rectangle viewRect = this.getViewRect();
            boolean ltr = BasicJYTabbedPaneUI.this.tabPane.getComponentOrientation().isLeftToRight();
            boolean vertical = BasicJYTabbedPaneUI.this.isVerticalTabPlacement();
            int tabGap = BasicJYTabbedPaneUI.this.getTabbedPane().getTabGap();
            if (BasicJYTabbedPaneUI.this.tabsPanel.getShowPlusButton()) {
                this.calculatePlusButtonAwareViewRect(viewRect, ltr, vertical, tabGap);
            }
            int i = 0;
            while (i < BasicJYTabbedPaneUI.this.rects.length) {
                Rectangle r = BasicJYTabbedPaneUI.this.rects[i];
                Rectangle rect = SwingUtilities.convertRectangle(BasicJYTabbedPaneUI.this.tabPane, r, this);
                if (vertical) {
                    rect.height += tabGap;
                    if (rect.contains(rect.x, 0)) {
                        return i;
                    }
                } else {
                    rect.width += tabGap;
                    if (rect.contains(ltr ? 0 : viewRect.width + tabGap - 1, rect.y)) {
                        return i;
                    }
                }
                ++i;
            }
            return -1;
        }

        private void updatePopupItems() {
            Rectangle viewRect = SwingUtilities.convertRectangle(BasicJYTabbedPaneUI.this.tabsPanelViewport.getParent(), BasicJYTabbedPaneUI.this.tabsPanelViewport.getBounds(), BasicJYTabbedPaneUI.this.tabPane);
            if (BasicJYTabbedPaneUI.this.tabsPanel.getShowPlusButton()) {
                this.calculatePlusButtonAwareViewRect(viewRect);
            }
            JPopupMenu leadingPopup = ((SimpleDropDownButton)BasicJYTabbedPaneUI.this.leadingTabControlsPanel.getComponents()[3]).getPopupMenu();
            leadingPopup.removeAll();
            JPopupMenu trailingPopup = ((SimpleDropDownButton)BasicJYTabbedPaneUI.this.trailingTabControlsPanel.getComponents()[2]).getPopupMenu();
            trailingPopup.removeAll();
            int i = 0;
            while (i < BasicJYTabbedPaneUI.this.rects.length) {
                Rectangle r = BasicJYTabbedPaneUI.this.rects[i];
                if (!viewRect.contains(r)) {
                    if (i >= BasicJYTabbedPaneUI.this.tabPane.getTabCount()) break;
                    Icon icon = BasicJYTabbedPaneUI.this.tabPane.getIconAt(i);
                    if (BasicJYTabbedPaneUI.this.forcePopupMenuIconSpace) {
                        icon = new EmptyIcon(SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(16)).intValue(), SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(4)).intValue());
                    }
                    SelectTabByMenuItemAction a = new SelectTabByMenuItemAction(i, BasicJYTabbedPaneUI.this.tabPane.getTitleAt(i), icon);
                    a.setEnabled(BasicJYTabbedPaneUI.this.tabPane.isEnabledAt(i));
                    JMenuItem item = new JMenuItem(a);
                    item.setComponentOrientation(BasicJYTabbedPaneUI.this.tabPane.getComponentOrientation());
                    leadingPopup.add(item);
                    item = new JMenuItem(a);
                    item.setComponentOrientation(BasicJYTabbedPaneUI.this.tabPane.getComponentOrientation());
                    trailingPopup.add(item);
                }
                ++i;
            }
        }

        private void calculatePlusButtonAwareViewRect(Rectangle viewRect, boolean ltr, boolean verticalTabPlacement, int tabGap) {
            if (verticalTabPlacement) {
                viewRect.height -= BasicJYTabbedPaneUI.this.tabsPanel.plusComponentPanel.getHeight() + tabGap;
            } else {
                if (!ltr) {
                    viewRect.x += BasicJYTabbedPaneUI.this.tabsPanel.plusComponentPanel.getWidth() + tabGap;
                }
                viewRect.width -= BasicJYTabbedPaneUI.this.tabsPanel.plusComponentPanel.getWidth() + tabGap;
            }
        }

        public void calculatePlusButtonAwareViewRect(Rectangle viewRect) {
            int tabGap = ((JYTabbedPane)BasicJYTabbedPaneUI.this.tabPane).getTabGap();
            this.calculatePlusButtonAwareViewRect(viewRect, this.getComponentOrientation().isLeftToRight(), BasicJYTabbedPaneUI.this.isVerticalTabPlacement(), tabGap);
        }

        private class DragGlassPane
        extends JPanel {
            private static final long serialVersionUID = -344140311958471859L;
            private int x;
            private int y;
            private Rectangle draggingTabRectangle;
            private BufferedImage draggingTab;
            private Icon dragArrowIcon;

            public DragGlassPane() {
                this.setOpaque(false);
                this.draggingTabRectangle = SwingUtilities.convertRectangle(BasicJYTabbedPaneUI.this.tabPane, BasicJYTabbedPaneUI.this.rects[TabsPanelViewport.this.dragStartIndex], this.getRootPane());
                this.draggingTab = new BufferedImage(this.draggingTabRectangle.width, this.draggingTabRectangle.height, 2);
                Tab tab = BasicJYTabbedPaneUI.this.tabsPanel.getTab(TabsPanelViewport.this.dragStartIndex);
                Graphics2D g2 = this.draggingTab.createGraphics();
                AlphaComposite alphaComp = AlphaComposite.getInstance(3, 0.75f);
                g2.setComposite(alphaComp);
                tab.print(g2);
                g2.dispose();
                int placement = BasicJYTabbedPaneUI.this.tabPane.getTabPlacement();
                String key = "JYTabbedPane.dragArrowIcon." + (placement == 1 ? "up" : (placement == 3 ? "down" : (placement == 2 ? "left" : "right")));
                this.dragArrowIcon = SyntheticaLookAndFeel.loadIcon((String)key, (Component)BasicJYTabbedPaneUI.this.tabPane, (boolean)true);
                if (this.dragArrowIcon == null) {
                    this.dragArrowIcon = new FallbackDragArrowIcon();
                }
            }

            public void update(Point p) {
                this.x = p.x;
                this.y = p.y;
                this.setVisible(true);
                if (!this.getSize().equals(this.getRootPane().getSize())) {
                    this.setSize(this.getRootPane().getSize());
                }
                this.repaint();
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(new Color(0x20FF0000, true));
                g.drawImage(this.draggingTab, this.draggingTabRectangle.x - ((TabsPanelViewport)TabsPanelViewport.this).dragStart.x + this.x, this.draggingTabRectangle.y - ((TabsPanelViewport)TabsPanelViewport.this).dragStart.y + this.y, null);
                Rectangle dragArrowRect = this.calcDragArrowBounds();
                if (dragArrowRect != null) {
                    this.dragArrowIcon.paintIcon(null, g, dragArrowRect.x, dragArrowRect.y);
                }
            }

            private Rectangle calcDragArrowBounds() {
                int index = TabsPanelViewport.this.mousePos2DragStopIndex(this.x, this.y);
                if (index < 0) {
                    return null;
                }
                Rectangle r = SwingUtilities.convertRectangle(BasicJYTabbedPaneUI.this.tabPane, BasicJYTabbedPaneUI.this.rects[index], this);
                boolean ltr = BasicJYTabbedPaneUI.this.tabPane.getComponentOrientation().isLeftToRight();
                boolean vertical = BasicJYTabbedPaneUI.this.isVerticalTabPlacement();
                int direction = TabsPanelViewport.this.dragIndex - TabsPanelViewport.this.dragStartIndex;
                Rectangle r_ = new Rectangle(r);
                if (vertical) {
                    r_.height /= 2;
                } else {
                    r_.width /= 2;
                }
                Point p = SwingUtilities.convertPoint(BasicJYTabbedPaneUI.this.tabsPanelViewport, this.x, this.y, this);
                boolean firstHalf = r_.contains(p);
                if (vertical && direction >= 0 && !firstHalf) {
                    r.y += r.height;
                } else if (ltr && direction >= 0 && !firstHalf || !ltr && direction <= 0 && !firstHalf) {
                    r.x += r.width;
                }
                int w = this.dragArrowIcon.getIconWidth();
                int h = this.dragArrowIcon.getIconHeight();
                if (vertical) {
                    r.x = r.x + (BasicJYTabbedPaneUI.this.tabPane.getTabPlacement() == 2 ? r.width : -w);
                    r.y -= h / 2;
                } else {
                    r.x -= w / 2;
                    r.y = r.y + (BasicJYTabbedPaneUI.this.tabPane.getTabPlacement() == 1 ? r.height : -h);
                }
                r.width = w;
                r.height = h;
                return r;
            }
        }

        private class FallbackDragArrowIcon
        extends SyntheticaBasicIconPainter {
            public FallbackDragArrowIcon() {
                super(null, 20, 20);
            }

            public void paint2D(SynthContext sc, Graphics2D g2, float x, float y, float w, float h) {
                y = 2.0f;
                x = 2.0f;
                Shape s = new Ellipse2D.Float(x, y, w - 4.0f, h - 4.0f);
                g2.setPaint(new Color(-1428102944, true));
                g2.fill(s);
                g2.setPaint(new Color(-863993728, true));
                g2.draw(s);
                int placement = BasicJYTabbedPaneUI.this.tabPane.getTabPlacement();
                if (placement != 1) {
                    int angle = placement == 3 ? 180 : (placement == 2 ? 270 : 90);
                    AffineTransform at = new AffineTransform(g2.getTransform());
                    at.rotate(Math.toRadians(angle), w / 2.0f, h / 2.0f);
                    g2.setTransform(at);
                }
                g2.setPaint(new Color(-532660160, true));
                s = this.createArrowUpShape(x + 3.0f, y + 3.0f, w - 10.0f, h - 11.0f);
                g2.fill(s);
                g2.draw(s);
            }

            private Shape createArrowUpShape(float x, float y, float w, float h) {
                GeneralPath path = new GeneralPath();
                path.moveTo(x + w / 2.0f, y + 0.0f);
                path.lineTo(x + w, y + h / 2.0f);
                path.lineTo(x + w - 2.0f, y + h / 2.0f);
                path.lineTo(x + w - 2.0f, y + h);
                path.lineTo(x + 2.0f, y + h);
                path.lineTo(x + 2.0f, y + h / 2.0f);
                path.lineTo(x + 0.0f, y + h / 2.0f);
                path.closePath();
                return path;
            }
        }

        private class MouseEventGenerator {
            private Thread t;
            private int x;
            private int y;

            public void updateMousePosition(int x, int y) {
                this.x = x;
                this.y = y;
            }

            public boolean isAlive() {
                return this.t != null && this.t.isAlive();
            }

            public void start(final MouseEvent evt) {
                this.t = new Thread(){

                    @Override
                    public void run() {
                        while (!this.isInterrupted()) {
                            try {
                                1.sleep(BasicJYTabbedPaneUI.this.tabAutoScrollDelay);
                                EventQueue.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        long when = System.currentTimeMillis();
                                        MouseEvent me = new MouseEvent(evt.getComponent(), evt.getID(), when, evt.getModifiersEx(), MouseEventGenerator.this.x, MouseEventGenerator.this.y, evt.getClickCount(), evt.isPopupTrigger(), evt.getButton());
                                        BasicJYTabbedPaneUI.this.tabsPanelViewport.dispatchEvent(me);
                                    }
                                });
                            }
                            catch (InterruptedException e) {
                                this.interrupt();
                            }
                        }
                    }
                };
                this.t.setDaemon(true);
                this.t.start();
            }

            public void stop() {
                if (this.t != null) {
                    this.t.interrupt();
                }
            }
        }

        private class ScrollAnimator {
            private Thread t;
            private int x;
            private int y;

            private ScrollAnimator() {
            }

            public void updateEndPosition(int x, int y) {
                this.x = x;
                this.y = y;
            }

            public boolean isAlive() {
                return this.t != null && this.t.isAlive();
            }

            public void start() {
                this.t = new Thread(){

                    @Override
                    public void run() {
                        while (!this.isInterrupted()) {
                            try {
                                1.sleep(25L);
                                EventQueue.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        int delta;
                                        Point currentPos = BasicJYTabbedPaneUI.this.tabsPanelViewport.getViewPosition().getLocation();
                                        boolean horizontal = !BasicJYTabbedPaneUI.this.isVerticalTabPlacement();
                                        boolean ltr = BasicJYTabbedPaneUI.this.tabsPanelViewport.getComponentOrientation().isLeftToRight();
                                        boolean forward = ScrollAnimator.this.x > currentPos.x || ScrollAnimator.this.y > currentPos.y;
                                        int n = delta = horizontal ? (ScrollAnimator.this.x - currentPos.x) / 2 : (ScrollAnimator.this.y - currentPos.y) / 2;
                                        if (delta == 0 || (forward ^= horizontal && !ltr) && TabsPanelViewport.this.isScrollEndReached() || !forward && TabsPanelViewport.this.isScrollStartReached()) {
                                            this.interrupt();
                                        } else {
                                            int tabIndex;
                                            if (delta == 1 || delta == -1) {
                                                delta = 0;
                                            }
                                            Point p = horizontal ? new Point(ScrollAnimator.this.x - delta, ScrollAnimator.this.y) : new Point(ScrollAnimator.this.x, ScrollAnimator.this.y - delta);
                                            BasicJYTabbedPaneUI.this.tabsPanelViewport.setViewPosition(p);
                                            int n2 = tabIndex = TabsPanelViewport.this.mouseWheelPosition == null ? -1 : BasicJYTabbedPaneUI.this.tabsPanelViewport.mousePos2TabIndex(((TabsPanelViewport)((ScrollAnimator)(this).ScrollAnimator.this).TabsPanelViewport.this).mouseWheelPosition.x, ((TabsPanelViewport)((ScrollAnimator)(this).ScrollAnimator.this).TabsPanelViewport.this).mouseWheelPosition.y);
                                            if (!TabsPanelViewport.this.mouseEventGenerator.isAlive()) {
                                                BasicJYTabbedPaneUI.this.tabPane.putClientProperty("Synthetica.MOUSE_OVER", tabIndex);
                                            }
                                            BasicJYTabbedPaneUI.this.tabsPanelViewport.revalidate();
                                            BasicJYTabbedPaneUI.this.tabsPanelViewport.repaint();
                                        }
                                    }
                                });
                            }
                            catch (InterruptedException e) {
                                this.interrupt();
                            }
                        }
                        if (!BasicJYTabbedPaneUI.this.tabsPanelViewport.isValid()) {
                            BasicJYTabbedPaneUI.this.tabsPanelViewport.validate();
                        }
                    }
                };
                this.t.setDaemon(true);
                this.t.start();
            }

            public void stop() {
                if (this.t != null) {
                    this.t.interrupt();
                }
            }
        }

        private class SelectTabByMenuItemAction
        extends AbstractAction {
            private int tabIndex;

            public SelectTabByMenuItemAction(int tabIndex, String tabText, Icon tabIcon) {
                this.tabIndex = tabIndex;
                this.putValue("Name", tabText);
                this.putValue("SmallIcon", this.scaleIcon(tabIcon));
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicJYTabbedPaneUI.this.tabPane.setSelectedIndex(this.tabIndex);
                BasicJYTabbedPaneUI.this.updateTabFontStyle();
                TabsPanelViewport.this.setLeadingTabIndex(this.tabIndex);
            }

            private Icon scaleIcon(Icon icon) {
                if (icon == null) {
                    return null;
                }
                int size = SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(16));
                if (icon.getIconWidth() <= size && icon.getIconHeight() <= size) {
                    return icon;
                }
                return SyntheticaAddonsUtilities.resizeIcon((Icon)icon, (int)size, (int)size);
            }
        }
    }
}

