/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.searchfield.ui.controls;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.searchfield.JYSearchField;
import de.javasoft.searchfield.ui.controls.IButtonFactory;
import de.javasoft.searchfield.ui.controls.SearchActionEvent;
import de.javasoft.syntheticaaddons.SimpleDropDownButton;
import de.javasoft.widgets.JYButtonIcon;
import de.javasoft.widgets.util.WidgetUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.plaf.synth.SynthContext;

public class ButtonFactory
implements IButtonFactory,
SwingConstants {
    @Override
    public AbstractButton createSearchButton(final JYSearchField searchField, Action a) {
        JButton b = new JButton(a){
            private static final long serialVersionUID = 2285809691111940943L;

            @Override
            public Icon getDisabledIcon() {
                return this.getIcon();
            }

            @Override
            public boolean isEnabled() {
                return searchField.isEnabled();
            }

            @Override
            public String getToolTipText(MouseEvent evt) {
                return (String)this.getAction().getValue("ShortDescription");
            }

            @Override
            public void updateUI() {
                super.updateUI();
                ButtonFactory.this.setSearchButtonDefaults(this, searchField);
            }

            @Override
            protected void fireActionPerformed(ActionEvent evt) {
                Object[] listeners = this.listenerList.getListenerList();
                int i = listeners.length - 2;
                while (i >= 0) {
                    SearchActionEvent event = new SearchActionEvent(searchField, 1001, evt.getActionCommand(), evt.getWhen(), evt.getModifiers(), SearchActionEvent.Initiator.SEARCH_BUTTON);
                    if (listeners[i] == ActionListener.class) {
                        ((ActionListener)listeners[i + 1]).actionPerformed(event);
                    }
                    i -= 2;
                }
            }
        };
        b.setModel(new DefaultButtonModel(){
            private static final long serialVersionUID = -777014533975461232L;

            @Override
            public boolean isEnabled() {
                return searchField.isEnabled();
            }
        });
        if (a != null && a.getValue("ShortDescription") == null) {
            a.putValue("ShortDescription", UIManager.get("JYSearchField.searchButton.toolTip"));
        }
        if (searchField.getShowSearchButton() != null) {
            b.setVisible(searchField.getShowSearchButton());
        }
        b.setMargin(new Insets(0, 0, 0, 0));
        b.setContentAreaFilled(false);
        b.setFocusable(false);
        b.setCursor(Cursor.getDefaultCursor());
        b.setName("JYSearchField.SearchButton");
        this.setSearchButtonDefaults(b, searchField);
        return b;
    }

    private void setSearchButtonDefaults(AbstractButton b, JYSearchField searchField) {
        if (b.getAction() != null && b.getAction().getValue("SmallIcon") != null) {
            b.setIcon((Icon)b.getAction().getValue("SmallIcon"));
        } else {
            b.setIcon(this.createSearchIcon(b, searchField));
        }
        Insets insets = SyntheticaLookAndFeel.getInsets((String)"JYSearchField.searchButton.insets", (Component)b, (Insets)new Insets(0, 1, 0, 4), (boolean)true);
        b.setBorder(new ButtonBorder(searchField, insets));
    }

    protected Icon createSearchIcon(AbstractButton b, JYSearchField searchField) {
        return new JYButtonIcon(b, "JYSearchField.searchButton.icon", 14, 14){

            @Override
            public void paintFallback2DIcon(SynthContext sc, SyntheticaState state, Graphics2D g2, float x, float y, float w, float h) {
                g2.setPaint(ButtonFactory.this.getSearchPaintColor(state));
                Ellipse2D.Float s = new Ellipse2D.Float(4.0f, 1.0f, 8.0f, 8.0f);
                g2.setPaint(ButtonFactory.this.getSearchPaintColor(state));
                g2.draw(s);
                g2.setStroke(new BasicStroke(1.0f));
                GeneralPath path = new GeneralPath();
                path.moveTo(0.0f, 13.0f);
                path.lineTo(4.0f, 9.0f);
                g2.draw(path);
                g2.draw(path);
            }

            protected BasicStroke createStroke(SynthContext sc) {
                return new BasicStroke(1.2f);
            }
        };
    }

    @Override
    public AbstractButton createSearchPopupButton(final JYSearchField searchField, Action a) {
        SimpleDropDownButton b = new SimpleDropDownButton(a){
            private static final long serialVersionUID = -588740562435809693L;

            public Icon getDisabledIcon() {
                return this.getIcon();
            }

            public String getToolTipText(MouseEvent evt) {
                return (String)this.getAction().getValue("ShortDescription");
            }

            public boolean isEnabled() {
                return searchField.isEnabled();
            }

            public void updateUI() {
                super.updateUI();
                ButtonFactory.this.setSearchPopupButtonDefaults((AbstractButton)((Object)this), searchField);
            }

            protected void fireActionPerformed(ActionEvent evt) {
                Object[] listeners = this.listenerList.getListenerList();
                int i = listeners.length - 2;
                while (i >= 0) {
                    SearchActionEvent event = new SearchActionEvent(searchField, 1001, evt.getActionCommand(), evt.getWhen(), evt.getModifiers(), SearchActionEvent.Initiator.SEARCH_POPUP_BUTTON);
                    if (listeners[i] == ActionListener.class) {
                        ((ActionListener)listeners[i + 1]).actionPerformed(event);
                    }
                    i -= 2;
                }
            }
        };
        b.setPopupMenu(searchField.getSearchPopupMenu());
        b.setModel((ButtonModel)new DefaultButtonModel(){
            private static final long serialVersionUID = -8516576038545240736L;

            @Override
            public boolean isEnabled() {
                return searchField.isEnabled();
            }
        });
        if (a != null && a.getValue("ShortDescription") == null) {
            a.putValue("ShortDescription", UIManager.get("JYSearchField.searchButton.toolTip"));
        }
        if (searchField.getShowSearchButton() != null) {
            b.setVisible(searchField.getShowSearchButton().booleanValue());
        }
        b.setArrowVisible(false);
        b.setMargin(new Insets(0, 0, 0, 0));
        b.setBorderPainted(false);
        b.setContentAreaFilled(false);
        b.setFocusable(false);
        b.setCursor(Cursor.getDefaultCursor());
        b.setName("JYSearchField.SearchButton");
        this.setSearchPopupButtonDefaults((AbstractButton)b, searchField);
        return b;
    }

    private void setSearchPopupButtonDefaults(AbstractButton b, JYSearchField searchField) {
        if (b.getAction() != null && b.getAction().getValue("SmallIcon") != null) {
            b.setIcon((Icon)b.getAction().getValue("SmallIcon"));
        } else {
            b.setIcon(this.createPopupIcon(b, searchField));
        }
        Insets insets = SyntheticaLookAndFeel.getInsets((String)"JYSearchField.searchPopupButton.insets", (Component)b, (Insets)new Insets(0, 1, 0, 4), (boolean)true);
        b.setBorder(new ButtonBorder(searchField, insets));
    }

    protected Icon createPopupIcon(AbstractButton b, JYSearchField searchField) {
        return new JYButtonIcon(b, "JYSearchField.searchPopupButton.icon", 14, 14){

            @Override
            public void paintFallback2DIcon(SynthContext sc, SyntheticaState state, Graphics2D g2, float x, float y, float w, float h) {
                g2.setPaint(ButtonFactory.this.getSearchPaintColor(state));
                Ellipse2D.Float s = new Ellipse2D.Float(4.0f, 1.0f, 8.0f, 8.0f);
                g2.setPaint(ButtonFactory.this.getSearchPaintColor(state));
                g2.draw(s);
                g2.setStroke(new BasicStroke(1.0f));
                GeneralPath path = new GeneralPath();
                path.moveTo(0.0f, 13.0f);
                path.lineTo(4.0f, 9.0f);
                g2.draw(path);
                g2.draw(path);
                path = new GeneralPath();
                path.moveTo(w - 4.5f, h - 1.1f);
                path.lineTo(w - 1.5f, h - 1.1f);
                path.lineTo(w - 3.0f, h);
                path.closePath();
                g2.draw(path);
            }

            protected BasicStroke createStroke(SynthContext sc) {
                return new BasicStroke(1.2f);
            }
        };
    }

    @Override
    public AbstractButton createDeleteButton(final JYSearchField searchField, Action a) {
        JButton b = new JButton(a){
            private static final long serialVersionUID = -1350228247067269391L;

            @Override
            public Icon getDisabledIcon() {
                return this.getIcon();
            }

            @Override
            public boolean isEnabled() {
                return searchField.isEnabled() && searchField.isEditable();
            }

            @Override
            public String getToolTipText(MouseEvent evt) {
                return (String)this.getAction().getValue("ShortDescription");
            }

            @Override
            public void updateUI() {
                super.updateUI();
                ButtonFactory.this.setDeleteButtonDefaults(this, searchField);
            }
        };
        b.setModel(new DefaultButtonModel(){
            private static final long serialVersionUID = -8516576038545240736L;

            @Override
            public boolean isEnabled() {
                return searchField.isEnabled() && searchField.isEditable();
            }
        });
        a.putValue("ShortDescription", UIManager.get("JYSearchField.deleteButton.toolTip"));
        b.setMargin(new Insets(0, 0, 0, 0));
        b.setContentAreaFilled(false);
        b.setVisible(searchField.getDocument().getLength() > 0);
        b.setFocusable(false);
        b.setCursor(Cursor.getDefaultCursor());
        b.setName("JYSearchField.DeleteButton");
        this.setDeleteButtonDefaults(b, searchField);
        return b;
    }

    private void setDeleteButtonDefaults(AbstractButton b, JYSearchField searchField) {
        b.setIcon(this.createDeleteIcon(b, searchField));
        Insets insets = SyntheticaLookAndFeel.getInsets((String)"JYSearchField.deleteButton.insets", (Component)b, (Insets)new Insets(0, 2, 0, 0), (boolean)true);
        b.setBorder(new ButtonBorder(searchField, insets));
    }

    protected Icon createDeleteIcon(AbstractButton b, JYSearchField searchField) {
        return new JYButtonIcon(b, "JYSearchField.deleteButton.icon", 10, 10){

            @Override
            public void paintFallback2DIcon(SynthContext sc, SyntheticaState state, Graphics2D g2, float x, float y, float w, float h) {
                g2.setPaint(ButtonFactory.this.getDeletePaintColor(state));
                GeneralPath path = new GeneralPath();
                path.moveTo(2.0f, 2.0f);
                path.lineTo(7.0f, 7.0f);
                path.moveTo(7.0f, 2.0f);
                path.lineTo(2.0f, 7.0f);
                g2.draw(path);
            }
        };
    }

    protected Color getDeletePaintColor(SyntheticaState state) {
        Color color = null;
        color = state.isSet(SyntheticaState.State.DISABLED) || state.isSet(SyntheticaState.State.LOCKED) ? new Color(0xA0A0A0) : (state.isSet(SyntheticaState.State.PRESSED) ? new Color(0x606060) : (state.isSet(SyntheticaState.State.HOVER) ? new Color(0xE70000) : new Color(0)));
        return color;
    }

    protected Color getSearchPaintColor(SyntheticaState state) {
        Color color = null;
        color = state.isSet(SyntheticaState.State.DISABLED) ? new Color(0xA0A0A0) : (state.isSet(SyntheticaState.State.PRESSED) ? new Color(0x555555) : (state.isSet(SyntheticaState.State.HOVER) ? new Color(0x808080) : new Color(0x222222)));
        return color;
    }

    private static class ButtonBorder
    extends WidgetUtils.OrientationAwareEmptyBorderUIResource {
        private static final long serialVersionUID = -4886609230446983952L;
        private JYSearchField searchField;

        public ButtonBorder(JYSearchField searchField, Insets insets) {
            super(insets);
            this.searchField = searchField;
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            Insets ins = super.getBorderInsets(c, insets);
            if (this.searchField.getSearchControlsPosition() == JYSearchField.SearchControlsPosition.CLEAR_LEADING_SEARCH_TRAILING) {
                int left = ins.left;
                ins.left = ins.right;
                ins.right = left;
            }
            return ins;
        }
    }
}

