/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.label.ui;

import de.javasoft.label.JYLabel;
import de.javasoft.label.ui.JYLabelUI;
import de.javasoft.widgets.IRotatableComponent;
import de.javasoft.widgets.util.WidgetUtils;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.View;

public class BasicJYLabelUI
extends JYLabelUI {
    public static ComponentUI createUI(JComponent c) {
        return new BasicJYLabelUI();
    }

    @Override
    protected void installDefaults(JLabel c) {
        super.installDefaults(c);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        JComponent c = (JComponent)evt.getSource();
        String name = evt.getPropertyName();
        if (WidgetUtils.shouldUpdateStyle(evt)) {
            this.installDefaults((JLabel)c);
        }
        if ("rotation".equals(name)) {
            c.revalidate();
            c.repaint();
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Icon icon;
        JYLabel label = (JYLabel)c;
        Font f = label.getFont();
        FontMetrics fm = label.getFontMetrics(f);
        int w = label.getWidth();
        int h = label.getHeight();
        String text = label.getText();
        Icon icon2 = icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
        if (icon == null && text == null) {
            return;
        }
        IRotatableComponent.Rotation rotation = label.getRotation();
        Insets insets = label.getInsets();
        Rectangle viewRect = new Rectangle(insets.left, insets.top, w - insets.left - insets.right, h - insets.top - insets.bottom);
        Rectangle textRect = new Rectangle();
        Rectangle iconRect = new Rectangle();
        text = this.layoutCL(label, fm, text, icon, viewRect, iconRect, textRect);
        if (icon != null) {
            this.paintIcon(label, g, icon, iconRect, rotation);
        }
        this.paintText(label, g, f, fm, text, textRect, rotation);
    }

    private void paintText(JLabel label, Graphics g, Font font, FontMetrics fm, String text, Rectangle textRect, IRotatableComponent.Rotation rotation) {
        boolean isHtml;
        boolean bl = isHtml = label.getClientProperty("html") != null;
        if (rotation == IRotatableComponent.Rotation.LEFT || rotation == IRotatableComponent.Rotation.RIGHT) {
            if (!isHtml) {
                textRect.x = textRect.x + (rotation == IRotatableComponent.Rotation.RIGHT ? -fm.getAscent() : fm.getAscent());
            }
            Graphics2D g2 = (Graphics2D)g;
            double origin = rotation == IRotatableComponent.Rotation.RIGHT ? (textRect.width - textRect.height) / 2 : -(textRect.width - textRect.height) / 2;
            g2.translate(origin, origin);
            g2.rotate(Math.toRadians(rotation.toAngle()), textRect.x + textRect.width / 2, textRect.y + textRect.height / 2);
            this.paintLabelText(label, text, g, fm, textRect);
            g2.rotate(-Math.toRadians(rotation.toAngle()), textRect.x + textRect.width / 2, textRect.y + textRect.height / 2);
            g2.translate(-origin, -origin);
        } else {
            if (!isHtml) {
                textRect.y += fm.getAscent();
            }
            this.paintLabelText(label, text, g, fm, textRect);
        }
    }

    protected void paintLabelText(JLabel label, String text, Graphics g, FontMetrics fm, Rectangle textRect) {
        View v = (View)label.getClientProperty("html");
        if (v != null) {
            v.paint(g, textRect);
        } else if (label.isEnabled()) {
            this.paintEnabledText(label, g, text, textRect.x, textRect.y);
        } else {
            this.paintDisabledText(label, g, text, textRect.x, textRect.y);
        }
    }

    private void paintIcon(JComponent c, Graphics g, Icon icon, Rectangle iconRect, IRotatableComponent.Rotation rotation) {
        if (rotation == IRotatableComponent.Rotation.LEFT || rotation == IRotatableComponent.Rotation.RIGHT) {
            Graphics2D g2 = (Graphics2D)g;
            double origin = rotation == IRotatableComponent.Rotation.LEFT ? -(iconRect.width - iconRect.height) / 2 : (iconRect.width - iconRect.height) / 2;
            g2.translate(origin, origin);
            g2.rotate(Math.toRadians(rotation.toAngle()), iconRect.x + iconRect.width / 2, iconRect.y + iconRect.height / 2);
            icon.paintIcon(c, g, iconRect.x, iconRect.y);
            g2.rotate(-Math.toRadians(rotation.toAngle()), iconRect.x + iconRect.width / 2, iconRect.y + iconRect.height / 2);
            g2.translate(-origin, -origin);
        } else {
            icon.paintIcon(c, g, iconRect.x, iconRect.y);
        }
    }

    @Override
    protected String layoutCL(JLabel label, FontMetrics fm, String text, Icon icon, Rectangle viewRect, Rectangle iconRect, Rectangle textRect) {
        IRotatableComponent.Rotation rotation = ((JYLabel)label).getRotation();
        WidgetUtils.rotateRectangle(viewRect, rotation);
        text = this.layoutLabel_(label, fm, text, icon, viewRect, iconRect, textRect, rotation);
        WidgetUtils.rotateRectangle(viewRect, rotation);
        this.rotatePosition(viewRect, textRect, rotation);
        WidgetUtils.rotateRectangle(textRect, rotation);
        this.rotatePosition(viewRect, iconRect, rotation);
        WidgetUtils.rotateRectangle(iconRect, rotation);
        return text;
    }

    private String layoutLabel_(JLabel label, FontMetrics fm, String text, Icon icon, Rectangle viewRect, Rectangle iconRect, Rectangle textRect, IRotatableComponent.Rotation rotation) {
        int vAlign = label.getVerticalAlignment();
        int hAlign = label.getHorizontalAlignment();
        int vPos = label.getVerticalTextPosition();
        int hPos = label.getHorizontalTextPosition();
        text = SwingUtilities.layoutCompoundLabel(label, fm, text, icon, vAlign, hAlign, vPos, hPos, viewRect, iconRect, textRect, label.getIconTextGap());
        return text;
    }

    private void rotatePosition(Rectangle outerRect, Rectangle r, IRotatableComponent.Rotation rotation) {
        int x = r.x - outerRect.x;
        int y = r.y - outerRect.y;
        if (rotation == IRotatableComponent.Rotation.LEFT) {
            r.x = outerRect.x + y;
            r.y = outerRect.y - x + outerRect.height - r.width;
        } else if (rotation == IRotatableComponent.Rotation.RIGHT) {
            r.x = outerRect.x - y + outerRect.width - r.height;
            r.y = outerRect.y + x;
        }
    }
}

