/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.label;

import de.javasoft.label.ui.JYLabelUI;
import de.javasoft.label.ui.addons.JYLabelAddon;
import de.javasoft.syntheticaaddons.SyntheticaAddons;
import de.javasoft.widgets.IRotatableComponent;
import java.awt.Color;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.FocusManager;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import org.jdesktop.swingx.plaf.ComponentAddon;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;

public class JYLabel
extends JLabel
implements IRotatableComponent {
    private static final long serialVersionUID = -5848260115739353584L;
    public static final String uiClassID = "JYLabelUI";
    protected JTextField editor;
    private MouseListener editMouseListener;
    private int minimumEditorColumns = 8;
    private IRotatableComponent.Rotation rotation = IRotatableComponent.Rotation.NONE;
    private boolean editable;

    static {
        SyntheticaAddons.contribute((ComponentAddon)new JYLabelAddon());
    }

    public JYLabel() {
        this((String)null);
    }

    public JYLabel(String text) {
        super(text);
        this.editMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2 && JYLabel.this.isEditable() && JYLabel.this.isEnabled()) {
                    JYLabel.this.startEdit();
                    JYLabel.this.firePropertyChange("editorStart", null, JYLabel.this.editor.getText());
                }
            }
        };
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        this.setUI(LookAndFeelAddons.getUI((JComponent)this, JYLabelUI.class));
    }

    @Override
    public Color getForeground() {
        Color color = super.getForeground();
        if ((color == null || color instanceof UIResource) && UIManager.getLookAndFeel() instanceof SynthLookAndFeel) {
            SynthStyle ss = SynthLookAndFeel.getStyle(this, Region.LABEL);
            SynthContext sc = new SynthContext(this, Region.LABEL, ss, this.isEnabled() ? 0 : 8);
            color = this.isEnabled() ? color : ss.getColor(sc, ColorType.TEXT_FOREGROUND);
        }
        return color;
    }

    public void startEdit() {
        if (this.editor != null) {
            return;
        }
        this.editor = this.createEditor();
        JLayeredPane layerPane = this.getRootPane().getLayeredPane();
        layerPane.setLayer(this.editor, JLayeredPane.DEFAULT_LAYER + 1);
        layerPane.add(this.editor);
        Insets ins = this.editor.getInsets();
        Rectangle r = this.getBounds();
        if (this.getRotation() == IRotatableComponent.Rotation.LEFT || this.getRotation() == IRotatableComponent.Rotation.RIGHT) {
            int w = r.width;
            r.width = r.height;
            r.height = w;
        }
        r = SwingUtilities.convertRectangle(this.getParent(), r, layerPane);
        r.x -= ins.left;
        r.y -= ins.top;
        r.height += ins.top + ins.bottom;
        r.width = Math.max(this.editor.getPreferredSize().width, r.width + ins.left + ins.right + 10);
        this.editor.setBounds(r);
        this.editor.setText(this.getText());
        this.editor.requestFocus();
    }

    protected JTextField createEditor() {
        JTextField textField = new JTextField(this.minimumEditorColumns);
        textField.getInputMap().put(KeyStroke.getKeyStroke(27, 0), "cancelEdit");
        textField.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "commitEdit");
        textField.getActionMap().put("cancelEdit", new AbstractAction(){
            private static final long serialVersionUID = 6493436037599401405L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                JYLabel.this.stopEdit();
                JYLabel.this.firePropertyChange("editorStop", JYLabel.this.getText(), null);
            }
        });
        textField.getActionMap().put("commitEdit", new AbstractAction(){
            private static final long serialVersionUID = -6358104323591921133L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                InputVerifier verifier = JYLabel.this.getInputVerifier();
                if (verifier == null && !JYLabel.this.getDefaultInputVerifier().verify(JYLabel.this.editor) || verifier != null && !verifier.verify(JYLabel.this.editor)) {
                    return;
                }
                String oldValue = JYLabel.this.getText();
                JYLabel.this.commitEdit();
                JYLabel.this.firePropertyChange("editorCommit", oldValue, JYLabel.this.getText());
            }
        });
        textField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent evt) {
                JYLabel.this.stopEdit();
                JYLabel.this.firePropertyChange("editorStop", JYLabel.this.getText(), null);
            }

            @Override
            public void focusGained(FocusEvent evt) {
            }
        });
        return textField;
    }

    private InputVerifier getDefaultInputVerifier() {
        return new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                String text = ((JTextField)input).getText();
                boolean empty = text == null || text.trim().length() == 0;
                return !empty;
            }
        };
    }

    public void stopEdit() {
        if (this.editor == null) {
            return;
        }
        JRootPane rootPane = this.getRootPane();
        if (rootPane == null) {
            Window w = FocusManager.getCurrentManager().getActiveWindow();
            if (w instanceof JFrame) {
                rootPane = ((JFrame)w).getRootPane();
            } else if (w instanceof JDialog) {
                rootPane = ((JDialog)w).getRootPane();
            }
        }
        rootPane.getLayeredPane().remove(this.editor);
        rootPane.getLayeredPane().repaint();
        this.editor = null;
    }

    public void commitEdit() {
        if (this.editor == null) {
            return;
        }
        this.setText(this.editor.getText());
        this.stopEdit();
    }

    @Override
    public IRotatableComponent.Rotation getRotation() {
        return this.rotation;
    }

    @Override
    public void setRotation(IRotatableComponent.Rotation rotation) {
        IRotatableComponent.Rotation oldValue = this.rotation;
        this.rotation = rotation;
        this.firePropertyChange("rotation", (Object)oldValue, (Object)rotation);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        if (editable) {
            this.addMouseListener(this.editMouseListener);
        } else {
            this.removeMouseListener(this.editMouseListener);
        }
    }
}

