/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.combobox.ui;

import de.javasoft.combobox.JYDateComboBox;
import de.javasoft.combobox.controls.ComboBoxMonthView;
import de.javasoft.combobox.controls.DateComboBoxEditor;
import de.javasoft.combobox.controls.DateComboBoxRenderer;
import de.javasoft.combobox.controls.MonthViewPopupPanel;
import de.javasoft.combobox.ui.SyntheticaJYComboBoxUI;
import de.javasoft.combobox.ui.controls.ComponentPopup;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.ComboPopup;

public class SyntheticaJYDateComboBoxUI
extends SyntheticaJYComboBoxUI {
    private FocusListener delegateFocusListener;

    public static ComponentUI createUI(JComponent c) {
        return new SyntheticaJYDateComboBoxUI();
    }

    protected void installDefaults() {
        Boolean visible;
        super.installDefaults();
        JYDateComboBox combo = (JYDateComboBox)this.comboBox;
        if (combo.todayButtonVisibleIsUIResource()) {
            visible = SyntheticaLookAndFeel.getBoolean((String)"JYDateComboBox.todayButton.visible", (Component)combo);
            combo.setTodayButtonVisible(visible, true);
        }
        if (combo.clearButtonVisibleIsUIResource()) {
            visible = SyntheticaLookAndFeel.getBoolean((String)"JYDateComboBox.clearButton.visible", (Component)combo);
            combo.setClearButtonVisible(visible, true);
        }
        this.updateTodayClearButton((JYDateComboBox)this.comboBox);
    }

    private void updateTodayClearButton(JYDateComboBox combo) {
        JPanel buttonPane = new JPanel();
        buttonPane.setName("JYDateComboBox.buttonPanel");
        buttonPane.setLayout(new FlowLayout(1, SyntheticaLookAndFeel.getInt((String)"JYDateComboBox.buttonPanel.hgap", (Component)combo, (int)8, (boolean)true), SyntheticaLookAndFeel.getInt((String)"JYDateComboBox.buttonPanel.vgap", (Component)combo, (int)4, (boolean)true)));
        buttonPane.setOpaque(false);
        if (combo.getTodayButtonVisible().booleanValue()) {
            buttonPane.add(this.createTodayButton(combo));
        }
        if (combo.getClearButtonVisible().booleanValue()) {
            buttonPane.add(this.createClearButton(combo));
        }
        MonthViewPopupPanel popup = combo.getPopupComponent();
        Component[] componentArray = popup.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (!(c instanceof ComboBoxMonthView)) {
                popup.remove(c);
            }
            ++n2;
        }
        if (buttonPane.getComponentCount() > 0) {
            int gap = SyntheticaLookAndFeel.getInt((String)"JYDateComboBox.popup.gap", (Component)combo, (int)4, (boolean)true);
            popup.add(Box.createVerticalStrut(gap));
            if (SyntheticaLookAndFeel.getBoolean((String)"JYDateComboBox.popup.separator.enabled", (Component)combo, (boolean)true)) {
                JSeparator separator = new JSeparator();
                separator.setName("JYDateComboBox.popupSeparator");
                popup.add(separator);
                popup.add(Box.createVerticalStrut(gap));
            }
            popup.add(buttonPane);
            int bottomGap = SyntheticaLookAndFeel.getInt((String)"JYDateComboBox.popup.gap.bottom", (Component)combo, (int)0, (boolean)true);
            popup.add(Box.createVerticalStrut(bottomGap));
        }
    }

    private AbstractButton createTodayButton(final JYDateComboBox combo) {
        String text = SyntheticaLookAndFeel.getString((String)"JYDateComboBox.today.text", (Component)this.comboBox);
        return new JButton(new AbstractAction(text){

            @Override
            public void actionPerformed(ActionEvent evt) {
                combo.setDate(new Date());
                combo.closePopup();
            }
        });
    }

    private AbstractButton createClearButton(final JYDateComboBox combo) {
        String text = SyntheticaLookAndFeel.getString((String)"JYDateComboBox.clear.text", (Component)this.comboBox);
        return new JButton(new AbstractAction(text){

            @Override
            public void actionPerformed(ActionEvent evt) {
                combo.setDate((Date)null);
                combo.closePopup();
            }
        });
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.comboBox.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if ("popupComponent".equals(name)) {
                    ((ComponentPopup)SyntheticaJYDateComboBoxUI.this.popup).setPopupComponent((JComponent)evt.getNewValue());
                } else if ("popupWidth".equals(name)) {
                    ((ComponentPopup)SyntheticaJYDateComboBoxUI.this.popup).setPreferredWidth((Integer)evt.getNewValue());
                } else if ("popupHeight".equals(name)) {
                    ((ComponentPopup)SyntheticaJYDateComboBoxUI.this.popup).setPreferredHeight((Integer)evt.getNewValue());
                } else if ("popupResizable".equals(name)) {
                    ((ComponentPopup)SyntheticaJYDateComboBoxUI.this.popup).setResizable((Boolean)evt.getNewValue());
                } else if ("popupSizeRestorable".equals(name)) {
                    ((ComponentPopup)SyntheticaJYDateComboBoxUI.this.popup).setSizeRestorable((Boolean)evt.getNewValue());
                } else if ("todayButtonVisible".equals(name)) {
                    SyntheticaJYDateComboBoxUI.this.updateTodayClearButton((JYDateComboBox)SyntheticaJYDateComboBoxUI.this.comboBox);
                } else if ("clearButtonVisible".equals(name)) {
                    SyntheticaJYDateComboBoxUI.this.updateTodayClearButton((JYDateComboBox)SyntheticaJYDateComboBoxUI.this.comboBox);
                }
            }
        };
        this.comboBox.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected ListCellRenderer<Object> createRenderer() {
        return new DateComboBoxRenderer((JYDateComboBox)this.comboBox, super.createRenderer());
    }

    protected ComboBoxEditor createEditor() {
        if (this.comboBox.getEditor() == null) {
            return new DateComboBoxEditor((JYDateComboBox)this.comboBox, super.createEditor(), null);
        }
        return this.comboBox.getEditor();
    }

    protected void configureEditor() {
        this.editor.setEnabled(this.comboBox.isEnabled());
        this.editor.setFont(this.comboBox.getFont());
        if (this.focusListener != null) {
            this.editor.addFocusListener(this.focusListener);
        }
    }

    protected FocusListener createFocusListener() {
        this.delegateFocusListener = super.createFocusListener();
        return new FocusListener(){

            @Override
            public void focusGained(FocusEvent evt) {
                SyntheticaJYDateComboBoxUI.this.delegateFocusListener.focusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                if (!(SyntheticaJYDateComboBoxUI.this.comboBox.getParent() instanceof JTable)) {
                    SyntheticaJYDateComboBoxUI.this.delegateFocusListener.focusLost(evt);
                }
            }
        };
    }

    @Override
    protected ComboPopup createPopup() {
        ComponentPopup p = new ComponentPopup(this.comboBox);
        p.setName("DateComboBoxPopup");
        p.setBorder(null);
        JScrollPane scroller = (JScrollPane)SyntheticaLookAndFeel.findComponent((String)"ComboBox.scrollPane", (Container)p);
        scroller.setOpaque(false);
        scroller.getViewport().setOpaque(false);
        return p;
    }
}

