/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.combobox.controls;

import de.javasoft.combobox.JYComboBox;
import de.javasoft.combobox.controls.IPopupComponentInitializer;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.ParseException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FontPopupPanel
extends JPanel
implements IPopupComponentInitializer {
    private JYComboBox comboBox;
    protected PreviewPanel previewPanel;
    private JComboBox<?> familyCombo;
    private JComboBox<?> styleCombo;
    private JSpinner sizeSpinner;
    private static String delimiter = ",";

    public FontPopupPanel(JYComboBox comboBox) {
        this.comboBox = comboBox;
        if (comboBox != null) {
            this.comboBox.setPopupResizable(true);
        }
        this.setLayout(new GridBagLayout());
        this.previewPanel = new PreviewPanel();
        this.add((Component)this.previewPanel, new GridBagConstraints(0, 0, 3, 1, 0.0, 1.0, 10, 1, SyntheticaLookAndFeel.getInstance().scaleInsets(0, 0, 4, 0), 0, 0));
        JLabel l = new JLabel(UIManager.getString("JYComboBox.fontPopup.family"));
        this.add((Component)l, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, SyntheticaLookAndFeel.getInstance().scaleInsets(0, 0, 4, 5), 0, 0));
        l = new JLabel(UIManager.getString("JYComboBox.fontPopup.style"));
        this.add((Component)l, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, SyntheticaLookAndFeel.getInstance().scaleInsets(0, 5, 4, 5), 0, 0));
        l = new JLabel(UIManager.getString("JYComboBox.fontPopup.size"));
        this.add((Component)l, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, SyntheticaLookAndFeel.getInstance().scaleInsets(0, 5, 4, 0), 0, 0));
        this.familyCombo = this.createFamilyCombo();
        this.add(this.familyCombo, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, SyntheticaLookAndFeel.getInstance().scaleInsets(0, 0, 0, 5), 0, 0));
        this.styleCombo = this.createStyleCombo();
        this.add(this.styleCombo, new GridBagConstraints(1, 2, 1, 1, 0.05, 0.0, 10, 2, SyntheticaLookAndFeel.getInstance().scaleInsets(0, 5, 0, 5), 0, 0));
        this.sizeSpinner = this.createSizeSpinner();
        this.add((Component)this.sizeSpinner, new GridBagConstraints(2, 2, 1, 1, 0.05, 0.0, 10, 1, SyntheticaLookAndFeel.getInstance().scaleInsets(0, 5, 0, 0), 0, 0));
        this.add((Component)new JSeparator(), new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 10, 2, SyntheticaLookAndFeel.getInstance().scaleInsets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.createButtonPanel(), new GridBagConstraints(0, 4, 3, 1, 0.0, 0.0, 10, 2, SyntheticaLookAndFeel.getInstance().scaleInsets(10, 0, 0, 0), 0, 0));
        this.setBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(10, 10, 5, 10, true));
    }

    @Override
    public void initializePopupComponent(JYComboBox comboBox) {
        Object item = comboBox.getItem();
        this.setPreviewFont(item == null ? UIManager.getFont("Label.font") : (Font)item);
    }

    public void setPreviewFont(Font font) {
        this.familyCombo.setSelectedItem(font.getFamily());
        this.styleCombo.setSelectedItem(font.getStyle());
        this.sizeSpinner.setValue(font.getSize());
    }

    private JComboBox<?> createFamilyCombo() {
        JYComboBox c = new JYComboBox(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
        c.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    String family = (String)evt.getItem();
                    Font f = FontPopupPanel.this.previewPanel.getPreviewFont();
                    FontPopupPanel.this.previewPanel.setPreviewFont(new Font(family, f.getStyle(), f.getSize()));
                }
            }
        });
        return c;
    }

    private JComboBox<?> createStyleCombo() {
        JYComboBox c = new JYComboBox();
        c.addItem(0);
        c.addItem(1);
        c.addItem(2);
        c.addItem(3);
        final ListCellRenderer defaultRenderer = c.getRenderer();
        c.setRenderer(new ListCellRenderer<Object>(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel l = (JLabel)defaultRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                int style = (Integer)value;
                l.setText(FontPopupPanel.fontStyleAsText(style));
                return l;
            }
        });
        c.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    int style = (Integer)evt.getItem();
                    FontPopupPanel.this.previewPanel.setPreviewFont(FontPopupPanel.this.previewPanel.getPreviewFont().deriveFont(style));
                }
            }
        });
        return c;
    }

    private JSpinner createSizeSpinner() {
        JSpinner spinner = new JSpinner();
        spinner.setModel(new SpinnerNumberModel(10, 4, 256, 1));
        spinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JSpinner spinner = (JSpinner)evt.getSource();
                int size = (Integer)spinner.getValue();
                FontPopupPanel.this.previewPanel.setPreviewFont(FontPopupPanel.this.previewPanel.getPreviewFont().deriveFont((float)size));
            }
        });
        return spinner;
    }

    private JPanel createButtonPanel() {
        Component c;
        JButton approveButton = new JButton(this.createApproveAction());
        JButton cancelButton = new JButton(this.createCancelAction());
        int xGap = 10;
        SpringLayout layout = new SpringLayout(){

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return parent.getComponent(0).getPreferredSize();
            }
        };
        JPanel p = new JPanel(layout);
        p.setOpaque(false);
        p.add(approveButton);
        p.add(cancelButton);
        layout.putConstraint("East", (Component)cancelButton, 0, "East", (Component)p);
        layout.putConstraint("East", (Component)approveButton, -xGap, "West", (Component)cancelButton);
        Spring maxWidth = Spring.constant(0);
        Component[] componentArray = p.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            c = componentArray[n2];
            maxWidth = Spring.max(maxWidth, layout.getConstraints(c).getWidth());
            ++n2;
        }
        componentArray = p.getComponents();
        n = componentArray.length;
        n2 = 0;
        while (n2 < n) {
            c = componentArray[n2];
            SpringLayout.Constraints constraints = layout.getConstraints(c);
            constraints.setWidth(maxWidth);
            ++n2;
        }
        return p;
    }

    protected Action createApproveAction() {
        AbstractAction action = new AbstractAction(){
            {
                this.putValue("Name", UIManager.getString("JYComboBox.fontPopup.approve.text"));
                String mm = UIManager.getString("JYComboBox.fontPopup.approve.mnemonic");
                this.putValue("MnemonicKey", mm == null ? 79 : (int)mm.charAt(0));
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                JYComboBox combo = FontPopupPanel.this.comboBox;
                combo.setItem(FontPopupPanel.this.previewPanel.getPreviewFont());
                combo.closePopup();
            }
        };
        return action;
    }

    protected Action createCancelAction() {
        AbstractAction action = new AbstractAction(){
            {
                this.putValue("Name", UIManager.getString("JYComboBox.fontPopup.cancel.text"));
                String mm = UIManager.getString("JYComboBox.fontPopup.cancel.mnemonic");
                this.putValue("MnemonicKey", mm == null ? 67 : (int)mm.charAt(0));
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                JYComboBox combo = FontPopupPanel.this.comboBox;
                combo.cancelPopup();
            }
        };
        return action;
    }

    static String fontStyleAsText(int style) {
        String s = null;
        if (style == 0) {
            s = UIManager.getString("JYComboBox.fontPopup.style.plain");
        } else if (style == 1) {
            s = UIManager.getString("JYComboBox.fontPopup.style.bold");
        } else if (style == 2) {
            s = UIManager.getString("JYComboBox.fontPopup.style.italic");
        } else if (style == 3) {
            s = UIManager.getString("JYComboBox.fontPopup.style.boldItalic");
        }
        return s;
    }

    static int parseFontStyle(String text) {
        int style = 0;
        if ((text = text.toLowerCase()).equals(UIManager.getString("JYComboBox.fontPopup.style.plain").toLowerCase())) {
            style = 0;
        } else if (text.equals(UIManager.getString("JYComboBox.fontPopup.style.bold").toLowerCase())) {
            style = 1;
        } else if (text.equals(UIManager.getString("JYComboBox.fontPopup.style.italic").toLowerCase())) {
            style = 2;
        } else if (text.equals(UIManager.getString("JYComboBox.fontPopup.style.boldItalic").toLowerCase())) {
            style = 3;
        }
        return style;
    }

    static String fontAsText(Font f) {
        return f == null ? "" : String.valueOf(f.getFamily()) + delimiter + " " + FontPopupPanel.fontStyleAsText(f.getStyle()) + delimiter + " " + f.getSize();
    }

    static Font parseFont(String text) throws ParseException {
        int numberOfValues = 3;
        String[] fss = text.split(delimiter);
        Object[] vals = new Object[numberOfValues];
        if (fss.length != numberOfValues) {
            throw new ParseException("Required number: " + numberOfValues, -1);
        }
        int i = 0;
        while (i < vals.length) {
            if (i == 0) {
                vals[i] = fss[i].trim();
            } else if (i == 1) {
                vals[i] = FontPopupPanel.parseFontStyle(fss[i].trim());
            } else if (i == 2) {
                try {
                    int val = Integer.parseInt(fss[i].trim());
                    if (val < 4 || val > 256) {
                        throw new NumberFormatException("Size has to be between 4 and 256");
                    }
                    vals[i] = val;
                }
                catch (NumberFormatException e) {
                    throw new ParseException(e.getMessage(), -1);
                }
            }
            ++i;
        }
        Font f = null;
        try {
            f = new Font((String)vals[0], (int)((Integer)vals[1]), (Integer)vals[2]);
        }
        catch (RuntimeException e) {
            throw new ParseException(e.getMessage(), -1);
        }
        return f;
    }

    protected static class PreviewPanel
    extends JPanel {
        JLabel previewText;

        public PreviewPanel() {
            this.setLayout(new BorderLayout());
            this.setBorder(new TitledBorder(UIManager.getString("JYComboBox.fontPopup.preview.text")));
            this.previewText = new JLabel(UIManager.getString("JYComboBox.fontPopup.preview.string"));
            this.previewText.setHorizontalAlignment(0);
            this.setPreferredSize(SyntheticaLookAndFeel.getInstance().scaleDimension(200, 80));
            this.setMinimumSize(SyntheticaLookAndFeel.getInstance().scaleDimension(0, 0));
            this.add(this.previewText);
        }

        public void setPreviewFont(Font font) {
            this.previewText.setFont(font);
        }

        public Font getPreviewFont() {
            return this.previewText.getFont();
        }
    }
}

