/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.combobox.controls;

import de.javasoft.combobox.JYDateComboBox;
import de.javasoft.combobox.controls.AbstractComboBoxEditor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.swing.CellEditor;
import javax.swing.ComboBoxEditor;
import javax.swing.JFormattedTextField;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.DefaultFormatterFactory;
import org.jdesktop.swingx.JXMonthView;
import org.jdesktop.swingx.calendar.DatePickerFormatter;

public class DateComboBoxEditor
extends AbstractComboBoxEditor {
    private JYDateComboBox dateComboBox;
    private Date lastDate;

    public DateComboBoxEditor(JYDateComboBox dateComboBox, ComboBoxEditor defaultEditor, CellEditor cellEditor) {
        super(defaultEditor, cellEditor);
        this.dateComboBox = dateComboBox;
        ((JFormattedTextField)this.editor).setFormatterFactory(new DefaultFormatterFactory((JFormattedTextField.AbstractFormatter)new DatePickerFormatter(dateComboBox.getDateFormats())));
        if (!this.getMonthView().getSelection().isEmpty()) {
            dateComboBox.configureEditor(this, this.getMonthView().getSelection().first());
        }
        dateComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DateComboBoxEditor.this.lastDate = DateComboBoxEditor.this.dateComboBox.getDateTime();
            }
        });
    }

    @Override
    protected JTextField createComboBoxEditorComponent() {
        DateTextField editor = new DateTextField();
        editor.setInheritsPopupMenu(true);
        editor.putClientProperty("Synthetica.opaque", false);
        editor.setBorder(new EmptyBorder(0, 0, 0, 0));
        editor.addFocusListener(this);
        editor.setName("ComboBox.textField");
        return editor;
    }

    @Override
    protected JFormattedTextField.AbstractFormatter createFormatter() {
        return null;
    }

    private JXMonthView getMonthView() {
        return this.dateComboBox.getPopupComponent().getMonthView();
    }

    @Override
    public void setItem(Object o) {
        if (this.getMonthView().isSelectionEmpty()) {
            o = null;
        }
        if (o != null) {
            o = DateComboBoxEditor.getDateTime((Date)o, (Date)this.getItem(), this.getMonthView().getTimeZone());
            ((JFormattedTextField)this.editor).setValue(o);
        } else {
            this.editor.setText("");
        }
    }

    @Override
    public void focusLost(FocusEvent evt) {
        if (this.commit() && this.dateComboBox.isShowing()) {
            this.actionPerformed();
        }
    }

    private boolean commit() {
        Date date = null;
        Object value = ((JFormattedTextField)this.editor).getValue();
        if (value instanceof Long) {
            date = new Date((Long)value);
        } else if (value instanceof Date) {
            date = (Date)value;
        } else if (value == null) {
            date = new Date(Long.MAX_VALUE);
        }
        try {
            if (!this.editor.getText().equals(this.dateComboBox.getDateFormats()[0].format(date))) {
                ((JFormattedTextField)this.editor).commitEdit();
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        value = ((JFormattedTextField)this.editor).getValue();
        JXMonthView monthView = this.getMonthView();
        if (value instanceof Long) {
            date = new Date((Long)value);
        } else if (value instanceof Date) {
            date = (Date)value;
        } else if (value == null) {
            monthView.clearSelection();
            return true;
        }
        if (this.lastDate == null && this.dateComboBox.getItemCount() > 0) {
            this.lastDate = (Date)this.dateComboBox.getItemAt(0);
        }
        if (!monthView.isSelectionEmpty() && date.equals(this.lastDate)) {
            return false;
        }
        monthView.setSelectionInterval(date, date);
        return true;
    }

    private void actionPerformed() {
        ActionEvent ae = new ActionEvent(this.dateComboBox, 1001, "comboBoxEdited", System.currentTimeMillis(), 0);
        ActionListener[] actionListenerArray = this.dateComboBox.getActionListeners();
        int n = actionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionListener l = actionListenerArray[n2];
            l.actionPerformed(ae);
            ++n2;
        }
    }

    static Date getDateTime(Date date, Date dateTime, TimeZone tz) {
        GregorianCalendar time = new GregorianCalendar();
        ((Calendar)time).setTimeZone(tz);
        if (dateTime != null) {
            time.setTime(dateTime);
        }
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).setTimeZone(tz);
        cal.setTime(date);
        cal.set(11, time.get(11));
        cal.set(12, time.get(12));
        cal.set(13, time.get(13));
        return cal.getTime();
    }

    private class DateTextField
    extends JFormattedTextField {
        private DateTextField() {
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension pref = super.getPreferredSize();
            if (UIManager.getLookAndFeel() instanceof MetalLookAndFeel) {
                pref.height += 4;
            }
            return pref;
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension min = super.getMinimumSize();
            if (UIManager.getLookAndFeel() instanceof MetalLookAndFeel) {
                min.height += 4;
            }
            return min;
        }

        @Override
        protected void processKeyEvent(KeyEvent evt) {
            boolean altDown;
            boolean popupVisible = DateComboBoxEditor.this.dateComboBox.isPopupVisible();
            boolean bl = altDown = evt.getKeyCode() == 40 && (evt.getModifiersEx() & 0x200) == 512;
            if (altDown) {
                evt = new KeyEvent(evt.getComponent(), evt.getID(), evt.getWhen(), 0, evt.getKeyCode(), evt.getKeyChar());
            }
            if (!(evt.getKeyCode() != 40 && evt.getKeyCode() != 38 || popupVisible)) {
                DateComboBoxEditor.this.commit();
                DateComboBoxEditor.this.dateComboBox.processKeyEvent(evt);
                JXMonthView monthView = DateComboBoxEditor.this.getMonthView();
                if (!monthView.isSelectionEmpty()) {
                    DateComboBoxEditor.this.setItem(monthView.getSelection().first());
                    monthView.ensureDateVisible((Date)monthView.getSelection().first());
                }
                return;
            }
            if ((evt.getKeyCode() == 27 || evt.getKeyCode() == 10) && popupVisible) {
                DateComboBoxEditor.this.dateComboBox.hidePopup();
            }
            if (!popupVisible || evt.getID() != 401) {
                if (evt.getKeyCode() == 10 && evt.getID() == 401) {
                    if (DateComboBoxEditor.this.commit()) {
                        DateComboBoxEditor.this.actionPerformed();
                    }
                    if (!DateComboBoxEditor.this.getMonthView().isSelectionEmpty()) {
                        DateComboBoxEditor.this.setItem(DateComboBoxEditor.this.getMonthView().getSelection().first());
                    }
                }
                super.processKeyEvent(evt);
            }
        }
    }
}

