/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.combobox.controls;

import de.javasoft.combobox.controls.ColorPopupPanel;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

public class ColorComboBoxRenderer
implements ListCellRenderer<Object> {
    private ListCellRenderer<Object> defaultRenderer;
    private boolean hexadecimal;
    private boolean includeAlphaValue;

    public ColorComboBoxRenderer(ListCellRenderer<Object> defaultRenderer) {
        this(defaultRenderer, false, false);
    }

    public ColorComboBoxRenderer(ListCellRenderer<Object> defaultRenderer, boolean hexadecimal, boolean includeAlphaValue) {
        this.defaultRenderer = defaultRenderer;
        this.hexadecimal = hexadecimal;
        this.includeAlphaValue = includeAlphaValue;
    }

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel l = (JLabel)this.defaultRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        Color color = (Color)value;
        l.setIcon(new ColorPopupPanel.ColorIcon(color, (int)SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(16)), (int)SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(12))));
        if (color == null) {
            l.setText(UIManager.getString("JYComboBox.colorPopup.noColor"));
        } else {
            l.setText(ColorPopupPanel.colorAsText(color, this.hexadecimal, this.includeAlphaValue));
        }
        return l;
    }

    public boolean isAlphaValueIncluded() {
        return this.includeAlphaValue;
    }
}

