/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.combobox;

import de.javasoft.combobox.JYComboBox;
import de.javasoft.combobox.controls.MonthViewPopupPanel;
import de.javasoft.combobox.ui.BasicJYDateComboBoxUI;
import de.javasoft.combobox.ui.SyntheticaJYDateComboBoxUI;
import de.javasoft.combobox.ui.addons.JYDateComboBoxAddon;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.syntheticaaddons.SyntheticaAddons;
import de.javasoft.syntheticaaddons.SyntheticaAddonsUtilities;
import de.javasoft.widgets.IUIPropertySupport;
import de.javasoft.widgets.ui.UIValue;
import de.javasoft.widgets.util.WidgetUtils;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.UIManager;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.text.DefaultFormatterFactory;
import org.jdesktop.swingx.JXMonthView;
import org.jdesktop.swingx.calendar.DatePickerFormatter;
import org.jdesktop.swingx.plaf.ComponentAddon;

public class JYDateComboBox
extends JYComboBox
implements IUIPropertySupport {
    private DateFormat[] dateFormats;
    private UIValue<Boolean> todayButtonVisible;
    private UIValue<Boolean> clearButtonVisible;

    static {
        SyntheticaAddons.contribute((ComponentAddon)new JYDateComboBoxAddon());
    }

    public JYDateComboBox() {
        this(new Date().getTime());
    }

    public JYDateComboBox(Date date) {
        this(date.getTime());
    }

    public JYDateComboBox(Long date) {
        this.setName("JYDateComboBox");
        this.setDateFormat(DateFormat.getDateInstance(2));
        this.setDate(date);
    }

    @Override
    public void updateUI() {
        if (UIManager.getLookAndFeel() instanceof SyntheticaLookAndFeel) {
            if (this.getPopupComponent() == null) {
                this.setPopupComponent(new MonthViewPopupPanel(this));
            }
            this.setUI((ComboBoxUI)((Object)new SyntheticaJYDateComboBoxUI()));
        } else {
            this.setUI(new BasicJYDateComboBoxUI());
        }
        if (this.getPopupComponent() != null) {
            SyntheticaAddonsUtilities.updateChildrenUI((JComponent)this.getPopupComponent());
        }
    }

    private JXMonthView getMonthView() {
        return this.getPopupComponent().getMonthView();
    }

    public void setDate(Date date) {
        if (date == null) {
            this.setDate((Long)null);
        } else {
            this.setDate(date.getTime());
        }
    }

    public void setDate(Long date) {
        if (this.getItemCount() > 0) {
            ActionListener l;
            ActionListener[] listeners;
            ActionListener[] actionListenerArray = listeners = this.getActionListeners();
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                l = actionListenerArray[n2];
                this.removeActionListener(l);
                ++n2;
            }
            this.removeItemAt(0);
            actionListenerArray = listeners;
            n = listeners.length;
            n2 = 0;
            while (n2 < n) {
                l = actionListenerArray[n2];
                this.addActionListener(l);
                ++n2;
            }
        }
        if (date == null) {
            this.getMonthView().clearSelection();
            this.getDateField().setValue(null);
            this.getDateField().setText("");
            this.addItem(null);
            this.fireActionEvent();
        } else {
            this.getDateField().setValue(new Date(date));
            this.getMonthView().setSelectionInterval(new Date(date), new Date(date));
            this.getMonthView().ensureDateVisible(new Date(date));
            this.addItem(new Date(date));
        }
        this.repaint();
    }

    public Date getDate() {
        if (this.getMonthView().isSelectionEmpty()) {
            return null;
        }
        return (Date)this.getMonthView().getSelection().first();
    }

    public Date getDateTime() {
        if (!this.isEditable) {
            return this.getDate();
        }
        Object val = this.getDateField().getValue();
        if (val instanceof Date) {
            return (Date)val;
        }
        if (val instanceof Long) {
            return new Date((Long)val);
        }
        return null;
    }

    public String getFormattedDate() {
        return this.dateFormats[0].format(this.getDate());
    }

    public void setDateFormat(DateFormat df) {
        this.setDateFormats(new DateFormat[]{df});
    }

    public void setDateFormats(DateFormat[] dateFormats) {
        this.dateFormats = dateFormats;
        this.getDateField().setFormatterFactory(new DefaultFormatterFactory((JFormattedTextField.AbstractFormatter)new DatePickerFormatter(dateFormats)));
    }

    public DateFormat[] getDateFormats() {
        return this.dateFormats;
    }

    private JFormattedTextField getDateField() {
        return (JFormattedTextField)this.getEditor().getEditorComponent();
    }

    @Override
    public MonthViewPopupPanel getPopupComponent() {
        return (MonthViewPopupPanel)super.getPopupComponent();
    }

    public boolean isEmpty() {
        return this.getMonthView().isSelectionEmpty();
    }

    @Override
    public Object getSelectedItem() {
        return this.getDateTime();
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void setTodayButtonVisible(Boolean visible) {
        this.setTodayButtonVisible(visible, false);
    }

    public void setTodayButtonVisible(Boolean visible, boolean isUIResource) {
        WidgetUtils.setUIProperty(this, "todayButtonVisible", this.todayButtonVisible, this.getTodayButtonVisible(), visible, isUIResource, false, false);
    }

    public boolean todayButtonVisibleIsUIResource() {
        return this.getTodayButtonVisibleUIValue().isUIResource();
    }

    public Boolean getTodayButtonVisible() {
        return this.getTodayButtonVisibleUIValue().get();
    }

    private UIValue<Boolean> getTodayButtonVisibleUIValue() {
        if (this.todayButtonVisible == null) {
            this.todayButtonVisible = new UIValue();
        }
        return this.todayButtonVisible;
    }

    public void setClearButtonVisible(Boolean visible) {
        this.setClearButtonVisible(visible, false);
    }

    public void setClearButtonVisible(Boolean visible, boolean isUIResource) {
        WidgetUtils.setUIProperty(this, "clearButtonVisible", this.clearButtonVisible, this.getClearButtonVisible(), visible, isUIResource, false, false);
    }

    public boolean clearButtonVisibleIsUIResource() {
        return this.getClearButtonVisibleUIValue().isUIResource();
    }

    public Boolean getClearButtonVisible() {
        return this.getClearButtonVisibleUIValue().get();
    }

    private UIValue<Boolean> getClearButtonVisibleUIValue() {
        if (this.clearButtonVisible == null) {
            this.clearButtonVisible = new UIValue();
        }
        return this.clearButtonVisible;
    }
}

