/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.combobox;

import de.javasoft.combobox.ui.BasicJYComboBoxUI;
import de.javasoft.combobox.ui.SyntheticaJYComboBoxUI;
import de.javasoft.combobox.ui.addons.JYComboBoxAddon;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.syntheticaaddons.SyntheticaAddons;
import de.javasoft.syntheticaaddons.SyntheticaAddonsUtilities;
import java.awt.event.ActionEvent;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComboBoxUI;
import org.jdesktop.swingx.plaf.ComponentAddon;

public class JYComboBox
extends JComboBox<Object> {
    private static final long serialVersionUID = 3382303522321212791L;
    private JComponent popupComponent;
    private boolean popupResizable;
    private boolean popupSizeRestorable;
    private int popupWidth;
    private int popupHeight;

    static {
        SyntheticaAddons.contribute((ComponentAddon)new JYComboBoxAddon());
    }

    public JYComboBox() {
        this.init();
    }

    public JYComboBox(Object[] items) {
        super(items);
        this.init();
    }

    private void init() {
        this.putClientProperty("Synthetica.popupType", 2);
        this.getEditor().getEditorComponent().setName("ComboBox.textField");
    }

    @Override
    public void updateUI() {
        if (UIManager.getLookAndFeel() instanceof SyntheticaLookAndFeel) {
            this.setUI((ComboBoxUI)((Object)new SyntheticaJYComboBoxUI()));
        } else {
            this.setUI(new BasicJYComboBoxUI());
        }
        if (this.popupComponent != null) {
            SyntheticaAddonsUtilities.updateChildrenUI((JComponent)this.popupComponent);
        }
    }

    public void setPopupWidth(int width) {
        int oldValue = this.getPopupWidth();
        this.popupWidth = width;
        this.firePropertyChange("popupWidth", oldValue, width);
    }

    public int getPopupWidth() {
        return this.popupWidth;
    }

    public void setPopupHeight(int height) {
        int oldValue = this.getPopupHeight();
        this.popupHeight = height;
        this.firePropertyChange("popupHeight", oldValue, height);
    }

    public int getPopupHeight() {
        return this.popupHeight;
    }

    public void setPopupResizable(boolean resizable) {
        boolean oldValue = this.isPopupResizable();
        this.popupResizable = resizable;
        this.firePropertyChange("popupResizable", oldValue, resizable);
    }

    public boolean isPopupResizable() {
        return this.popupResizable;
    }

    public void setPopupSizeRestorable(boolean restorable) {
        boolean oldValue = this.isPopupSizeRestorable();
        this.popupSizeRestorable = restorable;
        this.firePropertyChange("popupSizeRestorable", oldValue, restorable);
    }

    public boolean isPopupSizeRestorable() {
        return this.popupSizeRestorable;
    }

    public void setPopupComponent(JComponent c) {
        JComponent oldValue = this.getPopupComponent();
        this.popupComponent = c;
        this.firePropertyChange("popupComponent", oldValue, this.popupComponent);
    }

    public JComponent getPopupComponent() {
        return this.popupComponent;
    }

    public void setItem(Object item) {
        this.addItem(item);
        this.setSelectedItem(item);
        if (this.getItemCount() > 1) {
            this.removeItemAt(0);
        }
    }

    public Object getItem() {
        return this.getSelectedItem();
    }

    public void closePopup() {
        this.setPopupVisible(false);
    }

    @Override
    public void setPopupVisible(boolean visible) {
        if (visible) {
            super.setPopupVisible(true);
        } else {
            ComboBoxUI ui = this.getUI();
            if (ui instanceof SyntheticaJYComboBoxUI) {
                ((SyntheticaJYComboBoxUI)((Object)ui)).getPopup().setVisible(false);
            } else {
                ((BasicJYComboBoxUI)ui).getPopup().setVisible(false);
            }
        }
    }

    public void cancelPopup() {
        this.getActionMap().get("hidePopup").actionPerformed(new ActionEvent(this, 1001, null));
    }
}

