/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.button.ui;

import de.javasoft.button.JYButton;
import de.javasoft.button.ui.JYButtonUI;
import de.javasoft.button.ui.painter.JYButtonPainter;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.widgets.IRotatableComponent;
import de.javasoft.widgets.util.WidgetUtils;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.text.View;

public class BasicJYButtonUI
extends JYButtonUI
implements PropertyChangeListener {
    protected int textShiftOffset;

    public static ComponentUI createUI(JComponent c) {
        return new BasicJYButtonUI();
    }

    @Override
    protected void installListeners(AbstractButton b) {
        super.installListeners(b);
        b.addPropertyChangeListener(this);
    }

    @Override
    protected void uninstallListeners(AbstractButton b) {
        super.uninstallListeners(b);
        b.removePropertyChangeListener(this);
    }

    @Override
    protected void installDefaults(AbstractButton c) {
        Border border;
        super.installDefaults(c);
        c.setOpaque(false);
        Insets defaultMargin = new Insets(0, 0, 0, 0);
        Insets defaultInsets = new Insets(0, 0, 0, 0);
        Insets margin = c.getMargin();
        if (margin == null || margin instanceof UIResource) {
            c.setMargin(new InsetsUIResource(defaultMargin.top, defaultMargin.left, defaultMargin.bottom, defaultMargin.right));
        }
        if ((border = c.getBorder()) == null || border instanceof UIResource) {
            c.setBorder(WidgetUtils.createRotatableEmptyBorder(defaultInsets, true));
        }
        LookAndFeel.installProperty(c, "rolloverEnabled", Boolean.TRUE);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        JComponent c = (JComponent)evt.getSource();
        String name = evt.getPropertyName();
        if (WidgetUtils.shouldUpdateStyle(evt)) {
            this.installDefaults((AbstractButton)c);
        }
        if ("rotation".equals(name)) {
            c.revalidate();
            c.repaint();
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Icon icon;
        JYButton button = (JYButton)c;
        int angle = button.getRotation().toAngle();
        int w = c.getWidth();
        int h = c.getHeight();
        ButtonModel model = button.getModel();
        SyntheticaState state = new SyntheticaState();
        if (!model.isEnabled()) {
            state.setState(SyntheticaState.State.DISABLED);
        }
        if (model.isSelected()) {
            state.setState(SyntheticaState.State.SELECTED);
        }
        if (model.isPressed()) {
            state.setState(SyntheticaState.State.PRESSED);
        }
        if (model.isRollover()) {
            state.setState(SyntheticaState.State.HOVER);
        }
        if (button.hasFocus()) {
            state.setState(SyntheticaState.State.FOCUSED);
        }
        String segPos = (String)button.getClientProperty("JButton.segmentPosition");
        if (button.isContentAreaFilled()) {
            JYButtonPainter.getInstance().paintButtonBackground(c, state, segPos, angle, g, 0, 0, angle == 0 ? w : h, angle == 0 ? h : w);
        }
        Font f = button.getFont();
        FontMetrics fm = button.getFontMetrics(f);
        String text = button.getText();
        Icon icon2 = icon = button.isEnabled() ? button.getIcon() : button.getDisabledIcon();
        if (icon == null && text == null) {
            return;
        }
        IRotatableComponent.Rotation rotation = button.getRotation();
        Insets insets = button.getInsets();
        Rectangle viewRect = new Rectangle(insets.left, insets.top, w - insets.left - insets.right, h - insets.top - insets.bottom);
        Rectangle textRect = new Rectangle();
        Rectangle iconRect = new Rectangle();
        text = this.layoutButton(button, fm, text, icon, viewRect, iconRect, textRect);
        if (model.isPressed()) {
            textRect.x += this.textShiftOffset;
            textRect.y += this.textShiftOffset;
            iconRect.x += this.textShiftOffset;
            iconRect.y += this.textShiftOffset;
        }
        if (icon != null) {
            this.paintIcon(button, g, icon, iconRect, rotation);
        }
        this.paintText(button, g, f, fm, text, textRect, rotation);
    }

    private void paintText(AbstractButton button, Graphics g, Font font, FontMetrics fm, String text, Rectangle textRect, IRotatableComponent.Rotation rotation) {
        if (rotation == IRotatableComponent.Rotation.LEFT || rotation == IRotatableComponent.Rotation.RIGHT) {
            Graphics2D g2 = (Graphics2D)g;
            double origin = rotation == IRotatableComponent.Rotation.RIGHT ? (textRect.width - textRect.height) / 2 : -(textRect.width - textRect.height) / 2;
            g2.translate(origin, origin);
            g2.rotate(Math.toRadians(rotation.toAngle()), textRect.x + textRect.width / 2, textRect.y + textRect.height / 2);
            this.paintButtonText(button, text, g, fm, textRect);
            g2.rotate(-Math.toRadians(rotation.toAngle()), textRect.x + textRect.width / 2, textRect.y + textRect.height / 2);
            g2.translate(-origin, -origin);
        } else {
            this.paintButtonText(button, text, g, fm, textRect);
        }
    }

    protected void paintButtonText(AbstractButton button, String text, Graphics g, FontMetrics fm, Rectangle textRect) {
        View v = (View)button.getClientProperty("html");
        if (v != null) {
            v.paint(g, textRect);
        } else {
            this.paintText(g, button, textRect, text);
        }
    }

    private void paintIcon(JComponent c, Graphics g, Icon icon, Rectangle iconRect, IRotatableComponent.Rotation rotation) {
        if (rotation == IRotatableComponent.Rotation.LEFT || rotation == IRotatableComponent.Rotation.RIGHT) {
            Graphics2D g2 = (Graphics2D)g;
            double origin = rotation == IRotatableComponent.Rotation.LEFT ? -(iconRect.width - iconRect.height) / 2 : (iconRect.width - iconRect.height) / 2;
            g2.translate(origin, origin);
            g2.rotate(Math.toRadians(rotation.toAngle()), iconRect.x + iconRect.width / 2, iconRect.y + iconRect.height / 2);
            icon.paintIcon(c, g, iconRect.x, iconRect.y);
            g2.rotate(-Math.toRadians(rotation.toAngle()), iconRect.x + iconRect.width / 2, iconRect.y + iconRect.height / 2);
            g2.translate(-origin, -origin);
        } else {
            icon.paintIcon(c, g, iconRect.x, iconRect.y);
        }
    }

    private String layoutButton(AbstractButton button, FontMetrics fm, String text, Icon icon, Rectangle viewRect, Rectangle iconRect, Rectangle textRect) {
        IRotatableComponent.Rotation rotation = ((JYButton)button).getRotation();
        WidgetUtils.rotateRectangle(viewRect, rotation);
        text = this.layoutButton_(button, fm, text, icon, viewRect, iconRect, textRect);
        WidgetUtils.rotateRectangle(viewRect, rotation);
        this.rotatePosition(viewRect, textRect, rotation);
        WidgetUtils.rotateRectangle(textRect, rotation);
        this.rotatePosition(viewRect, iconRect, rotation);
        WidgetUtils.rotateRectangle(iconRect, rotation);
        return text;
    }

    private String layoutButton_(AbstractButton button, FontMetrics fm, String text, Icon icon, Rectangle viewRect, Rectangle iconRect, Rectangle textRect) {
        int vAlign = button.getVerticalAlignment();
        int hAlign = button.getHorizontalAlignment();
        int vPos = button.getVerticalTextPosition();
        int hPos = button.getHorizontalTextPosition();
        text = SwingUtilities.layoutCompoundLabel(button, fm, text, icon, vAlign, hAlign, vPos, hPos, viewRect, iconRect, textRect, button.getIconTextGap());
        return text;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        if (c.getComponentCount() > 0) {
            return null;
        }
        AbstractButton b = (AbstractButton)c;
        Icon icon = b.getIcon();
        String text = b.getText();
        Font font = b.getFont();
        FontMetrics fm = b.getFontMetrics(font);
        Rectangle viewR = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        Rectangle textR = new Rectangle();
        Rectangle iconR = new Rectangle();
        SwingUtilities.layoutCompoundLabel(b, fm, text, icon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewR, iconR, textR, text == null ? 0 : b.getIconTextGap());
        IRotatableComponent.Rotation rotation = null;
        if (b instanceof IRotatableComponent) {
            rotation = ((IRotatableComponent)((Object)c)).getRotation();
        }
        Rectangle r = WidgetUtils.rotateRectangle(iconR.union(textR), rotation);
        Insets insets = b.getInsets();
        r.width += insets.left + insets.right;
        r.height += insets.top + insets.bottom;
        return r.getSize();
    }

    private void rotatePosition(Rectangle outerRect, Rectangle r, IRotatableComponent.Rotation rotation) {
        int x = r.x - outerRect.x;
        int y = r.y - outerRect.y;
        if (rotation == IRotatableComponent.Rotation.LEFT) {
            r.x = outerRect.x + y;
            r.y = outerRect.y - x + outerRect.height - r.width;
        } else if (rotation == IRotatableComponent.Rotation.RIGHT) {
            r.x = outerRect.x - y + outerRect.width - r.height;
            r.y = outerRect.y + x;
        }
    }
}

