/*
 * Decompiled with CFR 0.152.
 */
package eqtrade.skin.ui.res;

import eqtrade.skin.ui.res.RangRes;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.util.Hashtable;
import java.util.Vector;

public class UIDataRes {
    public static String DATA_ICON_CLOSE_SIZE = "icon.close";
    public static String DATA_ICON_MAX_SIZE = "icon.max";
    public static String DATA_ICON_MIN_SIZE = "icon.min";
    public static String DATA_ICON_RESTORE_SIZE = "icon.restore";
    public static String DATA_RES_MULTIPLIER_SIZE = "sun.multiplier";
    public Integer width;
    public Integer height;
    private Hashtable<String, Vector<RangRes>> dataResolution = new Hashtable();
    private static UIDataRes instance = null;

    public static UIDataRes getInstance() {
        if (instance == null) {
            instance = new UIDataRes();
        }
        return instance;
    }

    public UIDataRes() {
        this.load();
    }

    public void load() {
        this.initScreenSize();
        this.initFontDefault();
        this.initPanelSize();
    }

    private void initFontDefault() {
        Vector<RangRes> vres = new Vector<RangRes>();
        vres.add(new RangRes(600, 1000, 9));
        vres.add(new RangRes(1000, 2000, 12));
        vres.add(new RangRes(2000, 3000, 13));
        vres.add(new RangRes(3000, 4000, 17));
        this.dataResolution.put("font.size", vres);
        this.updateDataRes(DATA_RES_MULTIPLIER_SIZE, new RangRes(0, 2000, "1"));
        this.updateDataRes(DATA_RES_MULTIPLIER_SIZE, new RangRes(2000, 3000, "1.3"));
        this.updateDataRes(DATA_RES_MULTIPLIER_SIZE, new RangRes(3000, 4000, "1.6"));
        this.updateDataRes(DATA_RES_MULTIPLIER_SIZE, new RangRes(4000, 8000, "3"));
    }

    private void initPanelSize() {
        this.initPanelTop();
    }

    private void initPanelTop() {
        Vector<RangRes> vres = new Vector<RangRes>();
        vres.add(new RangRes(600, 1024, 20));
        vres.add(new RangRes(1024, 2000, 23));
        vres.add(new RangRes(2000, 4000, 30));
        this.dataResolution.put("panel.top.height", vres);
    }

    public Integer getDefaultFontSize(Integer def) {
        return this.getDefaultRangeResByWidthRes("font.size", def);
    }

    public Integer getDefaultPanelTitleHeight(Integer def) {
        return this.getDefaultRangeResByWidthRes("panel.top.height", def);
    }

    public void updateDataRes(String name, RangRes res) {
        int idx;
        Vector<RangRes> vdata = this.dataResolution.get(name);
        if (vdata == null) {
            vdata = new Vector();
        }
        if ((idx = vdata.indexOf(res)) < 0) {
            vdata.add(res);
        } else {
            vdata.set(idx, res);
        }
        this.dataResolution.put(name, vdata);
    }

    private Integer getDefaultRangeResByWidthRes(String string, Integer def) {
        RangRes rr = this.getDefaultRangeResByWidthRes(string);
        return rr == null ? def : (Integer)rr.getDefaultValue();
    }

    public Dimension getDefaultRangeResByIcon(String iconname, Dimension def) {
        RangRes rr = this.getDefaultRangeResByWidthRes(iconname);
        return rr == null ? def : (Dimension)rr.getDefaultValue();
    }

    public void initScreenSize() {
        GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        int i = 0;
        while (i < devices.length) {
            GraphicsDevice dev = devices[i];
            DisplayMode[] modes = dev.getDisplayModes();
            int j = 0;
            while (j < modes.length) {
                DisplayMode displayMode = modes[j];
                ++j;
            }
            ++i;
        }
        Dimension resolution = Toolkit.getDefaultToolkit().getScreenSize();
        this.width = resolution.width;
        this.height = resolution.height;
        System.out.println("default=" + this.width + ":" + this.height);
    }

    public RangRes getDefaultRangeResByWidthRes(String name) {
        Vector<RangRes> vres = this.dataResolution.get(name);
        if (vres != null) {
            for (RangRes rr : vres) {
                if (rr.getResStart() > this.width || rr.getResEnd() < this.width) continue;
                return rr;
            }
        }
        return null;
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public static void main(String[] args) {
        UIDataRes dres = new UIDataRes();
        System.out.println(dres.getDefaultRangeResByWidthRes("font").getResStart());
    }
}

