/*
 * Decompiled with CFR 0.152.
 */
package eqtrade.skin.ext;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.painter.SyntheticaBasicIconPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.synth.SynthContext;

public class SimpleDropDownButton
extends JButton
implements PropertyChangeListener,
PopupMenuListener,
ChangeListener {
    private static final long serialVersionUID = 9122091784625141251L;
    public static final String uiClassID = "SimpleDropDownButtonUI";
    private static Object HIDE_POPUP_KEY = new JComboBox().getClientProperty("doNotCancelPopup");
    protected JPopupMenu popup;
    private int arrowIconSpace;
    private boolean useLargeArrowIcon = false;
    private Icon arrowIcon = null;
    private Border originalBorder;
    private int hPos = 4;
    private int vPos = 0;
    private boolean openPopupByArrow = false;
    private boolean arrowVisible = true;
    private int horizontalPopupMenuPosition = 2;
    private int verticalPopupMenuPosition = 3;
    private boolean initDone;
    private boolean rolloverEnabled;

    public SimpleDropDownButton() {
        this.init();
    }

    public SimpleDropDownButton(Action paramAction) {
        super(paramAction);
        this.init();
    }

    public SimpleDropDownButton(String paramString) {
        super(paramString);
        this.init();
    }

    public SimpleDropDownButton(Icon paramIcon) {
        super(paramIcon);
        this.init();
    }

    public SimpleDropDownButton(String paramString, Icon paramIcon) {
        super(paramString, paramIcon);
        this.init();
    }

    private void init() {
        this.updateArrowIcon();
        this.setArrowIconSpace(SyntheticaLookAndFeel.getInt((String)"SimpleDropDownButton.arrowIconGap", (Component)this, (int)4));
        this.putClientProperty("doNotCancelPopup", HIDE_POPUP_KEY);
        this.addPropertyChangeListener(this);
        this.getModel().addChangeListener(this);
        this.getInputMap().put(KeyStroke.getKeyStroke(40, 512), "openPopup");
        this.getActionMap().put("openPopup", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent paramAnonymousActionEvent) {
                if (SimpleDropDownButton.this.getPopupMenu().isVisible()) {
                    SimpleDropDownButton.this.popup.setVisible(false);
                } else if (!SimpleDropDownButton.this.getOpenPopupByArrow() || SimpleDropDownButton.this.getOpenPopupByArrow() && SimpleDropDownButton.this.isMouseInArrowArea()) {
                    int k;
                    JComponent localJComponent = (JComponent)paramAnonymousActionEvent.getSource();
                    MenuSelectionManager.defaultManager().clearSelectedPath();
                    localJComponent.requestFocusInWindow();
                    if (SyntheticaLookAndFeel.isToplevelPopupMenu((JPopupMenu)SimpleDropDownButton.this.popup)) {
                        SimpleDropDownButton.this.popup.updateUI();
                    }
                    SimpleDropDownButton.this.popup.addPopupMenuListener(SimpleDropDownButton.this);
                    boolean i = SimpleDropDownButton.this.horizontalPopupMenuPosition == 2;
                    boolean j = !localJComponent.getComponentOrientation().isLeftToRight();
                    int n = k = j ? 0 : SimpleDropDownButton.this.getWidth() - SimpleDropDownButton.this.popup.getPreferredSize().width;
                    if (SimpleDropDownButton.this.horizontalPopupMenuPosition == 0) {
                        k = SimpleDropDownButton.this.getWidth() / 2 - SimpleDropDownButton.this.popup.getPreferredSize().width / 2;
                    }
                    int m = SwingUtilities.convertPoint((Component)localJComponent, (int)0, (int)localJComponent.getHeight(), (Component)SimpleDropDownButton.this).y;
                    if (SimpleDropDownButton.this.verticalPopupMenuPosition == 1) {
                        m -= localJComponent.getHeight() + SimpleDropDownButton.this.popup.getPreferredSize().height;
                    }
                    int n2 = SyntheticaLookAndFeel.getInt((String)"DropDownButton.popup.xOffset", (Component)SimpleDropDownButton.this, (int)0);
                    int i1 = SyntheticaLookAndFeel.getInt((String)"DropDownButton.popup.yOffset", (Component)SimpleDropDownButton.this, (int)0);
                    SimpleDropDownButton.this.popup.show(SimpleDropDownButton.this, k + (j ? n2 : -n2), m + i1);
                }
            }
        });
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent paramAnonymousActionEvent) {
                SimpleDropDownButton.this.getActionMap().get("openPopup").actionPerformed(paramAnonymousActionEvent);
            }
        });
        this.initDone = true;
    }

    public void setPreferredHorizontalPopupMenuPosition(int paramInt) {
        this.horizontalPopupMenuPosition = paramInt;
    }

    public int getPreferredHorizontalPopupMenuPosition() {
        return this.horizontalPopupMenuPosition;
    }

    public void setPreferredVerticalPopupMenuPosition(int paramInt) {
        this.verticalPopupMenuPosition = paramInt;
    }

    public int getPreferredVerticalPopupMenuPosition() {
        return this.verticalPopupMenuPosition;
    }

    public boolean isMouseInArrowArea() {
        Point localPoint = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(localPoint, this);
        return this.isMouseInArrowArea(localPoint);
    }

    private boolean isMouseInArrowArea(Point paramPoint) {
        Rectangle localRectangle = SwingUtilities.calculateInnerArea(this, null);
        if (localRectangle.contains(paramPoint)) {
            return false;
        }
        Border localBorder = this.getArrowBorder();
        if (localBorder != null) {
            Insets localInsets = localBorder.getBorderInsets(this);
            localRectangle.x -= localInsets.left;
            localRectangle.y -= localInsets.top;
            localRectangle.width += localInsets.left + localInsets.right;
            localRectangle.height += localInsets.top + localInsets.bottom;
            return localRectangle.contains(paramPoint);
        }
        return false;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.initDone) {
            SimpleDropDownButton.updateChildrenUI(this.getPopupMenu());
        }
        this.updateArrowIcon();
        this.originalBorder = this.getBorder();
        if (this.isArrowVisible()) {
            this.installBorder(this.isToolBarButton());
        }
    }

    public static void updateChildrenUI(JComponent paramJComponent) {
        paramJComponent.updateUI();
        Component[] arrayOfComponent = paramJComponent.getComponents();
        int j = arrayOfComponent.length;
        int i = 0;
        while (i < j) {
            Component localComponent = arrayOfComponent[i];
            if (localComponent instanceof JComponent) {
                SimpleDropDownButton.updateChildrenUI((JComponent)localComponent);
            }
            ++i;
        }
    }

    private boolean isToolBarButton() {
        return this.getParent() != null && this.getParent() instanceof JToolBar;
    }

    private void installBorder(boolean paramBoolean) {
        Border localObject = this.originalBorder;
        localObject = UIManager.getLookAndFeel() instanceof MetalLookAndFeel && paramBoolean && localObject instanceof CompoundBorder ? new CompoundArrowBorder(new CompoundBorder(((CompoundBorder)localObject).getOutsideBorder(), new EmptyBorder(3, 3, 3, 3)), new ArrowBorder()) : ("Windows".equals(UIManager.getLookAndFeel().getID()) && paramBoolean ? new CompoundArrowBorder(new EmptyBorder(3, 3, 3, 3), new ArrowBorder()) : new CompoundArrowBorder(localObject, new ArrowBorder()));
        Insets localInsets = SyntheticaLookAndFeel.getInsets((String)"SimpleDropDownButton.margin", (Component)this, (boolean)true);
        if (localInsets != null) {
            this.setMargin(new InsetsUIResource(localInsets.top, localInsets.left, localInsets.bottom, localInsets.right));
        }
        this.setBorder(localObject);
    }

    private Border getArrowBorder() {
        Border localBorder = this.getBorder();
        if (localBorder instanceof CompoundArrowBorder) {
            return ((CompoundArrowBorder)localBorder).getInsideBorder();
        }
        return null;
    }

    private void updateArrowIcon() {
        Icon localObject = this.getArrowIcon();
        if ((localObject == null || localObject instanceof UIResource) && UIManager.getLookAndFeel() instanceof SyntheticaLookAndFeel) {
            boolean bool = this.getParent() instanceof JToolBar;
            String str = "Synthetica.arrow.down";
            if (!bool && this.getModel().isPressed() && SyntheticaLookAndFeel.get((String)"DropDownButton.pressed.arrowIcon", (Component)this) != null) {
                str = "DropDownButton.pressed.arrowIcon";
            } else if (!bool && this.getModel().isRollover() && SyntheticaLookAndFeel.get((String)"DropDownButton.hover.arrowIcon", (Component)this) != null) {
                str = "DropDownButton.hover.arrowIcon";
            } else if (bool && this.getModel().isPressed() && SyntheticaLookAndFeel.get((String)"DropDownButton.pressed.toolBarArrowIcon", (Component)this) != null) {
                str = "DropDownButton.pressed.toolBarArrowIcon";
            } else if (bool && this.getModel().isRollover() && SyntheticaLookAndFeel.get((String)"DropDownButton.hover.toolBarArrowIcon", (Component)this) != null) {
                str = "DropDownButton.hover.toolBarArrowIcon";
            } else if (bool && SyntheticaLookAndFeel.get((String)"DropDownButton.toolBarArrowIcon", (Component)this) != null) {
                str = "DropDownButton.toolBarArrowIcon";
            } else if (SyntheticaLookAndFeel.get((String)"DropDownButton.arrowIcon", (Component)this) != null) {
                str = "DropDownButton.arrowIcon";
            } else if (this.getUseSmallArrowIcon() && UIManager.getString("Synthetica.arrow.8x8.down") != null) {
                str = "Synthetica.arrow.8x8.down";
            }
            localObject = SyntheticaLookAndFeel.loadIcon((String)str);
        } else if (localObject == null || localObject instanceof UIResource) {
            localObject = new SyntheticaBasicIconPainter(null, 9, 4){

                public void paint2D(SynthContext paramAnonymousSynthContext, Graphics2D paramAnonymousGraphics2D, float paramAnonymousFloat1, float paramAnonymousFloat2, float paramAnonymousFloat3, float paramAnonymousFloat4) {
                    if (SimpleDropDownButton.this.isEnabled()) {
                        paramAnonymousGraphics2D.setPaint(Color.BLACK);
                    } else {
                        paramAnonymousGraphics2D.setPaint(Color.GRAY);
                    }
                    paramAnonymousFloat2 = 0.0f;
                    paramAnonymousFloat1 = 0.0f;
                    GeneralPath localGeneralPath = new GeneralPath();
                    localGeneralPath.moveTo(paramAnonymousFloat1, paramAnonymousFloat2);
                    localGeneralPath.lineTo(paramAnonymousFloat1 + paramAnonymousFloat3 / 2.0f, paramAnonymousFloat2 + paramAnonymousFloat4);
                    localGeneralPath.lineTo(paramAnonymousFloat1 + paramAnonymousFloat3, paramAnonymousFloat2);
                    paramAnonymousGraphics2D.fill(localGeneralPath);
                }
            };
        }
        this.arrowIcon = localObject;
    }

    public JPopupMenu getPopupMenu() {
        if (this.popup == null) {
            this.popup = this.createPopupMenu();
        }
        return this.popup;
    }

    public void setPopupMenu(JPopupMenu paramJPopupMenu) {
        this.popup = paramJPopupMenu;
    }

    protected JPopupMenu createPopupMenu() {
        return new JPopupMenu();
    }

    public void setArrowVisible(boolean paramBoolean) {
        this.arrowVisible = paramBoolean;
        if (paramBoolean) {
            this.installBorder(this.isToolBarButton());
        } else {
            this.setBorder(this.originalBorder);
        }
    }

    public boolean isArrowVisible() {
        return this.arrowVisible;
    }

    public void setOpenPopupByArrow(boolean paramBoolean) {
        this.openPopupByArrow = paramBoolean;
    }

    public boolean getOpenPopupByArrow() {
        return this.openPopupByArrow;
    }

    public void setUseSmallArrowIcon(boolean paramBoolean) {
        boolean bool = !this.useLargeArrowIcon;
        this.useLargeArrowIcon = !paramBoolean;
        this.firePropertyChange("useSmallArrowIcon", bool, paramBoolean);
    }

    public boolean getUseSmallArrowIcon() {
        return !this.useLargeArrowIcon;
    }

    public void setArrowIcon(Icon paramIcon) {
        Icon localIcon = this.arrowIcon;
        this.arrowIcon = paramIcon;
        this.firePropertyChange("arrowIcon", localIcon, paramIcon);
    }

    public Icon getArrowIcon() {
        return this.arrowIcon;
    }

    public void setArrowIconSpace(int paramInt) {
        this.arrowIconSpace = paramInt;
    }

    public int getArrowIconSpace() {
        return this.arrowIconSpace;
    }

    public void setHorizontalArrowPosition(int paramInt) {
        int i = this.hPos;
        this.hPos = paramInt;
        this.firePropertyChange("arrowPosition", i, paramInt);
    }

    public int getHorizontalArrowPosition() {
        return this.hPos;
    }

    public void setVerticalArrowPosition(int paramInt) {
        int i = this.vPos;
        this.vPos = paramInt;
        this.firePropertyChange("arrowPosition", i, paramInt);
    }

    public int getVerticalArrowPosition() {
        return this.vPos;
    }

    @Override
    public void propertyChange(PropertyChangeEvent paramPropertyChangeEvent) {
        String str = paramPropertyChangeEvent.getPropertyName();
        if (str.equals("useSmallArrowIcon") || str.equals("arrowIcon")) {
            this.updateArrowIcon();
            return;
        }
        if (str.equals("arrowPosition")) {
            return;
        }
        if (str.equals("ancestor")) {
            this.updateArrowIcon();
            if (this.isArrowVisible()) {
                this.installBorder(((Component)paramPropertyChangeEvent.getSource()).getParent() instanceof JToolBar);
            }
            return;
        }
        if (str.equals("componentOrientation")) {
            this.getPopupMenu().applyComponentOrientation((ComponentOrientation)paramPropertyChangeEvent.getNewValue());
            return;
        }
        if (str.equals("name")) {
            if (this.getBorder() instanceof UIResource) {
                this.setBorder(null);
                this.updateUI();
            }
            return;
        }
    }

    @Override
    public void stateChanged(ChangeEvent paramChangeEvent) {
        this.updateArrowIcon();
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent paramPopupMenuEvent) {
        this.rolloverEnabled = this.isRolloverEnabled();
        this.setRolloverEnabled(false);
        if (this.rolloverEnabled) {
            this.getModel().setRollover(true);
        }
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent paramPopupMenuEvent) {
        this.setRolloverEnabled(true);
        if (this.rolloverEnabled) {
            this.getModel().setRollover(false);
        }
        ((JPopupMenu)paramPopupMenuEvent.getSource()).removePopupMenuListener(this);
        this.setRolloverEnabled(this.rolloverEnabled);
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent paramPopupMenuEvent) {
    }

    private class ArrowBorder
    implements Border {
        private ArrowBorder() {
        }

        @Override
        public void paintBorder(Component paramComponent, Graphics paramGraphics, int paramInt1, int paramInt2, int paramInt3, int paramInt4) {
            this.paintArrow(paramGraphics, paramInt1, paramInt2, paramInt3, paramInt4);
        }

        private void paintArrow(Graphics paramGraphics, int paramInt1, int paramInt2, int paramInt3, int paramInt4) {
            int i = 0;
            int j = 0;
            switch (SimpleDropDownButton.this.getHorizontalArrowPosition()) {
                case 4: {
                    i = paramInt1 + paramInt3 - SimpleDropDownButton.this.getArrowIcon().getIconWidth();
                    break;
                }
                case 0: {
                    i = paramInt1 + (paramInt3 - SimpleDropDownButton.this.getArrowIcon().getIconWidth()) / 2;
                    break;
                }
                default: {
                    i = paramInt1;
                }
            }
            switch (SimpleDropDownButton.this.getVerticalArrowPosition()) {
                case 3: {
                    j = paramInt2 + paramInt4 - SimpleDropDownButton.this.getArrowIcon().getIconHeight();
                    break;
                }
                case 0: {
                    j = paramInt2 + (paramInt4 - SimpleDropDownButton.this.getArrowIcon().getIconHeight()) / 2;
                    break;
                }
                default: {
                    j = paramInt2;
                }
            }
            int k = SyntheticaLookAndFeel.getInt((String)"Button.textShiftOffset", (Component)SimpleDropDownButton.this);
            if (!SimpleDropDownButton.this.getModel().isArmed() || !SimpleDropDownButton.this.getModel().isPressed()) {
                k = 0;
            }
            SimpleDropDownButton.this.getArrowIcon().paintIcon(SimpleDropDownButton.this, paramGraphics, i + k, j + k);
        }

        @Override
        public Insets getBorderInsets(Component paramComponent) {
            if (SimpleDropDownButton.this.hPos == 2) {
                return new Insets(0, SimpleDropDownButton.this.getArrowIcon().getIconWidth() + SimpleDropDownButton.this.getArrowIconSpace(), 0, 0);
            }
            if (SimpleDropDownButton.this.hPos == 4) {
                return new Insets(0, 0, 0, SimpleDropDownButton.this.getArrowIcon().getIconWidth() + SimpleDropDownButton.this.getArrowIconSpace());
            }
            if (SimpleDropDownButton.this.vPos == 1) {
                return new Insets(SimpleDropDownButton.this.getArrowIcon().getIconHeight() + SimpleDropDownButton.this.getArrowIconSpace(), 0, 0, 0);
            }
            if (SimpleDropDownButton.this.vPos == 3) {
                return new Insets(0, 0, SimpleDropDownButton.this.getArrowIcon().getIconHeight() + SimpleDropDownButton.this.getArrowIconSpace(), 0);
            }
            return new Insets(0, 0, 0, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }

    private static class CompoundArrowBorder
    extends CompoundBorder
    implements UIResource {
        private static final long serialVersionUID = -7456112460542420750L;

        public CompoundArrowBorder(Border paramBorder1, Border paramBorder2) {
            super(paramBorder1, paramBorder2);
        }
    }
}

