/*
 * Decompiled with CFR 0.152.
 */
package eqtrade.skin.ext;

import com.jtattoo.plaf.BaseTabbedPaneUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class EQFastTabbedPaneUI
extends BaseTabbedPaneUI {
    protected static ColorUIResource controlColorLight = null;
    protected static ColorUIResource controlColorDark = null;
    protected static Color[] INACTIVE_COLORS = null;
    protected static Color[] HIDEFAULT_COLORS = null;
    protected static Color[] DEFAULT_COLORS = null;
    protected static Color[] ROLLOVER_COLORS = null;
    private Color[] SELECTED_COLORS;

    public static ComponentUI createUI(JComponent c) {
        return new EQFastTabbedPaneUI();
    }

    public void installDefaults() {
        super.installDefaults();
        this.roundedTabs = false;
        this.tabAreaInsets = new Insets(2, 6, 2, 6);
        this.contentBorderInsets = new Insets(0, 0, 0, 0);
        controlColorLight = (ColorUIResource)UIManager.get("TabbedPane.foreground");
        controlColorDark = (ColorUIResource)UIManager.get("TabbedPane.foreground");
        DEFAULT_COLORS = ColorHelper.createColorArr((Color)controlColorLight, (Color)controlColorDark, (int)20);
        HIDEFAULT_COLORS = ColorHelper.createColorArr((Color)ColorHelper.brighter((Color)controlColorLight, (double)40.0), (Color)ColorHelper.brighter((Color)controlColorDark, (double)40.0), (int)20);
        INACTIVE_COLORS = HIDEFAULT_COLORS;
        this.SELECTED_COLORS = DEFAULT_COLORS;
    }

    protected boolean hasInnerBorder() {
        return true;
    }

    protected Color[] getTabColors(int tabIndex, boolean isSelected, boolean isRollover) {
        Color[] colorArr = this.getTabColors();
        if (tabIndex >= 0 && tabIndex < this.tabPane.getTabCount()) {
            Color backColor = this.tabPane.getBackgroundAt(tabIndex);
            if (backColor instanceof UIResource) {
                colorArr = isSelected ? this.getSelectedColors() : (JTattooUtilities.isFrameActive((Component)this.tabPane) ? this.getTabColors() : this.getInActiveColors());
            } else if (backColor != null) {
                colorArr = ColorHelper.createColorArr((Color)backColor, (Color)backColor, (int)2);
            }
        }
        return colorArr;
    }

    private Color[] getInActiveColors() {
        return HIDEFAULT_COLORS;
    }

    private Color[] getSelectedColors() {
        return this.SELECTED_COLORS;
    }

    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        if (this.isTabOpaque() || isSelected) {
            Color[] colorArr = this.getTabColors(tabIndex, isSelected, false);
            g.setColor(colorArr[0]);
            switch (tabPlacement) {
                case 1: {
                    if (isSelected) {
                        g.fillRect(x + 1, y + 1, w - 1, h + 2);
                        break;
                    }
                    g.fillRect(x + 1, y + 1, w - 1, h - 1);
                    break;
                }
                case 2: {
                    if (isSelected) {
                        g.fillRect(x + 1, y + 1, w + 2, h - 1);
                        break;
                    }
                    g.fillRect(x + 1, y + 1, w - 1, h - 1);
                    break;
                }
                case 3: {
                    if (isSelected) {
                        g.fillRect(x + 1, y - 2, w - 1, h + 1);
                        break;
                    }
                    g.fillRect(x + 1, y, w - 1, h - 1);
                    break;
                }
                case 4: {
                    if (isSelected) {
                        g.fillRect(x - 2, y + 1, w + 2, h - 1);
                        break;
                    }
                    g.fillRect(x, y + 1, w, h - 1);
                }
            }
        }
    }

    private Color[] getTabColors() {
        return new Color[]{Color.white};
    }
}

