/*
 * Decompiled with CFR 0.152.
 */
package eqtrade.skin.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.RoundRectangle2D;
import javax.swing.border.AbstractBorder;

public class BorderTitlePane
extends AbstractBorder {
    private static final long serialVersionUID = -4456863310496721127L;
    protected Color highlight;
    protected Color shadow;
    protected String title;

    public BorderTitlePane(String title) {
        this(title, null, null);
    }

    public BorderTitlePane(String title, Color highlight, Color shadow) {
        this.title = title;
        this.highlight = highlight;
        this.shadow = shadow;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int w = width;
        int h = height;
        Graphics2D g2 = (Graphics2D)g;
        g.translate(x, y);
        g2.translate(x, y);
        GradientPaint grad = new GradientPaint(x, y, this.getShadowColor(c), x + width, y + height, c.getBackground());
        g2.setPaint(grad);
        g2.fill(new RoundRectangle2D.Double(x, y, width, height, 10.0, 10.0));
        g.setColor(this.getShadowColor(c).darker());
        g.drawString(this.title, 12, 18);
        g.setColor(this.getHighlightColor(c));
        g.drawString(this.title, 10, 16);
        g.setColor(this.getHighlightColor(c));
        g.drawLine(0, 0, w - 0, 0);
        g.drawLine(0, 0, 0, h - 0);
        g.setColor(this.getShadowColor(c));
        g.drawLine(0, h - 1, w, h - 1);
        g.translate(-x, -y);
        g2.translate(-x, -y);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(1, 1, 1, 1);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.bottom = 1;
        insets.right = 1;
        insets.top = 1;
        insets.left = 1;
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    public Color getHighlightColor(Component c) {
        return this.highlight != null ? this.highlight : c.getBackground().brighter();
    }

    public Color getHighlightColor() {
        return this.highlight;
    }

    public Color getShadowColor(Component c) {
        return this.shadow != null ? this.shadow : c.getBackground().darker();
    }

    public Color getShadowColor() {
        return this.shadow;
    }
}

