/*
 * Decompiled with CFR 0.152.
 */
package eqtrade.skin.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class BorderShadow
extends AbstractBorder {
    private static final long serialVersionUID = 2235047555738672149L;

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int w = width;
        int h = height;
        g.translate(x, y);
        g.setColor(this.getShadowColor(c));
        g.drawRect(0, 0, w - 1, h - 1);
        g.setColor(new Color(this.getShadowColor(c).getRed() + 20, this.getShadowColor(c).getGreen() + 20, this.getShadowColor(c).getBlue() + 20));
        g.drawLine(w, 2, w, h);
        g.drawLine(2, h, w, h);
        g.setColor(new Color(this.getShadowColor(c).getRed() + 40, this.getShadowColor(c).getGreen() + 40, this.getShadowColor(c).getBlue() + 40));
        g.drawLine(w + 1, 4, w + 1, h);
        g.drawLine(4, h + 1, w, h + 1);
        g.translate(-x, -y);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(1, 1, 1, 1);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.bottom = 1;
        insets.right = 1;
        insets.top = 1;
        insets.left = 1;
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    public Color getHighlightColor(Component c) {
        return c.getBackground().brighter();
    }

    public Color getShadowColor(Component c) {
        return c.getBackground().darker();
    }
}

