/*
 * Decompiled with CFR 0.152.
 */
package eqtrade.updater;

import eqtrade.updater.ListenerMessage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import java.util.Vector;
import jupar.Downloader;
import jupar.Updater;
import jupar.objects.Modes;
import jupar.objects.Release;
import jupar.parsers.Node;
import jupar.parsers.ReleaseXMLParser;

public class UpdaterMain {
    private Properties updaterServer;
    private ListenerMessage listener;

    public UpdaterMain(ListenerMessage list) {
        this.listener = list;
        this.init();
    }

    public UpdaterMain(ListenerMessage list, Properties updateserver) {
        this.listener = list;
        this.updaterServer = updateserver;
    }

    private void init() {
        try {
            FileInputStream fis = new FileInputStream("updater.ini");
            this.updaterServer = new Properties();
            this.updaterServer.load(fis);
            fis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void process() throws Exception {
        this.listener.message("initialization done", 5);
        String urllatest = (String)this.updaterServer.get("urllatest");
        String[] urlarray = urllatest.replace("\\", "").split("\\|");
        int i = 0;
        while (i < urlarray.length) {
            try {
                urllatest = urlarray[i].replace("\\", "");
                System.out.println("url " + urllatest);
                this.listener.message("checking version....", 5);
                String pkgver = (String)this.updaterServer.get("pkgver");
                String pkgrel = (String)this.updaterServer.get("pkgrel");
                ReleaseXMLParser parser = new ReleaseXMLParser();
                Release currentserver = parser.parse(String.valueOf(urllatest) + "/latest.xml", Modes.URL);
                Release releaseclient = parser.parse("latest.xml", Modes.FILE);
                Vector<Node> vnode = currentserver.getReleaseNotUpdate(releaseclient);
                this.listener.message("find updated " + vnode.size(), 10);
                File filetmp = new File("tmp");
                filetmp.mkdir();
                int divider = vnode.size() == 0 ? 1 : vnode.size();
                int beforepercent = 10;
                int tambahpercent = 80 / divider / 2;
                for (Node node : vnode) {
                    String folder = node.getHchilds().get("folder").getValue();
                    this.listener.message("downloading updater " + folder + " ....", beforepercent);
                    String urlfile = String.valueOf(urllatest) + "/" + folder + "/files.xml";
                    Downloader dl = new Downloader();
                    dl.download(String.valueOf(urllatest) + "/" + folder, urlfile, "tmp/" + folder, Modes.URL);
                    this.listener.message("downloading updater " + folder + " finished", beforepercent += tambahpercent);
                    this.listener.message("setting updater " + folder + " ....", beforepercent);
                    Updater update = new Updater();
                    update.update("update.xml", "tmp/" + folder, Modes.FILE);
                    this.listener.message("setting updater " + folder + " finished", beforepercent += tambahpercent);
                }
                beforepercent = 90;
                this.listener.message("downloading updater finished ", beforepercent);
                this.listener.message("delete temporary...", beforepercent);
                URL url = new URL(String.valueOf(urllatest) + "/latest.xml");
                Downloader.wget(url, "tmp/latest.xml");
                Updater.copy("tmp/latest.xml", "latest.xml");
                this.listener.message("delete temporary...", beforepercent += 5);
                UpdaterMain.delete(filetmp);
                this.listener.message("delete temporary finished", beforepercent += 5);
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
                if (i == urlarray.length - 1) {
                    throw e;
                }
                ++i;
            }
        }
        System.out.println("finish download & update " + urllatest);
    }

    public void process2() throws Exception {
        this.listener.message("initialization done", 5);
        String urllatest = (String)this.updaterServer.get("urllatest");
        urllatest = urllatest.replace("\\", "");
        this.listener.message("checking version....", 5);
        String pkgver = (String)this.updaterServer.get("pkgver");
        String pkgrel = (String)this.updaterServer.get("pkgrel");
        ReleaseXMLParser parser = new ReleaseXMLParser();
        Release currentserver = parser.parse(String.valueOf(urllatest) + "/latest.xml", Modes.URL);
        Release releaseclient = parser.parse("latest.xml", Modes.FILE);
        Vector<Node> vnode = currentserver.getReleaseNotUpdate(releaseclient);
        this.listener.message("find updated " + vnode.size(), 10);
        File filetmp = new File("tmp");
        filetmp.mkdir();
        int divider = vnode.size() == 0 ? 1 : vnode.size();
        int beforepercent = 10;
        int tambahpercent = 80 / divider / 2;
        for (Node node : vnode) {
            String folder = node.getHchilds().get("folder").getValue();
            this.listener.message("downloading updater " + folder + " ....", beforepercent);
            String urlfile = String.valueOf(urllatest) + "/" + folder + "/files.xml";
            Downloader dl = new Downloader();
            dl.download(String.valueOf(urllatest) + "/" + folder, urlfile, "tmp/" + folder, Modes.URL);
            this.listener.message("downloading updater " + folder + " finished", beforepercent += tambahpercent);
            this.listener.message("setting updater " + folder + " ....", beforepercent);
            Updater update = new Updater();
            update.update("update.xml", "tmp/" + folder, Modes.FILE);
            this.listener.message("setting updater " + folder + " finished", beforepercent += tambahpercent);
        }
        beforepercent = 90;
        this.listener.message("downloading updater finished ", beforepercent);
        this.listener.message("delete temporary...", beforepercent);
        URL url = new URL(String.valueOf(urllatest) + "/latest.xml");
        Downloader.wget(url, "tmp/latest.xml");
        Updater.copy("tmp/latest.xml", "latest.xml");
        this.listener.message("delete temporary...", beforepercent += 5);
        UpdaterMain.delete(filetmp);
        this.listener.message("delete temporary finished", beforepercent += 5);
    }

    public static void delete(File file) throws IOException {
        if (file.isDirectory()) {
            if (file.list().length == 0) {
                file.delete();
                System.out.println("Directory is deleted : " + file.getAbsolutePath());
            } else {
                String[] files;
                String[] stringArray = files = file.list();
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    String temp = stringArray[n2];
                    File fileDelete = new File(file, temp);
                    UpdaterMain.delete(fileDelete);
                    ++n2;
                }
                if (file.list().length == 0) {
                    file.delete();
                    System.out.println("Directory is deleted : " + file.getAbsolutePath());
                }
            }
        } else {
            file.delete();
            System.out.println("File is deleted : " + file.getAbsolutePath());
        }
    }

    private void save() throws FileNotFoundException, IOException {
        this.updaterServer.store(new FileOutputStream("updater.ini"), "");
    }

    private void deleteTemp() {
        File tmp = new File("tmp");
        if (tmp.exists()) {
            File[] fileArray = tmp.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                file.delete();
                ++n2;
            }
            tmp.delete();
        }
    }

    public static void main(String[] args) {
        try {
            new UpdaterMain(null).process();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

