/*
 * Decompiled with CFR 0.152.
 */
package eqtrade.updater;

import eqtrade.updater.ListenerMessage;
import eqtrade.updater.UIDataRes;
import eqtrade.updater.UpdaterMain;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.util.Properties;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class UpdaterFrame
extends JFrame
implements ListenerMessage {
    private JLayeredPane jLayeredPane1;
    private JPanel jPanel1;
    private JLabel lblImage;
    private JLabel lblStatus;
    private JProgressBar progressStatus;
    private Properties fileConfig;
    private String exec;
    private String java;
    private String[] paramsExec;
    private int errorCount = -1;
    private String[] memoryMin = new String[]{"-Xms64M"};
    private String[] memoryMax = new String[]{"-Xmx128M"};
    private boolean isXDocks = false;
    PrintWriter pw = new PrintWriter("out.txt");
    private int width;
    private int height;
    private String APP_TYPE;

    public UpdaterFrame() throws Exception {
        FileInputStream fis = new FileInputStream("updater.ini");
        this.fileConfig = new Properties();
        this.fileConfig.load(fis);
        fis.close();
        this.initComponents();
        this.setLocationRelativeTo(null);
    }

    private void initComponents() {
        this.setDefaultCloseOperation(3);
        this.setTitle("Updater");
        this.setForeground(Color.white);
        this.setResizable(false);
        this.setUndecorated(true);
        this.jPanel1 = new JPanel();
        this.jLayeredPane1 = new JLayeredPane();
        this.lblStatus = new JLabel();
        this.progressStatus = new JProgressBar();
        this.lblImage = new JLabel();
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        this.setDefaultCloseOperation(3);
        this.setBackground(new Color(51, 53, 53));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                UpdaterFrame.this.windowopended();
            }
        });
        this.lblStatus.setBackground(Color.white);
        this.lblStatus.setForeground(Color.white);
        this.lblStatus.setText("initialization....");
        this.lblStatus.setBounds(10, 170, 260, 17);
        this.jLayeredPane1.add((Component)this.lblStatus, JLayeredPane.DEFAULT_LAYER);
        this.progressStatus.setBounds(10, 190, 420, 18);
        this.jLayeredPane1.add((Component)this.progressStatus, JLayeredPane.DEFAULT_LAYER);
        this.lblImage.setIcon(new ImageIcon(this.getClass().getResource("/eqtrade/updater/resources/logon.png")));
        this.lblImage.setText("");
        this.lblImage.setBounds(30, -15, 440, 290);
        this.jLayeredPane1.add((Component)this.lblImage, JLayeredPane.DEFAULT_LAYER);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLayeredPane1, -2, 439, -2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLayeredPane1, -2, 282, -2));
        this.pack();
    }

    protected void windowopended() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Object localObject1 = UpdaterFrame.readFile("data/app.dat");
                String str1 = (String)localObject1;
                UpdaterFrame.this.APP_TYPE = str1.toUpperCase();
                try {
                    if (UpdaterFrame.this.APP_TYPE.equals("SL")) {
                        UpdaterFrame.this.APP_TYPE = "Syariah";
                    } else if (UpdaterFrame.this.APP_TYPE.equals("RG")) {
                        UpdaterFrame.this.APP_TYPE = "Reguler";
                    } else if (UpdaterFrame.this.APP_TYPE.equals("DL")) {
                        UpdaterFrame.this.APP_TYPE = "Dealer";
                    }
                    String res = (String)UIDataRes.getInstance().getDefaultRangeResByWidthRes(UIDataRes.DATA_RES_MULTIPLIER_SIZE).getDefaultValue();
                    System.out.println("java.home=" + System.getProperty("java.home") + " scaleup=" + res);
                    String javaFolder = System.getProperty("java.home");
                    File f = new File(javaFolder);
                    f = new File(f, "bin");
                    f = new File(f, "java");
                    System.out.println("absolutefile=" + f.getAbsolutePath() + ":" + f.exists() + ":" + f.canExecute());
                    UpdaterFrame.this.java = UpdaterFrame.this.fileConfig.getProperty("java").replace("\\", "/");
                    res = UpdaterFrame.this.fileConfig.containsKey("resolution") ? "-Dsun.java2d.uiScale=" + UpdaterFrame.this.fileConfig.getProperty("resolution") : "-Dsun.java2d.uiScale=" + res;
                    String execname = UpdaterFrame.this.fileConfig.getProperty("exec").replace("\\", "/");
                    UpdaterFrame.this.exec = String.valueOf(UpdaterFrame.this.java) + " " + res + " " + execname;
                    UpdaterFrame.this.paramsExec = UpdaterFrame.this.exec.split(" ");
                    System.out.println("execname.is=" + execname + ":is.Xdock:name=" + execname.contains("Xdock:name"));
                    if (execname.contains("Xdock:name")) {
                        int i = 0;
                        while (i < UpdaterFrame.this.paramsExec.length) {
                            if (UpdaterFrame.this.paramsExec[i].startsWith("-Xdock:name")) {
                                ((UpdaterFrame)UpdaterFrame.this).paramsExec[i] = UpdaterFrame.this.paramsExec[i].replace("xdockname", "RHB TradeSmart ID " + UpdaterFrame.this.APP_TYPE);
                                System.out.println("paramsExec=" + UpdaterFrame.this.paramsExec[i]);
                                break;
                            }
                            ++i;
                        }
                    }
                    UpdaterMain updater = new UpdaterMain(UpdaterFrame.this, UpdaterFrame.this.fileConfig);
                    updater.process();
                    UpdaterFrame.this.runApplication();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    final String ss = e.getMessage();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.showMessageDialog(null, "Error while updating : " + ss);
                            UpdaterFrame.this.runApplication();
                        }
                    });
                }
            }
        }).start();
    }

    public void runApplication() {
        boolean isrunning;
        String error;
        block25: {
            System.out.println("starting application...");
            this.message("starting application..", 100);
            error = null;
            Process proc = null;
            BufferedReader buffinp = null;
            isrunning = false;
            try {
                try {
                    System.out.println("running with config " + this.paramsExec + " " + this.APP_TYPE);
                    String[] stringArray = this.paramsExec;
                    int n = this.paramsExec.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        System.out.println(s);
                        ++n2;
                    }
                    ProcessBuilder pb = new ProcessBuilder(this.paramsExec);
                    proc = pb.start();
                    buffinp = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                    String sinp = null;
                    while ((sinp = buffinp.readLine()) != null) {
                        System.out.println("sinp " + sinp);
                        this.pw.println("sinp " + sinp);
                        if (sinp.contains("EQTrade")) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    UpdaterFrame.this.dispose();
                                }
                            });
                            error = null;
                            isrunning = true;
                            break;
                        }
                        if (sinp.startsWith("Error occurred") || sinp.startsWith("Invalid")) {
                            error = sinp;
                            continue;
                        }
                        if (error == null) continue;
                        error = String.valueOf(error) + " " + sinp;
                    }
                    this.pw.flush();
                }
                catch (Exception e) {
                    this.pw.flush();
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(null, "Error while execution aplication : " + e.getMessage());
                    System.exit(1);
                    try {
                        buffinp.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    this.pw.close();
                    break block25;
                }
            }
            catch (Throwable throwable) {
                try {
                    buffinp.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.pw.close();
                throw throwable;
            }
            try {
                buffinp.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.pw.close();
        }
        System.out.println("finished application available memory " + error);
        if (!isrunning) {
            ++this.errorCount;
            String comm = String.valueOf(error != null ? "Error while running application (" + error + "). " : "cannot runing application with recommended configuration. ") + " Do you want to run with minimal configuration?";
            if (this.errorCount < this.memoryMax.length) {
                int confirm = JOptionPane.showConfirmDialog(null, comm, "Error VM", 0);
                if (confirm == 0) {
                    String[] sp = this.exec.split(" ");
                    StringBuffer sbf = new StringBuffer();
                    String[] stringArray = sp;
                    int n = sp.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String st = stringArray[n3];
                        if (st.startsWith("-Xms")) {
                            sbf.append(this.memoryMin[this.errorCount]).append(" ");
                        } else if (st.startsWith("-Xmx")) {
                            sbf.append(this.memoryMax[this.errorCount]).append(" ");
                        } else {
                            sbf.append(st).append(" ");
                        }
                        ++n3;
                    }
                    this.exec = sbf.toString();
                    this.runApplication();
                } else {
                    System.exit(1);
                }
            } else {
                JOptionPane.showMessageDialog(null, "failed to run application with minimal configuration (" + this.exec + ")");
                System.exit(1);
            }
        }
    }

    long getAvailableMemory() {
        int mb = 0x100000;
        Runtime instance = Runtime.getRuntime();
        return instance.maxMemory();
    }

    public static void main(String[] args) {
        try {
            new UpdaterFrame().setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void message(final String msg, final int percent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UpdaterFrame.this.lblStatus.setText(msg);
                UpdaterFrame.this.progressStatus.setValue(percent);
            }
        });
    }

    public static Object readFile(String pname) {
        Object objresult = null;
        try {
            File file = new File(pname);
            FileInputStream fis = new FileInputStream(file);
            ObjectInputStream in = new ObjectInputStream(fis);
            objresult = in.readObject();
            in.close();
        }
        catch (Exception ex) {
            objresult = null;
        }
        return objresult;
    }
}

