/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics.commands;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import org.icepdf.core.pobjects.Form;
import org.icepdf.core.pobjects.ImageUtility;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.graphics.DeviceCMYK;
import org.icepdf.core.pobjects.graphics.DeviceRGB;
import org.icepdf.core.pobjects.graphics.ICCBased;
import org.icepdf.core.pobjects.graphics.OptionalContentState;
import org.icepdf.core.pobjects.graphics.PaintTimer;
import org.icepdf.core.pobjects.graphics.Shapes;
import org.icepdf.core.pobjects.graphics.SoftMask;
import org.icepdf.core.pobjects.graphics.commands.AbstractDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.DrawCmd;
import org.icepdf.core.pobjects.graphics.commands.ShapeDrawCmd;
import org.icepdf.core.util.Defs;

public class FormDrawCmd
extends AbstractDrawCmd {
    private Form xForm;
    private BufferedImage xFormBuffer;
    private int x;
    private int y;
    private static boolean disableXObjectSMask = Defs.sysPropertyBoolean("org.icepdf.core.disableXObjectSMask", false);

    public FormDrawCmd(Form xForm) {
        this.xForm = xForm;
    }

    public Shape paintOperand(Graphics2D g, Page parentPage, Shape currentShape, Shape clip, AffineTransform base, OptionalContentState optionalContentState, boolean paintAlpha, PaintTimer paintTimer) {
        if (optionalContentState.isVisible() && this.xFormBuffer == null) {
            boolean isShading;
            RenderingHints renderingHints = g.getRenderingHints();
            Rectangle2D bBox = this.xForm.getBBox();
            this.x = (int)bBox.getX();
            this.y = (int)bBox.getY();
            boolean hasMask = this.xForm.getGraphicsState().getExtGState() != null && this.xForm.getGraphicsState().getExtGState().getSMask() != null || this.xForm.getExtGState() != null && this.xForm.getExtGState().getSMask() != null;
            boolean isExtendGraphicState = this.xForm.getGraphicsState().getExtGState() != null && this.xForm.getExtGState() != null;
            boolean normalBM = false;
            if (isExtendGraphicState && this.xForm.getExtGState().getBlendingMode() != null) {
                normalBM = this.xForm.getExtGState().getBlendingMode().equals(new Name("Normal")) && this.xForm.getGraphicsState().getExtGState().getBlendingMode().equals(new Name("Normal")) && this.xForm.getExtGState() != null && (this.xForm.getExtGState().isAlphaAShape() == false || this.xForm.getExtGState().getOverprintMode() == 0);
            }
            SoftMask formSoftMask = null;
            SoftMask softMask = null;
            if (this.xForm.getGraphicsState().getExtGState().getSMask() != null) {
                softMask = this.xForm.getGraphicsState().getExtGState().getSMask();
                isShading = softMask.getG().getResources().isShading();
                if (isShading) {
                    isShading = this.checkForShaddingFill(softMask.getG());
                    softMask.getG().setShading(isShading);
                }
                if (!isShading) {
                    this.x = (int)softMask.getG().getBBox().getX();
                    this.y = (int)softMask.getG().getBBox().getY();
                }
            }
            if (this.xForm.getExtGState().getSMask() != null) {
                formSoftMask = this.xForm.getExtGState().getSMask();
                isShading = formSoftMask.getG().getResources().isShading();
                if (isShading) {
                    isShading = this.checkForShaddingFill(formSoftMask.getG());
                    formSoftMask.getG().setShading(isShading);
                }
                if (!isShading) {
                    this.x = (int)formSoftMask.getG().getBBox().getX();
                    this.y = (int)formSoftMask.getG().getBBox().getY();
                }
            }
            if (softMask != null && formSoftMask != null) {
                if (softMask.getPObjectReference() != null && formSoftMask.getPObjectReference() != null && softMask.getPObjectReference().equals(formSoftMask.getPObjectReference())) {
                    softMask = null;
                } else if (softMask.getG().getPObjectReference() != null && formSoftMask.getG().getPObjectReference() != null && softMask.getG().getPObjectReference().equals(formSoftMask.getG().getPObjectReference())) {
                    softMask = null;
                }
            }
            if (this.xForm.getResources().isShading()) {
                boolean isFormShading = this.checkForShaddingFill(this.xForm);
                this.xForm.setShading(isFormShading);
            }
            this.xFormBuffer = this.createBufferXObject(parentPage, this.xForm, null, renderingHints, normalBM);
            if (!disableXObjectSMask && hasMask) {
                if (!this.xForm.isShading()) {
                    if (softMask != null && softMask.getS().equals("Alpha")) {
                        logger.warning("Smask alpha example, currently not supported.");
                    } else if (softMask != null && softMask.getS().equals("Luminosity")) {
                        this.xFormBuffer = this.applyMask(parentPage, this.xFormBuffer, softMask, formSoftMask != null, g.getRenderingHints());
                    }
                } else if (softMask != null) {
                    logger.warning("Smask pattern paint example, currently not supported.");
                    this.xFormBuffer.flush();
                    this.xFormBuffer = this.createBufferXObject(parentPage, softMask.getG(), null, renderingHints, true);
                    return currentShape;
                }
                if (formSoftMask != null) {
                    BufferedImage formSMaskBuffer = this.applyMask(parentPage, this.xFormBuffer, formSoftMask, softMask != null, g.getRenderingHints());
                    if (softMask != null) {
                        BufferedImage formBuffer = ImageUtility.createTranslucentCompatibleImage(this.xFormBuffer.getWidth(), this.xFormBuffer.getHeight());
                        Graphics2D g2d = (Graphics2D)formBuffer.getGraphics();
                        g2d.drawImage((Image)formSMaskBuffer, 0, 0, null);
                        this.xFormBuffer.flush();
                        this.xFormBuffer = formBuffer;
                    } else {
                        this.xFormBuffer = formSMaskBuffer;
                    }
                }
            } else if (isExtendGraphicState) {
                BufferedImage shape = this.createBufferXObject(parentPage, this.xForm, null, renderingHints, true);
                this.xFormBuffer = ImageUtility.applyExplicitOutline(this.xFormBuffer, shape);
            }
        }
        g.drawImage(this.xFormBuffer, null, this.x, this.y);
        return currentShape;
    }

    private BufferedImage applyMask(Page parentPage, BufferedImage xFormBuffer, SoftMask softMask, boolean useLuminosity, RenderingHints renderingHints) {
        if (softMask != null && softMask.getS().equals("Alpha")) {
            logger.warning("Smask alpha example, currently not supported.");
        } else if (softMask != null && softMask.getS().equals("Luminosity")) {
            BufferedImage sMaskBuffer = this.createBufferXObject(parentPage, softMask.getG(), softMask, renderingHints, true);
            xFormBuffer = !useLuminosity ? ImageUtility.applyExplicitSMask(xFormBuffer, sMaskBuffer) : ImageUtility.applyExplicitOutline(xFormBuffer, sMaskBuffer);
            if (softMask.getTR() != null) {
                logger.warning("Smask Transfer Function example, currently not supported.");
            }
        }
        return xFormBuffer;
    }

    private BufferedImage createBufferXObject(Page parentPage, Form xForm, SoftMask softMask, RenderingHints renderingHints, boolean isMask) {
        Rectangle2D bBox = xForm.getBBox();
        int width = (int)bBox.getWidth();
        int height = (int)bBox.getHeight();
        if (width == 0) {
            width = 1;
        } else if (width >= Short.MAX_VALUE) {
            width = this.xFormBuffer.getWidth();
        }
        if (height == 0) {
            height = 1;
        } else if (height >= Short.MAX_VALUE) {
            height = this.xFormBuffer.getHeight();
        }
        BufferedImage bi = ImageUtility.createTranslucentCompatibleImage(width, height);
        Graphics2D canvas = bi.createGraphics();
        if (!isMask && xForm.getExtGState() != null && xForm.getExtGState().getBlendingMode() != null && !new Name("Normal").equals(xForm.getExtGState().getBlendingMode()) && xForm.getGroup() != null) {
            HashMap tmp = xForm.getGroup();
            Object cs = xForm.getLibrary().getObject(tmp, new Name("CS"));
            if (cs == null || cs instanceof ICCBased || cs instanceof Name && (((Name)cs).equals(DeviceRGB.DEVICERGB_KEY) || ((Name)cs).equals(DeviceCMYK.DEVICECMYK_KEY))) {
                canvas.setColor(Color.WHITE);
                canvas.fillRect(0, 0, width, height);
            }
        }
        canvas.setRenderingHints(renderingHints);
        Shapes xFormShapes = xForm.getShapes();
        if (xFormShapes != null) {
            xFormShapes.setPageParent(parentPage);
            if (!xForm.isShading()) {
                canvas.translate(-((int)bBox.getX()), -((int)bBox.getY()));
                canvas.setClip(bBox);
                xFormShapes.paint(canvas);
                xFormShapes.setPageParent(null);
            } else {
                for (DrawCmd cmd : xFormShapes.getShapes()) {
                    if (!(cmd instanceof ShapeDrawCmd) || ((ShapeDrawCmd)cmd).getShape() != null) continue;
                    Rectangle2D bounds = bBox.getBounds2D();
                    ((ShapeDrawCmd)cmd).setShape(bounds);
                }
                canvas.translate(-this.x, -this.y);
                canvas.setClip(0, 0, bi.getWidth(), bi.getHeight());
                xFormShapes.paint(canvas);
                xFormShapes.setPageParent(null);
            }
        }
        canvas.dispose();
        return bi;
    }

    private boolean checkForShaddingFill(Form xform) {
        boolean found = false;
        for (DrawCmd cmd : xform.getShapes().getShapes()) {
            if (!(cmd instanceof ShapeDrawCmd) || ((ShapeDrawCmd)cmd).getShape() != null) continue;
            found = true;
        }
        return found;
    }
}

