/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.annotations;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import org.icepdf.core.pobjects.Form;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.PObject;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.StateManager;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.acroform.FieldDictionary;
import org.icepdf.core.pobjects.acroform.TextFieldDictionary;
import org.icepdf.core.pobjects.annotations.AbstractWidgetAnnotation;
import org.icepdf.core.pobjects.annotations.Appearance;
import org.icepdf.core.pobjects.annotations.AppearanceState;
import org.icepdf.core.pobjects.fonts.FontFile;
import org.icepdf.core.pobjects.fonts.FontManager;
import org.icepdf.core.util.Library;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextWidgetAnnotation
extends AbstractWidgetAnnotation<TextFieldDictionary> {
    protected FontFile fontFile;
    private TextFieldDictionary fieldDictionary;

    public TextWidgetAnnotation(Library l, HashMap h) {
        super(l, h);
        this.fieldDictionary = new TextFieldDictionary(this.library, this.entries);
        this.fontFile = FontManager.getInstance().initialize().getInstance(this.fieldDictionary.getFontName(), 0);
    }

    @Override
    public void resetAppearanceStream(double dx, double dy, AffineTransform pageTransform) {
        TextFieldDictionary.TextFieldType textFieldType = this.fieldDictionary.getTextFieldType();
        if (textFieldType != TextFieldDictionary.TextFieldType.TEXT_PASSWORD) {
            Form appearanceStream;
            Appearance appearance = (Appearance)this.appearances.get(this.currentAppearance);
            AppearanceState appearanceState = appearance.getSelectedAppearanceState();
            Rectangle2D bbox = appearanceState.getBbox();
            AffineTransform matrix = appearanceState.getMatrix();
            String currentContentStream = appearanceState.getOriginalContentStream();
            if ((currentContentStream = this.buildTextWidgetContents(currentContentStream)) != null) {
                appearanceState.setContentStream(currentContentStream.getBytes());
            }
            if ((appearanceStream = this.getOrGenerateAppearanceForm()) != null) {
                appearanceStream.setRawBytes(currentContentStream.getBytes());
                StateManager stateManager = this.library.getStateManager();
                stateManager.addChange(new PObject(appearanceStream, appearanceStream.getPObjectReference()));
                HashMap<Name, Reference> appearanceRefs = new HashMap<Name, Reference>();
                appearanceRefs.put(APPEARANCE_STREAM_NORMAL_KEY, appearanceStream.getPObjectReference());
                this.entries.put(APPEARANCE_STREAM_KEY, appearanceRefs);
                Rectangle2D.Float formBbox = new Rectangle2D.Float(0.0f, 0.0f, (float)bbox.getWidth(), (float)bbox.getHeight());
                appearanceStream.setAppearance(null, matrix, formBbox);
                if (this.library.getResources(appearanceStream.getEntries(), Form.RESOURCES_KEY) == null) {
                    appearanceStream.getEntries().put(Form.RESOURCES_KEY, this.library.getCatalog().getInteractiveForm().getResources().getEntries());
                }
                stateManager.addChange(new PObject(this, this.getPObjectReference()));
                if (compressAppearanceStream) {
                    appearanceStream.getEntries().put(Stream.FILTER_KEY, new Name("FlateDecode"));
                } else {
                    appearanceStream.getEntries().remove(Stream.FILTER_KEY);
                }
            }
        }
    }

    public String buildTextWidgetContents(String currentContentStream) {
        if (currentContentStream == null || currentContentStream.equals("")) {
            currentContentStream = " /Tx BMC q BT ET Q EMC";
        }
        String contents = (String)this.fieldDictionary.getFieldValue();
        int btStart = currentContentStream.indexOf("BMC") + 3;
        int etEnd = currentContentStream.lastIndexOf("EMC");
        String preBt = "";
        String postEt = "";
        String markedContent = "";
        if (btStart >= 0 && etEnd >= 0) {
            preBt = currentContentStream.substring(0, btStart) + " BT ";
            postEt = "ET " + currentContentStream.substring(etEnd);
            markedContent = currentContentStream.substring(btStart, etEnd);
        } else {
            preBt = currentContentStream + " /Tx BMC q BT ";
            postEt = " ET Q EMC ";
        }
        Rectangle2D.Float bounds = this.findRectangle(preBt);
        boolean isfourthQuadrant = false;
        if (bounds != null && bounds.getHeight() < 0.0) {
            isfourthQuadrant = true;
        }
        StringBuilder content = new StringBuilder();
        double lineHeight = this.getLineHeight(this.fieldDictionary.getDefaultAppearance());
        content.append(this.generateDefaultAppearance(markedContent, this.fieldDictionary.getDefaultAppearance()));
        if (this.fieldDictionary.getDefaultAppearance() == null) {
            lineHeight = this.getFontSize(markedContent);
        }
        if (!isfourthQuadrant) {
            content.append(lineHeight).append(" TL ");
            content.append(2).append(' ').append(Math.round(this.getBbox().getHeight() * 100.0) / 100L).append(" Td ");
        } else {
            content.append(2).append(' ').append(2).append(" Td ");
        }
        content = this.encodeLiteralString(content, contents);
        currentContentStream = preBt + content + postEt;
        return currentContentStream;
    }

    @Override
    public void reset() {
        Object oldValue = this.fieldDictionary.getFieldValue();
        Object tmp = this.fieldDictionary.getDefaultFieldValue();
        if (tmp != null) {
            this.fieldDictionary.setFieldValue(this.fieldDictionary.getDefaultFieldValue(), this.getPObjectReference());
            this.changeSupport.firePropertyChange("valueFieldReset", oldValue, this.fieldDictionary.getFieldValue());
        } else {
            this.fieldDictionary.getEntries().remove(FieldDictionary.V_KEY);
            this.fieldDictionary.setFieldValue("", this.getPObjectReference());
            this.changeSupport.firePropertyChange("valueFieldReset", oldValue, "");
        }
    }

    @Override
    public TextFieldDictionary getFieldDictionary() {
        return this.fieldDictionary;
    }

    public String generateDefaultAppearance(String content, String defaultAppearance) {
        String appearanceText;
        if (defaultAppearance != null && this.checkAppearance(defaultAppearance)) {
            appearanceText = defaultAppearance + ' ';
        } else {
            String fontName = "/Helv";
            double size = this.getFontSize(content);
            this.fieldDictionary.setSize((int)size);
            this.fieldDictionary.setFontName(fontName);
            appearanceText = fontName + " " + size + " Tf 0 g ";
        }
        return appearanceText;
    }
}

