/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelGrabber;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.graphics.CalGray;
import org.icepdf.core.pobjects.graphics.DeviceCMYK;
import org.icepdf.core.pobjects.graphics.DeviceGray;
import org.icepdf.core.pobjects.graphics.DeviceRGB;
import org.icepdf.core.pobjects.graphics.GraphicsState;
import org.icepdf.core.pobjects.graphics.ICCBased;
import org.icepdf.core.pobjects.graphics.Indexed;
import org.icepdf.core.pobjects.graphics.PColorSpace;
import org.icepdf.core.pobjects.graphics.RasterOps.CMYKRasterOp;
import org.icepdf.core.pobjects.graphics.RasterOps.DecodeRasterOp;
import org.icepdf.core.pobjects.graphics.RasterOps.GrayRasterOp;
import org.icepdf.core.pobjects.graphics.RasterOps.PColorSpaceRasterOp;
import org.icepdf.core.pobjects.graphics.RasterOps.YCCKRasterOp;
import org.icepdf.core.pobjects.graphics.RasterOps.YCbCrRasterOp;
import org.icepdf.core.pobjects.graphics.Separation;
import org.icepdf.core.util.Defs;

public class ImageUtility {
    private static final Logger logger = Logger.getLogger(ImageUtility.class.toString());
    protected static final int[] GRAY_1_BIT_INDEX_TO_RGB_REVERSED = new int[]{-1, -16777216};
    protected static final int[] GRAY_1_BIT_INDEX_TO_RGB = new int[]{-16777216, -1};
    protected static final int[] GRAY_2_BIT_INDEX_TO_RGB = new int[]{-16777216, -11184811, -5592406, -1};
    protected static final int[] GRAY_4_BIT_INDEX_TO_RGB = new int[]{-16777216, -15658735, -14540254, -13421773, -12303292, -11184811, -10066330, -8947849, -7829368, -6710887, -5592406, -4473925, -3355444, -2236963, -1118482, -1};
    protected static final int JPEG_ENC_UNKNOWN_PROBABLY_YCbCr = 0;
    protected static final int JPEG_ENC_RGB = 1;
    protected static final int JPEG_ENC_CMYK = 2;
    protected static final int JPEG_ENC_YCbCr = 3;
    protected static final int JPEG_ENC_YCCK = 4;
    protected static final int JPEG_ENC_GRAY = 5;
    private static boolean scaleQuality;
    private static GraphicsConfiguration configuration;
    private static ImageUtility imageUtility;

    private ImageUtility() {
    }

    public static BufferedImage createCompatibleImage(int width, int height) {
        if (configuration != null) {
            return configuration.createCompatibleImage(width, height);
        }
        return new BufferedImage(width, height, 1);
    }

    public static BufferedImage createTranslucentCompatibleImage(int width, int height) {
        if (configuration != null) {
            return configuration.createCompatibleImage(width, height, 3);
        }
        return new BufferedImage(width, height, 2);
    }

    public static ImageUtility getInstance() {
        if (imageUtility == null) {
            imageUtility = new ImageUtility();
        }
        return imageUtility;
    }

    protected static BufferedImage alterBufferedImageAlpha(BufferedImage bi, int[] maskMinRGB, int[] maskMaxRGB) {
        if (!ImageUtility.hasAlpha(bi)) {
            bi = ImageUtility.createBufferedImage(bi);
        }
        int width = bi.getWidth();
        int height = bi.getHeight();
        int maskMinRed = 255;
        int maskMinGreen = 255;
        int maskMinBlue = 255;
        int maskMaxRed = 0;
        int maskMaxGreen = 0;
        int maskMaxBlue = 0;
        if (maskMinRGB != null && maskMaxRGB != null) {
            maskMinRed = maskMinRGB[0];
            maskMinGreen = maskMinRGB[1];
            maskMinBlue = maskMinRGB[2];
            maskMaxRed = maskMaxRGB[0];
            maskMaxGreen = maskMaxRGB[1];
            maskMaxBlue = maskMaxRGB[2];
        }
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int alpha = 255;
                int argb = bi.getRGB(x, y);
                int red = argb >> 16 & 0xFF;
                int green = argb >> 8 & 0xFF;
                int blue = argb & 0xFF;
                if (blue >= maskMinBlue && blue <= maskMaxBlue && green >= maskMinGreen && green <= maskMaxGreen && red >= maskMinRed && red <= maskMaxRed) {
                    alpha = 0;
                }
                if (alpha == 255) continue;
                argb = bi.getRGB(x, y);
                argb &= 0xFFFFFF;
                bi.setRGB(x, y, argb |= alpha << 24 & 0xFF000000);
            }
        }
        return bi;
    }

    public static void displayImage(final BufferedImage bufferedImage, final String title) {
        if (bufferedImage == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                final JFrame f = new JFrame("Image - " + title);
                f.setDefaultCloseOperation(1);
                int width = (int)((double)bufferedImage.getWidth() * 1.2);
                int height = (int)((double)bufferedImage.getHeight() * 1.2);
                JComponent image = new JComponent(){

                    public void paint(Graphics g_) {
                        super.paint(g_);
                        g_.setColor(Color.green);
                        g_.fillRect(0, 0, 10000, 10000);
                        g_.drawImage(bufferedImage, 0, 0, f);
                        g_.setColor(Color.red);
                        g_.drawRect(0, 0, bufferedImage.getWidth() - 2, bufferedImage.getHeight() - 2);
                    }
                };
                image.setPreferredSize(new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight()));
                image.setSize(new Dimension(width, height));
                JPanel test = new JPanel();
                test.setPreferredSize(new Dimension(width, height));
                JScrollPane tmp = new JScrollPane(image);
                tmp.revalidate();
                f.setSize(new Dimension(width < 250 ? 250 : width, height < 250 ? 250 : height));
                f.getContentPane().add(tmp);
                f.validate();
                f.setVisible(true);
            }
        });
    }

    protected static BufferedImage makeRGBABufferedImage(WritableRaster wr) {
        return ImageUtility.makeRGBABufferedImage(wr, 1);
    }

    protected static BufferedImage makeRGBABufferedImage(WritableRaster wr, int transparency) {
        ColorSpace cs = ColorSpace.getInstance(1000);
        int[] bits = new int[4];
        for (int i = 0; i < bits.length; ++i) {
            bits[i] = 8;
        }
        ComponentColorModel cm = new ComponentColorModel(cs, bits, true, false, transparency, wr.getTransferType());
        return new BufferedImage(cm, wr, false, null);
    }

    protected static BufferedImage makeBufferedImage(Raster raster) {
        DirectColorModel colorModel = new DirectColorModel(24, 0xFF0000, 65280, 255, 0);
        raster = colorModel.createCompatibleWritableRaster(raster.getWidth(), raster.getHeight());
        return new BufferedImage(colorModel, (WritableRaster)raster, false, null);
    }

    protected static BufferedImage makeRGBBufferedImage(WritableRaster wr) {
        ColorSpace cs = ColorSpace.getInstance(1000);
        int[] bits = new int[3];
        for (int i = 0; i < bits.length; ++i) {
            bits[i] = 8;
        }
        ComponentColorModel cm = new ComponentColorModel(cs, bits, false, false, 1, wr.getTransferType());
        return new BufferedImage(cm, wr, false, null);
    }

    protected static BufferedImage makeGrayBufferedImage(WritableRaster wr) {
        ColorSpace cs = ColorSpace.getInstance(1003);
        int[] bits = new int[1];
        for (int i = 0; i < bits.length; ++i) {
            bits[i] = 8;
        }
        ComponentColorModel cm = new ComponentColorModel(cs, bits, false, false, 1, wr.getTransferType());
        return new BufferedImage(cm, wr, false, null);
    }

    protected static BufferedImage makeRGBABufferedImageFromImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean hasAlpha = ImageUtility.hasAlpha(image);
        BufferedImage bImage = null;
        try {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            int transparency = 1;
            if (hasAlpha) {
                transparency = 2;
            }
            int width = image.getWidth(null);
            int height = image.getHeight(null);
            if (width == -1 || height == -1) {
                return null;
            }
            bImage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException e) {
            // empty catch block
        }
        if (bImage == null) {
            int width = image.getWidth(null);
            int height = image.getHeight(null);
            if (width == -1 || height == -1) {
                return null;
            }
            bImage = hasAlpha ? ImageUtility.createTranslucentCompatibleImage(width, height) : ImageUtility.createCompatibleImage(width, height);
        }
        Graphics2D g = bImage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        image.flush();
        return bImage;
    }

    public static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            return bufferedImage.getColorModel().hasAlpha();
        }
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        ColorModel cm = pixelGrabber.getColorModel();
        return cm == null || cm.hasAlpha();
    }

    protected static void getNormalizedComponents(byte[] pixels, float[] decode, float[] out) {
        for (int i = 0; i < pixels.length; ++i) {
            out[i] = decode[i * 2] + (float)(pixels[i] & 0xFF) * decode[i * 2 + 1];
        }
    }

    protected static WritableRaster alterRasterRGBA(WritableRaster wr, BufferedImage smaskImage, BufferedImage maskImage, int[] maskMinRGB, int[] maskMaxRGB) {
        WritableRaster smaskRaster = null;
        int smaskWidth = 0;
        int smaskHeight = 0;
        if (smaskImage != null) {
            smaskRaster = smaskImage.getRaster();
            smaskWidth = smaskRaster.getWidth();
            smaskHeight = smaskRaster.getHeight();
        }
        WritableRaster maskRaster = null;
        int maskWidth = 0;
        int maskHeight = 0;
        if (maskImage != null) {
            maskRaster = maskImage.getRaster();
            maskWidth = maskRaster.getWidth();
            maskHeight = maskRaster.getHeight();
        }
        int maskMinRed = 255;
        int maskMinGreen = 255;
        int maskMinBlue = 255;
        int maskMaxRed = 0;
        int maskMaxGreen = 0;
        int maskMaxBlue = 0;
        if (maskMinRGB != null && maskMaxRGB != null) {
            maskMinRed = maskMinRGB[0];
            maskMinGreen = maskMinRGB[1];
            maskMinBlue = maskMinRGB[2];
            maskMaxRed = maskMaxRGB[0];
            maskMaxGreen = maskMaxRGB[1];
            maskMaxBlue = maskMaxRGB[2];
        }
        if (smaskRaster == null && maskRaster == null && (maskMinRGB == null || maskMaxRGB == null)) {
            return null;
        }
        int[] rgbaValues = new int[4];
        int width = wr.getWidth();
        int height = wr.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                wr.getPixel(x, y, rgbaValues);
                int red = rgbaValues[0];
                int green = rgbaValues[1];
                int blue = rgbaValues[2];
                int alpha = 255;
                if (y < smaskHeight && x < smaskWidth && smaskRaster != null) {
                    alpha = smaskImage.getRGB(x, y) & 0xFF;
                } else if (y < maskHeight && x < maskWidth && maskRaster != null) {
                    alpha = maskImage.getRGB(x, y) >>> 24 & 0xFF;
                } else if (blue >= maskMinBlue && blue <= maskMaxBlue && green >= maskMinGreen && green <= maskMaxGreen && red >= maskMinRed && red <= maskMaxRed) {
                    alpha = 0;
                }
                if (alpha == 255) continue;
                rgbaValues[3] = alpha;
                wr.setPixel(x, y, rgbaValues);
            }
        }
        return wr;
    }

    public static BufferedImage applyExplicitMask(BufferedImage baseImage, BufferedImage maskImage) {
        BufferedImage[] images = ImageUtility.scaleImagesToSameSize(baseImage, maskImage);
        baseImage = images[0];
        maskImage = images[1];
        int baseWidth = baseImage.getWidth();
        int baseHeight = baseImage.getHeight();
        BufferedImage argbImage = ImageUtility.createTranslucentCompatibleImage(baseWidth, baseHeight);
        int[] srcBand = new int[baseWidth];
        int[] maskBnd = new int[baseWidth];
        for (int i = 0; i < baseHeight; ++i) {
            baseImage.getRGB(0, i, baseWidth, 1, srcBand, 0, baseWidth);
            maskImage.getRGB(0, i, baseWidth, 1, maskBnd, 0, baseWidth);
            for (int j = 0; j < baseWidth; ++j) {
                maskBnd[j] = maskBnd[j] == 0 || maskBnd[j] == 0xFFFFFF ? 255 : srcBand[j];
            }
            argbImage.setRGB(0, i, baseWidth, 1, maskBnd, 0, baseWidth);
        }
        baseImage.flush();
        baseImage = argbImage;
        return baseImage;
    }

    public static BufferedImage applyBlendingMode(BufferedImage baseImage, Name blendingMode, Color blendColor) {
        int baseWidth = baseImage.getWidth();
        int baseHeight = baseImage.getHeight();
        BufferedImage argbImage = ImageUtility.createTranslucentCompatibleImage(baseWidth, baseHeight);
        int[] srcBand = new int[baseWidth];
        int[] blendBand = new int[baseWidth];
        int blendColorValue = blendColor.getRGB();
        for (int i = 0; i < baseHeight; ++i) {
            baseImage.getRGB(0, i, baseWidth, 1, srcBand, 0, baseWidth);
            for (int j = 0; j < baseWidth; ++j) {
                blendBand[j] = srcBand[j] == blendColorValue || srcBand[j] == 0xFFFFFF || srcBand[j] == 65535 ? 255 : srcBand[j];
            }
            argbImage.setRGB(0, i, baseWidth, 1, blendBand, 0, baseWidth);
        }
        baseImage.flush();
        baseImage = argbImage;
        return baseImage;
    }

    public static BufferedImage applyExplicitSMask(BufferedImage baseImage, BufferedImage sMaskImage) {
        BufferedImage[] images = ImageUtility.scaleImagesToSameSize(baseImage, sMaskImage);
        baseImage = images[0];
        sMaskImage = images[1];
        int baseWidth = baseImage.getWidth();
        int baseHeight = baseImage.getHeight();
        BufferedImage argbImage = ImageUtility.createTranslucentCompatibleImage(baseWidth, baseHeight);
        int[] srcBand = new int[baseWidth];
        int[] sMaskBand = new int[baseWidth];
        for (int i = 0; i < baseHeight; ++i) {
            baseImage.getRGB(0, i, baseWidth, 1, srcBand, 0, baseWidth);
            sMaskImage.getRGB(0, i, baseWidth, 1, sMaskBand, 0, baseWidth);
            for (int j = 0; j < baseWidth; ++j) {
                int red = sMaskBand[j] >> 16 & 0xFF;
                int alpha = srcBand[j] >> 24 & 0xFF;
                int sa = (int)((float)red * ((float)alpha / 255.0f)) << 24;
                srcBand[j] = sa | srcBand[j] & 0xFFFFFF;
            }
            argbImage.setRGB(0, i, baseWidth, 1, srcBand, 0, baseWidth);
        }
        baseImage.flush();
        baseImage = argbImage;
        return baseImage;
    }

    public static BufferedImage applyExplicitLuminosity(BufferedImage baseImage, BufferedImage sMaskImage) {
        BufferedImage[] images = ImageUtility.scaleImagesToSameSize(baseImage, sMaskImage);
        baseImage = images[0];
        sMaskImage = images[1];
        int baseWidth = baseImage.getWidth();
        int baseHeight = baseImage.getHeight();
        BufferedImage argbImage = ImageUtility.createTranslucentCompatibleImage(baseWidth, baseHeight);
        int[] srcBand = new int[baseWidth];
        int[] sMaskBand = new int[baseWidth];
        for (int i = 0; i < baseHeight; ++i) {
            baseImage.getRGB(0, i, baseWidth, 1, srcBand, 0, baseWidth);
            sMaskImage.getRGB(0, i, baseWidth, 1, sMaskBand, 0, baseWidth);
            for (int j = 0; j < baseWidth; ++j) {
                int red = srcBand[j] >> 16 & 0xFF;
                int green = srcBand[j] >> 8 & 0xFF;
                int blue = srcBand[j] & 0xFF;
                int alpha = sMaskBand[j] >> 16 & 0xFF;
                int trans = sMaskBand[j] >> 24 & 0xFF;
                int redOut = Math.min(255, red - alpha);
                int greenOut = Math.min(255, green - alpha);
                int blueOut = Math.min(255, blue - alpha);
                srcBand[j] = trans << 24 | Math.max(0, redOut) << 16 | Math.max(0, greenOut) << 8 | Math.max(0, blueOut);
            }
            argbImage.setRGB(0, i, baseWidth, 1, srcBand, 0, baseWidth);
        }
        baseImage.flush();
        baseImage = argbImage;
        return baseImage;
    }

    public static BufferedImage applyExplicitOutline(BufferedImage baseImage, BufferedImage sMaskImage) {
        BufferedImage[] images = ImageUtility.scaleImagesToSameSize(baseImage, sMaskImage);
        baseImage = images[0];
        sMaskImage = images[1];
        int baseWidth = baseImage.getWidth();
        int baseHeight = baseImage.getHeight();
        BufferedImage argbImage = ImageUtility.createTranslucentCompatibleImage(baseWidth, baseHeight);
        int[] srcBand = new int[baseWidth];
        int[] sMaskBand = new int[baseWidth];
        for (int i = 0; i < baseHeight; ++i) {
            baseImage.getRGB(0, i, baseWidth, 1, srcBand, 0, baseWidth);
            sMaskImage.getRGB(0, i, baseWidth, 1, sMaskBand, 0, baseWidth);
            for (int j = 0; j < baseWidth; ++j) {
                int alpha = sMaskBand[j] >> 24 & 0xFF;
                int sa = alpha << 24;
                if (sMaskBand[j] != 0) continue;
                srcBand[j] = sa | srcBand[j] & 0xFFFFFF;
            }
            argbImage.setRGB(0, i, baseWidth, 1, srcBand, 0, baseWidth);
        }
        baseImage.flush();
        baseImage = argbImage;
        return baseImage;
    }

    protected static BufferedImage applyExplicitMask(BufferedImage baseImage, Color fill) {
        int baseWidth = baseImage.getWidth();
        int baseHeight = baseImage.getHeight();
        BufferedImage imageMask = ImageUtility.hasAlpha(baseImage) ? baseImage : ImageUtility.createTranslucentCompatibleImage(baseWidth, baseHeight);
        int[] srcBand = new int[baseWidth];
        int[] maskBnd = new int[baseWidth];
        int fillRgb = fill.getRGB();
        for (int i = 0; i < baseHeight; ++i) {
            baseImage.getRGB(0, i, baseWidth, 1, srcBand, 0, baseWidth);
            imageMask.getRGB(0, i, baseWidth, 1, maskBnd, 0, baseWidth);
            for (int j = 0; j < baseWidth; ++j) {
                if (srcBand[j] == -1 || srcBand[j] == 0xFFFFFF) continue;
                maskBnd[j] = fillRgb;
            }
            imageMask.setRGB(0, i, baseWidth, 1, maskBnd, 0, baseWidth);
        }
        baseImage.flush();
        return imageMask;
    }

    protected static BufferedImage applyIndexColourModel(WritableRaster wr, PColorSpace colourSpace, int bitsPerComponent) {
        int i;
        colourSpace.init();
        Color[] colors = ((Indexed)colourSpace).accessColorTable();
        int colorsLength = colors == null ? 0 : colors.length;
        int[] cmap = new int[256];
        for (i = 0; i < colorsLength; ++i) {
            cmap[i] = colors[i].getRGB();
        }
        for (i = colorsLength; i < cmap.length; ++i) {
            cmap[i] = -16777216;
        }
        DataBuffer db = wr.getDataBuffer();
        IndexColorModel cm = new IndexColorModel(bitsPerComponent, cmap.length, cmap, 0, false, -1, db.getDataType());
        BufferedImage img = new BufferedImage(cm, wr, false, null);
        return img;
    }

    protected static BufferedImage proJbig2Decode(ImageInputStream imageInputStream, HashMap decodeParms, Stream globalsStream) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException, IOException, ClassNotFoundException, InstantiationException {
        byte[] globals;
        Class<?> levigoJBIG2ImageReaderClass = Class.forName("com.levigo.jbig2.JBIG2ImageReader");
        Class<?> jbig2ImageReaderSpiClass = Class.forName("com.levigo.jbig2.JBIG2ImageReaderSpi");
        Class<?> jbig2GlobalsClass = Class.forName("com.levigo.jbig2.JBIG2Globals");
        Object jbig2ImageReaderSpi = jbig2ImageReaderSpiClass.newInstance();
        Constructor<?> levigoJbig2DecoderClassConstructor = levigoJBIG2ImageReaderClass.getDeclaredConstructor(ImageReaderSpi.class);
        Object levigoJbig2Reader = levigoJbig2DecoderClassConstructor.newInstance(jbig2ImageReaderSpi);
        Class[] partypes = new Class[]{Object.class};
        Object[] arglist = new Object[]{imageInputStream};
        Method setInput = levigoJBIG2ImageReaderClass.getMethod("setInput", partypes);
        setInput.invoke(levigoJbig2Reader, arglist);
        if (decodeParms != null && globalsStream != null && (globals = globalsStream.getDecodedStreamBytes(0)) != null && globals.length > 0) {
            partypes = new Class[]{ImageInputStream.class};
            arglist = new Object[]{ImageIO.createImageInputStream(new ByteArrayInputStream(globals))};
            Method processGlobals = levigoJBIG2ImageReaderClass.getMethod("processGlobals", partypes);
            Object globalSegments = processGlobals.invoke(levigoJbig2Reader, arglist);
            if (globalSegments != null) {
                partypes = new Class[]{jbig2GlobalsClass};
                arglist = new Object[]{globalSegments};
                Method setGlobalData = levigoJBIG2ImageReaderClass.getMethod("setGlobals", partypes);
                setGlobalData.invoke(levigoJbig2Reader, arglist);
            }
        }
        partypes = new Class[]{Integer.TYPE};
        arglist = new Object[]{0};
        Method read = levigoJBIG2ImageReaderClass.getMethod("read", partypes);
        BufferedImage tmpImage = (BufferedImage)read.invoke(levigoJbig2Reader, arglist);
        Method dispose = levigoJBIG2ImageReaderClass.getMethod("dispose", null);
        dispose.invoke(levigoJbig2Reader, new Object[0]);
        if (imageInputStream != null) {
            imageInputStream.close();
        }
        return tmpImage;
    }

    protected static BufferedImage jbig2Decode(byte[] data, HashMap decodeParms, Stream globalsStream) {
        BufferedImage tmpImage = null;
        try {
            byte[] globals;
            Class<?> jbig2DecoderClass = Class.forName("org.jpedal.jbig2.JBIG2Decoder");
            Constructor<?> jbig2DecoderClassConstructor = jbig2DecoderClass.getDeclaredConstructor(new Class[0]);
            Object jbig2Decoder = jbig2DecoderClassConstructor.newInstance(new Object[0]);
            if (decodeParms != null && globalsStream != null && (globals = globalsStream.getDecodedStreamBytes(0)) != null && globals.length > 0) {
                Class[] partypes = new Class[]{byte[].class};
                Object[] arglist = new Object[]{globals};
                Method setGlobalData = jbig2DecoderClass.getMethod("setGlobalData", partypes);
                setGlobalData.invoke(jbig2Decoder, arglist);
            }
            Class[] argTypes = new Class[]{byte[].class};
            Object[] arglist = new Object[]{data};
            Method decodeJBIG2 = jbig2DecoderClass.getMethod("decodeJBIG2", argTypes);
            decodeJBIG2.invoke(jbig2Decoder, arglist);
            Method cleanupPostDecode = jbig2DecoderClass.getMethod("cleanupPostDecode", new Class[0]);
            cleanupPostDecode.invoke(jbig2Decoder, new Object[0]);
            argTypes = new Class[]{Integer.TYPE};
            arglist = new Object[]{0};
            Method getPageAsBufferedImage = jbig2DecoderClass.getMethod("getPageAsBufferedImage", argTypes);
            tmpImage = (BufferedImage)getPageAsBufferedImage.invoke(jbig2Decoder, arglist);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Problem loading JBIG2 image: ", e);
        }
        return tmpImage;
    }

    protected static int getJPEGEncoding(byte[] data, int dataLength) {
        int jpegEncoding = 0;
        boolean foundAPP14 = false;
        int compsTypeFromAPP14 = 0;
        boolean foundSOF = false;
        int numCompsFromSOF = 0;
        boolean foundSOS = false;
        int numCompsFromSOS = 0;
        int index = 0;
        while (!(index >= dataLength || data[index] != -1 || foundAPP14 && foundSOF)) {
            byte segmentType = data[index + 1];
            index += 2;
            if (segmentType == -40) continue;
            int length = (data[index] << 8 & 0xFF00) + (data[index + 1] & 0xFF);
            if (segmentType == -18) {
                if (length >= 14) {
                    foundAPP14 = true;
                    compsTypeFromAPP14 = data[index + 13];
                }
            } else if (segmentType == -64) {
                foundSOF = true;
                numCompsFromSOF = data[index + 7] & 0xFF;
            } else if (segmentType == -38) {
                foundSOS = true;
                numCompsFromSOS = data[index + 2] & 0xFF;
            }
            index += length;
        }
        if (foundAPP14 && foundSOF) {
            if (compsTypeFromAPP14 == 0) {
                if (numCompsFromSOF == 1) {
                    jpegEncoding = 5;
                }
                if (numCompsFromSOF == 3) {
                    jpegEncoding = 1;
                } else if (numCompsFromSOF == 4) {
                    jpegEncoding = 2;
                }
            } else if (compsTypeFromAPP14 == 1) {
                jpegEncoding = 3;
            } else if (compsTypeFromAPP14 == 2) {
                jpegEncoding = 4;
            }
        } else if (foundSOS && numCompsFromSOS == 1) {
            jpegEncoding = 5;
        }
        return jpegEncoding;
    }

    public static BufferedImage applyGrayDecode(BufferedImage rgbImage, int bitsPerComponent, float[] decode) {
        WritableRaster wr = rgbImage.getRaster();
        int[] cmap = null;
        if (bitsPerComponent == 1) {
            boolean defaultDecode = 0.0f == decode[0];
            cmap = defaultDecode ? GRAY_1_BIT_INDEX_TO_RGB : GRAY_1_BIT_INDEX_TO_RGB_REVERSED;
        } else if (bitsPerComponent == 2) {
            cmap = GRAY_2_BIT_INDEX_TO_RGB;
        } else if (bitsPerComponent == 4) {
            cmap = GRAY_4_BIT_INDEX_TO_RGB;
        }
        IndexColorModel cm = new IndexColorModel(bitsPerComponent, cmap.length, cmap, 0, false, -1, wr.getDataBuffer().getDataType());
        rgbImage = new BufferedImage(cm, wr, false, null);
        return rgbImage;
    }

    public static BufferedImage convertSpaceToRgb(Raster colourRaster, PColorSpace colorSpace, float[] decode) {
        BufferedImage rgbImage = ImageUtility.makeBufferedImage(colourRaster);
        WritableRaster rgbRaster = rgbImage.getRaster();
        DecodeRasterOp decodeRasterOp = new DecodeRasterOp(decode, null);
        decodeRasterOp.filter(colourRaster, (WritableRaster)colourRaster);
        PColorSpaceRasterOp pColorSpaceRasterOp = new PColorSpaceRasterOp(colorSpace, null);
        pColorSpaceRasterOp.filter(colourRaster, rgbRaster);
        return rgbImage;
    }

    public static BufferedImage convertGrayToRgb(Raster grayRaster, float[] decode) {
        DecodeRasterOp decodeRasterOp = new DecodeRasterOp(decode, null);
        decodeRasterOp.filter(grayRaster, (WritableRaster)grayRaster);
        GrayRasterOp grayRasterOp = new GrayRasterOp(decode, null);
        grayRasterOp.filter(grayRaster, (WritableRaster)grayRaster);
        return ImageUtility.makeGrayBufferedImage((WritableRaster)grayRaster);
    }

    public static BufferedImage convertCmykToRgb(Raster cmykRaster, float[] decode) {
        BufferedImage rgbImage = ImageUtility.makeBufferedImage(cmykRaster);
        if (!DeviceCMYK.isDisableICCCmykColorSpace()) {
            WritableRaster rgbRaster = rgbImage.getRaster();
            ColorSpace rgbCS = rgbImage.getColorModel().getColorSpace();
            DecodeRasterOp decodeRasterOp = new DecodeRasterOp(decode, null);
            decodeRasterOp.filter(cmykRaster, (WritableRaster)cmykRaster);
            ColorConvertOp cmykToRgb = new ColorConvertOp(DeviceCMYK.getIccCmykColorSpace(), rgbCS, null);
            cmykToRgb.filter(cmykRaster, rgbRaster);
            return rgbImage;
        }
        WritableRaster rgbRaster = rgbImage.getRaster();
        DecodeRasterOp decodeRasterOp = new DecodeRasterOp(decode, null);
        decodeRasterOp.filter(cmykRaster, (WritableRaster)cmykRaster);
        CMYKRasterOp cmykRasterOp = new CMYKRasterOp(null);
        cmykRasterOp.filter(cmykRaster, rgbRaster);
        return rgbImage;
    }

    public static BufferedImage convertYCbCrToRGB(Raster yCbCrRaster, float[] decode) {
        BufferedImage rgbImage = ImageUtility.makeBufferedImage(yCbCrRaster);
        WritableRaster rgbRaster = rgbImage.getRaster();
        DecodeRasterOp decodeRasterOp = new DecodeRasterOp(decode, null);
        decodeRasterOp.filter(yCbCrRaster, (WritableRaster)yCbCrRaster);
        YCbCrRasterOp rasterOp = new YCbCrRasterOp(null);
        rasterOp.filter(yCbCrRaster, rgbRaster);
        return rgbImage;
    }

    public static BufferedImage convertYCCKToRgb(Raster ycckRaster, float[] decode) {
        BufferedImage rgbImage = ImageUtility.makeBufferedImage(ycckRaster);
        if (!DeviceCMYK.isDisableICCCmykColorSpace()) {
            WritableRaster rgbRaster = rgbImage.getRaster();
            ColorSpace rgbCS = rgbImage.getColorModel().getColorSpace();
            DecodeRasterOp decodeRasterOp = new DecodeRasterOp(decode, null);
            decodeRasterOp.filter(ycckRaster, (WritableRaster)ycckRaster);
            YCCKRasterOp ycckRasterOp = new YCCKRasterOp(null);
            ycckRasterOp.filter(ycckRaster, (WritableRaster)ycckRaster);
            ColorConvertOp cmykToRgb = new ColorConvertOp(DeviceCMYK.getIccCmykColorSpace(), rgbCS, null);
            cmykToRgb.filter(ycckRaster, rgbRaster);
            return rgbImage;
        }
        WritableRaster rgbRaster = rgbImage.getRaster();
        DecodeRasterOp decodeRasterOp = new DecodeRasterOp(decode, null);
        decodeRasterOp.filter(ycckRaster, (WritableRaster)ycckRaster);
        YCCKRasterOp ycckRasterOp = new YCCKRasterOp(null);
        ycckRasterOp.filter(ycckRaster, (WritableRaster)ycckRaster);
        CMYKRasterOp cmykRasterOp = new CMYKRasterOp(null);
        cmykRasterOp.filter(ycckRaster, rgbRaster);
        return rgbImage;
    }

    protected static BufferedImage makeImageWithRasterFromBytes(PColorSpace colourSpace, GraphicsState graphicsState, int width, int height, int colorSpaceCompCount, int bitsPerComponent, boolean imageMask, float[] decode, BufferedImage smaskImage, BufferedImage maskImage, int[] maskMinRGB, int[] maskMaxRGB, int maskMinIndex, int maskMaxIndex, byte[] data, int dataLength) {
        DataBufferByte db;
        ICCBased iccBased;
        BufferedImage img = null;
        if (colourSpace instanceof ICCBased && (iccBased = (ICCBased)colourSpace).getAlternate() != null) {
            colourSpace = iccBased.getAlternate();
        }
        if (colourSpace instanceof DeviceGray) {
            if (imageMask && bitsPerComponent == 1) {
                db = new DataBufferByte(data, dataLength);
                WritableRaster wr = Raster.createPackedRaster(db, width, height, bitsPerComponent, new Point(0, 0));
                boolean defaultDecode = decode[0] == 0.0f;
                int a = 0xFFFFFF;
                Color fill = graphicsState.getFillColor();
                int[] cmap = new int[]{defaultDecode ? fill.getRGB() : a, defaultDecode ? a : fill.getRGB()};
                int transparentIndex = defaultDecode ? 1 : 0;
                IndexColorModel icm = new IndexColorModel(bitsPerComponent, cmap.length, cmap, 0, true, transparentIndex, db.getDataType());
                img = new BufferedImage(icm, wr, false, null);
            } else if (bitsPerComponent == 1 || bitsPerComponent == 2 || bitsPerComponent == 4) {
                db = new DataBufferByte(data, dataLength);
                WritableRaster wr = Raster.createPackedRaster(db, width, height, bitsPerComponent, new Point(0, 0));
                int[] cmap = null;
                if (bitsPerComponent == 1) {
                    boolean defaultDecode = 0.0f == decode[0];
                    cmap = defaultDecode ? GRAY_1_BIT_INDEX_TO_RGB : GRAY_1_BIT_INDEX_TO_RGB_REVERSED;
                } else if (bitsPerComponent == 2) {
                    cmap = GRAY_2_BIT_INDEX_TO_RGB;
                } else if (bitsPerComponent == 4) {
                    cmap = GRAY_4_BIT_INDEX_TO_RGB;
                }
                IndexColorModel cm = new IndexColorModel(bitsPerComponent, cmap.length, cmap, 0, false, -1, db.getDataType());
                img = new BufferedImage(cm, wr, false, null);
            } else if (bitsPerComponent == 8) {
                img = ImageUtility.createCompatibleImage(width, height);
                int[] dataToRGB = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
                ImageUtility.copyDecodedStreamBytesIntoGray(data, dataToRGB, decode);
            }
        } else if (colourSpace instanceof DeviceRGB) {
            if (bitsPerComponent == 8) {
                boolean usingAlpha = smaskImage != null || maskImage != null || maskMinRGB != null && maskMaxRGB != null;
                int type = usingAlpha ? 2 : 1;
                img = new BufferedImage(width, height, type);
                int[] dataToRGB = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
                ImageUtility.copyDecodedStreamBytesIntoRGB(data, dataToRGB);
                if (usingAlpha) {
                    img = ImageUtility.alterBufferedImageAlpha(img, maskMinRGB, maskMaxRGB);
                }
            }
        } else if (!(colourSpace instanceof DeviceCMYK)) {
            if (colourSpace instanceof Indexed) {
                Color[] colors;
                if (bitsPerComponent == 1 || bitsPerComponent == 2 || bitsPerComponent == 4) {
                    boolean usingAlpha;
                    colourSpace.init();
                    colors = ((Indexed)colourSpace).accessColorTable();
                    int[] cmap = new int[colors == null ? 0 : colors.length];
                    for (int i = 0; i < cmap.length; ++i) {
                        cmap[i] = colors[i].getRGB();
                    }
                    int cmapMaxLength = 1 << bitsPerComponent;
                    if (cmap.length > cmapMaxLength) {
                        int[] cmapTruncated = new int[cmapMaxLength];
                        System.arraycopy(cmap, 0, cmapTruncated, 0, cmapMaxLength);
                        cmap = cmapTruncated;
                    }
                    boolean usingIndexedAlpha = maskMinIndex >= 0 && maskMaxIndex >= 0;
                    boolean bl = usingAlpha = smaskImage != null || maskImage != null || maskMinRGB != null && maskMaxRGB != null;
                    if (usingAlpha) {
                        DataBufferByte db2 = new DataBufferByte(data, dataLength);
                        WritableRaster wr = Raster.createPackedRaster(db2, width, height, bitsPerComponent, new Point(0, 0));
                        IndexColorModel cm = new IndexColorModel(bitsPerComponent, cmap.length, cmap, 0, true, -1, db2.getDataType());
                        img = new BufferedImage(cm, wr, false, null);
                        img = ImageUtility.alterBufferedImageAlpha(img, maskMinRGB, maskMaxRGB);
                    } else {
                        DataBufferByte db3 = new DataBufferByte(data, dataLength);
                        WritableRaster wr = Raster.createPackedRaster(db3, width, height, bitsPerComponent, new Point(0, 0));
                        IndexColorModel cm = new IndexColorModel(bitsPerComponent, cmap.length, cmap, 0, false, -1, db3.getDataType());
                        img = new BufferedImage(cm, wr, false, null);
                    }
                } else if (bitsPerComponent == 8) {
                    boolean usingAlpha;
                    int i;
                    colourSpace.init();
                    colors = ((Indexed)colourSpace).accessColorTable();
                    int colorsLength = colors == null ? 0 : colors.length;
                    int[] cmap = new int[256];
                    for (i = 0; i < colorsLength; ++i) {
                        cmap[i] = colors[i].getRGB();
                    }
                    for (i = colorsLength; i < cmap.length; ++i) {
                        cmap[i] = -16777216;
                    }
                    boolean usingIndexedAlpha = maskMinIndex >= 0 && maskMaxIndex >= 0;
                    boolean bl = usingAlpha = smaskImage != null || maskImage != null || maskMinRGB != null && maskMaxRGB != null;
                    if (usingIndexedAlpha) {
                        for (int i2 = maskMinIndex; i2 <= maskMaxIndex; ++i2) {
                            cmap[i2] = 0;
                        }
                        DataBufferByte db4 = new DataBufferByte(data, dataLength);
                        PixelInterleavedSampleModel sm = new PixelInterleavedSampleModel(db4.getDataType(), width, height, 1, width, new int[]{0});
                        WritableRaster wr = Raster.createWritableRaster(sm, db4, new Point(0, 0));
                        IndexColorModel cm = new IndexColorModel(bitsPerComponent, cmap.length, cmap, 0, true, -1, db4.getDataType());
                        img = new BufferedImage(cm, wr, false, null);
                    } else if (usingAlpha) {
                        int[] rgbaData = new int[width * height];
                        int max = rgbaData.length;
                        for (int index = 0; index < max; ++index) {
                            int cmapIndex = data[index] & 0xFF;
                            rgbaData[index] = cmap[cmapIndex];
                        }
                        DataBufferInt db5 = new DataBufferInt(rgbaData, rgbaData.length);
                        int[] masks = new int[]{0xFF0000, 65280, 255, -16777216};
                        WritableRaster wr = Raster.createPackedRaster(db5, width, height, width, masks, new Point(0, 0));
                        ColorSpace cs = ColorSpace.getInstance(1000);
                        DirectColorModel cm = new DirectColorModel(cs, 32, 0xFF0000, 65280, 255, -16777216, false, db5.getDataType());
                        img = new BufferedImage(cm, wr, false, null);
                    } else {
                        DataBufferByte db6 = new DataBufferByte(data, dataLength);
                        PixelInterleavedSampleModel sm = new PixelInterleavedSampleModel(db6.getDataType(), width, height, 1, width, new int[]{0});
                        WritableRaster wr = Raster.createWritableRaster(sm, db6, new Point(0, 0));
                        IndexColorModel cm = new IndexColorModel(bitsPerComponent, cmap.length, cmap, 0, false, -1, db6.getDataType());
                        img = new BufferedImage(cm, wr, false, null);
                    }
                }
            } else if ((colourSpace instanceof Separation || colourSpace instanceof CalGray) && (colourSpace instanceof CalGray || ((Separation)colourSpace).isNamedColor())) {
                db = new DataBufferByte(data, dataLength);
                WritableRaster wr = Raster.createPackedRaster(db, width, height, bitsPerComponent, new Point(0, 0));
                int[] cmap = null;
                if (bitsPerComponent == 1) {
                    cmap = GRAY_1_BIT_INDEX_TO_RGB;
                } else if (bitsPerComponent == 2) {
                    cmap = GRAY_2_BIT_INDEX_TO_RGB;
                } else if (bitsPerComponent == 4) {
                    cmap = GRAY_4_BIT_INDEX_TO_RGB;
                } else if (bitsPerComponent == 8) {
                    return null;
                }
                IndexColorModel cm = new IndexColorModel(bitsPerComponent, cmap.length, cmap, 0, false, -1, db.getDataType());
                img = new BufferedImage(cm, wr, false, null);
            }
        }
        return img;
    }

    private static void copyDecodedStreamBytesIntoRGB(byte[] data, int[] pixels) {
        byte[] rgb = new byte[3];
        try {
            ByteArrayInputStream input = new ByteArrayInputStream(data);
            for (int pixelIndex = 0; pixelIndex < pixels.length; ++pixelIndex) {
                int haveRead;
                int currRead;
                int argb = -16777216;
                int toRead = 3;
                for (haveRead = 0; haveRead < 3 && (currRead = ((InputStream)input).read(rgb, haveRead, 3 - haveRead)) >= 0; haveRead += currRead) {
                }
                if (haveRead >= 1) {
                    argb |= rgb[0] << 16 & 0xFF0000;
                }
                if (haveRead >= 2) {
                    argb |= rgb[1] << 8 & 0xFF00;
                }
                if (haveRead >= 3) {
                    argb |= rgb[2] & 0xFF;
                }
                pixels[pixelIndex] = argb;
            }
            ((InputStream)input).close();
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Problem copying decoding stream bytes: ", e);
        }
    }

    private static void copyDecodedStreamBytesIntoGray(byte[] data, int[] pixels, float[] decode) {
        byte[] rgb = new byte[1];
        boolean defaultDecode = 0.0f == decode[0];
        try {
            ByteArrayInputStream input = new ByteArrayInputStream(data);
            for (int pixelIndex = 0; pixelIndex < pixels.length; ++pixelIndex) {
                int currRead;
                int argb = -16777216;
                boolean toRead = true;
                for (int haveRead = 0; haveRead < 1 && (currRead = ((InputStream)input).read(rgb, haveRead, 1 - haveRead)) >= 0; haveRead += currRead) {
                }
                int Y = rgb[0] & 0xFF;
                Y = defaultDecode ? Y : 255 - Y;
                argb |= Y << 16 & 0xFF0000;
                argb |= Y << 8 & 0xFF00;
                pixels[pixelIndex] = argb |= Y & 0xFF;
            }
            ((InputStream)input).close();
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Problem copying decoding stream bytes: ", e);
        }
    }

    public static BufferedImage createBufferedImage(Image imageIn) {
        return ImageUtility.createBufferedImage(imageIn, 2);
    }

    public static BufferedImage createBufferedImage(Image imageIn, int imageType) {
        BufferedImage bufferedImageOut = new BufferedImage(imageIn.getWidth(null), imageIn.getHeight(null), imageType);
        Graphics g = bufferedImageOut.getGraphics();
        g.drawImage(imageIn, 0, 0, null);
        imageIn.flush();
        return bufferedImageOut;
    }

    public static BufferedImage[] scaleImagesToSameSize(BufferedImage baseImage, BufferedImage maskImage) {
        if (scaleQuality) {
            int width = baseImage.getWidth();
            int height = baseImage.getHeight();
            WritableRaster maskRaster = maskImage.getRaster();
            int maskWidth = maskRaster.getWidth();
            int maskHeight = maskRaster.getHeight();
            if (width < maskWidth || height < maskHeight) {
                double scaleX = (double)maskWidth / (double)width;
                double scaleY = (double)maskHeight / (double)height;
                AffineTransform tx = new AffineTransform();
                tx.scale(scaleX, scaleY);
                AffineTransformOp op = new AffineTransformOp(tx, 1);
                BufferedImage bim = op.filter(baseImage, null);
                baseImage.flush();
                baseImage = bim;
            } else if (width > maskWidth || height > maskHeight) {
                double scaleX = (double)width / (double)maskWidth;
                double scaleY = (double)height / (double)maskHeight;
                AffineTransform tx = new AffineTransform();
                tx.scale(scaleX, scaleY);
                AffineTransformOp op = new AffineTransformOp(tx, 1);
                BufferedImage bim = op.filter(maskImage, null);
                maskImage.flush();
                maskImage = bim;
            }
            return new BufferedImage[]{baseImage, maskImage};
        }
        int width = baseImage.getWidth();
        int height = baseImage.getHeight();
        WritableRaster maskRaster = maskImage.getRaster();
        int maskWidth = maskRaster.getWidth();
        int maskHeight = maskRaster.getHeight();
        if (width < maskWidth || height < maskHeight) {
            double scaleX = (double)width / (double)maskWidth;
            double scaleY = (double)height / (double)maskHeight;
            AffineTransform tx = new AffineTransform();
            tx.scale(scaleX, scaleY);
            AffineTransformOp op = new AffineTransformOp(tx, 1);
            BufferedImage bim = op.filter(maskImage, null);
            maskImage.flush();
            maskImage = bim;
        }
        return new BufferedImage[]{baseImage, maskImage};
    }

    static {
        configuration = null;
        try {
            configuration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        scaleQuality = Defs.booleanProperty("org.icepdf.core.imageMaskScale.quality", true);
    }
}

