/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.pobjects.fonts.FontFile;
import org.icepdf.core.pobjects.security.SecurityManager;
import org.icepdf.core.util.Utils;

public class HexStringObject
implements StringObject {
    private static Logger logger = Logger.getLogger(HexStringObject.class.toString());
    private StringBuilder stringData;
    Reference reference;

    public HexStringObject(byte[] bytes) {
        this(new StringBuilder(bytes.length).append(new String(bytes)));
    }

    public HexStringObject(StringBuilder stringBuffer) {
        stringBuffer.deleteCharAt(0);
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        this.stringData = new StringBuilder(stringBuffer.length());
        this.stringData.append(HexStringObject.normalizeHex(stringBuffer, 2).toString());
    }

    public HexStringObject(String string) {
        this.stringData = new StringBuilder(string.length());
        this.stringData.append(HexStringObject.normalizeHex(new StringBuilder(string), 2).toString());
    }

    public HexStringObject(String string, Reference reference, SecurityManager securityManager) {
        this.reference = reference;
        this.stringData = new StringBuilder(this.encryption(Utils.convertByteArrayToHexString(string.getBytes(), false), false, securityManager));
    }

    public int getUnsignedInt(int start, int offset) {
        int unsignedInt;
        block3: {
            if (start < 0 || this.stringData.length() < start + offset) {
                return 0;
            }
            unsignedInt = 0;
            try {
                unsignedInt = Integer.parseInt(this.stringData.substring(start, start + offset), 16);
            }
            catch (NumberFormatException e) {
                if (!logger.isLoggable(Level.FINER)) break block3;
                logger.finer("Number Format Exception " + unsignedInt);
            }
        }
        return unsignedInt;
    }

    public int getUnsignedInt(String data) {
        int unsignedInt;
        block2: {
            unsignedInt = 0;
            try {
                unsignedInt = Integer.parseInt(data, 16);
            }
            catch (NumberFormatException e) {
                if (!logger.isLoggable(Level.FINER)) break block2;
                logger.finer("Number Format Exception " + unsignedInt);
            }
        }
        return unsignedInt;
    }

    public String toString() {
        return this.getLiteralString();
    }

    public String getHexString() {
        return this.stringData.toString();
    }

    public StringBuilder getHexStringBuffer() {
        return this.stringData;
    }

    public StringBuilder getLiteralStringBuffer() {
        return this.hexToString(this.stringData);
    }

    public String getLiteralString() {
        return this.hexToString(this.stringData).toString();
    }

    public StringBuilder getLiteralStringBuffer(int fontFormat, FontFile font) {
        if (fontFormat == 1) {
            this.stringData = new StringBuilder(HexStringObject.normalizeHex(this.stringData, 2).toString());
            int charOffset = 2;
            int length = this.getLength();
            StringBuilder tmp = new StringBuilder(length);
            int lastIndex = 0;
            for (int i = 0; i < length; i += charOffset) {
                int offset = lastIndex + charOffset;
                int charValue = this.getUnsignedInt(i - lastIndex, offset);
                if ((offset >= length || charValue != 0) && font.canDisplayEchar((char)charValue)) {
                    tmp.append((char)charValue);
                    lastIndex = 0;
                    continue;
                }
                lastIndex += charOffset;
            }
            return tmp;
        }
        if (fontFormat == 2) {
            this.stringData = new StringBuilder(HexStringObject.normalizeHex(this.stringData, 4).toString());
            int charOffset = 2;
            int length = this.getLength();
            StringBuilder tmp = new StringBuilder(length);
            for (int i = 0; i < length; i += charOffset) {
                int charValue;
                String first = this.stringData.substring(i, i + 2);
                if (first.charAt(0) != '0') {
                    charValue = this.getUnsignedInt(first);
                    if (font.getByteEncoding() == FontFile.ByteEncoding.MIXED_BYTE && font.canDisplayEchar((char)charValue) && font.getSource() != null) {
                        tmp.append((char)charValue);
                        continue;
                    }
                    charValue = this.getUnsignedInt(i, 4);
                    if (!font.canDisplayEchar((char)charValue)) continue;
                    tmp.append((char)charValue);
                    i += 2;
                    continue;
                }
                charValue = this.getUnsignedInt(i, 4);
                if (!font.canDisplayEchar((char)charValue)) continue;
                tmp.append((char)charValue);
                i += 2;
            }
            return tmp;
        }
        return null;
    }

    public int getLength() {
        return this.stringData.length();
    }

    private static StringBuilder normalizeHex(StringBuilder hex, int step) {
        int length = hex.length();
        for (int i = 0; i < length; ++i) {
            if (!HexStringObject.isNoneHexChar(hex.charAt(i))) continue;
            hex.deleteCharAt(i);
            --length;
            --i;
        }
        length = hex.length();
        if (step == 2 && length % 2 != 0) {
            hex.append('0');
        }
        if (step == 4 && length % 4 != 0) {
            hex.append("00");
        }
        return hex;
    }

    private static boolean isNoneHexChar(char c) {
        return !(c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f');
    }

    private StringBuilder hexToString(StringBuilder hh) {
        if (hh != null && hh.length() == 0) {
            return new StringBuilder();
        }
        if (!(hh.charAt(0) == 'F' | hh.charAt(0) == 'f' && hh.charAt(1) == 'E' | hh.charAt(1) == 'e' && hh.charAt(2) == 'F' | hh.charAt(2) == 'f' && hh.charAt(3) == 'F' | hh.charAt(3) == 'f')) {
            int length = hh.length();
            StringBuilder sb = new StringBuilder(length / 2);
            for (int i = 0; i < length; i += 2) {
                String subStr = hh.substring(i, i + 2);
                sb.append((char)Integer.parseInt(subStr, 16));
            }
            return sb;
        }
        int length = hh.length();
        StringBuilder sb = new StringBuilder(length / 4);
        for (int i = 0; i < length; i += 4) {
            String subStr = hh.substring(i, i + 4);
            sb.append((char)Integer.parseInt(subStr, 16));
        }
        return sb;
    }

    public void setReference(Reference reference) {
        this.reference = reference;
    }

    public Reference getReference() {
        return this.reference;
    }

    public String getDecryptedLiteralString(SecurityManager securityManager) {
        if (securityManager != null && this.reference != null) {
            byte[] key = securityManager.getDecryptionKey();
            byte[] textBytes = Utils.convertByteCharSequenceToByteArray(this.getLiteralString());
            textBytes = securityManager.decrypt(this.reference, key, textBytes);
            return Utils.convertByteArrayToByteString(textBytes);
        }
        return this.getLiteralString();
    }

    public String encryption(String string, boolean decrypt, SecurityManager securityManager) {
        if (securityManager != null && this.reference != null) {
            byte[] key = securityManager.getDecryptionKey();
            byte[] textBytes = Utils.convertByteCharSequenceToByteArray(string);
            textBytes = decrypt ? securityManager.decrypt(this.reference, key, textBytes) : securityManager.encrypt(this.reference, key, textBytes);
            return Utils.convertByteArrayToByteString(textBytes);
        }
        return string;
    }
}

