/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.windows;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicArrowButton;

final class WindowsArrowButton
extends BasicArrowButton {
    public WindowsArrowButton(int direction) {
        super(direction);
    }

    @Override
    public Dimension getPreferredSize() {
        int width = Math.max(5, UIManager.getInt("ScrollBar.width"));
        return new Dimension(width, width);
    }

    @Override
    public void paintTriangle(Graphics g, int x, int y, int size, int triangleDirection, boolean enabled) {
        Color oldColor = g.getColor();
        int j = 0;
        size = Math.max(size, 2);
        int mid = (size - 1) / 2;
        g.translate(x, y);
        g.setColor(UIManager.getColor(enabled ? "controlText" : "controlShadow"));
        switch (triangleDirection) {
            case 1: {
                int i = 0;
                while (i < size) {
                    g.drawLine(mid - i, i, mid + i, i);
                    ++i;
                }
                if (enabled) break;
                g.setColor(UIManager.getColor("controlLtHighlight"));
                g.drawLine(mid - i + 2, i, mid + i, i);
                break;
            }
            case 5: {
                int i;
                if (!enabled) {
                    g.translate(1, 1);
                    g.setColor(UIManager.getColor("controlLtHighlight"));
                    i = size - 1;
                    while (i >= 0) {
                        g.drawLine(mid - i, j, mid + i, j);
                        ++j;
                        --i;
                    }
                    g.translate(-1, -1);
                    g.setColor(UIManager.getColor("controlShadow"));
                }
                j = 0;
                i = size - 1;
                while (i >= 0) {
                    g.drawLine(mid - i, j, mid + i, j);
                    ++j;
                    --i;
                }
                break;
            }
            case 7: {
                int i = 0;
                while (i < size) {
                    g.drawLine(i, mid - i, i, mid + i);
                    ++i;
                }
                if (enabled) break;
                g.setColor(UIManager.getColor("controlLtHighlight"));
                g.drawLine(i, mid - i + 2, i, mid + i);
                break;
            }
            case 3: {
                int i;
                if (!enabled) {
                    g.translate(1, 1);
                    g.setColor(UIManager.getColor("controlLtHighlight"));
                    i = size - 1;
                    while (i >= 0) {
                        g.drawLine(j, mid - i, j, mid + i);
                        ++j;
                        --i;
                    }
                    g.translate(-1, -1);
                    g.setColor(UIManager.getColor("controlShadow"));
                }
                j = 0;
                i = size - 1;
                while (i >= 0) {
                    g.drawLine(j, mid - i, j, mid + i);
                    ++j;
                    --i;
                }
                break;
            }
        }
        g.translate(-x, -y);
        g.setColor(oldColor);
    }
}

