/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.synthetica.simple2d.iconpainter;

import de.javasoft.plaf.synthetica.painter.SyntheticaBasicIconPainter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import javax.swing.JComponent;
import javax.swing.plaf.synth.SynthContext;

public class MenuArrowIconPainter
extends SyntheticaBasicIconPainter {
    private static final boolean JAVA5 = System.getProperty("java.version").startsWith("1.5.");

    public MenuArrowIconPainter() {
        super(null, 5, 9);
    }

    public void paint2D(SynthContext sc, Graphics2D g, float x, float y, float w, float h) {
        JComponent c = sc == null ? null : sc.getComponent();
        boolean ltr = c == null ? true : c.getComponentOrientation().isLeftToRight();
        Shape shape = this.createShape(0.0f, 0.0f, w, h, JAVA5 ? ltr : true);
        if (sc != null && (sc.getComponentState() & 8) > 0) {
            g.setPaint(new Color(0xA0A0A0));
        } else if (sc != null && (sc.getComponentState() & 0x200) > 0) {
            g.setPaint(new Color(0xFFFFFF));
        } else {
            g.setPaint(new Color(0x606060));
        }
        g.fill(shape);
        g.draw(shape);
    }

    private Shape createShape(float x, float y, float w, float h, boolean ltr) {
        GeneralPath path = new GeneralPath();
        if (ltr) {
            path.moveTo(x, y);
            path.lineTo(x + w, y + h / 2.0f);
            path.lineTo(x, y + h);
        } else {
            path.moveTo(x + w, y);
            path.lineTo(x, y + h / 2.0f);
            path.lineTo(x + w, y + h);
        }
        path.closePath();
        return path;
    }
}

