/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.synthetica.simple2d.iconpainter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.painter.SyntheticaBasicIconPainter;
import de.javasoft.synthetica.simple2d.SyntheticaSimple2DLookAndFeel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.plaf.synth.SynthContext;

public class CheckBoxIconPainter
extends SyntheticaBasicIconPainter {
    private final float ARC = 3.0f;

    public CheckBoxIconPainter() {
        super(null, 14, 14);
    }

    public void paint2D(SynthContext sc, Graphics2D g2, float x, float y, float w, float h) {
        Color syntheticaBackground;
        boolean disabled = (sc.getComponentState() & 8) > 0;
        boolean pressed = (sc.getComponentState() & 4) > 0;
        boolean selected = (sc.getComponentState() & 0x200) > 0;
        boolean focused = (sc.getComponentState() & 0x100) > 0 || sc.getComponent().hasFocus();
        boolean hover = (sc.getComponentState() & 2) > 0;
        Shape shape = this.createShape(0.0f, 0.0f, w, h, 3.0f);
        if (disabled) {
            g2.setPaint(new Color(0x19FFFFFF, true));
        } else if (pressed && selected) {
            g2.setPaint(this.createLinearGradientPaint(0.0f, 0.0f, 0.0f, h, new float[]{0.0f, 1.0f}, new Color[]{new Color(0x808080), new Color(0xAAAAAA)}));
        } else if (pressed) {
            g2.setPaint(this.createLinearGradientPaint(0.0f, 0.0f, 0.0f, h, new float[]{0.0f, 1.0f}, new Color[]{new Color(0xAAAAAA), new Color(0xCCCCCC)}));
        } else if (selected) {
            g2.setPaint(this.createLinearGradientPaint(0.0f, 0.0f, 0.0f, h, new float[]{0.0f, 1.0f}, new Color[]{new Color(0xAAAAAA), new Color(0xC0C0C0)}));
        } else {
            g2.setPaint(this.createLinearGradientPaint(0.0f, 0.0f, 0.0f, h, new float[]{0.0f, 0.5f, 0.75f, 1.0f}, new Color[]{new Color(0xFCFCFC), new Color(0xF0F0F0), new Color(0xE8E8E8), new Color(0xDCDCDC)}));
        }
        g2.fill(CheckBoxIconPainter.subtractStroke((Graphics2D)g2, (Shape)shape));
        if (disabled) {
            g2.setPaint(new Color(0x2E000000, true));
        } else if (pressed && selected) {
            g2.setPaint(new GradientPaint(0.0f, 0.0f, new Color(0x7F000000, true), 0.0f, h, new Color(0x4C000000, true)));
        } else if (pressed) {
            g2.setPaint(new GradientPaint(0.0f, 0.0f, new Color(0x4C000000, true), 0.0f, h, new Color(0x33000000, true)));
        } else if (selected) {
            g2.setPaint(new GradientPaint(0.0f, 0.0f, new Color(0x4C000000, true), 0.0f, h, new Color(0x7F000000, true)));
        } else {
            g2.setPaint(new GradientPaint(0.0f, 0.0f, new Color(0x33000000, true), 0.0f, h, new Color(0x4C000000, true)));
        }
        g2.draw(shape);
        boolean paintFocus = (Boolean)SyntheticaLookAndFeel.getClientProperty((String)"Synthetica.paintFocus", (JComponent)sc.getComponent(), (Object)true);
        if (focused && ((AbstractButton)sc.getComponent()).isFocusPainted() && paintFocus) {
            float strokeWidth = 2.0f;
            shape = this.createShape((strokeWidth - 1.0f) / 2.0f, (strokeWidth - 1.0f) / 2.0f, w - strokeWidth + 1.0f, h - strokeWidth + 1.0f, 3.0f - strokeWidth + 1.0f);
            g2.setStroke(new BasicStroke(strokeWidth));
            g2.setPaint(SyntheticaSimple2DLookAndFeel.getFocusColor());
            g2.draw(shape);
        }
        if (selected) {
            shape = this.createSelectedShape(0.0f, 0.0f, w, h);
            if (disabled) {
                g2.setPaint(new Color(0xA0A0A0));
            } else if (pressed) {
                g2.setPaint(new Color(0xF0F0F0));
            } else {
                g2.setPaint(Color.WHITE);
            }
            BasicStroke stroke = new BasicStroke(2.0f, 1, 1);
            g2.setStroke(stroke);
            g2.draw(shape);
        }
        if (hover) {
            shape = this.createShape(0.0f, 0.0f, w, h, 3.0f);
            g2.setPaint(SyntheticaSimple2DLookAndFeel.getHoverColor());
            g2.fill(CheckBoxIconPainter.subtractStroke((Graphics2D)g2, (Shape)shape));
        }
        if ((syntheticaBackground = this.getSyntheticaBackgroundColor(sc.getComponent())) != null) {
            shape = this.createShape(0.0f, 0.0f, w, h, 3.0f);
            g2.setPaint(syntheticaBackground);
            g2.fill(CheckBoxIconPainter.subtractStroke((Graphics2D)g2, (Shape)shape));
        }
    }

    private Shape createShape(float x, float y, float w, float h, float arc) {
        return new RoundRectangle2D.Float(x, y, w, h, arc, arc);
    }

    protected Shape createSelectedShape(float x, float y, float w, float h) {
        GeneralPath path = new GeneralPath();
        path.moveTo(x + 0.2f * w, y + 0.55f * h);
        path.lineTo(x + 0.4f * w, y + 0.75f * h);
        path.lineTo(x + 0.825f * w, y + 0.275f * h);
        return path;
    }
}

