/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.synthetica.simple2d;

import de.javasoft.plaf.synthetica.SyntheticaState;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;

public class ToolBarHandlePainter
extends de.javasoft.plaf.synthetica.painter.ToolBarHandlePainter {
    public void paintHandle(JComponent c, SyntheticaState state, int orientation, Graphics g, int x, int y, int w, int h) {
        Graphics2D g2 = (Graphics2D)g;
        int bumpSize = (int)(3.0f * this.getScale());
        int bumpGap = (int)(3.0f * this.getScale());
        int size = bumpSize + bumpGap;
        int bumps = orientation == 0 ? (h + bumpGap) / size : (w + bumpGap) / size;
        float x_ = orientation == 0 ? x + w / 2 - bumpSize / 2 : x + (w - bumps * size + bumpGap + 1) / 2;
        float y_ = orientation == 0 ? y + (h - bumps * size + bumpGap + 1) / 2 : y + h / 2 - bumpSize / 2;
        int i = 0;
        while (i < bumps) {
            this.paintBump(g2, x_, y_, bumpSize);
            x_ += (float)(orientation == 0 ? 0 : size);
            y_ += (float)(orientation == 0 ? size : 0);
            ++i;
        }
    }

    private void paintBump(Graphics2D g2, float x, float y, float bumpSize) {
        float scale = this.getScale();
        Shape s = this.createShape(x, y, bumpSize - scale, bumpSize - scale);
        g2.setPaint(new Color(0xD2D2D2));
        g2.fill(s);
        s = this.createShape(x, y + bumpSize - scale, bumpSize - scale, scale);
        g2.setPaint(new Color(0xFFFFFF));
        g2.fill(s);
        s = this.createShape(x + bumpSize - scale, y, scale, bumpSize);
        g2.setPaint(this.createLinearGradientPaint(x, y, x, y + bumpSize - 1.0f, new float[]{0.67f, 0.671f}, new Color[]{new Color(0xFFFFFF), new Color(0xFFFFFF)}));
        g2.fill(s);
    }

    private Shape createShape(float x, float y, float w, float h) {
        return new Rectangle2D.Float(x, y, w, h);
    }
}

