/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.synthetica.simple2d;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.text.JTextComponent;

class TextComponentPainter {
    static final int TC_ENABLED_BACKGROUND1 = 552332267;
    static final int TC_ENABLED_BACKGROUND2 = 553384955;
    static final int TC_ENABLED_BACKGROUND3 = 0x20FFFFFF;
    static final int TC_DISABLED_BACKGROUND = 0xEFEFEF;
    static final int TC_LOCKED_BACKGROUND1 = 1893720031;
    static final int TC_LOCKED_BACKGROUND2 = 0x70E7E7E7;
    static final boolean MODIFY_CUSTOM_BACKGROUND = false;

    TextComponentPainter() {
    }

    static void fill(SynthContext sc, Shape shape, Graphics2D g2, float x, float y, float w, float h) {
        boolean defaultBackground;
        float y_;
        boolean multiLine;
        JComponent c = sc.getComponent();
        if (!SyntheticaLookAndFeel.isOpaque((JComponent)c)) {
            return;
        }
        Border border = c.getBorder();
        Border defaultBorder = SyntheticaLookAndFeel.findDefaultBorder((Border)border);
        boolean defaultBorderIsSynth = defaultBorder == null ? false : defaultBorder.getClass().getName().equals("javax.swing.plaf.synth.SynthBorder");
        boolean innerBorderIsDefault = border instanceof CompoundBorder && ((CompoundBorder)border).getInsideBorder() == defaultBorder;
        boolean inScrollPane = c.getParent() instanceof JViewport;
        boolean opaque = SyntheticaLookAndFeel.isOpaque((JComponent)c);
        boolean bl = multiLine = c instanceof JTextArea || c instanceof JTextPane || c instanceof JEditorPane;
        if (!opaque || multiLine && inScrollPane) {
            return;
        }
        Insets insets = c.getInsets();
        if (multiLine || border == null) {
            new Rectangle2D.Float(x, y, w, h);
        } else if (!defaultBorderIsSynth) {
            BasicStroke stroke = (BasicStroke)g2.getStroke();
            float offset = stroke.getLineWidth() / 2.0f;
            float x_ = x + (float)insets.left - offset;
            float y_2 = x + (float)insets.top - offset;
            float w_ = w - (float)insets.left - (float)insets.right;
            float h_ = h - (float)insets.top - (float)insets.bottom;
            shape = new Rectangle2D.Float(x_, y_2, w_, h_);
        } else if (innerBorderIsDefault) {
            Insets ins_ = defaultBorder.getBorderInsets(c);
            float x_ = x + (float)insets.left - (float)ins_.left;
            y_ = y + (float)insets.top - (float)ins_.top;
            float w_ = w - (float)(insets.left - ins_.left + insets.right - ins_.right);
            float h_ = h - (float)(insets.top - ins_.top + insets.bottom - ins_.bottom);
            AffineTransform at = new AffineTransform();
            at.translate(x_, y_);
            at.scale(w_ / w, h_ / h);
            g2.transform(at);
        }
        Color background = c.getBackground();
        boolean bl2 = defaultBackground = background == null || background instanceof UIResource;
        if (!defaultBackground) {
            g2.setPaint(background);
            g2.fill(shape);
            return;
        }
        if ((sc.getComponentState() & 8) > 0) {
            g2.setPaint(new Color(0xEFEFEF));
        } else {
            float f = y_ = multiLine ? 4.0f / h : 0.25f;
            if (c instanceof JTextComponent) {
                JTextComponent tc = (JTextComponent)c;
                boolean isInScrollPane = c.getParent() instanceof JViewport;
                if (!tc.isEditable() && !isInScrollPane) {
                    g2.setPaint(SyntheticaLookAndFeel.createLinearGradientPaint((float)0.0f, (float)y, (float)0.0f, (float)(y + h - 1.0f), (float[])new float[]{0.0f, y_, 1.0f}, (Color[])new Color[]{new Color(1893720031, !defaultBackground), new Color(0x70E7E7E7, !defaultBackground), new Color(0x70E7E7E7, !defaultBackground)}));
                } else if (!tc.isEditable() && isInScrollPane) {
                    g2.setPaint(new Color(0x70E7E7E7, !defaultBackground));
                } else if (tc.isEditable() && !isInScrollPane) {
                    g2.setPaint(SyntheticaLookAndFeel.createLinearGradientPaint((float)0.0f, (float)y, (float)0.0f, (float)(y + h - 1.0f), (float[])new float[]{0.0f, y_, 1.0f}, (Color[])new Color[]{new Color(552332267, !defaultBackground), new Color(553384955, !defaultBackground), new Color(0x20FFFFFF, !defaultBackground)}));
                } else if (tc.isEditable() && isInScrollPane) {
                    g2.setPaint(SyntheticaLookAndFeel.createLinearGradientPaint((float)0.0f, (float)y, (float)0.0f, (float)(y + h - 1.0f), (float[])new float[]{0.0f, 1.0f}, (Color[])new Color[]{new Color(553384955, !defaultBackground), new Color(0x20FFFFFF, !defaultBackground)}));
                }
            } else {
                g2.setPaint(SyntheticaLookAndFeel.createLinearGradientPaint((float)0.0f, (float)y, (float)0.0f, (float)(y + h - 1.0f), (float[])new float[]{0.0f, y_, 1.0f}, (Color[])new Color[]{new Color(552332267, !defaultBackground), new Color(553384955, !defaultBackground), new Color(0x20FFFFFF, !defaultBackground)}));
            }
        }
        g2.fill(shape);
    }

    static void draw(SynthContext sc, Shape shape, Graphics2D g2, float x, float y, float w, float h) {
        if (!SyntheticaLookAndFeel.isOpaque((JComponent)sc.getComponent())) {
            return;
        }
        if ((sc.getComponentState() & 8) > 0) {
            g2.setPaint(new Color(0x2E000000, true));
        } else {
            g2.setPaint(new GradientPaint(x, y, new Color(0x33000000, true), x, y + h - 1.0f, new Color(0x19000000, true)));
        }
        g2.draw(shape);
    }
}

