/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.synthetica.simple2d;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.synthetica.simple2d.SyntheticaSimple2DLookAndFeel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.SynthContext;

public class TabbedPanePainter
extends de.javasoft.plaf.synthetica.painter.TabbedPanePainter {
    private static final float TAB_ARC = 8.0f;
    private static final float CONTENT_ARC = 10.0f;

    public void paintTabbedPaneBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        boolean innerBorderIsDefault;
        JComponent c = sc.getComponent();
        Border border = c.getBorder();
        Border defaultBorder = SyntheticaLookAndFeel.findDefaultBorder((Border)border);
        if (defaultBorder == null) {
            return;
        }
        boolean bl = innerBorderIsDefault = border instanceof CompoundBorder && ((CompoundBorder)border).getInsideBorder() == defaultBorder;
        if (innerBorderIsDefault) {
            Insets ins = border.getBorderInsets(c);
            Insets ins_ = defaultBorder.getBorderInsets(c);
            x += ins.left - ins_.left;
            y += ins.top - ins_.top;
            w -= ins.left - ins_.left + ins.right - ins_.right;
            h -= ins.top - ins_.top + ins.bottom - ins_.bottom;
        }
    }

    public void paintTabbedPaneBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
    }

    public void paintTabbedPaneContentBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
    }

    public void paintTabbedPaneContentBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        JTabbedPane tabbedPane = (JTabbedPane)sc.getComponent();
        this.modifyChildOpacity(sc);
        this.paintTabbedPaneContentBorder(tabbedPane, new SyntheticaState(sc.getComponentState()), tabbedPane.getTabPlacement(), true, g, x, y, w, h);
    }

    public void paintTabbedPaneContentBorder(JComponent c, SyntheticaState state, int placement, boolean gap4SelectedTab, Graphics g, int x, int y, int w, int h) {
        this.paintTabbedPaneContentBorder(c, state, placement, gap4SelectedTab, 0, g, x, y, w, h);
    }

    public void paintTabbedPaneContentBorder(JComponent c, SyntheticaState state, int placement, boolean gap4SelectedTab, int angle, Graphics g, int x, int y, int w, int h) {
        Graphics2D g2 = this.prepareGraphics2D(null, g, x, y, true);
        Shape shape = this.createContentShape(0.0f, 0.0f, TabbedPanePainter.calcRelativeLength((Graphics2D)g2, (float)w, (float)0.0f), TabbedPanePainter.calcRelativeLength((Graphics2D)g2, (float)h, (float)0.0f), this.scaleArc(10.0f));
        g2.setPaint(new Color(0x66000000, true));
        g2.draw(shape);
        if (gap4SelectedTab && c instanceof JTabbedPane && !SyntheticaLookAndFeel.getBoolean((String)"Synthetica.tabbedPane.tab.selected.paintOverContentBorder.disabled", (Component)c)) {
            this.drawContentBorderLine4SelectedTab((JTabbedPane)c, placement, angle, g2, x, y, w, h);
        }
        this.restoreGraphics2D(g2);
    }

    private void drawContentBorderLine4SelectedTab(JTabbedPane tabbedPane, int placement, int angle, Graphics2D g2, int x, int y, int w, int h) {
        int selectedTabIndex = tabbedPane.getSelectedIndex();
        if (selectedTabIndex == -1 || SyntheticaLookAndFeel.get((String)"Synthetica.tabbedPane.rotateTabRuns", (Component)tabbedPane) != null && !SyntheticaLookAndFeel.getBoolean((String)"Synthetica.tabbedPane.rotateTabRuns", (Component)tabbedPane) && this.getSelectedRun(tabbedPane) != 0) {
            return;
        }
        Rectangle rect = (Rectangle)tabbedPane.getClientProperty("JTabbedPane.visibleSelectedTabRect");
        if (rect == null) {
            rect = tabbedPane.getBoundsAt(selectedTabIndex);
            Insets insets = tabbedPane.getInsets();
            rect.x -= insets.left;
            rect.y -= insets.top;
        }
        if (rect.width <= 0 || rect.height <= 0) {
            return;
        }
        int pos = this.getTabPosition(tabbedPane, selectedTabIndex);
        int x1 = rect.x;
        int y1 = rect.y;
        int x2 = x1 + rect.width;
        int y2 = y1 + rect.height;
        Color gapColor = new Color(13623527);
        if (placement == 1) {
            ++x1;
            y1 = 0;
            x2 -= pos == 1 ? 2 : 1;
            y2 = y1;
            g2.setPaint(gapColor);
        } else if (placement == 3) {
            ++x1;
            x2 -= pos == 1 ? 2 : 1;
            y2 = --y1;
            g2.setPaint(new Color(0xF5FCFF));
        } else if (placement == 2) {
            x1 = 0;
            ++y1;
            x2 = x1;
            y2 -= pos == 4 ? 2 : 1;
            if (angle == 90 || angle == -90) {
                g2.setPaint(gapColor);
            } else {
                g2.setPaint(new Color(15069172));
            }
        } else if (placement == 4) {
            ++y1;
            x2 = --x1;
            y2 -= pos == 4 ? 2 : 1;
            if (angle == 90 || angle == -90) {
                g2.setPaint(gapColor);
            } else {
                g2.setPaint(new Color(15069172));
            }
        }
        Line2D.Float shape = new Line2D.Float(x1, y1, x2, y2);
        g2.draw(shape);
    }

    public void paintTabbedPaneTabAreaBackground(JComponent c, SyntheticaState state, int placement, int angle, Graphics g, int x, int y, int w, int h) {
    }

    public void paintTabbedPaneTabAreaBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
    }

    public void paintTabbedPaneTab(JComponent c, SyntheticaState state, int tabIndex, int placement, int position, int angle, Graphics g, int x, int y, int w, int h) {
        String bgKey;
        Color bg;
        Color[] colorArray;
        int tabGap;
        Graphics2D g2 = this.prepareGraphics2D(null, g, x, y, false);
        int borderWidth = 1;
        float arc = this.scaleArc(8.0f);
        String key = "Synthetica.tabbedPane.tab.removeDoubleBorder";
        int n = tabGap = SyntheticaLookAndFeel.get((String)key, (Component)c) == null || SyntheticaLookAndFeel.getBoolean((String)key, (Component)c) ? -1 : 0;
        if (angle == 90 || angle == -90) {
            int w_ = w;
            w = h;
            h = w_;
        }
        Shape shape = this.createTabShape(0.0f, 0.0f, TabbedPanePainter.calcRelativeLength((Graphics2D)g2, (float)w, (float)0.0f), TabbedPanePainter.calcRelativeLength((Graphics2D)g2, (float)h, (float)0.0f), arc, placement, position, tabGap, false);
        if (state.isSet(SyntheticaState.State.SELECTED)) {
            Color[] colorArray2 = new Color[4];
            colorArray2[0] = new Color(0xF5FCFF);
            colorArray2[1] = new Color(15595516);
            colorArray2[2] = new Color(15069172);
            colorArray = colorArray2;
            colorArray2[3] = new Color(13623527);
        } else {
            Color[] colorArray3 = new Color[4];
            colorArray3[0] = new Color(0xF0F0F0);
            colorArray3[1] = new Color(0xE7E7E7);
            colorArray3[2] = new Color(0xE1E1E1);
            colorArray = colorArray3;
            colorArray3[3] = new Color(0xD2D2D2);
        }
        Color[] gradient = colorArray;
        if (angle == -90) {
            g2.setPaint(this.createLinearGradientPaint(this.calcRelativeGradientPos(g2, 0.0f, borderWidth), 0.0f, this.calcRelativeGradientPos(g2, w - 1, -borderWidth), 0.0f, new float[]{0.0f, 0.5f, 0.75f, 1.0f}, gradient));
        } else if (angle == 90) {
            g2.setPaint(this.createLinearGradientPaint(this.calcRelativeGradientPos(g2, 0.0f, borderWidth), 0.0f, this.calcRelativeGradientPos(g2, w - 1, -borderWidth), 0.0f, new float[]{0.0f, 0.5f, 0.75f, 1.0f}, new Color[]{gradient[3], gradient[2], gradient[1], gradient[0]}));
        } else {
            g2.setPaint(this.createLinearGradientPaint(0.0f, this.calcRelativeGradientPos(g2, 0.0f, borderWidth), 0.0f, this.calcRelativeGradientPos(g2, h - 1, -borderWidth), new float[]{0.0f, 0.5f, 0.75f, 1.0f}, gradient));
        }
        g2.fill(TabbedPanePainter.subtractStroke((Graphics2D)g2, (Shape)shape));
        if (state.isSet(SyntheticaState.State.HOVER) && !state.isSet(SyntheticaState.State.DISABLED) && !state.isSet(SyntheticaState.State.SELECTED)) {
            g2.setPaint(SyntheticaSimple2DLookAndFeel.getHoverColor());
            g2.fill(TabbedPanePainter.subtractStroke((Graphics2D)g2, (Shape)shape));
        }
        if ((bg = (Color)c.getClientProperty(bgKey = "Synthetica.tabbedPane.tab." + tabIndex + ".background")) == null && c instanceof JTabbedPane && !(((JTabbedPane)c).getBackgroundAt(tabIndex) instanceof UIResource)) {
            bg = ((JTabbedPane)c).getBackgroundAt(tabIndex);
        }
        if (bg != null) {
            Float alpha = (Float)c.getClientProperty(String.valueOf(bgKey) + ".alpha");
            g2.setPaint(this.createAlphaColor(bg, alpha));
            g2.fill(TabbedPanePainter.subtractStroke((Graphics2D)g2, (Shape)shape));
        }
        this.restoreGraphics2D(g2);
        g2 = this.prepareGraphics2D(null, g, x, y, true);
        shape = this.createTabShape(0.0f, 0.0f, TabbedPanePainter.calcRelativeLength((Graphics2D)g2, (float)w, (float)0.0f), TabbedPanePainter.calcRelativeLength((Graphics2D)g2, (float)h, (float)0.0f), arc, placement, position, tabGap, true);
        if (placement == 2 || placement == 4) {
            g2.setPaint(new Color(0xA0A0A0));
        } else {
            g2.setPaint(this.createLinearGradientPaint(0.0f, this.calcRelativeGradientPos(g2, 0.0f, 0.0f), 0.0f, this.calcRelativeGradientPos(g2, h - 1, 0.0f), new float[]{0.0f, 1.0f}, new Color[]{new Color(0xC0C0C0), new Color(0x808080)}));
        }
        g2.draw(shape);
        g2.setPaint(this.createLinearGradientPaint(0.0f, this.calcRelativeGradientPos(g2, 0.0f, 0.0f), 0.0f, this.calcRelativeGradientPos(g2, h - 1, 0.0f), new float[]{0.0f, 1.0f}, new Color[]{new Color(Integer.MAX_VALUE, true), new Color(0x3FFFFFFF, true)}));
        shape = this.createTabShape(this.calcRelativePos(g2, 0.0f, 1.0f), this.calcRelativePos(g2, 0.0f, 1.0f), TabbedPanePainter.calcRelativeLength((Graphics2D)g2, (float)w, (float)-2.0f), TabbedPanePainter.calcRelativeLength((Graphics2D)g2, (float)h, (float)-2.0f), this.calcRelativeArc(g2, arc, -2.0f), placement, position, tabGap, true);
        g2.draw(shape);
        this.restoreGraphics2D(g2);
        boolean paintFocus = (Boolean)SyntheticaLookAndFeel.getClientProperty((String)"Synthetica.paintFocus", (JComponent)c, (Object)true);
        if (state.isSet(SyntheticaState.State.FOCUSED) && paintFocus) {
            g2 = this.prepareGraphics2D(null, g, x, y, true, true, new BasicStroke(2.0f));
            shape = this.createTabShape(0.0f, 0.0f, TabbedPanePainter.calcRelativeLength((Graphics2D)g2, (float)w, (float)0.0f), TabbedPanePainter.calcRelativeLength((Graphics2D)g2, (float)h, (float)0.0f), arc, placement, position, tabGap, true);
            g2.setPaint(SyntheticaSimple2DLookAndFeel.getFocusColor());
            g2.draw(shape);
            this.restoreGraphics2D(g2);
        }
    }

    public void paintTabbedPaneTabBorder(SynthContext sc, Graphics g, int x, int y, int w, int h, int tabIndex) {
    }

    private Shape createContentShape(float x, float y, float w, float h, float arc) {
        return new RoundRectangle2D.Float(x, y, w, h, arc, arc);
    }

    private Shape createTabShape(float x, float y, float w, float h, float arc, int placement, int tabPosition, int tabGap, boolean isBorder) {
        arc /= 2.0f;
        GeneralPath path = new GeneralPath();
        if (placement == 1) {
            x += (float)(tabGap / 2);
            if (tabGap > 0 || tabPosition != 1 && tabPosition != 2) {
                w -= (float)tabGap;
            }
            if (!isBorder) {
                h += 1.0f;
            }
            path.moveTo(x, y + h);
            path.lineTo(x, y + arc);
            path.quadTo(x, y, x + arc, y);
            path.lineTo(x + w - arc, y);
            path.quadTo(x + w, y, x + w, y + arc);
            path.lineTo(x + w, y + h);
        } else if (placement == 3) {
            x += (float)(tabGap / 2);
            if (tabGap > 0 || tabPosition != 1 && tabPosition != 2) {
                w -= (float)tabGap;
            }
            if (!isBorder) {
                y -= 1.0f;
                h += 1.0f;
            }
            path.moveTo(x + w, y);
            path.lineTo(x + w, y + h - arc);
            path.quadTo(x + w, y + h, x + w - arc, y + h);
            path.lineTo(x + arc, y + h);
            path.quadTo(x, y + h, x, y + h - arc);
            path.lineTo(x, y);
        } else if (placement == 2) {
            y += (float)(tabGap / 2);
            if (tabGap > 0 || tabPosition != 4 && tabPosition != 5) {
                h -= (float)tabGap;
            }
            if (!isBorder) {
                w += 1.0f;
            }
            path.moveTo(x + w, y + h);
            path.lineTo(x + arc, y + h);
            path.quadTo(x, y + h, x, y + h - arc);
            path.lineTo(x, y + arc);
            path.quadTo(x, y, x + arc, y);
            path.lineTo(x + w, y);
        } else {
            y += (float)(tabGap / 2);
            if (tabGap > 0 || tabPosition != 4 && tabPosition != 5) {
                h -= (float)tabGap;
            }
            if (!isBorder) {
                x -= 1.0f;
                w += 1.0f;
            }
            path.moveTo(x, y);
            path.lineTo(x + w - arc, y);
            path.quadTo(x + w, y, x + w, y + arc);
            path.lineTo(x + w, y + h - arc);
            path.quadTo(x + w, y + h, x + w - arc, y + h);
            path.lineTo(x, y + h);
        }
        return path;
    }
}

