/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.synthetica.simple2d;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.synthetica.simple2d.SyntheticaSimple2DLookAndFeel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.table.JTableHeader;
import javax.swing.text.JTextComponent;

public class ScrollPanePainter
extends de.javasoft.plaf.synthetica.painter.ScrollPanePainter {
    private static final float ARC = 8.0f;
    private static final float TC_ARC = 8.0f;

    public void paintScrollPaneBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        boolean innerBorderIsDefault;
        JScrollPane scrollPane = (JScrollPane)sc.getComponent();
        if (scrollPane.getViewport() == null || scrollPane.getViewport().getView() == null || !SyntheticaLookAndFeel.isOpaque((JComponent)scrollPane)) {
            return;
        }
        Component view = scrollPane.getViewport().getView();
        Border border = scrollPane.getBorder();
        Border defaultBorder = SyntheticaLookAndFeel.findDefaultBorder((Border)border);
        boolean isTextComponent = view instanceof JTextComponent;
        boolean defaultBorderIsSynth = defaultBorder == null ? false : defaultBorder.getClass().getName().equals("javax.swing.plaf.synth.SynthBorder");
        Insets insets = scrollPane.getInsets();
        if (isTextComponent && !SyntheticaLookAndFeel.isOpaque((JComponent)((JTextComponent)view))) {
            return;
        }
        if (!isTextComponent && !defaultBorderIsSynth) {
            if (view.isOpaque()) {
                g.setColor(view.getBackground());
                if (border == null || insets.equals(new Insets(0, 0, 0, 0))) {
                    g.fillRect(x, y, w, h);
                } else {
                    g.fillRect(x + insets.left, y + insets.top, w - insets.left - insets.right, h - insets.top - insets.bottom);
                }
            }
            return;
        }
        boolean bl = innerBorderIsDefault = border instanceof CompoundBorder && ((CompoundBorder)border).getInsideBorder() == defaultBorder;
        if (innerBorderIsDefault) {
            Insets ins_ = defaultBorder.getBorderInsets(scrollPane);
            x += insets.left - ins_.left;
            y += insets.top - ins_.top;
            w -= insets.left - ins_.left + insets.right - ins_.right;
            h -= insets.top - ins_.top + insets.bottom - ins_.bottom;
        }
        Graphics2D g2 = defaultBorderIsSynth ? this.prepareGraphics2D(sc, g, 0, 0, true) : this.prepareGraphics2D(sc, g, 0, 0, false, true, new BasicStroke(0.0f));
        float arc = view instanceof JTextComponent ? 8.0f : 8.0f;
        arc = this.scaleArc(arc);
        int offset = view instanceof JTextComponent ? 0 : 0;
        Shape shape = this.createShape(this.calcRelativePos(g2, x, offset), this.calcRelativePos(g2, y, offset), ScrollPanePainter.calcRelativeLength((Graphics2D)g2, (float)w, (float)(-offset * 2)), ScrollPanePainter.calcRelativeLength((Graphics2D)g2, (float)h, (float)(-offset * 2)), this.calcRelativeArc(g2, arc, -offset * 2), insets, defaultBorderIsSynth);
        if (isTextComponent) {
            Color background = view.getBackground();
            boolean defaultBackground = background == null || background instanceof UIResource;
            g2.setPaint(background);
            if (!defaultBackground) {
                g2.fill(shape);
                this.restoreGraphics2D(g2);
                return;
            }
            float y_ = arc / 2.0f / (float)h;
            int borderWidth = 1;
            JTextComponent tc = (JTextComponent)view;
            if (!tc.isEnabled()) {
                g2.setPaint(new Color(0xEFEFEF));
            } else if (!tc.isEditable()) {
                g2.setPaint(this.createLinearGradientPaint(0.0f, this.calcRelativeGradientPos(g2, y, borderWidth), 0.0f, this.calcRelativeGradientPos(g2, y + h - 1, -borderWidth), new float[]{0.0f, y_, 1.0f}, new Color[]{new Color(1893720031, !defaultBackground), new Color(0x70E7E7E7, !defaultBackground), new Color(0x70E7E7E7, !defaultBackground)}));
            } else {
                g2.setPaint(this.createLinearGradientPaint(0.0f, this.calcRelativeGradientPos(g2, y, borderWidth), 0.0f, this.calcRelativeGradientPos(g2, y + h - 1, -borderWidth), new float[]{0.0f, y_, 1.0f}, new Color[]{new Color(552332267, !defaultBackground), new Color(553384955, !defaultBackground), new Color(0x20FFFFFF, !defaultBackground)}));
            }
        } else if (!view.isEnabled()) {
            g2.setPaint(new Color(0xEFEFEF));
        } else {
            g2.setPaint(view.getBackground());
        }
        g2.fill(shape);
        this.restoreGraphics2D(g2);
    }

    public void paintScrollPaneBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        JTable table;
        JTableHeader tableHeader;
        JScrollPane scrollPane = (JScrollPane)sc.getComponent();
        JComponent view = (JComponent)scrollPane.getViewport().getView();
        boolean defaultBorderIsSynth = true;
        Insets insets = scrollPane.getInsets();
        if (!SyntheticaLookAndFeel.isOpaque((JComponent)scrollPane)) {
            return;
        }
        Graphics2D g2 = this.prepareGraphics2D(sc, g, 0, 0, true);
        float arc = view instanceof JTextComponent ? 8.0f : 8.0f;
        arc = this.scaleArc(arc);
        if (view instanceof JTable && (tableHeader = (table = (JTable)view).getTableHeader()) != null) {
            int offset = 0;
            g2.setPaint(table.getTableHeader().getBackground());
            int hh = table.getTableHeader().getHeight() + insets.top;
            Shape headerShape = this.createTableHeaderShape(this.calcRelativePos(g2, x, offset), this.calcRelativePos(g2, y, offset), ScrollPanePainter.calcRelativeLength((Graphics2D)g2, (float)w, (float)(-offset * 2)), ScrollPanePainter.calcRelativeLength((Graphics2D)g2, (float)(hh - y), (float)0.0f), this.calcRelativeArc(g2, arc, -offset * 2));
            g2.fill(headerShape);
            g2.setPaint(SyntheticaLookAndFeel.getColor((String)"Synthetica.tableHeader.gridColor", (Component)table));
            g2.draw(this.createTableHeaderLine(this.calcRelativePos(g2, x, offset), this.calcRelativePos(g2, hh, -1.0f), ScrollPanePainter.calcRelativeLength((Graphics2D)g2, (float)w, (float)(-offset * 2))));
        }
        if (view instanceof JTextComponent) {
            Shape shape = this.createShape(this.calcRelativePos(g2, x, 0.0f), this.calcRelativePos(g2, y, 0.0f), ScrollPanePainter.calcRelativeLength((Graphics2D)g2, (float)w, (float)0.0f), ScrollPanePainter.calcRelativeLength((Graphics2D)g2, (float)h, (float)0.0f), arc, insets, defaultBorderIsSynth);
            JTextComponent tc = (JTextComponent)view;
            if (!tc.isEnabled()) {
                g2.setPaint(new Color(0x2E000000, true));
            } else {
                g2.setPaint(this.createLinearGradientPaint(0.0f, this.calcRelativeGradientPos(g2, 0.0f, 0.0f), 0.0f, this.calcRelativeGradientPos(g2, h - 1, 0.0f), new float[]{0.0f, 1.0f}, new Color[]{new Color(0x33000000, true), new Color(0x19000000, true)}));
            }
            g2.draw(shape);
            boolean textComponentsFocusEnabled = SyntheticaLookAndFeel.get((String)"Synthetica.focus.textComponents.enabled", (Component)tc) == null ? true : SyntheticaLookAndFeel.getBoolean((String)"Synthetica.focus.textComponents.enabled", (Component)tc);
            boolean paintFocus = (Boolean)SyntheticaLookAndFeel.getClientProperty((String)"Synthetica.paintFocus", (JComponent)scrollPane, (Object)true);
            if (tc.hasFocus() && textComponentsFocusEnabled && paintFocus) {
                g2.setPaint(SyntheticaSimple2DLookAndFeel.getFocusColor());
                g2.draw(shape);
                Shape s = this.createShape(this.getScale(), this.getScale(), ScrollPanePainter.calcRelativeLength((Graphics2D)g2, (float)w, (float)-2.0f), ScrollPanePainter.calcRelativeLength((Graphics2D)g2, (float)h, (float)-2.0f), this.calcRelativeArc(g2, arc, -1.0f), insets, defaultBorderIsSynth);
                g2.draw(s);
            }
        } else {
            Color[][] colors = new Color[][]{{new Color(0x7F000000, true), new Color(0x66000000, true), new Color(0x66000000, true), new Color(0x40000000, true)}, {new Color(0x2E000000, true), new Color(0x12000000, true), new Color(0x12000000, true), new Color(0, true)}, {new Color(0x19000000, true), new Color(0xA000000, true), new Color(0xA000000, true), new Color(0, true)}, {new Color(0xA000000, true), new Color(0x3000000, true), new Color(0x3000000, true), new Color(0, true)}};
            int offset = 0;
            while (offset < colors.length) {
                float arc_ = this.calcRelativeArc(g2, arc, -offset * 2);
                float y_ = arc_ / 2.0f / (float)(h - offset * 2);
                if (y_ > 0.5f) break;
                g2.setPaint(this.createLinearGradientPaint(0.0f, this.calcRelativeGradientPos(g2, y, offset), 0.0f, this.calcRelativeGradientPos(g2, y + h - 1, -offset), new float[]{0.0f, y_, 1.0f - y_, 1.0f}, colors[offset]));
                Shape shape = this.createShape(this.calcRelativePos(g2, x, offset), this.calcRelativePos(g2, y, offset), ScrollPanePainter.calcRelativeLength((Graphics2D)g2, (float)w, (float)(-offset * 2)), ScrollPanePainter.calcRelativeLength((Graphics2D)g2, (float)h, (float)(-offset * 2)), arc_, insets, defaultBorderIsSynth);
                g2.draw(shape);
                ++offset;
            }
        }
        this.restoreGraphics2D(g2);
    }

    private Shape createShape(float x, float y, float w, float h, float arc, Insets insets, boolean defaultBorderIsSynth) {
        if (defaultBorderIsSynth) {
            return new RoundRectangle2D.Float(x, y, w, h, arc, arc);
        }
        return new Rectangle2D.Float(x + (float)insets.left, y + (float)insets.top, w - (float)insets.left - (float)insets.right, h - (float)insets.top - (float)insets.bottom);
    }

    private Shape createTableHeaderShape(float x, float y, float w, float h, float arc) {
        GeneralPath path = new GeneralPath();
        path.moveTo(x, y + h);
        path.lineTo(x, y + arc);
        path.quadTo(x, y, x + arc, y);
        path.lineTo(x + w - arc, y);
        path.quadTo(x + w, y, x + w, y + arc);
        path.lineTo(x + w, y + h);
        path.closePath();
        return path;
    }

    private Shape createTableHeaderLine(float x, float y, float w) {
        return new Line2D.Float(x, y, x + w, y);
    }

    public Insets getCacheScaleInsets(SynthContext sc, String id) {
        JScrollPane scrollPane = (JScrollPane)sc.getComponent();
        JComponent view = (JComponent)scrollPane.getViewport().getView();
        if (id.equals("paintScrollPaneBorder")) {
            JTable table;
            JTableHeader tableHeader;
            int val = (int)this.scaleArc(8.0f);
            Insets insets = new Insets(val, val, val, val);
            if (view instanceof JTable && (tableHeader = (table = (JTable)view).getTableHeader()) != null) {
                insets.top += tableHeader.getHeight();
            }
            return insets;
        }
        Insets insets = super.getCacheScaleInsets(sc, id);
        if (view instanceof JTextComponent) {
            insets.top += 4;
        }
        return insets;
    }

    public int getCacheHash(SynthContext sc, int w, int h, int meta, String id) {
        Component view;
        JScrollPane scrollPane = (JScrollPane)sc.getComponent();
        JViewport viewport = scrollPane.getViewport();
        Component component = view = viewport == null ? null : viewport.getView();
        if (id.equals("paintScrollPaneBorder") && !(scrollPane.getBorder() instanceof UIResource) && view instanceof JTable && ((JTable)view).getTableHeader() != null) {
            return -1;
        }
        return super.getCacheHash(sc, w, h, meta, id);
    }
}

