/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.synthetica.simple2d;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaRootPaneUI;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.util.OS;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.Window;
import java.awt.geom.Line2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.synth.SynthContext;

public class RootPanePainter
extends de.javasoft.plaf.synthetica.painter.RootPanePainter {
    private static final float ARC = 8.0f;
    private static final boolean IS_MAC = OS.getCurrentOS() == OS.Mac;
    private String rootPaneText;

    public void paintRootPaneBorder(JRootPane root, SyntheticaState state, Graphics g, int x, int y, int w, int h) {
        Window window = this.getWindow(root);
        boolean maximized = this.isMaximized(window);
        boolean evalCopy = SyntheticaRootPaneUI.isEvalCopy();
        this.rootPaneText = ((SyntheticaRootPaneUI)root.getUI()).getRootPaneBorderText();
        int marginLeft = 0;
        if ((evalCopy || this.rootPaneText != null) && !maximized) {
            h -= 16;
            marginLeft = SyntheticaLookAndFeel.getInt((String)"Synthetica.rootPane.margin.left", (Component)window, (int)0);
            x += marginLeft;
            w -= marginLeft;
        }
        Graphics2D g2 = this.prepareGraphics2D(null, g, x, y, true);
        if (this.getWindow(root).isActive()) {
            g2.setPaint(IS_MAC ? new Color(0x707070) : new Color(-2013265920, true));
        } else {
            g2.setPaint(IS_MAC ? new Color(0xA4A4A4) : new Color(0x50000000, true));
        }
        Shape shape = this.createShape(0.0f, 0.0f, RootPanePainter.calcRelativeLength((Graphics2D)g2, (float)w, (float)0.0f), RootPanePainter.calcRelativeLength((Graphics2D)g2, (float)h, (float)0.0f), this.scaleArc(8.0f));
        g2.draw(shape);
        g2.translate(this.calcRelativePos(g2, x - marginLeft, 1.0f), this.calcRelativePos(g2, y, 1.0f));
        g2.setPaint(IS_MAC ? new Color(0xF9F9F9) : new Color(-251987206, true));
        shape = this.createShape(0.0f, 0.0f, RootPanePainter.calcRelativeLength((Graphics2D)g2, (float)w, (float)-2.0f), RootPanePainter.calcRelativeLength((Graphics2D)g2, (float)h, (float)-2.0f), this.calcRelativeArc(g2, this.scaleArc(8.0f), -2.0f));
        g2.draw(shape);
        this.restoreGraphics2D(g2);
        if (evalCopy || this.rootPaneText != null) {
            g.setColor(evalCopy ? UIManager.getColor("Panel.background") : SyntheticaLookAndFeel.getColor((String)"Synthetica.rootPane.borderText.background", (Component)window, (Color)UIManager.getColor("Panel.background")));
            g.fillRect(x, h, w, 16);
            if (marginLeft > 0) {
                g.fillRect(x - marginLeft, y, marginLeft, h + 16);
            }
            g.setColor(evalCopy ? new Color(0xCC0000) : SyntheticaLookAndFeel.getColor((String)"Synthetica.rootPane.borderText.foreground", (Component)window, (Color)UIManager.getColor("Label.foreground")));
            g.setFont(g.getFont().deriveFont(10.0f));
            String text = evalCopy ? "Synthetica - Unregistered Evaluation Copy!" : this.rootPaneText;
            g.drawString(text, 4, h + g.getFontMetrics().getAscent());
        }
    }

    public void paintContentBackground(JRootPane root, SyntheticaState state, Graphics g, int x, int y, int w, int h) {
    }

    protected Window getWindow(JRootPane root) {
        Container parent = root.getParent();
        return parent instanceof Window ? (Window)parent : SwingUtilities.getWindowAncestor(parent);
    }

    public void paintTitlePaneBackground(JRootPane root, SyntheticaState state, Graphics g, int x, int y, int w, int h) {
        JComponent titlePane = (JComponent)SyntheticaLookAndFeel.findComponent((String)"RootPane.titlePane", (Container)root);
        if (SyntheticaLookAndFeel.isOpaque((JComponent)titlePane)) {
            g.setColor(IS_MAC ? new Color(0xECECEC) : new Color(-252908308, true));
            g.fillRect(x, y, w, h);
            Graphics2D g2 = this.prepareGraphics2D(null, g, x, y, true, true, new BasicStroke(1.0f * this.getScale()));
            g2.setPaint(new Color(0x10000000, true));
            g2.draw(new Line2D.Float(x, y + h - 2, x + w - 1, y + h - 2));
            g2.setPaint(new Color(-1426063361, true));
            g2.draw(new Line2D.Float(x, y + h - 1, x + w - 1, y + h - 1));
            this.restoreGraphics2D(g2);
        }
        if (root.getClientProperty("Synthetica.logoRenderer") != null) {
            Window window = this.getWindow(root);
            this.renderLogo(root, window.isActive(), this.isMaximized(window), false, g, w, h);
        }
    }

    public void paintButtonAreaBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
    }

    protected BasicStroke createStroke(SynthContext sc) {
        return new BasicStroke(2.0f * this.getScale());
    }

    private Shape createShape(float x, float y, float w, float h, float arc) {
        return new RoundRectangle2D.Float(x, y, w, h, arc, arc);
    }

    public Insets getCacheScaleInsets(SynthContext sc, String id) {
        int arc = (int)this.scaleArc(8.0f);
        Insets insets = new Insets(arc, arc, arc, arc);
        return insets;
    }

    public int getCacheHash(SynthContext sc, int w, int h, int meta, String id) {
        boolean isBorder = id.equals("paintRootPaneBorder");
        if (SyntheticaRootPaneUI.isEvalCopy() == isBorder || this.rootPaneText != null == isBorder) {
            return -1;
        }
        return super.getCacheHash(sc, w, h, meta, id);
    }
}

