/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.synthetica.simple2d;

import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.util.DropShadow;
import de.javasoft.plaf.synthetica.util.OS;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.plaf.synth.SynthContext;

public class MenuPainter
extends de.javasoft.plaf.synthetica.painter.MenuPainter {
    private static final float ARC = 8.0f;
    private static final Image roundBackground = MenuPainter.createPopupBackground(false);
    private static final Image rectBackground = MenuPainter.createPopupBackground(true);

    public void paintMenuBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        boolean hover;
        boolean mouseOver;
        JMenu m = (JMenu)sc.getComponent();
        int state = sc.getComponentState();
        boolean selected = (state & 0x200) > 0;
        boolean disabled = (state & 8) > 0;
        Boolean b = (Boolean)m.getClientProperty("Synthetica.MOUSE_OVER");
        boolean bl = mouseOver = b == null ? false : b;
        if (mouseOver) {
            state |= 2;
        }
        boolean bl2 = hover = (state & 2) > 0;
        if (selected || hover && !disabled) {
            Graphics2D g2 = (Graphics2D)g;
            if (m.isTopLevelMenu()) {
                boolean borderWidth = true;
                g2.setPaint(this.createLinearGradientPaint(0.0f, this.calcRelativeGradientPos(g2, 0.0f, (float)borderWidth), 0.0f, this.calcRelativeGradientPos(g2, h - 1, 0.0f), new float[]{0.0f, 0.5f, 1.0f}, new Color[]{new Color(0x3000000, true), new Color(0x17000000, true), new Color(0x3000000, true)}));
                Rectangle2D.Float s = new Rectangle2D.Float(this.calcRelativePos(g2, x, 0.0f), this.calcRelativePos(g2, y, 0.0f), w, h);
                g2.fill(s);
                g2.setPaint(this.createLinearGradientPaint(0.0f, this.calcRelativeGradientPos(g2, 0.0f, (float)borderWidth), 0.0f, this.calcRelativeGradientPos(g2, h - 1, 0.0f), new float[]{0.0f, 0.5f, 1.0f}, new Color[]{new Color(Integer.MAX_VALUE, true), new Color(-855638017, true), new Color(Integer.MAX_VALUE, true)}));
                g2.draw(new Rectangle2D.Float(this.calcRelativePos(g2, x, 0.0f), this.calcRelativePos(g2, y, 0.0f), MenuPainter.calcRelativeLength((Graphics2D)g2, (float)w, (float)0.0f), MenuPainter.calcRelativeLength((Graphics2D)g2, (float)h, (float)0.0f)));
                g2.setPaint(new Color(0x17000000, true));
                g2.draw(new Line2D.Float(this.calcRelativePos(g2, x, 1.0f), this.calcRelativePos(g2, y, 0.0f), this.calcRelativePos(g2, x + w - 1, -1.0f), this.calcRelativePos(g2, y, 0.0f)));
                g2.setPaint(this.createLinearGradientPaint(0.0f, this.calcRelativeGradientPos(g2, 0.0f, (float)borderWidth), 0.0f, this.calcRelativeGradientPos(g2, h - 1, 0.0f), new float[]{0.0f, 0.5f, 1.0f}, new Color[]{new Color(0x7000000, true), new Color(0x5F000000, true), new Color(0x7000000, true)}));
                g2.draw(new Line2D.Float(this.calcRelativePos(g2, x, 1.0f), this.calcRelativePos(g2, y, 0.0f), this.calcRelativePos(g2, x, 1.0f), this.calcRelativePos(g2, y + h, 0.0f)));
                g2.draw(new Line2D.Float(this.calcRelativePos(g2, x + w - 1, -1.0f), this.calcRelativePos(g2, y, 0.0f), this.calcRelativePos(g2, x + w - 1, -1.0f), this.calcRelativePos(g2, y + h, 0.0f)));
                g2.setPaint(this.createLinearGradientPaint(0.0f, this.calcRelativeGradientPos(g2, 0.0f, (float)borderWidth), 0.0f, this.calcRelativeGradientPos(g2, h - 1, 0.0f), new float[]{0.0f, 0.5f, 1.0f}, new Color[]{new Color(0x3000000, true), new Color(0xF000000, true), new Color(0x3000000, true)}));
                g2.draw(new Line2D.Float(this.calcRelativePos(g2, x, 2.0f), this.calcRelativePos(g2, y, 0.0f), this.calcRelativePos(g2, x, 2.0f), this.calcRelativePos(g2, y + h, 0.0f)));
                g2.draw(new Line2D.Float(this.calcRelativePos(g2, x + w - 1, -2.0f), this.calcRelativePos(g2, y, 0.0f), this.calcRelativePos(g2, x + w - 1, -2.0f), this.calcRelativePos(g2, y + h, 0.0f)));
            } else {
                this.paintItemBackground(g, x, y, w, h);
            }
        } else {
            m.isTopLevelMenu();
        }
    }

    public void paintMenuBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
    }

    public void paintMenuBarBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        this.paintMenuBarBackground(sc.getComponent(), new SyntheticaState(sc.getComponentState()), g, x, y, w, h);
    }

    public void paintMenuBarBackground(JComponent c, SyntheticaState state, Graphics g, int x, int y, int w, int h) {
        if (OS.getCurrentOS() == OS.Mac) {
            g.setColor(new Color(0xEFEFEF));
            g.fillRect(x, y, w, h);
        }
    }

    public void paintMenuBarBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
    }

    public void paintMenuItemBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        int state = sc.getComponentState();
        if ((state & 2) > 0) {
            this.paintItemBackground(g, x, y, w, h);
        }
    }

    private void paintItemBackground(Graphics g, int x, int y, int w, int h) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(this.createLinearGradientPaint(0.0f, 0.0f, 0.0f, h - 1, new float[]{0.0f, 0.2f, 0.5f, 0.8f, 1.0f}, new Color[]{new Color(0x5F000000, true), new Color(Integer.MIN_VALUE, true), new Color(-1610612736, true), new Color(Integer.MIN_VALUE, true), new Color(0x5F000000, true)}));
        Rectangle2D.Float s = new Rectangle2D.Float(this.calcRelativePos(g2, x, 0.0f), this.calcRelativePos(g2, y, 0.0f), w, h);
        g2.fill(s);
        g2.setPaint(this.createLinearGradientPaint(0.0f, 0.0f, 0.0f, h - 1, new float[]{0.0f, 0.5f, 1.0f}, new Color[]{new Color(-1, true), new Color(-1, true), new Color(-1, true)}));
        g2.draw(new Rectangle2D.Float(x, y, x + w - 1, y + h - 1));
        g2.setPaint(new Color(0x6C000000, true));
        g2.draw(new Line2D.Float(x + 1, y, x + w - 2, y));
        g2.setPaint(this.createLinearGradientPaint(0.0f, 0.0f, 0.0f, h - 1, new float[]{0.0f, 0.5f, 1.0f}, new Color[]{new Color(0xF000000, true), new Color(0x5F000000, true), new Color(0xF000000, true)}));
        g2.draw(new Line2D.Float(x + 1, y, x + 1, y + h));
        g2.draw(new Line2D.Float(x + w - 2, y, x + w - 2, y + h));
        g2.setPaint(this.createLinearGradientPaint(0.0f, 0.0f, 0.0f, h - 1, new float[]{0.0f, 0.5f, 1.0f}, new Color[]{new Color(0x3000000, true), new Color(0x1F000000, true), new Color(0x3000000, true)}));
        g2.draw(new Line2D.Float(x + 2, y, x + 2, y + h));
        g2.draw(new Line2D.Float(x + w - 3, y, x + w - 3, y + h));
    }

    public void paintMenuItemBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
    }

    public void paintCheckBoxMenuItemBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        this.paintMenuItemBackground(sc, g, x, y, w, h);
    }

    public void paintCheckBoxMenuItemBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
    }

    public void paintRadioButtonMenuItemBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        this.paintMenuItemBackground(sc, g, x, y, w, h);
    }

    public void paintRadioButtonMenuItemBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
    }

    public void paintPopupMenuBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        JPopupMenu popup = (JPopupMenu)sc.getComponent();
        JPanel panel = (JPanel)popup.getParent();
        BufferedImage background = (BufferedImage)panel.getClientProperty("POPUP_BACKGROUND");
        if (background != null) {
            g.drawImage(background, x, y, null);
        }
        Insets insets = new Insets(10, 10, 10, 10);
        ImagePainter ip = null;
        ip = popup.getName() != null && popup.getName().startsWith("ComboPopup") ? new ImagePainter(rectBackground, g, x, y, w, h, insets, insets) : new ImagePainter(roundBackground, g, x, y, w, h, insets, insets);
        ip.draw();
    }

    public void paintPopupMenuBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        Graphics2D g2 = this.prepareGraphics2D(sc, g, x, y, true);
        float arc_ = this.scaleArc(8.0f);
        float y_ = arc_ / 2.0f / (float)h;
        RoundRectangle2D.Float shape = new RoundRectangle2D.Float(this.calcRelativePos(g2, x, 3.0f), this.calcRelativePos(g2, y, 0.0f), MenuPainter.calcRelativeLength((Graphics2D)g2, (float)w, (float)-6.0f), MenuPainter.calcRelativeLength((Graphics2D)g2, (float)h, (float)-5.0f), arc_, arc_);
        g2.setPaint(this.createLinearGradientPaint(0.0f, this.calcRelativeGradientPos(g2, 0.0f, 0.0f), 0.0f, this.calcRelativeGradientPos(g2, h - 1, -5.0f), new float[]{0.0f, y_, 1.0f - y_, 1.0f}, new Color[]{new Color(0xFFFFFF), new Color(0xAAAAAA), new Color(0xAAAAAA), new Color(0x808080)}));
        g2.draw(shape);
        this.restoreGraphics2D(g2);
    }

    private static Image createPopupBackground(boolean rectangle) {
        BufferedImage image = new BufferedImage(100, 100, 2);
        Graphics2D g2 = image.createGraphics();
        Shape shape = null;
        Rectangle rect = new Rectangle(0, 0, 94, 95);
        shape = rectangle ? MenuPainter.createRectangleShape(rect) : MenuPainter.createRoundShape(rect, 8.0f);
        g2.fill(shape);
        g2.draw(shape);
        g2.dispose();
        BufferedImage img = new BufferedImage(100, 100, 2);
        g2 = img.createGraphics();
        DropShadow ds = new DropShadow(image);
        ds.setDistance(-5);
        ds.setAngle(0.0f);
        ds.setShadowSize(6);
        ds.setShadowColor(new Color(0x7F000000, true));
        ds.setQuality(true);
        ds.paintShadow((Graphics)g2, 1, -5);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        rect = new Rectangle(4, 1, 92, 93);
        shape = rectangle ? MenuPainter.createRectangleShape(rect) : MenuPainter.createRoundShape(rect, 6.0f);
        g2.setPaint(new Color(0xF7F7F7));
        g2.fill(shape);
        g2.dispose();
        return img;
    }

    private static Shape createRoundShape(Rectangle rect, float arc) {
        return new RoundRectangle2D.Float(rect.x, rect.y, rect.width, rect.height, arc, arc);
    }

    private static Shape createRectangleShape(Rectangle rect) {
        return new Rectangle2D.Float(rect.x, rect.y, rect.width, rect.height);
    }
}

