/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.synthetica.simple2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;

public class DefaultComboListCellRenderer
extends DefaultListCellRenderer
implements UIResource {
    private static final long serialVersionUID = -2396218920790008812L;
    private static final Color BACKGROUND = new Color(0xFAFAFA);
    private Border rendererBorder;

    public DefaultComboListCellRenderer() {
        EmptyBorder listBorder = UIManager.get("Synthetica.comboBox.viewport.border.insets") != null ? new EmptyBorder(UIManager.getInsets("Synthetica.comboBox.viewport.border.insets")) : new EmptyBorder(0, 0, 0, 0);
        Insets insets = listBorder.getBorderInsets(null);
        JMenuItem mi = new JMenuItem();
        if (SynthLookAndFeel.getStyleFactory() != null) {
            SynthStyle ss = SynthLookAndFeel.getStyle(mi, Region.MENU_ITEM);
            Insets miInsets = ss.getInsets(new SynthContext(mi, Region.MENU_ITEM, ss, 0), null);
            insets.top = miInsets.top;
            insets.bottom = miInsets.bottom;
        }
        this.rendererBorder = new EmptyBorder(insets);
    }

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (list.getBorder() == null || list.getBorder().getClass().getName().contains("SynthBorder")) {
            list.setBackground(BACKGROUND);
        }
        JComponent c = (JComponent)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        c.setOpaque(index >= 0 && isSelected);
        if (index >= 0) {
            c.setBorder(this.rendererBorder);
        }
        if (value == null || "".equals(value)) {
            this.setText(" ");
        }
        return c;
    }
}

