/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.Frame;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.ProxySelector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.netbeans.TopSecurityManager;
import org.netbeans.core.NbAuthenticator;
import org.netbeans.core.NbLoaderPool;
import org.netbeans.core.NbProxySelector;
import org.netbeans.core.WarmUpSupport;
import org.netbeans.core.WindowSystem;
import org.netbeans.core.startup.CLIOptions;
import org.netbeans.core.startup.MainLookup;
import org.netbeans.core.startup.RunLevel;
import org.netbeans.core.startup.Splash;
import org.netbeans.core.startup.StartLog;
import org.netbeans.swing.plaf.Startup;
import org.openide.LifecycleManager;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.ExClipboard;
import org.openide.windows.WindowManager;

public class GuiRunLevel
implements RunLevel {
    private static int count;

    public GuiRunLevel() {
        MainLookup.started();
        assert (count++ == 0) : "Only one instance allowed";
    }

    public void run() {
        try {
            NbLoaderPool.load();
        }
        catch (IOException iOException) {
            Logger.getLogger(GuiRunLevel.class.getName()).log(Level.INFO, null, iOException);
        }
        StartLog.logProgress((String)"LoaderPool loaded");
        Splash.getInstance().increment(10);
        NbLoaderPool.installationFinished();
        StartLog.logProgress((String)"LoaderPool notified");
        Splash.getInstance().increment(10);
        ProxySelector.setDefault(new NbProxySelector());
        if (CLIOptions.isGui()) {
            this.initializeMainWindow();
            StartLog.logProgress((String)"Main window initialized");
            Splash.getInstance().increment(1);
        }
        if (!Boolean.getBoolean("TopSecurityManager.disable")) {
            TopSecurityManager.install();
            if (CLIOptions.isGui()) {
                TopSecurityManager.makeSwingUseSpecialClipboard((Clipboard)((Clipboard)Lookup.getDefault().lookup(ExClipboard.class)));
            }
        }
        Authenticator.setDefault(new NbAuthenticator());
        StartLog.logProgress((String)"Security managers installed");
        Splash.getInstance().increment(1);
    }

    private void initializeMainWindow() {
        Startup.setClassLoader((ClassLoader)((ClassLoader)Lookup.getDefault().lookup(ClassLoader.class)));
        StartLog.logStart((String)"Main window initialization");
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(GuiRunLevel.class, (String)"MSG_MainWindowInit"));
        Timer timer = new Timer(0, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        timer.setRepeats(false);
        timer.start();
        Splash.getInstance().increment(10);
        StartLog.logProgress((String)"Timer initialized");
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(GuiRunLevel.class, (String)"MSG_WindowShowInit"));
        final WindowSystem windowSystem = (WindowSystem)Lookup.getDefault().lookup(WindowSystem.class);
        if (windowSystem != null) {
            windowSystem.init();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StartLog.logProgress((String)"Window system initialization");
                if (System.getProperty("netbeans.warmup.skip") == null && System.getProperty("netbeans.close") == null) {
                    final Frame frame = WindowManager.getDefault().getMainWindow();
                    frame.addComponentListener(new ComponentAdapter(){

                        @Override
                        public void componentShown(ComponentEvent componentEvent) {
                            frame.removeComponentListener(this);
                            WarmUpSupport.warmUp();
                        }
                    });
                }
                if (windowSystem != null) {
                    windowSystem.load();
                    StartLog.logProgress((String)"Window system loaded");
                    if (StartLog.willLog()) {
                        GuiRunLevel.waitForMainWindowPaint();
                    }
                    windowSystem.show();
                } else {
                    Logger.getLogger(GuiRunLevel.class.getName()).log(Level.WARNING, "Module org.netbeans.core.windows missing, cannot start window system");
                }
                StartLog.logProgress((String)"Window system shown");
                if (!StartLog.willLog()) {
                    GuiRunLevel.maybeDie(null);
                }
            }
        });
        StartLog.logEnd((String)"Main window initialization");
    }

    private static void waitForMainWindowPaint() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Class<?> clazz = Class.forName("org.netbeans.performance.test.guitracker.LoggingRepaintManager");
                    Method method = clazz.getMethod("measureStartup", new Class[0]);
                    Object object = method.invoke(null, new Object[0]);
                    GuiRunLevel.endOfStartupMeasuring(object);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    StartLog.logProgress((String)classNotFoundException.toString());
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    StartLog.logProgress((String)noSuchMethodException.toString());
                }
                catch (IllegalAccessException illegalAccessException) {
                    StartLog.logProgress((String)illegalAccessException.toString());
                }
                catch (InvocationTargetException invocationTargetException) {
                    StartLog.logProgress((String)invocationTargetException.toString());
                }
            }
        };
        new Thread(runnable).start();
    }

    private static void endOfStartupMeasuring(Object object) {
        StartLog.logProgress((String)"Startup memory and time measured");
        GuiRunLevel.maybeDie(object);
    }

    private static void maybeDie(Object object) {
        if (System.getProperty("netbeans.kill") != null) {
            TopSecurityManager.exit((int)5);
        }
        if (System.getProperty("netbeans.close") != null) {
            if (Boolean.getBoolean("netbeans.warm.close")) {
                new WarmUpSupport().run();
            }
            if (object != null) {
                StartLog.logMeasuredStartupTime((long)((Long)object));
            }
            LifecycleManager.getDefault().exit();
        }
    }
}

