/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.util.java2d;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;

public class Synthetica2DUtils {
    public static BufferedImage createBlurredImage(BufferedImage src, int size) {
        ConvolveOp co = Synthetica2DUtils.createBlurOp(size);
        BufferedImage dest = co.createCompatibleDestImage(src, src.getColorModel());
        co.filter(src, dest);
        return dest;
    }

    public static ConvolveOp createBlurOp(int size) {
        float[] data = new float[size * size];
        float value = 1.0f / (float)(size * size);
        int i = 0;
        while (i < data.length) {
            data[i] = value;
            ++i;
        }
        return new ConvolveOp(new Kernel(size, size, data));
    }

    public static BufferedImage createAlphaImage(BufferedImage src, float alpha) {
        BufferedImage dest = new BufferedImage(src.getWidth(), src.getHeight(), 2);
        Graphics2D g2d = (Graphics2D)dest.getGraphics();
        g2d.setComposite(AlphaComposite.getInstance(3, alpha));
        g2d.drawImage((Image)src, 0, 0, null);
        g2d.dispose();
        return dest;
    }

    public static BufferedImage createColorizedImage(BufferedImage src, Color color, float alpha) {
        BufferedImage dest = new BufferedImage(src.getWidth(), src.getHeight(), 2);
        Synthetica2DUtils.colorizeImage(src, dest, color, alpha);
        return dest;
    }

    public static void colorizeImage(BufferedImage src, BufferedImage dest, Color color, float alpha) {
        Graphics2D g2d = (Graphics2D)dest.getGraphics();
        g2d.drawImage((Image)src, 0, 0, null);
        g2d.setComposite(AlphaComposite.getInstance(10, alpha));
        g2d.setColor(color);
        g2d.fillRect(0, 0, dest.getWidth(), dest.getHeight());
        g2d.dispose();
    }

    public static Image flipHorizontal(Image image) {
        BufferedImage bi = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g2 = (Graphics2D)bi.getGraphics();
        g2.scale(-1.0, 1.0);
        g2.translate(-image.getWidth(null), 0);
        g2.drawImage(image, 0, 0, null);
        g2.dispose();
        return bi;
    }

    public static Image flipVertical(Image image) {
        BufferedImage bi = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g2 = (Graphics2D)bi.getGraphics();
        g2.scale(1.0, -1.0);
        g2.translate(0, -image.getHeight(null));
        g2.drawImage(image, 0, 0, null);
        g2.dispose();
        return bi;
    }
}

