/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.util;

import de.javasoft.plaf.synthetica.ScalableIcon;
import de.javasoft.plaf.synthetica.ScalableImage;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.border.Border;

public class HiDpi {
    public static boolean isUIScalingEnabled() {
        return SyntheticaLookAndFeel.getInstance().isUIScalingEnabled();
    }

    public static boolean isSwingUIScalingEnabled() {
        return SyntheticaLookAndFeel.getInstance().isSwingUIScalingEnabled();
    }

    public static float getScaleFactor() {
        SyntheticaLookAndFeel instance = SyntheticaLookAndFeel.getInstance();
        return instance == null ? (float)SyntheticaLookAndFeel.getInt("Synthetica.scaleFactor", null, 100, false) / 100.0f : instance.getScaleFactor();
    }

    public static float scaleFontSize(float fontSize) {
        return SyntheticaLookAndFeel.getInstance().scaleFontSize(fontSize);
    }

    public static Insets scale(Insets insets) {
        return HiDpi.scaleInsets(insets);
    }

    public static Insets scaleInsets(Insets insets) {
        return SyntheticaLookAndFeel.getInstance().scaleInsets(insets);
    }

    public static Insets scaleInsets(int top, int left, int bottom, int right) {
        return SyntheticaLookAndFeel.getInstance().scaleInsets(top, left, bottom, right);
    }

    public static Insets scaleInsets(int top, int left, int bottom, int right, boolean asUIResource) {
        return SyntheticaLookAndFeel.getInstance().scaleInsets(top, left, bottom, right, asUIResource);
    }

    public static Point scale(Point p) {
        return HiDpi.scalePoint(p);
    }

    public static Point scalePoint(Point p) {
        return SyntheticaLookAndFeel.getInstance().scalePoint(p);
    }

    public static Point scalePoint(int x, int y) {
        return SyntheticaLookAndFeel.getInstance().scalePoint(x, y);
    }

    public static Dimension scale(Dimension dim) {
        return HiDpi.scaleDimension(dim);
    }

    public static Dimension scaleDimension(Dimension dim) {
        return SyntheticaLookAndFeel.getInstance().scaleDimension(dim);
    }

    public static Dimension scaleDimension(int width, int height) {
        return SyntheticaLookAndFeel.getInstance().scaleDimension(width, height);
    }

    public static Dimension scaleDimension(int width, int height, boolean asUIResource) {
        return SyntheticaLookAndFeel.getInstance().scaleDimension(width, height, asUIResource);
    }

    public static Rectangle scale(Rectangle rect) {
        return HiDpi.scaleBounds(rect);
    }

    public static Rectangle scaleBounds(Rectangle rect) {
        return SyntheticaLookAndFeel.getInstance().scaleBounds(rect);
    }

    public static Rectangle scaleBounds(int x, int y, int w, int h) {
        return SyntheticaLookAndFeel.getInstance().scaleBounds(x, y, w, h);
    }

    public static Rectangle scaleBounds(int x, int y, int w, int h, boolean asUIResource) {
        return SyntheticaLookAndFeel.getInstance().scaleBounds(x, y, w, h, asUIResource);
    }

    public static Integer scale(Integer val) {
        return HiDpi.scaleInteger(val);
    }

    public static Integer scaleInteger(Integer val) {
        return SyntheticaLookAndFeel.getInstance().scaleInteger(val);
    }

    public static Float scale(Float val) {
        return HiDpi.scaleFloat(val);
    }

    public static Float scaleFloat(Float val) {
        return SyntheticaLookAndFeel.getInstance().scaleFloat(val);
    }

    public static Border createEmptyBorder(int top, int left, int bottom, int right) {
        return SyntheticaLookAndFeel.getInstance().createEmptyBorder(top, left, bottom, right, true);
    }

    public static Border createEmptyBorder(int top, int left, int bottom, int right, boolean scaled) {
        return SyntheticaLookAndFeel.getInstance().createEmptyBorder(top, left, bottom, right, scaled);
    }

    public static Border createEmptyBorder(Insets insets) {
        return SyntheticaLookAndFeel.getInstance().createEmptyBorder(insets, true);
    }

    public static Border createEmptyBorder(Insets insets, boolean scaled) {
        return SyntheticaLookAndFeel.getInstance().createEmptyBorder(insets, scaled);
    }

    public static Border createMatteBorder(int top, int left, int bottom, int right, Color color) {
        return SyntheticaLookAndFeel.getInstance().createMatteBorder(top, left, bottom, right, color, true);
    }

    public static Border createMatteBorder(int top, int left, int bottom, int right, Color color, boolean scaled) {
        return SyntheticaLookAndFeel.getInstance().createMatteBorder(top, left, bottom, right, color, scaled);
    }

    public static Border createMatteBorder(Insets insets, Color color) {
        return SyntheticaLookAndFeel.getInstance().createMatteBorder(insets, color, true);
    }

    public static Border createMatteBorder(Insets insets, Color color, boolean scaled) {
        return SyntheticaLookAndFeel.getInstance().createMatteBorder(insets, color, scaled);
    }

    public static Border createLineBorder(Color color) {
        return SyntheticaLookAndFeel.getInstance().createLineBorder(color, true);
    }

    public static Border createLineBorder(Color color, boolean scaled) {
        return SyntheticaLookAndFeel.getInstance().createLineBorder(color, scaled);
    }

    public static Border createLineBorder(Color color, int thickness) {
        return SyntheticaLookAndFeel.getInstance().createLineBorder(color, thickness, true);
    }

    public static Border createLineBorder(Color color, int thickness, boolean scaled) {
        return SyntheticaLookAndFeel.getInstance().createLineBorder(color, thickness, scaled);
    }

    public static Icon createIcon(Class<?> resourceBase, String ... fileNames) {
        return new ScalableIcon(resourceBase, fileNames);
    }

    public static Icon createIcon(Image ... images) {
        return new ScalableIcon(images);
    }

    public static Icon createIcon(Icon icon) {
        return new ScalableIcon(icon);
    }

    public static Image createImage(Class<?> resourceBase, String ... fileNames) {
        return new ScalableImage(resourceBase, fileNames);
    }

    public static Image createImage(Image ... images) {
        return new ScalableImage(images);
    }

    public static Image scaleImage(Image image) {
        return HiDpi.scaleImage(image, HiDpi.scale(image.getWidth(null)), HiDpi.scale(image.getHeight(null)));
    }

    public static Image scaleImage(Image image, int width, int height) {
        int w = image.getWidth(null);
        int h = image.getHeight(null);
        Image img = null;
        int algo = SyntheticaLookAndFeel.getInt("Synthetica.imageScaleAlgorithm", null, 1);
        if (algo == 0) {
            return image;
        }
        if (algo == 1) {
            if (width < w && height < h) {
                img = image.getScaledInstance(width, height, 4);
            } else {
                img = new BufferedImage(width, height, 2);
                Graphics2D g2 = (Graphics2D)img.getGraphics();
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                g2.drawImage(image, 0, 0, width, height, null);
                g2.dispose();
            }
        } else if (algo == 2) {
            img = image.getScaledInstance(width, height, 4);
        } else if (algo == 3) {
            img = new BufferedImage(width, height, 2);
            Graphics2D g2 = (Graphics2D)img.getGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2.drawImage(image, 0, 0, width, height, null);
            g2.dispose();
        } else if (algo == 4) {
            img = new BufferedImage(width, height, 2);
            Graphics2D g2 = (Graphics2D)img.getGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.drawImage(image, 0, 0, width, height, null);
            g2.dispose();
        }
        return img;
    }
}

