/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.styles;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.styles.StyleWrapper;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthStyle;

public class ViewportStyle
extends StyleWrapper {
    private static ViewportStyle instance = new ViewportStyle();

    private ViewportStyle() {
    }

    public static SynthStyle getStyle(SynthStyle style, JComponent c, Region region) {
        if (SyntheticaLookAndFeel.getStyleName(c) == null) {
            instance.setStyle(style);
            return instance;
        }
        ViewportStyle sw = new ViewportStyle();
        sw.setStyle(style);
        return sw;
    }

    @Override
    public Color getColor(SynthContext sc, ColorType type) {
        if (type == ColorType.BACKGROUND) {
            JViewport vp = (JViewport)sc.getComponent();
            Component view = vp.getView();
            if (view != null && view.getClass().getName().endsWith("JHEditorPane") && SyntheticaLookAndFeel.get("Synthetica.javaHelpEditorViewport.background", vp) != null) {
                return SyntheticaLookAndFeel.getColor("Synthetica.javaHelpEditorViewport.background", vp);
            }
            boolean useViewBackgroundColor = SyntheticaLookAndFeel.getBoolean("Synthetica.viewport.dynamicBackgroundColorEnabled", vp);
            if (view != null && view instanceof JComponent && ((JComponent)view).isOpaque() && useViewBackgroundColor) {
                return view.getBackground();
            }
        }
        return super.getColor(sc, type);
    }
}

