/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.styles;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.styles.StyleWrapper;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthStyle;

public class ToolBarStyle
extends StyleWrapper {
    private static final String ORG_FILLERS = "Synthetica.toolBarStyle.orgFillers";
    private static final String ORG_X_ALIGNMENTS = "Synthetica.toolBarStyle.orgXAlignments";
    private static final String ORG_Y_ALIGNMENTS = "Synthetica.toolBarStyle.orgYAlignments";
    private static final String ORG_MARGIN = "Synthetica.toolBarStyle.orgMargin";
    private static final String ORG_LAYOUT_MANAGER = "Synthetica.toolBarStyle.orgLayoutManager";
    private static final String ORIENTATION_LISTENER = "Synthetica.toolBarStyle.orientationListener";
    private static final String CONTAINER_LISTENER = "Synthetica.toolBarStyle.containerListener";
    private static ToolBarStyle instance = new ToolBarStyle();

    private ToolBarStyle() {
    }

    public static SynthStyle getStyle(SynthStyle style, JComponent c, Region region) {
        if (SyntheticaLookAndFeel.getStyleName(c) == null) {
            instance.setStyle(style);
            return instance;
        }
        ToolBarStyle sw = new ToolBarStyle();
        sw.setStyle(style);
        return sw;
    }

    @Override
    public void installDefaults(SynthContext context) {
        this.synthStyle.installDefaults(context);
        JToolBar toolBar = (JToolBar)context.getComponent();
        if (toolBar.getClientProperty(ORG_FILLERS) == null) {
            toolBar.putClientProperty(ORG_FILLERS, new HashMap());
        }
        HashMap orgFillers = (HashMap)toolBar.getClientProperty(ORG_FILLERS);
        if (toolBar.getClientProperty(ORG_X_ALIGNMENTS) == null) {
            toolBar.putClientProperty(ORG_X_ALIGNMENTS, new HashMap());
        }
        HashMap orgXAlignments = (HashMap)toolBar.getClientProperty(ORG_X_ALIGNMENTS);
        if (toolBar.getClientProperty(ORG_Y_ALIGNMENTS) == null) {
            toolBar.putClientProperty(ORG_Y_ALIGNMENTS, new HashMap());
        }
        HashMap orgYAlignments = (HashMap)toolBar.getClientProperty(ORG_Y_ALIGNMENTS);
        toolBar.putClientProperty(ORG_LAYOUT_MANAGER, toolBar.getLayout());
        toolBar.putClientProperty(ORG_MARGIN, toolBar.getMargin());
        toolBar.addPropertyChangeListener(this.getOrientationListener(toolBar));
        Component[] components = toolBar.getComponents();
        int i = 0;
        while (i < components.length) {
            Component c = components[i];
            orgXAlignments.put(c, Float.valueOf(c.getAlignmentX()));
            orgYAlignments.put(c, Float.valueOf(c.getAlignmentY()));
            if (c instanceof Box.Filler) {
                orgFillers.put(i, c);
            }
            ((JComponent)c).setAlignmentX(0.5f);
            ((JComponent)c).setAlignmentY(0.5f);
            ++i;
        }
        toolBar.addContainerListener(this.getContainerListener(toolBar));
        this.setLayoutManager(toolBar);
    }

    private PropertyChangeListener getOrientationListener(final JToolBar toolBar) {
        PropertyChangeListener orientationListener = (PropertyChangeListener)toolBar.getClientProperty(ORIENTATION_LISTENER);
        if (orientationListener == null) {
            orientationListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    String name = evt.getPropertyName();
                    if (name.equals("orientation")) {
                        ToolBarStyle.this.setLayoutManager(toolBar);
                    } else if (name.equals("floatable")) {
                        ToolBarStyle.this.setMargin(toolBar, (Boolean)evt.getNewValue());
                    } else if (name.equals("componentOrientation")) {
                        ToolBarStyle.this.setMargin(toolBar, toolBar.isFloatable());
                    }
                }
            };
            toolBar.putClientProperty(ORIENTATION_LISTENER, orientationListener);
        }
        return orientationListener;
    }

    private ContainerListener getContainerListener(final JToolBar toolBar) {
        ContainerListener containerListener = (ContainerListener)toolBar.getClientProperty(CONTAINER_LISTENER);
        if (containerListener == null) {
            containerListener = new ContainerListener(){

                @Override
                public void componentAdded(ContainerEvent evt) {
                    HashMap orgFillers = (HashMap)toolBar.getClientProperty(ToolBarStyle.ORG_FILLERS);
                    HashMap orgXAlignments = (HashMap)toolBar.getClientProperty(ToolBarStyle.ORG_X_ALIGNMENTS);
                    HashMap orgYAlignments = (HashMap)toolBar.getClientProperty(ToolBarStyle.ORG_Y_ALIGNMENTS);
                    Component child = evt.getChild();
                    orgXAlignments.put(child, Float.valueOf(child.getAlignmentX()));
                    orgYAlignments.put(child, Float.valueOf(child.getAlignmentY()));
                    if (child instanceof Box.Filler) {
                        orgFillers.put(toolBar.getComponents().length - 1, child);
                    }
                    if (child instanceof JComponent) {
                        ((JComponent)child).setAlignmentX(0.5f);
                        ((JComponent)child).setAlignmentY(0.5f);
                    }
                }

                @Override
                public void componentRemoved(ContainerEvent evt) {
                    HashMap orgXAlignments = (HashMap)toolBar.getClientProperty(ToolBarStyle.ORG_X_ALIGNMENTS);
                    orgXAlignments.remove(evt.getChild());
                    HashMap orgYAlignments = (HashMap)toolBar.getClientProperty(ToolBarStyle.ORG_Y_ALIGNMENTS);
                    orgYAlignments.remove(evt.getChild());
                }
            };
            toolBar.putClientProperty(CONTAINER_LISTENER, containerListener);
        }
        return containerListener;
    }

    @Override
    public void uninstallDefaults(SynthContext context) {
        this.synthStyle.uninstallDefaults(context);
        JToolBar toolBar = (JToolBar)context.getComponent();
        toolBar.removePropertyChangeListener(this.getOrientationListener(toolBar));
        toolBar.removeContainerListener(this.getContainerListener(toolBar));
        HashMap orgFillers = (HashMap)toolBar.getClientProperty(ORG_FILLERS);
        HashMap orgXAlignments = (HashMap)toolBar.getClientProperty(ORG_X_ALIGNMENTS);
        HashMap orgYAlignments = (HashMap)toolBar.getClientProperty(ORG_Y_ALIGNMENTS);
        for (Map.Entry entry : orgFillers.entrySet()) {
            int index = (Integer)entry.getKey();
            Component filler = (Component)entry.getValue();
            toolBar.remove(index);
            toolBar.add(filler, index);
        }
        for (Map.Entry entry : orgXAlignments.entrySet()) {
            JComponent c = (JComponent)entry.getKey();
            float x = ((Float)entry.getValue()).floatValue();
            c.setAlignmentX(x);
        }
        for (Map.Entry entry : orgYAlignments.entrySet()) {
            JComponent c = (JComponent)entry.getKey();
            float y = ((Float)entry.getValue()).floatValue();
            c.setAlignmentY(y);
        }
        toolBar.setMargin((Insets)toolBar.getClientProperty(ORG_MARGIN));
        toolBar.setLayout((LayoutManager)toolBar.getClientProperty(ORG_LAYOUT_MANAGER));
        toolBar.putClientProperty(ORG_FILLERS, null);
        toolBar.putClientProperty(ORG_X_ALIGNMENTS, null);
        toolBar.putClientProperty(ORG_Y_ALIGNMENTS, null);
        toolBar.putClientProperty(ORG_MARGIN, null);
        toolBar.putClientProperty(ORG_LAYOUT_MANAGER, null);
        toolBar.putClientProperty(ORIENTATION_LISTENER, null);
        toolBar.putClientProperty(CONTAINER_LISTENER, null);
    }

    private void setLayoutManager(JToolBar toolBar) {
        int i;
        if (this.useSynthLayout(toolBar)) {
            return;
        }
        HashMap orgFillers = (HashMap)toolBar.getClientProperty(ORG_FILLERS);
        toolBar.removeContainerListener(this.getContainerListener(toolBar));
        Component[] components = toolBar.getComponents();
        SyntheticaToolBarLayout lm = null;
        if (toolBar.getOrientation() == 0) {
            lm = new SyntheticaToolBarLayout(toolBar, 2);
            i = 0;
            while (i < components.length) {
                if (components[i] instanceof Box.Filler && this.fillerIsGlue((Box.Filler)components[i])) {
                    toolBar.remove(components[i]);
                    toolBar.add(Box.createHorizontalGlue(), i);
                } else if (components[i] instanceof Box.Filler && !this.fillerIsGlue((Box.Filler)components[i])) {
                    toolBar.remove(components[i]);
                    Component c = (Component)orgFillers.get(i);
                    Dimension size = c.getPreferredSize();
                    int strut = Math.max(size.width, size.height);
                    toolBar.add(Box.createHorizontalStrut(strut), i);
                }
                ++i;
            }
            this.setMargin(toolBar, toolBar.isFloatable());
            i = 0;
            while (i < components.length) {
                ((JComponent)components[i]).setAlignmentY(0.5f);
                ++i;
            }
        } else {
            lm = new SyntheticaToolBarLayout(toolBar, 3);
            i = 0;
            while (i < components.length) {
                if (components[i] instanceof Box.Filler && this.fillerIsGlue((Box.Filler)components[i])) {
                    toolBar.remove(components[i]);
                    toolBar.add(Box.createVerticalGlue(), i);
                } else if (components[i] instanceof Box.Filler && !this.fillerIsGlue((Box.Filler)components[i])) {
                    toolBar.remove(components[i]);
                    Component c = (Component)orgFillers.get(i);
                    Dimension size = c.getPreferredSize();
                    int strut = Math.max(size.width, size.height);
                    toolBar.add(Box.createVerticalStrut(strut), i);
                }
                ++i;
            }
            this.setMargin(toolBar, toolBar.isFloatable());
            i = 0;
            while (i < components.length) {
                ((JComponent)components[i]).setAlignmentX(0.5f);
                ++i;
            }
        }
        LayoutManager layout = toolBar.getLayout();
        if (layout != null && (layout.getClass().getName().contains("SynthToolBar") || layout instanceof SyntheticaToolBarLayout)) {
            toolBar.setLayout(lm);
        }
        toolBar.addContainerListener(this.getContainerListener(toolBar));
    }

    private void setMargin(JToolBar toolBar, boolean floatable) {
        if (this.useSynthLayout(toolBar)) {
            return;
        }
        Insets newMargin = null;
        if (toolBar.getOrientation() == 0) {
            newMargin = SyntheticaLookAndFeel.getInsets("Synthetica.toolBar.margin.horizontal", (Component)toolBar, false, true);
            if (floatable && toolBar.getComponentOrientation().isLeftToRight()) {
                newMargin.left += SyntheticaLookAndFeel.getInt("Synthetica.toolBar.handle.size", toolBar, 0, true);
            } else if (floatable) {
                newMargin.right += SyntheticaLookAndFeel.getInt("Synthetica.toolBar.handle.size", toolBar, 0, true);
            }
        } else {
            newMargin = SyntheticaLookAndFeel.getInsets("Synthetica.toolBar.margin.vertical", (Component)toolBar, false, true);
            if (floatable) {
                newMargin.top += SyntheticaLookAndFeel.getInt("Synthetica.toolBar.handle.size", toolBar, 0, true);
            }
        }
        Insets orgMargin = (Insets)toolBar.getClientProperty(ORG_MARGIN);
        if (orgMargin != null && newMargin != null) {
            newMargin.bottom += orgMargin.bottom;
            newMargin.left += orgMargin.left;
            newMargin.top += orgMargin.top;
            newMargin.right += orgMargin.right;
            toolBar.setMargin(newMargin);
        }
    }

    private boolean useSynthLayout(JComponent c) {
        return SyntheticaLookAndFeel.getBoolean("Synthetica.toolBar.useSynthLayoutManager", c, false);
    }

    private boolean fillerIsGlue(Box.Filler filler) {
        Dimension zeroDim = new Dimension(0, 0);
        return filler.getMinimumSize().equals(zeroDim) && filler.getPreferredSize().equals(zeroDim);
    }

    private static class SyntheticaToolBarLayout
    extends BoxLayout {
        private static final long serialVersionUID = 6806218476946368742L;

        SyntheticaToolBarLayout(Container target, int axis) {
            super(target, axis);
        }
    }
}

