/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.styles;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.styles.StyleWrapper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.text.JTextComponent;

public class TextFieldStyle
extends StyleWrapper {
    private static TextFieldStyle instance = new TextFieldStyle();

    private TextFieldStyle() {
    }

    public static SynthStyle getStyle(SynthStyle style, JComponent c, Region region) {
        if (SyntheticaLookAndFeel.getStyleName(c) == null && ((JTextComponent)c).isEditable()) {
            instance.setStyle(style);
            return instance;
        }
        TextFieldStyle sw = new TextFieldStyle();
        sw.setStyle(style);
        return sw;
    }

    @Override
    public Insets getInsets(SynthContext sc, Insets insets) {
        Insets ins = this.synthStyle.getInsets(sc, insets);
        String cName = sc.getComponent().getName();
        if ("ComboBox.textField".equals(cName)) {
            ins = new Insets(0, 1, 0, 1);
        }
        return SyntheticaLookAndFeel.getInstance().scaleInsets(ins);
    }

    @Override
    public Color getColorForState(SynthContext sc, ColorType type) {
        JComponent c = sc.getComponent();
        if (type == ColorType.TEXT_FOREGROUND && c.getForeground() instanceof ColorUIResource && !((JTextComponent)c).isEditable()) {
            Color lockedTextColor = SyntheticaLookAndFeel.getColor("Synthetica.textField.locked.textColor", c);
            return lockedTextColor == null ? super.getColorForState(sc, type) : lockedTextColor;
        }
        return super.getColorForState(sc, type);
    }

    @Override
    public Color getColor(SynthContext sc, ColorType type) {
        JComponent c = sc.getComponent();
        Color background = c.getBackground();
        if (((Component)c).isOpaque() && background != null && !(background instanceof UIResource) && type == ColorType.BACKGROUND) {
            return background;
        }
        return super.getColor(sc, type);
    }
}

