/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.styles;

import de.javasoft.plaf.synthetica.GraphicsUtils;
import de.javasoft.plaf.synthetica.Scalable;
import de.javasoft.plaf.synthetica.ScalableIcon;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.styles.StyleWrapper;
import de.javasoft.plaf.synthetica.util.Synthetica2DUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthStyle;

public class RadioButtonStyle
extends StyleWrapper {
    private static RadioButtonStyle instance = new RadioButtonStyle();

    private RadioButtonStyle() {
    }

    public static SynthStyle getStyle(SynthStyle style, JComponent c, Region region) {
        if (SyntheticaLookAndFeel.getStyleName(c) == null) {
            instance.setStyle(style);
            return instance;
        }
        RadioButtonStyle sw = new RadioButtonStyle();
        sw.setStyle(style);
        return sw;
    }

    @Override
    public Object get(SynthContext sc, Object key) {
        Object val = super.get(sc, key);
        if ("RadioButton.margin".equals(key) && val != null) {
            val = SyntheticaLookAndFeel.getInstance().scaleInsets((Insets)val);
        } else if ("RadioButton.iconTextGap".equals(key) && val != null) {
            val = SyntheticaLookAndFeel.getInstance().scaleInteger((Integer)val);
        }
        return val;
    }

    @Override
    public Icon getIcon(SynthContext sc, Object key) {
        AbstractButton button = (AbstractButton)sc.getComponent();
        if (button.getIcon() != null) {
            return null;
        }
        int state = sc.getComponentState();
        Boolean b = (Boolean)button.getClientProperty("Synthetica.MOUSE_OVER");
        boolean mouseOver = b == null ? false : b;
        Icon icon = null;
        if ((state & 4) > 0) {
            boolean emulatePressedState = SyntheticaLookAndFeel.getBoolean("Synthetica.radioButton.emulatedPressedState.enabled", button);
            boolean selected = button.isSelected();
            if (emulatePressedState) {
                icon = SyntheticaLookAndFeel.loadIcon(selected ? "Synthetica.radioButton.selected.image" : "Synthetica.radioButton.image", null, true);
            }
            if (icon == null) {
                icon = super.getIcon(new SynthContext(button, sc.getRegion(), sc.getStyle(), selected ? 516 : 4), key);
            }
            if (emulatePressedState) {
                BufferedImage bi = (BufferedImage)GraphicsUtils.iconToImage(sc, icon);
                Color color = SyntheticaLookAndFeel.getColor("Synthetica.radioButton.emulatedPressedState.color", button, UIManager.getColor("Panel.background").darker());
                float alpha = (float)SyntheticaLookAndFeel.getInt("Synthetica.radioButton.emulatedPressedState.alpha", (Component)button, 25) / 100.0f;
                BufferedImage colorizedIcon = Synthetica2DUtils.createColorizedImage(bi, color, alpha);
                icon = new ImageIcon(colorizedIcon);
            }
        } else {
            icon = (state & 0x200) > 0 && mouseOver ? super.getIcon(new SynthContext(button, sc.getRegion(), sc.getStyle(), state | 2), key) : super.getIcon(sc, key);
        }
        if (button.getClientProperty("Synthetica.background") != null) {
            float alpha = button.getClientProperty("Synthetica.background.alpha") == null ? 0.1f : ((Float)button.getClientProperty("Synthetica.background.alpha")).floatValue();
            BufferedImage bi = (BufferedImage)GraphicsUtils.iconToImage(sc, icon);
            BufferedImage colorizedIcon = Synthetica2DUtils.createColorizedImage(bi, (Color)button.getClientProperty("Synthetica.background"), alpha);
            icon = new ImageIcon(colorizedIcon);
        }
        return icon == null || icon instanceof Scalable || SyntheticaLookAndFeel.getInstance().getScaleFactor() == 1.0f ? icon : new ScalableIcon.ScalableIconUIResource(icon);
    }
}

