/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.styles;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.styles.StyleWrapper;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthStyle;

public class PopupMenuStyle
extends StyleWrapper {
    private static PopupMenuStyle instance = new PopupMenuStyle();

    private PopupMenuStyle() {
    }

    public static SynthStyle getStyle(SynthStyle style, JComponent c, Region region) {
        JPopupMenu popup = (JPopupMenu)c;
        popup.setOpaque(false);
        if (!SyntheticaLookAndFeel.isWindowOpacityEnabled(null)) {
            popup.setDoubleBuffered(false);
        }
        popup.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JComponent parent;
                JPopupMenu popup;
                Container c;
                String name = evt.getPropertyName();
                if ("visible".equals(name) && (c = (popup = (JPopupMenu)evt.getSource()).getParent()) instanceof JComponent && (parent = (JComponent)c).isOpaque()) {
                    parent.setOpaque(false);
                    if (!SyntheticaLookAndFeel.isWindowOpacityEnabled(null)) {
                        parent.setDoubleBuffered(false);
                    }
                }
            }
        });
        if (SyntheticaLookAndFeel.getStyleName(c) == null) {
            instance.setStyle(style);
            return instance;
        }
        PopupMenuStyle sw = new PopupMenuStyle();
        sw.setStyle(style);
        return sw;
    }

    @Override
    public Insets getInsets(SynthContext sc, Insets insets) {
        JPopupMenu popup = (JPopupMenu)sc.getComponent();
        Insets toplevelInsets = SyntheticaLookAndFeel.getInsets("Synthetica.popupMenu.toplevel.insets", (Component)popup, false, true);
        return SyntheticaLookAndFeel.isToplevelPopupMenu(popup) ? toplevelInsets : super.getInsets(sc, insets);
    }
}

