/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.styles;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.styles.StyleWrapper;
import java.awt.Color;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.text.JTextComponent;

public class FormattedTextFieldStyle
extends StyleWrapper {
    private static FormattedTextFieldStyle instance = new FormattedTextFieldStyle();

    private FormattedTextFieldStyle() {
    }

    public static SynthStyle getStyle(SynthStyle style, JComponent c, Region region) {
        if (SyntheticaLookAndFeel.getStyleName(c) == null && ((JTextComponent)c).isEditable()) {
            instance.setStyle(style);
            return instance;
        }
        FormattedTextFieldStyle sw = new FormattedTextFieldStyle();
        sw.setStyle(style);
        return sw;
    }

    @Override
    public Insets getInsets(SynthContext sc, Insets insets) {
        Insets ins = this.synthStyle.getInsets(sc, insets);
        String cName = sc.getComponent().getName();
        if ("Spinner.formattedTextField".equals(cName)) {
            ins = sc.getComponent().getComponentOrientation().isLeftToRight() ? new Insets(0, 0, 0, ins.right) : new Insets(0, ins.right, 0, 0);
        } else if ("ComboBox.textField".equals(cName)) {
            ins = new Insets(0, 1, 0, 1);
        }
        return SyntheticaLookAndFeel.getInstance().scaleInsets(ins);
    }

    @Override
    public Color getColorForState(SynthContext sc, ColorType type) {
        JComponent c = sc.getComponent();
        if (type == ColorType.TEXT_FOREGROUND && c.getForeground() instanceof ColorUIResource && !((JTextComponent)c).isEditable()) {
            Color lockedTextColor = SyntheticaLookAndFeel.getColor("Synthetica.formattedTextField.locked.textColor", c);
            return lockedTextColor == null ? super.getColorForState(sc, type) : lockedTextColor;
        }
        return super.getColorForState(sc, type);
    }
}

